/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api;

import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerResourceIncreaseRequest;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerResourceIncreaseRequestPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.junit.Assert;
import org.junit.Test;

public class TestContainerResourceIncreaseRequest {
    @Test
    public void ContainerResourceIncreaseRequest() {
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1234L, (int)3), (int)3), (long)7L);
        Resource resource = Resource.newInstance((int)1023, (int)3);
        ContainerResourceIncreaseRequest context = ContainerResourceIncreaseRequest.newInstance((ContainerId)containerId, (Resource)resource);
        YarnProtos.ContainerResourceIncreaseRequestProto proto = ((ContainerResourceIncreaseRequestPBImpl)context).getProto();
        ContainerResourceIncreaseRequestPBImpl contextRecover = new ContainerResourceIncreaseRequestPBImpl(proto);
        Assert.assertEquals((Object)contextRecover.getContainerId(), (Object)containerId);
        Assert.assertEquals((Object)contextRecover.getCapability(), (Object)resource);
    }

    @Test
    public void testResourceChangeContextWithNullField() {
        ContainerResourceIncreaseRequest context = ContainerResourceIncreaseRequest.newInstance(null, null);
        YarnProtos.ContainerResourceIncreaseRequestProto proto = ((ContainerResourceIncreaseRequestPBImpl)context).getProto();
        ContainerResourceIncreaseRequestPBImpl contextRecover = new ContainerResourceIncreaseRequestPBImpl(proto);
        Assert.assertNull((Object)contextRecover.getContainerId());
        Assert.assertNull((Object)contextRecover.getCapability());
    }
}

