/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api;

import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.junit.Assert;
import org.junit.Test;

public class TestResourcePBImpl {
    @Test
    public void testEmptyResourcePBInit() throws Exception {
        ResourcePBImpl res = new ResourcePBImpl();
        Assert.assertEquals((long)0L, (long)res.getMemorySize());
        Assert.assertEquals((Object)ResourceInformation.MEMORY_MB.getUnits(), (Object)res.getResourceInformation(ResourceInformation.MEMORY_MB.getName()).getUnits());
        Assert.assertEquals((Object)ResourceInformation.VCORES.getUnits(), (Object)res.getResourceInformation(ResourceInformation.VCORES.getName()).getUnits());
    }

    @Test
    public void testResourcePBInitFromOldPB() throws Exception {
        YarnProtos.ResourceProto proto = YarnProtos.ResourceProto.newBuilder().setMemory(1024L).setVirtualCores(3).build();
        ResourcePBImpl res = new ResourcePBImpl(proto);
        Assert.assertEquals((long)1024L, (long)res.getMemorySize());
        Assert.assertEquals((long)3L, (long)res.getVirtualCores());
        Assert.assertEquals((Object)ResourceInformation.MEMORY_MB.getUnits(), (Object)res.getResourceInformation(ResourceInformation.MEMORY_MB.getName()).getUnits());
        Assert.assertEquals((Object)ResourceInformation.VCORES.getUnits(), (Object)res.getResourceInformation(ResourceInformation.VCORES.getName()).getUnits());
    }
}

