/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerLaunchContextPBImpl;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.junit.Assert;
import org.junit.Test;

public class TestApplicationClientProtocolRecords {
    @Test
    public void testCLCPBImplNullEnv() throws IOException {
        Map localResources = Collections.emptyMap();
        HashMap<String, Object> environment = new HashMap<String, Object>();
        List commands = Collections.emptyList();
        Map serviceData = Collections.emptyMap();
        Credentials containerCreds = new Credentials();
        DataOutputBuffer dob = new DataOutputBuffer();
        containerCreds.writeTokenStorageToStream((DataOutputStream)dob);
        ByteBuffer containerTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        Map acls = Collections.emptyMap();
        environment.put("testCLCPBImplNullEnv", null);
        ContainerLaunchContext clc = ContainerLaunchContext.newInstance(localResources, environment, commands, serviceData, (ByteBuffer)containerTokens, acls);
        ContainerLaunchContextPBImpl clcProto = new ContainerLaunchContextPBImpl(((ContainerLaunchContextPBImpl)clc).getProto());
        Assert.assertEquals((Object)"", clcProto.getEnvironment().get("testCLCPBImplNullEnv"));
    }

    @Test
    public void testCLCPBImplNullResourceURL() throws IOException {
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        try {
            LocalResource rsrc_alpha = (LocalResource)recordFactory.newRecordInstance(LocalResource.class);
            rsrc_alpha.setResource(null);
            rsrc_alpha.setSize(-1L);
            rsrc_alpha.setVisibility(LocalResourceVisibility.APPLICATION);
            rsrc_alpha.setType(LocalResourceType.FILE);
            rsrc_alpha.setTimestamp(System.currentTimeMillis());
            HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
            localResources.put("null_url_resource", rsrc_alpha);
            ContainerLaunchContext containerLaunchContext = (ContainerLaunchContext)recordFactory.newRecordInstance(ContainerLaunchContext.class);
            containerLaunchContext.setLocalResources(localResources);
            Assert.fail((String)"Setting an invalid local resource should be an error!");
        }
        catch (NullPointerException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Null resource URL for local resource"));
        }
    }

    @Test
    public void testCLCPBImplNullResourceType() throws IOException {
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        try {
            LocalResource resource = (LocalResource)recordFactory.newRecordInstance(LocalResource.class);
            resource.setResource(URL.fromPath((Path)new Path(".")));
            resource.setSize(-1L);
            resource.setVisibility(LocalResourceVisibility.APPLICATION);
            resource.setType(null);
            resource.setTimestamp(System.currentTimeMillis());
            HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
            localResources.put("null_type_resource", resource);
            ContainerLaunchContext containerLaunchContext = (ContainerLaunchContext)recordFactory.newRecordInstance(ContainerLaunchContext.class);
            containerLaunchContext.setLocalResources(localResources);
            Assert.fail((String)"Setting an invalid local resource should be an error!");
        }
        catch (NullPointerException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Null resource type for local resource"));
        }
    }

    @Test
    public void testCLCPBImplNullResourceVisibility() throws IOException {
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        try {
            LocalResource resource = (LocalResource)recordFactory.newRecordInstance(LocalResource.class);
            resource.setResource(URL.fromPath((Path)new Path(".")));
            resource.setSize(-1L);
            resource.setVisibility(null);
            resource.setType(LocalResourceType.FILE);
            resource.setTimestamp(System.currentTimeMillis());
            HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
            localResources.put("null_visibility_resource", resource);
            ContainerLaunchContext containerLaunchContext = (ContainerLaunchContext)recordFactory.newRecordInstance(ContainerLaunchContext.class);
            containerLaunchContext.setLocalResources(localResources);
            Assert.fail((String)"Setting an invalid local resource should be an error!");
        }
        catch (NullPointerException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Null resource visibility for local resource"));
        }
    }
}

