/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.event;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;

public class InlineDispatcher
extends AsyncDispatcher {
    private static final Log LOG = LogFactory.getLog(InlineDispatcher.class);

    protected void dispatch(Event event) {
        LOG.info((Object)("Dispatching the event " + event.getClass().getName() + "." + event.toString()));
        Class type = event.getType().getDeclaringClass();
        if (this.eventDispatchers.get(type) != null) {
            ((EventHandler)this.eventDispatchers.get(type)).handle(event);
        }
    }

    public EventHandler<Event> getEventHandler() {
        return new TestEventHandler();
    }

    public static class EmptyEventHandler
    implements EventHandler<Event> {
        public void handle(Event event) {
        }
    }

    private class TestEventHandler
    implements EventHandler {
        private TestEventHandler() {
        }

        public void handle(Event event) {
            InlineDispatcher.this.dispatch(event);
        }
    }
}

