/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation.filecontroller.ifile;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;
import org.apache.hadoop.yarn.logaggregation.ContainerLogFileInfo;
import org.apache.hadoop.yarn.logaggregation.ContainerLogMeta;
import org.apache.hadoop.yarn.logaggregation.ContainerLogsRequest;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerContext;
import org.apache.hadoop.yarn.logaggregation.filecontroller.ifile.LogAggregationIndexedFileController;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestLogAggregationIndexFileController {
    private final String rootLocalLogDir = "target/LocalLogs";
    private final Path rootLocalLogDirPath = new Path("target/LocalLogs");
    private final String remoteLogDir = "target/remote-app";
    private static final FsPermission LOG_FILE_UMASK = FsPermission.createImmutable((short)511);
    private static final UserGroupInformation USER_UGI = UserGroupInformation.createRemoteUser((String)"testUser");
    private FileSystem fs;
    private Configuration conf;
    private ApplicationId appId;
    private ContainerId containerId;
    private NodeId nodeId;
    private ByteArrayOutputStream sysOutStream;
    private PrintStream sysOut;
    private ByteArrayOutputStream sysErrStream;
    private PrintStream sysErr;

    @Before
    public void setUp() throws IOException {
        this.appId = ApplicationId.newInstance((long)123456L, (int)1);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)this.appId, (int)1);
        this.containerId = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L);
        this.nodeId = NodeId.newInstance((String)"localhost", (int)9999);
        this.conf = new Configuration();
        this.conf.set("yarn.log-aggregation.Indexed.remote-app-log-dir", "target/remote-app");
        this.conf.set("yarn.log-aggregation.Indexed.remote-app-log-dir-suffix", "logs");
        this.conf.set("yarn.nodemanager.log-aggregation.compression-type", "gz");
        this.fs = FileSystem.get((Configuration)this.conf);
        this.sysOutStream = new ByteArrayOutputStream();
        this.sysOut = new PrintStream(this.sysOutStream);
        System.setOut(this.sysOut);
        this.sysErrStream = new ByteArrayOutputStream();
        this.sysErr = new PrintStream(this.sysErrStream);
        System.setErr(this.sysErr);
    }

    @After
    public void teardown() throws Exception {
        this.fs.delete(this.rootLocalLogDirPath, true);
        this.fs.delete(new Path("target/remote-app"), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=15000L)
    public void testLogAggregationIndexFileFormat() throws Exception {
        if (this.fs.exists(this.rootLocalLogDirPath)) {
            this.fs.delete(this.rootLocalLogDirPath, true);
        }
        Assert.assertTrue((boolean)this.fs.mkdirs(this.rootLocalLogDirPath));
        Path appLogsDir = new Path(this.rootLocalLogDirPath, this.appId.toString());
        if (this.fs.exists(appLogsDir)) {
            this.fs.delete(appLogsDir, true);
        }
        Assert.assertTrue((boolean)this.fs.mkdirs(appLogsDir));
        ArrayList<String> logTypes = new ArrayList<String>();
        logTypes.add("syslog");
        logTypes.add("stdout");
        logTypes.add("stderr");
        HashSet<File> files = new HashSet<File>();
        AggregatedLogFormat.LogKey key1 = new AggregatedLogFormat.LogKey(this.containerId.toString());
        for (String logType : logTypes) {
            File file = this.createAndWriteLocalLogFile(this.containerId, appLogsDir, logType);
            files.add(file);
        }
        AggregatedLogFormat.LogValue value = (AggregatedLogFormat.LogValue)Mockito.mock(AggregatedLogFormat.LogValue.class);
        Mockito.when((Object)value.getPendingLogFilesToUploadForThisContainer()).thenReturn(files);
        final ControlledClock clock = new ControlledClock();
        clock.setTime(System.currentTimeMillis());
        LogAggregationIndexedFileController fileFormat = new LogAggregationIndexedFileController(){
            private int rollOverCheck = 0;

            public Clock getSystemClock() {
                return clock;
            }

            public boolean isRollover(FileContext fc, Path candidate) throws IOException {
                ++this.rollOverCheck;
                return this.rollOverCheck >= 3;
            }
        };
        fileFormat.initialize(this.conf, "Indexed");
        HashMap appAcls = new HashMap();
        Path appDir = fileFormat.getRemoteAppLogDir(this.appId, USER_UGI.getShortUserName());
        if (this.fs.exists(appDir)) {
            this.fs.delete(appDir, true);
        }
        Assert.assertTrue((boolean)this.fs.mkdirs(appDir));
        Path logPath = fileFormat.getRemoteNodeLogFileForApp(this.appId, USER_UGI.getShortUserName(), this.nodeId);
        LogAggregationFileControllerContext context = new LogAggregationFileControllerContext(logPath, logPath, true, 1000L, this.appId, appAcls, this.nodeId, USER_UGI);
        fileFormat.initializeWriter(context);
        fileFormat.write(key1, value);
        fileFormat.postWrite(context);
        fileFormat.closeWriter();
        ContainerLogsRequest logRequest = new ContainerLogsRequest();
        logRequest.setAppId(this.appId);
        logRequest.setNodeId(this.nodeId.toString());
        logRequest.setAppOwner(USER_UGI.getShortUserName());
        logRequest.setContainerId(this.containerId.toString());
        logRequest.setBytes(Long.MAX_VALUE);
        List meta = fileFormat.readAggregatedLogsMeta(logRequest);
        Assert.assertTrue((meta.size() == 1 ? 1 : 0) != 0);
        ArrayList<String> fileNames = new ArrayList<String>();
        for (Object log : meta) {
            Assert.assertTrue((boolean)log.getContainerId().equals(this.containerId.toString()));
            Assert.assertTrue((boolean)log.getNodeId().equals(this.nodeId.toString()));
            Assert.assertTrue((log.getContainerLogMeta().size() == 3 ? 1 : 0) != 0);
            for (ContainerLogFileInfo file : log.getContainerLogMeta()) {
                fileNames.add(file.getFileName());
            }
        }
        fileNames.removeAll(logTypes);
        Assert.assertTrue((boolean)fileNames.isEmpty());
        boolean foundLogs = fileFormat.readAggregatedLogs(logRequest, (OutputStream)System.out);
        Assert.assertTrue((boolean)foundLogs);
        for (String logType : logTypes) {
            Assert.assertTrue((boolean)this.sysOutStream.toString().contains(this.logMessage(this.containerId, logType)));
        }
        this.sysOutStream.reset();
        Path checksumFile = new Path(fileFormat.getRemoteAppLogDir(this.appId, USER_UGI.getShortUserName()), LogAggregationUtils.getNodeString((NodeId)this.nodeId) + "-checksum");
        FSDataOutputStream fInput = null;
        try {
            String nodeName = logPath.getName() + "_" + clock.getTime();
            fInput = FileSystem.create((FileSystem)this.fs, (Path)checksumFile, (FsPermission)LOG_FILE_UMASK);
            fInput.writeInt(nodeName.length());
            fInput.write(nodeName.getBytes(Charset.forName("UTF-8")));
            fInput.writeLong(0L);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fInput);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fInput);
        meta = fileFormat.readAggregatedLogsMeta(logRequest);
        Assert.assertTrue((meta.size() == 0 ? 1 : 0) != 0);
        foundLogs = fileFormat.readAggregatedLogs(logRequest, (OutputStream)System.out);
        Assert.assertFalse((boolean)foundLogs);
        this.sysOutStream.reset();
        this.fs.delete(checksumFile, false);
        Assert.assertFalse((boolean)this.fs.exists(checksumFile));
        ArrayList<String> newLogTypes = new ArrayList<String>(logTypes);
        files.clear();
        newLogTypes.add("test1");
        files.add(this.createAndWriteLocalLogFile(this.containerId, appLogsDir, "test1"));
        newLogTypes.add("test2");
        files.add(this.createAndWriteLocalLogFile(this.containerId, appLogsDir, "test2"));
        AggregatedLogFormat.LogValue value2 = (AggregatedLogFormat.LogValue)Mockito.mock(AggregatedLogFormat.LogValue.class);
        Mockito.when((Object)value2.getPendingLogFilesToUploadForThisContainer()).thenReturn(files);
        fileFormat.initializeWriter(context);
        fileFormat.write(key1, value2);
        fileFormat.closeWriter();
        meta = fileFormat.readAggregatedLogsMeta(logRequest);
        Assert.assertEquals((long)meta.size(), (long)1L);
        for (ContainerLogMeta log : meta) {
            Assert.assertTrue((boolean)log.getContainerId().equals(this.containerId.toString()));
            Assert.assertTrue((boolean)log.getNodeId().equals(this.nodeId.toString()));
            Assert.assertTrue((log.getContainerLogMeta().size() == 3 ? 1 : 0) != 0);
            for (ContainerLogFileInfo file : log.getContainerLogMeta()) {
                fileNames.add(file.getFileName());
            }
        }
        fileNames.removeAll(logTypes);
        Assert.assertTrue((boolean)fileNames.isEmpty());
        foundLogs = fileFormat.readAggregatedLogs(logRequest, (OutputStream)System.out);
        Assert.assertTrue((boolean)foundLogs);
        for (String logType : logTypes) {
            Assert.assertTrue((boolean)this.sysOutStream.toString().contains(this.logMessage(this.containerId, logType)));
        }
        Assert.assertFalse((boolean)this.sysOutStream.toString().contains(this.logMessage(this.containerId, "test1")));
        Assert.assertFalse((boolean)this.sysOutStream.toString().contains(this.logMessage(this.containerId, "test2")));
        this.sysOutStream.reset();
        fileFormat.initializeWriter(context);
        fileFormat.write(key1, value2);
        fileFormat.postWrite(context);
        fileFormat.closeWriter();
        meta = fileFormat.readAggregatedLogsMeta(logRequest);
        Assert.assertEquals((long)meta.size(), (long)2L);
        for (ContainerLogMeta log : meta) {
            Assert.assertTrue((boolean)log.getContainerId().equals(this.containerId.toString()));
            Assert.assertTrue((boolean)log.getNodeId().equals(this.nodeId.toString()));
            for (ContainerLogFileInfo file : log.getContainerLogMeta()) {
                fileNames.add(file.getFileName());
            }
        }
        fileNames.removeAll(newLogTypes);
        Assert.assertTrue((boolean)fileNames.isEmpty());
        foundLogs = fileFormat.readAggregatedLogs(logRequest, (OutputStream)System.out);
        Assert.assertTrue((boolean)foundLogs);
        for (String logType : newLogTypes) {
            Assert.assertTrue((boolean)this.sysOutStream.toString().contains(this.logMessage(this.containerId, logType)));
        }
        this.sysOutStream.reset();
        clock.setTime(System.currentTimeMillis());
        fileFormat.initializeWriter(context);
        fileFormat.write(key1, value2);
        fileFormat.postWrite(context);
        fileFormat.closeWriter();
        FileStatus[] status = this.fs.listStatus(logPath.getParent());
        Assert.assertTrue((status.length == 2 ? 1 : 0) != 0);
        meta = fileFormat.readAggregatedLogsMeta(logRequest);
        Assert.assertEquals((long)meta.size(), (long)3L);
        for (ContainerLogMeta log : meta) {
            Assert.assertTrue((boolean)log.getContainerId().equals(this.containerId.toString()));
            Assert.assertTrue((boolean)log.getNodeId().equals(this.nodeId.toString()));
            for (ContainerLogFileInfo file : log.getContainerLogMeta()) {
                fileNames.add(file.getFileName());
            }
        }
        fileNames.removeAll(newLogTypes);
        Assert.assertTrue((boolean)fileNames.isEmpty());
        foundLogs = fileFormat.readAggregatedLogs(logRequest, (OutputStream)System.out);
        Assert.assertTrue((boolean)foundLogs);
        for (String logType : newLogTypes) {
            Assert.assertTrue((boolean)this.sysOutStream.toString().contains(this.logMessage(this.containerId, logType)));
        }
        this.sysOutStream.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createAndWriteLocalLogFile(ContainerId containerId, Path localLogDir, String logType) throws IOException {
        File file;
        File file2 = new File(localLogDir.toString(), logType);
        if (file2.exists()) {
            file2.delete();
        }
        file2.createNewFile();
        FileWriter writer = null;
        try {
            writer = new FileWriter(file2);
            writer.write(this.logMessage(containerId, logType));
            ((Writer)writer).close();
            file = file2;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)writer);
        return file;
    }

    private String logMessage(ContainerId containerId, String logType) {
        StringBuilder sb = new StringBuilder();
        sb.append("Hello " + containerId + " in " + logType + "!");
        return sb.toString();
    }
}

