/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.timelineservice;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.timelineservice.ApplicationAttemptEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.ApplicationEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.ClusterEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.ContainerEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.FlowRunEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.QueueEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.api.records.timelineservice.UserEntity;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestTimelineServiceRecords {
    private static final Log LOG = LogFactory.getLog(TestTimelineServiceRecords.class);

    @Test
    public void testTimelineEntities() throws Exception {
        TimelineEntity entity = new TimelineEntity();
        entity.setType("test type 1");
        entity.setId("test id 1");
        entity.addInfo("test info key 1", (Object)"test info value 1");
        entity.addInfo("test info key 2", Arrays.asList("test info value 2", "test info value 3"));
        entity.addInfo("test info key 3", (Object)true);
        Assert.assertTrue((boolean)(entity.getInfo().get("test info key 3") instanceof Boolean));
        entity.addConfig("test config key 1", "test config value 1");
        entity.addConfig("test config key 2", "test config value 2");
        TimelineMetric metric1 = new TimelineMetric(TimelineMetric.Type.TIME_SERIES);
        metric1.setId("test metric id 1");
        metric1.addValue(1L, (Number)Float.valueOf(1.0f));
        metric1.addValue(3L, (Number)3.0);
        metric1.addValue(2L, (Number)2);
        Assert.assertEquals((Object)TimelineMetric.Type.TIME_SERIES, (Object)metric1.getType());
        Iterator itr = metric1.getValues().entrySet().iterator();
        Map.Entry entry = itr.next();
        Assert.assertEquals((Object)new Long(3L), entry.getKey());
        Assert.assertEquals((Object)3.0, entry.getValue());
        entry = itr.next();
        Assert.assertEquals((Object)new Long(2L), entry.getKey());
        Assert.assertEquals((Object)2, entry.getValue());
        entry = itr.next();
        Assert.assertEquals((Object)new Long(1L), entry.getKey());
        Assert.assertEquals((Object)Float.valueOf(1.0f), entry.getValue());
        Assert.assertFalse((boolean)itr.hasNext());
        entity.addMetric(metric1);
        TimelineMetric metric2 = new TimelineMetric(TimelineMetric.Type.SINGLE_VALUE);
        metric2.setId("test metric id 1");
        metric2.addValue(3L, (Number)3);
        Assert.assertEquals((Object)TimelineMetric.Type.SINGLE_VALUE, (Object)metric2.getType());
        Assert.assertTrue((boolean)(metric2.getValues().values().iterator().next() instanceof Short));
        HashMap<Long, Double> points = new HashMap<Long, Double>();
        points.put(4L, 4.0);
        points.put(5L, 5.0);
        try {
            metric2.setValues(points);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Values cannot contain more than one point in"));
        }
        try {
            metric2.addValues(points);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Values cannot contain more than one point in"));
        }
        entity.addMetric(metric2);
        TimelineMetric metric3 = new TimelineMetric(TimelineMetric.Type.SINGLE_VALUE);
        metric3.setId("test metric id 1");
        metric3.addValue(4L, (Number)4);
        Assert.assertEquals((String)"metric3 should equal to metric2! ", (Object)metric3, (Object)metric2);
        Assert.assertNotEquals((String)"metric1 should not equal to metric2! ", (Object)metric1, (Object)metric2);
        TimelineEvent event1 = new TimelineEvent();
        event1.setId("test event id 1");
        event1.addInfo("test info key 1", (Object)"test info value 1");
        event1.addInfo("test info key 2", Arrays.asList("test info value 2", "test info value 3"));
        event1.addInfo("test info key 3", (Object)true);
        Assert.assertTrue((boolean)(event1.getInfo().get("test info key 3") instanceof Boolean));
        event1.setTimestamp(1L);
        entity.addEvent(event1);
        TimelineEvent event2 = new TimelineEvent();
        event2.setId("test event id 2");
        event2.addInfo("test info key 1", (Object)"test info value 1");
        event2.addInfo("test info key 2", Arrays.asList("test info value 2", "test info value 3"));
        event2.addInfo("test info key 3", (Object)true);
        Assert.assertTrue((boolean)(event2.getInfo().get("test info key 3") instanceof Boolean));
        event2.setTimestamp(2L);
        entity.addEvent(event2);
        Assert.assertFalse((String)"event1 should not equal to event2! ", (boolean)event1.equals((Object)event2));
        TimelineEvent event3 = new TimelineEvent();
        event3.setId("test event id 1");
        event3.setTimestamp(1L);
        Assert.assertEquals((String)"event1 should equal to event3! ", (Object)event3, (Object)event1);
        Assert.assertNotEquals((String)"event1 should not equal to event2! ", (Object)event1, (Object)event2);
        entity.setCreatedTime(Long.valueOf(0L));
        entity.addRelatesToEntity("test type 2", "test id 2");
        entity.addRelatesToEntity("test type 3", "test id 3");
        entity.addIsRelatedToEntity("test type 4", "test id 4");
        entity.addIsRelatedToEntity("test type 5", "test id 5");
        LOG.info((Object)TimelineUtils.dumpTimelineRecordtoJSON((Object)entity, (boolean)true));
        TimelineEntities entities = new TimelineEntities();
        TimelineEntity entity1 = new TimelineEntity();
        entities.addEntity(entity1);
        TimelineEntity entity2 = new TimelineEntity();
        entities.addEntity(entity2);
        LOG.info((Object)TimelineUtils.dumpTimelineRecordtoJSON((Object)entities, (boolean)true));
        Assert.assertFalse((String)"entity 1 should not be valid without type and id", (boolean)entity1.isValid());
        entity1.setId("test id 2");
        entity1.setType("test type 2");
        entity2.setId("test id 1");
        entity2.setType("test type 1");
        Assert.assertEquals((String)"Timeline entity should equal to entity2! ", (Object)entity, (Object)entity2);
        Assert.assertNotEquals((String)"entity1 should not equal to entity! ", (Object)entity1, (Object)entity);
        Assert.assertEquals((String)"entity should be less than entity1! ", (long)entity1.compareTo(entity), (long)1L);
        Assert.assertEquals((String)("entity's hash code should be -28727840 but not " + entity.hashCode()), (long)entity.hashCode(), (long)-28727840L);
    }

    @Test
    public void testFirstClassCitizenEntities() throws Exception {
        UserEntity user = new UserEntity();
        user.setId("test user id");
        QueueEntity queue = new QueueEntity();
        queue.setId("test queue id");
        ClusterEntity cluster = new ClusterEntity();
        cluster.setId("test cluster id");
        FlowRunEntity flow1 = new FlowRunEntity();
        flow1.setUser(user.getId());
        flow1.setName("test flow name 1");
        flow1.setVersion("test flow version 1");
        flow1.setRunId(1L);
        FlowRunEntity flow2 = new FlowRunEntity();
        flow2.setUser(user.getId());
        flow2.setName("test flow name 2");
        flow2.setVersion("test flow version 2");
        flow2.setRunId(2L);
        ApplicationEntity app1 = new ApplicationEntity();
        app1.setId(ApplicationId.newInstance((long)0L, (int)1).toString());
        app1.setQueue(queue.getId());
        ApplicationEntity app2 = new ApplicationEntity();
        app2.setId(ApplicationId.newInstance((long)0L, (int)2).toString());
        app2.setQueue(queue.getId());
        ApplicationAttemptEntity appAttempt = new ApplicationAttemptEntity();
        appAttempt.setId(ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1).toString());
        ContainerEntity container = new ContainerEntity();
        container.setId(ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (long)1L).toString());
        cluster.addChild(TimelineEntityType.YARN_FLOW_RUN.toString(), flow1.getId());
        flow1.setParent(TimelineEntityType.YARN_CLUSTER.toString(), cluster.getId());
        flow1.addChild(TimelineEntityType.YARN_FLOW_RUN.toString(), flow2.getId());
        flow2.setParent(TimelineEntityType.YARN_FLOW_RUN.toString(), flow1.getId());
        flow2.addChild(TimelineEntityType.YARN_APPLICATION.toString(), app1.getId());
        flow2.addChild(TimelineEntityType.YARN_APPLICATION.toString(), app2.getId());
        app1.setParent(TimelineEntityType.YARN_FLOW_RUN.toString(), flow2.getId());
        app1.addChild(TimelineEntityType.YARN_APPLICATION_ATTEMPT.toString(), appAttempt.getId());
        appAttempt.setParent(TimelineEntityType.YARN_APPLICATION.toString(), app1.getId());
        app2.setParent(TimelineEntityType.YARN_FLOW_RUN.toString(), flow2.getId());
        appAttempt.addChild(TimelineEntityType.YARN_CONTAINER.toString(), container.getId());
        container.setParent(TimelineEntityType.YARN_APPLICATION_ATTEMPT.toString(), appAttempt.getId());
        LOG.info((Object)TimelineUtils.dumpTimelineRecordtoJSON((Object)cluster, (boolean)true));
        LOG.info((Object)TimelineUtils.dumpTimelineRecordtoJSON((Object)flow1, (boolean)true));
        LOG.info((Object)TimelineUtils.dumpTimelineRecordtoJSON((Object)flow2, (boolean)true));
        LOG.info((Object)TimelineUtils.dumpTimelineRecordtoJSON((Object)app1, (boolean)true));
        LOG.info((Object)TimelineUtils.dumpTimelineRecordtoJSON((Object)app2, (boolean)true));
        LOG.info((Object)TimelineUtils.dumpTimelineRecordtoJSON((Object)appAttempt, (boolean)true));
        LOG.info((Object)TimelineUtils.dumpTimelineRecordtoJSON((Object)container, (boolean)true));
        Assert.assertNotNull((Object)app1.getParent());
        Assert.assertEquals((Object)flow2.getType(), (Object)app1.getParent().getType());
        Assert.assertEquals((Object)flow2.getId(), (Object)app1.getParent().getId());
        app1.addInfo("SYSTEM_INFO_PARENT_ENTITY", (Object)"invalid parent object");
        try {
            app1.getParent();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof YarnRuntimeException));
            Assert.assertTrue((boolean)e.getMessage().contains("Parent info is invalid identifier object"));
        }
        Assert.assertNotNull((Object)app1.getChildren());
        Assert.assertEquals((long)1L, (long)app1.getChildren().size());
        Assert.assertEquals((Object)appAttempt.getType(), (Object)((TimelineEntity.Identifier)app1.getChildren().iterator().next()).getType());
        Assert.assertEquals((Object)appAttempt.getId(), (Object)((TimelineEntity.Identifier)app1.getChildren().iterator().next()).getId());
        app1.addInfo("SYSTEM_INFO_CHILDREN_ENTITY", Collections.singletonList("invalid children set"));
        try {
            app1.getChildren();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof YarnRuntimeException));
            Assert.assertTrue((boolean)e.getMessage().contains("Children info is invalid identifier set"));
        }
        app1.addInfo("SYSTEM_INFO_CHILDREN_ENTITY", Collections.singleton("invalid child object"));
        try {
            app1.getChildren();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof YarnRuntimeException));
            Assert.assertTrue((boolean)e.getMessage().contains("Children info contains invalid identifier object"));
        }
    }

    @Test
    public void testUser() throws Exception {
        UserEntity user = new UserEntity();
        user.setId("test user id");
        user.addInfo("test info key 1", (Object)"test info value 1");
        user.addInfo("test info key 2", (Object)"test info value 2");
        LOG.info((Object)TimelineUtils.dumpTimelineRecordtoJSON((Object)user, (boolean)true));
    }

    @Test
    public void testQueue() throws Exception {
        QueueEntity queue = new QueueEntity();
        queue.setId("test queue id");
        queue.addInfo("test info key 1", (Object)"test info value 1");
        queue.addInfo("test info key 2", (Object)"test info value 2");
        queue.setParent(TimelineEntityType.YARN_QUEUE.toString(), "test parent queue id");
        queue.addChild(TimelineEntityType.YARN_QUEUE.toString(), "test child queue id 1");
        queue.addChild(TimelineEntityType.YARN_QUEUE.toString(), "test child queue id 2");
        LOG.info((Object)TimelineUtils.dumpTimelineRecordtoJSON((Object)queue, (boolean)true));
    }
}

