/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation.filecontroller;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileController;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class TestLogAggregationFileController {
    @Test
    public void testRemoteDirCreationWithCustomUser() throws Exception {
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        ((FileSystem)Mockito.doReturn((Object)new URI("")).when((Object)fs)).getUri();
        ((FileSystem)Mockito.doReturn((Object)new FileStatus(128L, false, 0, 64L, System.currentTimeMillis(), System.currentTimeMillis(), new FsPermission(LogAggregationFileController.TLDIR_PERMISSIONS), "not_yarn_user", "yarn_group", new Path("/tmp/logs"))).when((Object)fs)).getFileStatus((Path)Mockito.any(Path.class));
        Configuration conf = new Configuration();
        LogAggregationFileController controller = (LogAggregationFileController)Mockito.mock(LogAggregationFileController.class, (Answer)Mockito.CALLS_REAL_METHODS);
        controller.fsSupportsChmod = true;
        ((LogAggregationFileController)Mockito.doReturn((Object)fs).when((Object)controller)).getFileSystem((Configuration)Mockito.any(Configuration.class));
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"yarn_user", (String[])new String[]{"yarn_group", "other_group"});
        UserGroupInformation.setLoginUser((UserGroupInformation)ugi);
        ((LogAggregationFileController)Mockito.doNothing().when((Object)controller)).initInternal((Configuration)Mockito.any(Configuration.class));
        controller.initialize(conf, "TFile");
        controller.verifyAndCreateRemoteLogDir();
        ((FileSystem)Mockito.verify((Object)fs)).createNewFile((Path)Mockito.any());
        ((FileSystem)Mockito.verify((Object)fs)).setPermission((Path)Mockito.any(), (FsPermission)Mockito.eq((Object)new FsPermission(LogAggregationFileController.TLDIR_PERMISSIONS)));
        ((FileSystem)Mockito.verify((Object)fs)).delete((Path)Mockito.any(), Mockito.eq((boolean)false));
        Assert.assertTrue((boolean)controller.fsSupportsChmod);
    }
}

