/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.nodelabels;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.NodeAttribute;
import org.apache.hadoop.yarn.api.records.NodeAttributeType;
import org.apache.hadoop.yarn.nodelabels.NodeLabelUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestNodeLabelUtil {
    @Test
    public void testAttributeValueAddition() {
        String[] invalidVals;
        String[] values;
        for (String val : values = new String[]{"1_8", "1.8", "ABZ", "ABZ", "az", "a-z", "a_z", "123456789"}) {
            try {
                NodeLabelUtil.checkAndThrowAttributeValue((String)val);
            }
            catch (Exception e) {
                Assert.fail((String)("Valid values for NodeAttributeValue :" + val));
            }
        }
        for (String val : invalidVals = new String[]{"_18", "1,8", "1/5", ".15", "1\\5"}) {
            try {
                NodeLabelUtil.checkAndThrowAttributeValue((String)val);
                Assert.fail((String)("Valid values for NodeAttributeValue :" + val));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Test
    public void testIsNodeAttributesEquals() {
        NodeAttribute nodeAttributeCK1V1 = NodeAttribute.newInstance((String)"rm.yarn.io", (String)"K1", (NodeAttributeType)NodeAttributeType.STRING, (String)"V1");
        NodeAttribute nodeAttributeCK1V1Copy = NodeAttribute.newInstance((String)"rm.yarn.io", (String)"K1", (NodeAttributeType)NodeAttributeType.STRING, (String)"V1");
        NodeAttribute nodeAttributeDK1V1 = NodeAttribute.newInstance((String)"nm.yarn.io", (String)"K1", (NodeAttributeType)NodeAttributeType.STRING, (String)"V1");
        NodeAttribute nodeAttributeDK1V1Copy = NodeAttribute.newInstance((String)"nm.yarn.io", (String)"K1", (NodeAttributeType)NodeAttributeType.STRING, (String)"V1");
        NodeAttribute nodeAttributeDK2V1 = NodeAttribute.newInstance((String)"nm.yarn.io", (String)"K2", (NodeAttributeType)NodeAttributeType.STRING, (String)"V1");
        NodeAttribute nodeAttributeDK2V2 = NodeAttribute.newInstance((String)"nm.yarn.io", (String)"K2", (NodeAttributeType)NodeAttributeType.STRING, (String)"V2");
        Assert.assertTrue((boolean)NodeLabelUtil.isNodeAttributesEquals(null, null));
        Assert.assertTrue((boolean)NodeLabelUtil.isNodeAttributesEquals((Set)ImmutableSet.of(), (Set)ImmutableSet.of()));
        Assert.assertTrue((boolean)NodeLabelUtil.isNodeAttributesEquals((Set)ImmutableSet.of((Object)nodeAttributeCK1V1), (Set)ImmutableSet.of((Object)nodeAttributeCK1V1Copy)));
        Assert.assertTrue((boolean)NodeLabelUtil.isNodeAttributesEquals((Set)ImmutableSet.of((Object)nodeAttributeDK1V1), (Set)ImmutableSet.of((Object)nodeAttributeDK1V1Copy)));
        Assert.assertTrue((boolean)NodeLabelUtil.isNodeAttributesEquals((Set)ImmutableSet.of((Object)nodeAttributeCK1V1, (Object)nodeAttributeDK1V1), (Set)ImmutableSet.of((Object)nodeAttributeCK1V1Copy, (Object)nodeAttributeDK1V1Copy)));
        Assert.assertFalse((boolean)NodeLabelUtil.isNodeAttributesEquals(null, (Set)ImmutableSet.of()));
        Assert.assertFalse((boolean)NodeLabelUtil.isNodeAttributesEquals((Set)ImmutableSet.of(), null));
        Assert.assertFalse((boolean)NodeLabelUtil.isNodeAttributesEquals((Set)ImmutableSet.of((Object)nodeAttributeCK1V1), (Set)ImmutableSet.of((Object)nodeAttributeDK1V1)));
        Assert.assertFalse((boolean)NodeLabelUtil.isNodeAttributesEquals((Set)ImmutableSet.of((Object)nodeAttributeDK1V1), (Set)ImmutableSet.of((Object)nodeAttributeDK2V1)));
        Assert.assertFalse((boolean)NodeLabelUtil.isNodeAttributesEquals((Set)ImmutableSet.of((Object)nodeAttributeDK2V1), (Set)ImmutableSet.of((Object)nodeAttributeDK2V2)));
        Assert.assertFalse((boolean)NodeLabelUtil.isNodeAttributesEquals((Set)ImmutableSet.of((Object)nodeAttributeCK1V1), (Set)ImmutableSet.of()));
        Assert.assertFalse((boolean)NodeLabelUtil.isNodeAttributesEquals((Set)ImmutableSet.of((Object)nodeAttributeCK1V1), (Set)ImmutableSet.of((Object)nodeAttributeCK1V1, (Object)nodeAttributeDK1V1)));
        Assert.assertFalse((boolean)NodeLabelUtil.isNodeAttributesEquals((Set)ImmutableSet.of((Object)nodeAttributeCK1V1, (Object)nodeAttributeDK1V1), (Set)ImmutableSet.of((Object)nodeAttributeDK1V1)));
    }
}

