/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.resource;

import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestResourceCalculator {
    private static final String EXTRA_RESOURCE_NAME = "test";
    private final ResourceCalculator resourceCalculator;

    @Parameterized.Parameters
    public static Collection<ResourceCalculator[]> getParameters() {
        return Arrays.asList({new DefaultResourceCalculator()}, {new DominantResourceCalculator()});
    }

    @Before
    public void setupNoExtraResource() {
        ResourceUtils.resetResourceTypes((Configuration)new Configuration());
    }

    private static void setupExtraResource() {
        Configuration conf = new Configuration();
        conf.set("yarn.resource-types", EXTRA_RESOURCE_NAME);
        ResourceUtils.resetResourceTypes((Configuration)conf);
    }

    public TestResourceCalculator(ResourceCalculator rs) {
        this.resourceCalculator = rs;
    }

    @Test(timeout=10000L)
    public void testFitsIn() {
        if (this.resourceCalculator instanceof DefaultResourceCalculator) {
            Assert.assertTrue((boolean)this.resourceCalculator.fitsIn(Resource.newInstance((int)1, (int)2), Resource.newInstance((int)2, (int)1)));
            Assert.assertTrue((boolean)this.resourceCalculator.fitsIn(Resource.newInstance((int)1, (int)2), Resource.newInstance((int)2, (int)2)));
            Assert.assertTrue((boolean)this.resourceCalculator.fitsIn(Resource.newInstance((int)1, (int)2), Resource.newInstance((int)1, (int)2)));
            Assert.assertTrue((boolean)this.resourceCalculator.fitsIn(Resource.newInstance((int)1, (int)2), Resource.newInstance((int)1, (int)1)));
            Assert.assertFalse((boolean)this.resourceCalculator.fitsIn(Resource.newInstance((int)2, (int)1), Resource.newInstance((int)1, (int)2)));
        } else if (this.resourceCalculator instanceof DominantResourceCalculator) {
            Assert.assertFalse((boolean)this.resourceCalculator.fitsIn(Resource.newInstance((int)1, (int)2), Resource.newInstance((int)2, (int)1)));
            Assert.assertTrue((boolean)this.resourceCalculator.fitsIn(Resource.newInstance((int)1, (int)2), Resource.newInstance((int)2, (int)2)));
            Assert.assertTrue((boolean)this.resourceCalculator.fitsIn(Resource.newInstance((int)1, (int)2), Resource.newInstance((int)1, (int)2)));
            Assert.assertFalse((boolean)this.resourceCalculator.fitsIn(Resource.newInstance((int)1, (int)2), Resource.newInstance((int)1, (int)1)));
            Assert.assertFalse((boolean)this.resourceCalculator.fitsIn(Resource.newInstance((int)2, (int)1), Resource.newInstance((int)1, (int)2)));
        }
    }

    private Resource newResource(long memory, int cpu) {
        Resource res = Resource.newInstance((long)memory, (int)cpu);
        return res;
    }

    private Resource newResource(long memory, int cpu, int extraResource) {
        Resource res = this.newResource(memory, cpu);
        res.setResourceValue(EXTRA_RESOURCE_NAME, (long)extraResource);
        return res;
    }

    private void assertComparison(Resource cluster, Resource res1, Resource res2, int expected) {
        int actual = this.resourceCalculator.compare(cluster, res1, res2);
        Assert.assertEquals((String)String.format("Resource comparison did not give the expected result for %s v/s %s", res1.toString(), res2.toString()), (long)expected, (long)actual);
        if (expected != 0) {
            actual = this.resourceCalculator.compare(cluster, res2, res1);
            Assert.assertEquals((String)String.format("Resource comparison did not give the expected result for %s v/s %s", res2.toString(), res1.toString()), (long)(expected * -1), (long)actual);
        }
    }

    @Test
    public void testCompareWithOnlyMandatory() {
        Resource cluster = this.newResource(4L, 4);
        this.assertComparison(cluster, this.newResource(1L, 1), this.newResource(1L, 1), 0);
        this.assertComparison(cluster, this.newResource(0L, 0), this.newResource(0L, 0), 0);
        this.assertComparison(cluster, this.newResource(2L, 2), this.newResource(1L, 1), 1);
        this.assertComparison(cluster, this.newResource(2L, 2), this.newResource(0L, 0), 1);
        if (this.resourceCalculator instanceof DefaultResourceCalculator) {
            this.testCompareDefaultWithOnlyMandatory(cluster);
        } else if (this.resourceCalculator instanceof DominantResourceCalculator) {
            this.testCompareDominantWithOnlyMandatory(cluster);
        }
    }

    private void testCompareDefaultWithOnlyMandatory(Resource cluster) {
        this.assertComparison(cluster, this.newResource(1L, 1), this.newResource(1L, 1), 0);
        this.assertComparison(cluster, this.newResource(1L, 2), this.newResource(1L, 1), 0);
        this.assertComparison(cluster, this.newResource(1L, 1), this.newResource(1L, 0), 0);
        this.assertComparison(cluster, this.newResource(2L, 1), this.newResource(1L, 1), 1);
        this.assertComparison(cluster, this.newResource(2L, 1), this.newResource(1L, 2), 1);
        this.assertComparison(cluster, this.newResource(2L, 1), this.newResource(1L, 0), 1);
    }

    private void testCompareDominantWithOnlyMandatory(Resource cluster) {
        this.assertComparison(cluster, this.newResource(2L, 1), this.newResource(2L, 1), 0);
        this.assertComparison(cluster, this.newResource(2L, 1), this.newResource(1L, 2), 0);
        this.assertComparison(cluster, this.newResource(2L, 1), this.newResource(1L, 1), 1);
        this.assertComparison(cluster, this.newResource(2L, 2), this.newResource(2L, 1), 1);
        this.assertComparison(cluster, this.newResource(2L, 2), this.newResource(1L, 2), 1);
        this.assertComparison(cluster, this.newResource(3L, 1), this.newResource(3L, 0), 1);
    }

    @Test
    public void testCompare() {
        TestResourceCalculator.setupExtraResource();
        Resource cluster = this.newResource(4L, 4, 4);
        this.assertComparison(cluster, this.newResource(1L, 1, 1), this.newResource(1L, 1, 1), 0);
        this.assertComparison(cluster, this.newResource(0L, 0, 0), this.newResource(0L, 0, 0), 0);
        this.assertComparison(cluster, this.newResource(2L, 2, 2), this.newResource(1L, 1, 1), 1);
        this.assertComparison(cluster, this.newResource(2L, 2, 2), this.newResource(0L, 0, 0), 1);
        if (this.resourceCalculator instanceof DefaultResourceCalculator) {
            this.testCompareDefault(cluster);
        } else if (this.resourceCalculator instanceof DominantResourceCalculator) {
            this.testCompareDominant(cluster);
            this.testCompareDominantZeroValueResource();
        }
    }

    private void testCompareDefault(Resource cluster) {
        this.assertComparison(cluster, this.newResource(1L, 1, 2), this.newResource(1L, 1, 1), 0);
        this.assertComparison(cluster, this.newResource(1L, 2, 1), this.newResource(1L, 1, 1), 0);
        this.assertComparison(cluster, this.newResource(1L, 2, 2), this.newResource(1L, 1, 1), 0);
        this.assertComparison(cluster, this.newResource(1L, 2, 2), this.newResource(1L, 0, 0), 0);
        this.assertComparison(cluster, this.newResource(2L, 1, 1), this.newResource(1L, 1, 1), 1);
        this.assertComparison(cluster, this.newResource(2L, 1, 1), this.newResource(1L, 2, 1), 1);
        this.assertComparison(cluster, this.newResource(2L, 1, 1), this.newResource(1L, 1, 2), 1);
        this.assertComparison(cluster, this.newResource(2L, 1, 1), this.newResource(1L, 2, 2), 1);
        this.assertComparison(cluster, this.newResource(2L, 1, 1), this.newResource(1L, 0, 0), 1);
    }

    private void testCompareDominantZeroValueResource() {
        Resource cluster = this.newResource(4L, 4, 0);
        this.assertComparison(cluster, this.newResource(2L, 1, 1), this.newResource(1L, 1, 2), 1);
        this.assertComparison(cluster, this.newResource(2L, 2, 1), this.newResource(1L, 2, 2), 1);
        this.assertComparison(cluster, this.newResource(2L, 2, 1), this.newResource(2L, 2, 2), 0);
        this.assertComparison(cluster, this.newResource(0L, 2, 1), this.newResource(0L, 2, 2), 0);
        this.assertComparison(cluster, this.newResource(0L, 1, 2), this.newResource(1L, 1, 2), -1);
        this.assertComparison(cluster, this.newResource(1L, 1, 2), this.newResource(2L, 1, 2), -1);
        cluster = this.newResource(0L, 0, 0);
        this.assertComparison(cluster, this.newResource(2L, 1, 1), this.newResource(1L, 1, 1), 1);
        this.assertComparison(cluster, this.newResource(2L, 2, 2), this.newResource(1L, 1, 1), 1);
        this.assertComparison(cluster, this.newResource(2L, 1, 1), this.newResource(1L, 2, 1), 0);
        this.assertComparison(cluster, this.newResource(1L, 1, 1), this.newResource(1L, 1, 1), 0);
        this.assertComparison(cluster, this.newResource(1L, 1, 1), this.newResource(1L, 1, 2), -1);
        this.assertComparison(cluster, this.newResource(1L, 1, 1), this.newResource(1L, 2, 1), -1);
    }

    private void testCompareDominant(Resource cluster) {
        this.assertComparison(cluster, this.newResource(2L, 1, 1), this.newResource(2L, 1, 1), 0);
        this.assertComparison(cluster, this.newResource(2L, 1, 1), this.newResource(1L, 2, 1), 0);
        this.assertComparison(cluster, this.newResource(2L, 1, 1), this.newResource(1L, 1, 2), 0);
        this.assertComparison(cluster, this.newResource(2L, 1, 0), this.newResource(0L, 1, 2), 0);
        this.assertComparison(cluster, this.newResource(2L, 2, 1), this.newResource(1L, 2, 2), 0);
        this.assertComparison(cluster, this.newResource(2L, 2, 1), this.newResource(2L, 1, 2), 0);
        this.assertComparison(cluster, this.newResource(2L, 2, 1), this.newResource(2L, 2, 1), 0);
        this.assertComparison(cluster, this.newResource(2L, 2, 0), this.newResource(2L, 0, 2), 0);
        this.assertComparison(cluster, this.newResource(3L, 2, 1), this.newResource(3L, 2, 1), 0);
        this.assertComparison(cluster, this.newResource(3L, 2, 1), this.newResource(3L, 1, 2), 0);
        this.assertComparison(cluster, this.newResource(3L, 2, 1), this.newResource(1L, 2, 3), 0);
        this.assertComparison(cluster, this.newResource(3L, 2, 1), this.newResource(1L, 3, 2), 0);
        this.assertComparison(cluster, this.newResource(3L, 2, 1), this.newResource(2L, 1, 3), 0);
        this.assertComparison(cluster, this.newResource(3L, 2, 1), this.newResource(2L, 3, 1), 0);
        this.assertComparison(cluster, this.newResource(2L, 1, 1), this.newResource(1L, 1, 1), 1);
        this.assertComparison(cluster, this.newResource(2L, 1, 1), this.newResource(1L, 1, 0), 1);
        this.assertComparison(cluster, this.newResource(2L, 2, 1), this.newResource(2L, 1, 1), 1);
        this.assertComparison(cluster, this.newResource(2L, 2, 1), this.newResource(1L, 2, 1), 1);
        this.assertComparison(cluster, this.newResource(2L, 2, 1), this.newResource(1L, 1, 2), 1);
        this.assertComparison(cluster, this.newResource(2L, 2, 1), this.newResource(0L, 2, 2), 1);
        this.assertComparison(cluster, this.newResource(2L, 2, 2), this.newResource(2L, 1, 1), 1);
        this.assertComparison(cluster, this.newResource(2L, 2, 2), this.newResource(1L, 2, 1), 1);
        this.assertComparison(cluster, this.newResource(2L, 2, 2), this.newResource(1L, 1, 2), 1);
        this.assertComparison(cluster, this.newResource(2L, 2, 2), this.newResource(2L, 2, 1), 1);
        this.assertComparison(cluster, this.newResource(2L, 2, 2), this.newResource(2L, 1, 2), 1);
        this.assertComparison(cluster, this.newResource(2L, 2, 2), this.newResource(1L, 2, 2), 1);
        this.assertComparison(cluster, this.newResource(3L, 2, 1), this.newResource(2L, 2, 2), 1);
        this.assertComparison(cluster, this.newResource(3L, 1, 1), this.newResource(2L, 2, 2), 1);
        this.assertComparison(cluster, this.newResource(3L, 1, 1), this.newResource(3L, 1, 0), 1);
        this.assertComparison(cluster, this.newResource(3L, 1, 1), this.newResource(3L, 0, 0), 1);
    }

    @Test(timeout=10000L)
    public void testCompareWithEmptyCluster() {
        Resource clusterResource = Resource.newInstance((int)0, (int)0);
        Resource lhs = Resource.newInstance((int)0, (int)0);
        Resource rhs = Resource.newInstance((int)0, (int)0);
        this.assertResourcesOperations(clusterResource, lhs, rhs, false, true, false, true, lhs, lhs);
        lhs = Resource.newInstance((int)1, (int)1);
        rhs = Resource.newInstance((int)0, (int)0);
        this.assertResourcesOperations(clusterResource, lhs, rhs, false, false, true, true, lhs, rhs);
        lhs = Resource.newInstance((int)0, (int)0);
        rhs = Resource.newInstance((int)1, (int)1);
        this.assertResourcesOperations(clusterResource, lhs, rhs, true, true, false, false, rhs, lhs);
        if (!(this.resourceCalculator instanceof DominantResourceCalculator)) {
            return;
        }
        lhs = Resource.newInstance((int)1, (int)0);
        rhs = Resource.newInstance((int)0, (int)1);
        this.assertResourcesOperations(clusterResource, lhs, rhs, false, true, false, true, lhs, lhs);
        lhs = Resource.newInstance((int)0, (int)1);
        rhs = Resource.newInstance((int)1, (int)0);
        this.assertResourcesOperations(clusterResource, lhs, rhs, false, true, false, true, lhs, lhs);
        lhs = Resource.newInstance((int)1, (int)1);
        rhs = Resource.newInstance((int)1, (int)0);
        this.assertResourcesOperations(clusterResource, lhs, rhs, false, false, true, true, lhs, rhs);
        lhs = Resource.newInstance((int)0, (int)1);
        rhs = Resource.newInstance((int)1, (int)1);
        this.assertResourcesOperations(clusterResource, lhs, rhs, true, true, false, false, rhs, lhs);
    }

    private void assertResourcesOperations(Resource clusterResource, Resource lhs, Resource rhs, boolean lessThan, boolean lessThanOrEqual, boolean greaterThan, boolean greaterThanOrEqual, Resource max, Resource min) {
        Assert.assertEquals((String)"Less Than operation is wrongly calculated.", (Object)lessThan, (Object)Resources.lessThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)lhs, (Resource)rhs));
        Assert.assertEquals((String)"Less Than Or Equal To operation is wrongly calculated.", (Object)lessThanOrEqual, (Object)Resources.lessThanOrEqual((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)lhs, (Resource)rhs));
        Assert.assertEquals((String)"Greater Than operation is wrongly calculated.", (Object)greaterThan, (Object)Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)lhs, (Resource)rhs));
        Assert.assertEquals((String)"Greater Than Or Equal To operation is wrongly calculated.", (Object)greaterThanOrEqual, (Object)Resources.greaterThanOrEqual((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)lhs, (Resource)rhs));
        Assert.assertEquals((String)"Max(value) Operation wrongly calculated.", (Object)max, (Object)Resources.max((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)lhs, (Resource)rhs));
        Assert.assertEquals((String)"Min(value) operation is wrongly calculated.", (Object)min, (Object)Resources.min((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)lhs, (Resource)rhs));
    }

    @Test(timeout=10000L)
    public void testNormalize() {
        Resource result;
        Resource ask = Resource.newInstance((int)1111, (int)2);
        Resource min = Resource.newInstance((int)1024, (int)1);
        Resource max = Resource.newInstance((int)8192, (int)8);
        Resource increment = Resource.newInstance((int)1024, (int)4);
        if (this.resourceCalculator instanceof DefaultResourceCalculator) {
            result = Resources.normalize((ResourceCalculator)this.resourceCalculator, (Resource)ask, (Resource)min, (Resource)max, (Resource)increment);
            Assert.assertEquals((long)2048L, (long)result.getMemorySize());
        } else if (this.resourceCalculator instanceof DominantResourceCalculator) {
            result = Resources.normalize((ResourceCalculator)this.resourceCalculator, (Resource)ask, (Resource)min, (Resource)max, (Resource)increment);
            Assert.assertEquals((long)2048L, (long)result.getMemorySize());
            Assert.assertEquals((long)4L, (long)result.getVirtualCores());
        }
        ask = Resource.newInstance((int)512, (int)0);
        min = Resource.newInstance((int)2048, (int)2);
        max = Resource.newInstance((int)8192, (int)8);
        increment = Resource.newInstance((int)1024, (int)1);
        if (this.resourceCalculator instanceof DefaultResourceCalculator) {
            result = Resources.normalize((ResourceCalculator)this.resourceCalculator, (Resource)ask, (Resource)min, (Resource)max, (Resource)increment);
            Assert.assertEquals((long)2048L, (long)result.getMemorySize());
        } else if (this.resourceCalculator instanceof DominantResourceCalculator) {
            result = Resources.normalize((ResourceCalculator)this.resourceCalculator, (Resource)ask, (Resource)min, (Resource)max, (Resource)increment);
            Assert.assertEquals((long)2048L, (long)result.getMemorySize());
            Assert.assertEquals((long)2L, (long)result.getVirtualCores());
        }
        ask = Resource.newInstance((int)9216, (int)9);
        min = Resource.newInstance((int)2048, (int)2);
        max = Resource.newInstance((int)8192, (int)8);
        increment = Resource.newInstance((int)1024, (int)1);
        if (this.resourceCalculator instanceof DefaultResourceCalculator) {
            result = Resources.normalize((ResourceCalculator)this.resourceCalculator, (Resource)ask, (Resource)min, (Resource)max, (Resource)increment);
            Assert.assertEquals((long)8192L, (long)result.getMemorySize());
        } else if (this.resourceCalculator instanceof DominantResourceCalculator) {
            result = Resources.normalize((ResourceCalculator)this.resourceCalculator, (Resource)ask, (Resource)min, (Resource)max, (Resource)increment);
            Assert.assertEquals((long)8192L, (long)result.getMemorySize());
            Assert.assertEquals((long)8L, (long)result.getVirtualCores());
        }
        ask = Resource.newInstance((int)1111, (int)2);
        min = Resource.newInstance((int)2048, (int)2);
        max = Resource.newInstance((int)8192, (int)8);
        increment = Resource.newInstance((int)0, (int)0);
        if (this.resourceCalculator instanceof DefaultResourceCalculator) {
            result = Resources.normalize((ResourceCalculator)this.resourceCalculator, (Resource)ask, (Resource)min, (Resource)max, (Resource)increment);
            Assert.assertEquals((long)2048L, (long)result.getMemorySize());
        } else if (this.resourceCalculator instanceof DominantResourceCalculator) {
            result = Resources.normalize((ResourceCalculator)this.resourceCalculator, (Resource)ask, (Resource)min, (Resource)max, (Resource)increment);
            Assert.assertEquals((long)2048L, (long)result.getMemorySize());
            Assert.assertEquals((long)2L, (long)result.getVirtualCores());
        }
    }

    @Test
    public void testRatioWithNoExtraResource() {
        Resource resource1 = this.newResource(1L, 1);
        Resource resource2 = this.newResource(2L, 1);
        float ratio = this.resourceCalculator.ratio(resource1, resource2);
        if (this.resourceCalculator instanceof DefaultResourceCalculator) {
            double ratioOfMemories = 0.5;
            Assert.assertEquals((double)ratioOfMemories, (double)ratio, (double)1.0E-5);
        } else if (this.resourceCalculator instanceof DominantResourceCalculator) {
            double ratioOfCPUs = 1.0;
            Assert.assertEquals((double)ratioOfCPUs, (double)ratio, (double)1.0E-5);
        }
    }

    @Test
    public void testRatioWithExtraResource() {
        TestResourceCalculator.setupExtraResource();
        Resource resource1 = this.newResource(1L, 1, 2);
        Resource resource2 = this.newResource(2L, 1, 1);
        float ratio = this.resourceCalculator.ratio(resource1, resource2);
        if (this.resourceCalculator instanceof DefaultResourceCalculator) {
            double ratioOfMemories = 0.5;
            Assert.assertEquals((double)ratioOfMemories, (double)ratio, (double)1.0E-5);
        } else if (this.resourceCalculator instanceof DominantResourceCalculator) {
            double ratioOfExtraResources = 2.0;
            Assert.assertEquals((double)ratioOfExtraResources, (double)ratio, (double)1.0E-5);
        }
    }
}

