/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.timeline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomains;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvents;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTimelineRecords {
    private static final Logger LOG = LoggerFactory.getLogger(TestTimelineRecords.class);

    @Test
    public void testEntities() throws Exception {
        TimelineEntities entities = new TimelineEntities();
        for (int j = 0; j < 2; ++j) {
            TimelineEntity entity = new TimelineEntity();
            entity.setEntityId("entity id " + j);
            entity.setEntityType("entity type " + j);
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            for (int i = 0; i < 2; ++i) {
                TimelineEvent event = new TimelineEvent();
                event.setTimestamp(System.currentTimeMillis());
                event.setEventType("event type " + i);
                event.addEventInfo("key1", (Object)"val1");
                event.addEventInfo("key2", (Object)"val2");
                entity.addEvent(event);
            }
            entity.addRelatedEntity("test ref type 1", "test ref id 1");
            entity.addRelatedEntity("test ref type 2", "test ref id 2");
            entity.addPrimaryFilter("pkey1", (Object)"pval1");
            entity.addPrimaryFilter("pkey2", (Object)"pval2");
            entity.addOtherInfo("okey1", (Object)"oval1");
            entity.addOtherInfo("okey2", (Object)"oval2");
            entity.setDomainId("domain id " + j);
            entities.addEntity(entity);
        }
        LOG.info("Entities in JSON:");
        LOG.info(TimelineUtils.dumpTimelineRecordtoJSON((Object)entities, (boolean)true));
        Assert.assertEquals((long)2L, (long)entities.getEntities().size());
        TimelineEntity entity1 = (TimelineEntity)entities.getEntities().get(0);
        Assert.assertEquals((Object)"entity id 0", (Object)entity1.getEntityId());
        Assert.assertEquals((Object)"entity type 0", (Object)entity1.getEntityType());
        Assert.assertEquals((long)2L, (long)entity1.getRelatedEntities().size());
        Assert.assertEquals((long)2L, (long)entity1.getEvents().size());
        Assert.assertEquals((long)2L, (long)entity1.getPrimaryFilters().size());
        Assert.assertEquals((long)2L, (long)entity1.getOtherInfo().size());
        Assert.assertEquals((Object)"domain id 0", (Object)entity1.getDomainId());
        TimelineEntity entity2 = (TimelineEntity)entities.getEntities().get(1);
        Assert.assertEquals((Object)"entity id 1", (Object)entity2.getEntityId());
        Assert.assertEquals((Object)"entity type 1", (Object)entity2.getEntityType());
        Assert.assertEquals((long)2L, (long)entity2.getRelatedEntities().size());
        Assert.assertEquals((long)2L, (long)entity2.getEvents().size());
        Assert.assertEquals((long)2L, (long)entity2.getPrimaryFilters().size());
        Assert.assertEquals((long)2L, (long)entity2.getOtherInfo().size());
        Assert.assertEquals((Object)"domain id 1", (Object)entity2.getDomainId());
    }

    @Test
    public void testEvents() throws Exception {
        TimelineEvents events = new TimelineEvents();
        for (int j = 0; j < 2; ++j) {
            TimelineEvents.EventsOfOneEntity partEvents = new TimelineEvents.EventsOfOneEntity();
            partEvents.setEntityId("entity id " + j);
            partEvents.setEntityType("entity type " + j);
            for (int i = 0; i < 2; ++i) {
                TimelineEvent event = new TimelineEvent();
                event.setTimestamp(System.currentTimeMillis());
                event.setEventType("event type " + i);
                event.addEventInfo("key1", (Object)"val1");
                event.addEventInfo("key2", (Object)"val2");
                partEvents.addEvent(event);
            }
            events.addEvent(partEvents);
        }
        LOG.info("Events in JSON:");
        LOG.info(TimelineUtils.dumpTimelineRecordtoJSON((Object)events, (boolean)true));
        Assert.assertEquals((long)2L, (long)events.getAllEvents().size());
        TimelineEvents.EventsOfOneEntity partEvents1 = (TimelineEvents.EventsOfOneEntity)events.getAllEvents().get(0);
        Assert.assertEquals((Object)"entity id 0", (Object)partEvents1.getEntityId());
        Assert.assertEquals((Object)"entity type 0", (Object)partEvents1.getEntityType());
        Assert.assertEquals((long)2L, (long)partEvents1.getEvents().size());
        TimelineEvent event11 = (TimelineEvent)partEvents1.getEvents().get(0);
        Assert.assertEquals((Object)"event type 0", (Object)event11.getEventType());
        Assert.assertEquals((long)2L, (long)event11.getEventInfo().size());
        TimelineEvent event12 = (TimelineEvent)partEvents1.getEvents().get(1);
        Assert.assertEquals((Object)"event type 1", (Object)event12.getEventType());
        Assert.assertEquals((long)2L, (long)event12.getEventInfo().size());
        TimelineEvents.EventsOfOneEntity partEvents2 = (TimelineEvents.EventsOfOneEntity)events.getAllEvents().get(1);
        Assert.assertEquals((Object)"entity id 1", (Object)partEvents2.getEntityId());
        Assert.assertEquals((Object)"entity type 1", (Object)partEvents2.getEntityType());
        Assert.assertEquals((long)2L, (long)partEvents2.getEvents().size());
        TimelineEvent event21 = (TimelineEvent)partEvents2.getEvents().get(0);
        Assert.assertEquals((Object)"event type 0", (Object)event21.getEventType());
        Assert.assertEquals((long)2L, (long)event21.getEventInfo().size());
        TimelineEvent event22 = (TimelineEvent)partEvents2.getEvents().get(1);
        Assert.assertEquals((Object)"event type 1", (Object)event22.getEventType());
        Assert.assertEquals((long)2L, (long)event22.getEventInfo().size());
    }

    @Test
    public void testTimelinePutErrors() throws Exception {
        TimelinePutResponse TimelinePutErrors = new TimelinePutResponse();
        TimelinePutResponse.TimelinePutError error1 = new TimelinePutResponse.TimelinePutError();
        error1.setEntityId("entity id 1");
        error1.setEntityId("entity type 1");
        error1.setErrorCode(1);
        TimelinePutErrors.addError(error1);
        ArrayList<TimelinePutResponse.TimelinePutError> response = new ArrayList<TimelinePutResponse.TimelinePutError>();
        response.add(error1);
        TimelinePutResponse.TimelinePutError error2 = new TimelinePutResponse.TimelinePutError();
        error2.setEntityId("entity id 2");
        error2.setEntityId("entity type 2");
        error2.setErrorCode(2);
        response.add(error2);
        TimelinePutErrors.addErrors(response);
        LOG.info("Errors in JSON:");
        LOG.info(TimelineUtils.dumpTimelineRecordtoJSON((Object)TimelinePutErrors, (boolean)true));
        Assert.assertEquals((long)3L, (long)TimelinePutErrors.getErrors().size());
        TimelinePutResponse.TimelinePutError e = (TimelinePutResponse.TimelinePutError)TimelinePutErrors.getErrors().get(0);
        Assert.assertEquals((Object)error1.getEntityId(), (Object)e.getEntityId());
        Assert.assertEquals((Object)error1.getEntityType(), (Object)e.getEntityType());
        Assert.assertEquals((long)error1.getErrorCode(), (long)e.getErrorCode());
        e = (TimelinePutResponse.TimelinePutError)TimelinePutErrors.getErrors().get(1);
        Assert.assertEquals((Object)error1.getEntityId(), (Object)e.getEntityId());
        Assert.assertEquals((Object)error1.getEntityType(), (Object)e.getEntityType());
        Assert.assertEquals((long)error1.getErrorCode(), (long)e.getErrorCode());
        e = (TimelinePutResponse.TimelinePutError)TimelinePutErrors.getErrors().get(2);
        Assert.assertEquals((Object)error2.getEntityId(), (Object)e.getEntityId());
        Assert.assertEquals((Object)error2.getEntityType(), (Object)e.getEntityType());
        Assert.assertEquals((long)error2.getErrorCode(), (long)e.getErrorCode());
    }

    @Test
    public void testTimelineDomain() throws Exception {
        int i;
        TimelineDomains domains = new TimelineDomains();
        TimelineDomain domain = null;
        for (i = 0; i < 2; ++i) {
            domain = new TimelineDomain();
            domain.setId("test id " + (i + 1));
            domain.setDescription("test description " + (i + 1));
            domain.setOwner("test owner " + (i + 1));
            domain.setReaders("test_reader_user_" + (i + 1) + " test_reader_group+" + (i + 1));
            domain.setWriters("test_writer_user_" + (i + 1) + " test_writer_group+" + (i + 1));
            domain.setCreatedTime(Long.valueOf(0L));
            domain.setModifiedTime(Long.valueOf(1L));
            domains.addDomain(domain);
        }
        LOG.info("Domain in JSON:");
        LOG.info(TimelineUtils.dumpTimelineRecordtoJSON((Object)domains, (boolean)true));
        Assert.assertEquals((long)2L, (long)domains.getDomains().size());
        for (i = 0; i < domains.getDomains().size(); ++i) {
            domain = (TimelineDomain)domains.getDomains().get(i);
            Assert.assertEquals((Object)("test id " + (i + 1)), (Object)domain.getId());
            Assert.assertEquals((Object)("test description " + (i + 1)), (Object)domain.getDescription());
            Assert.assertEquals((Object)("test owner " + (i + 1)), (Object)domain.getOwner());
            Assert.assertEquals((Object)("test_reader_user_" + (i + 1) + " test_reader_group+" + (i + 1)), (Object)domain.getReaders());
            Assert.assertEquals((Object)("test_writer_user_" + (i + 1) + " test_writer_group+" + (i + 1)), (Object)domain.getWriters());
            Assert.assertEquals((Object)new Long(0L), (Object)domain.getCreatedTime());
            Assert.assertEquals((Object)new Long(1L), (Object)domain.getModifiedTime());
        }
    }

    @Test
    public void testMapInterfaceOrTimelineRecords() throws Exception {
        TimelineEntity entity = new TimelineEntity();
        ArrayList<Map<String, Set<String>>> primaryFiltersList = new ArrayList<Map<String, Set<String>>>();
        primaryFiltersList.add(Collections.singletonMap("pkey", Collections.singleton("pval")));
        TreeMap<String, Set<String>> primaryFilters = new TreeMap<String, Set<String>>();
        primaryFilters.put("pkey1", Collections.singleton("pval1"));
        primaryFilters.put("pkey2", Collections.singleton("pval2"));
        primaryFiltersList.add(primaryFilters);
        entity.setPrimaryFilters(null);
        for (Map map : primaryFiltersList) {
            entity.setPrimaryFilters(map);
            TestTimelineRecords.assertPrimaryFilters(entity);
            WeakHashMap<String, Set<String>> primaryFiltersToAdd = new WeakHashMap<String, Set<String>>();
            primaryFiltersToAdd.put("pkey3", Collections.singleton("pval3"));
            entity.addPrimaryFilters(primaryFiltersToAdd);
            TestTimelineRecords.assertPrimaryFilters(entity);
        }
        ArrayList<Map<String, Set<String>>> relatedEntitiesList = new ArrayList<Map<String, Set<String>>>();
        relatedEntitiesList.add(Collections.singletonMap("rkey", Collections.singleton("rval")));
        TreeMap<String, Set<String>> treeMap = new TreeMap<String, Set<String>>();
        treeMap.put("rkey1", Collections.singleton("rval1"));
        treeMap.put("rkey2", Collections.singleton("rval2"));
        relatedEntitiesList.add(treeMap);
        entity.setRelatedEntities(null);
        for (Map map : relatedEntitiesList) {
            entity.setRelatedEntities(map);
            TestTimelineRecords.assertRelatedEntities(entity);
            WeakHashMap<String, Set<String>> relatedEntitiesToAdd = new WeakHashMap<String, Set<String>>();
            relatedEntitiesToAdd.put("rkey3", Collections.singleton("rval3"));
            entity.addRelatedEntities(relatedEntitiesToAdd);
            TestTimelineRecords.assertRelatedEntities(entity);
        }
        ArrayList<Map<String, String>> otherInfoList = new ArrayList<Map<String, String>>();
        otherInfoList.add(Collections.singletonMap("okey", "oval"));
        TreeMap<String, String> treeMap2 = new TreeMap<String, String>();
        treeMap2.put("okey1", "oval1");
        treeMap2.put("okey2", "oval2");
        otherInfoList.add(treeMap2);
        entity.setOtherInfo(null);
        for (Map map : otherInfoList) {
            entity.setOtherInfo(map);
            TestTimelineRecords.assertOtherInfo(entity);
            WeakHashMap<String, String> otherInfoToAdd = new WeakHashMap<String, String>();
            otherInfoToAdd.put("okey3", "oval3");
            entity.addOtherInfo(otherInfoToAdd);
            TestTimelineRecords.assertOtherInfo(entity);
        }
        TimelineEvent event = new TimelineEvent();
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        arrayList.add(Collections.singletonMap("ekey", "eval"));
        TreeMap<String, String> eventInfo = new TreeMap<String, String>();
        eventInfo.put("ekey1", "eval1");
        eventInfo.put("ekey2", "eval2");
        arrayList.add(eventInfo);
        event.setEventInfo(null);
        for (Map map : arrayList) {
            event.setEventInfo(map);
            TestTimelineRecords.assertEventInfo(event);
            WeakHashMap<String, String> eventInfoToAdd = new WeakHashMap<String, String>();
            eventInfoToAdd.put("ekey3", "eval3");
            event.addEventInfo(eventInfoToAdd);
            TestTimelineRecords.assertEventInfo(event);
        }
    }

    private static void assertPrimaryFilters(TimelineEntity entity) {
        Assert.assertNotNull((Object)entity.getPrimaryFilters());
        Assert.assertNotNull((Object)entity.getPrimaryFiltersJAXB());
        Assert.assertTrue((boolean)(entity.getPrimaryFilters() instanceof HashMap));
        Assert.assertTrue((boolean)(entity.getPrimaryFiltersJAXB() instanceof HashMap));
        Assert.assertEquals((Object)entity.getPrimaryFilters(), (Object)entity.getPrimaryFiltersJAXB());
    }

    private static void assertRelatedEntities(TimelineEntity entity) {
        Assert.assertNotNull((Object)entity.getRelatedEntities());
        Assert.assertNotNull((Object)entity.getRelatedEntitiesJAXB());
        Assert.assertTrue((boolean)(entity.getRelatedEntities() instanceof HashMap));
        Assert.assertTrue((boolean)(entity.getRelatedEntitiesJAXB() instanceof HashMap));
        Assert.assertEquals((Object)entity.getRelatedEntities(), (Object)entity.getRelatedEntitiesJAXB());
    }

    private static void assertOtherInfo(TimelineEntity entity) {
        Assert.assertNotNull((Object)entity.getOtherInfo());
        Assert.assertNotNull((Object)entity.getOtherInfoJAXB());
        Assert.assertTrue((boolean)(entity.getOtherInfo() instanceof HashMap));
        Assert.assertTrue((boolean)(entity.getOtherInfoJAXB() instanceof HashMap));
        Assert.assertEquals((Object)entity.getOtherInfo(), (Object)entity.getOtherInfoJAXB());
    }

    private static void assertEventInfo(TimelineEvent event) {
        Assert.assertNotNull((Object)event);
        Assert.assertNotNull((Object)event.getEventInfoJAXB());
        Assert.assertTrue((boolean)(event.getEventInfo() instanceof HashMap));
        Assert.assertTrue((boolean)(event.getEventInfoJAXB() instanceof HashMap));
        Assert.assertEquals((Object)event.getEventInfo(), (Object)event.getEventInfoJAXB());
    }
}

