/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.resource;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.api.resource.PlacementConstraintTransformations;
import org.apache.hadoop.yarn.api.resource.PlacementConstraints;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPlacementConstraintTransformations {
    @Test
    void testTargetConstraint() {
        PlacementConstraint.AbstractConstraint sConstraintExpr = PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"hbase-m"})});
        Assertions.assertTrue((boolean)(sConstraintExpr instanceof PlacementConstraint.SingleConstraint));
        PlacementConstraint sConstraint = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)sConstraintExpr);
        PlacementConstraintTransformations.SpecializedConstraintTransformer specTransformer = new PlacementConstraintTransformations.SpecializedConstraintTransformer(sConstraint);
        PlacementConstraint tConstraint = specTransformer.transform();
        PlacementConstraint.AbstractConstraint tConstraintExpr = tConstraint.getConstraintExpr();
        Assertions.assertTrue((boolean)(tConstraintExpr instanceof PlacementConstraint.TargetConstraint));
        PlacementConstraint.SingleConstraint single = (PlacementConstraint.SingleConstraint)sConstraintExpr;
        PlacementConstraint.TargetConstraint target = (PlacementConstraint.TargetConstraint)tConstraintExpr;
        Assertions.assertEquals((Object)single.toString(), (Object)target.toString());
        Assertions.assertEquals((Object)single.getScope(), (Object)target.getScope());
        Assertions.assertEquals((Object)PlacementConstraint.TargetConstraint.TargetOperator.IN, (Object)target.getOp());
        Assertions.assertEquals((Object)single.getTargetExpressions(), (Object)target.getTargetExpressions());
        PlacementConstraintTransformations.SingleConstraintTransformer singleTransformer = new PlacementConstraintTransformations.SingleConstraintTransformer(tConstraint);
        sConstraint = singleTransformer.transform();
        sConstraintExpr = sConstraint.getConstraintExpr();
        Assertions.assertTrue((boolean)(sConstraintExpr instanceof PlacementConstraint.SingleConstraint));
        single = (PlacementConstraint.SingleConstraint)sConstraintExpr;
        Assertions.assertEquals((Object)target.getScope(), (Object)single.getScope());
        Assertions.assertEquals((int)1, (int)single.getMinCardinality());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)single.getMaxCardinality());
        Assertions.assertEquals((Object)single.getTargetExpressions(), (Object)target.getTargetExpressions());
    }

    @Test
    void testCardinalityConstraint() {
        PlacementConstraint.CardinalityConstraint cardinality = new PlacementConstraint.CardinalityConstraint("rack", 3, 10, new HashSet<String>(Arrays.asList("hb")));
        PlacementConstraint cConstraint = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)cardinality);
        PlacementConstraintTransformations.SingleConstraintTransformer singleTransformer = new PlacementConstraintTransformations.SingleConstraintTransformer(cConstraint);
        PlacementConstraint sConstraint = singleTransformer.transform();
        PlacementConstraint.AbstractConstraint sConstraintExpr = sConstraint.getConstraintExpr();
        Assertions.assertTrue((boolean)(sConstraintExpr instanceof PlacementConstraint.SingleConstraint));
        PlacementConstraint.SingleConstraint single = (PlacementConstraint.SingleConstraint)sConstraintExpr;
        Assertions.assertEquals((Object)single.toString(), (Object)cardinality.toString());
        Assertions.assertEquals((Object)cardinality.getScope(), (Object)single.getScope());
        Assertions.assertEquals((int)cardinality.getMinCardinality(), (int)single.getMinCardinality());
        Assertions.assertEquals((int)cardinality.getMaxCardinality(), (int)single.getMaxCardinality());
        Assertions.assertEquals(new HashSet<PlacementConstraint.TargetExpression>(Arrays.asList(PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"hb"}))), (Object)single.getTargetExpressions());
    }

    @Test
    void testTargetCardinalityConstraint() {
        PlacementConstraint.AbstractConstraint constraintExpr = PlacementConstraints.targetCardinality((String)"rack", (int)3, (int)10, (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"zk"})});
        Assertions.assertTrue((boolean)(constraintExpr instanceof PlacementConstraint.SingleConstraint));
        PlacementConstraint constraint = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)constraintExpr);
        PlacementConstraintTransformations.SpecializedConstraintTransformer specTransformer = new PlacementConstraintTransformations.SpecializedConstraintTransformer(constraint);
        PlacementConstraint newConstraint = specTransformer.transform();
        Assertions.assertEquals((Object)constraintExpr, (Object)newConstraint.getConstraintExpr());
    }

    @Test
    void testCompositeConstraint() {
        PlacementConstraint.Or constraintExpr = PlacementConstraints.or((PlacementConstraint.AbstractConstraint[])new PlacementConstraint.AbstractConstraint[]{PlacementConstraints.targetIn((String)"rack", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"spark"})}), PlacementConstraints.maxCardinality((String)"node", (int)3, (String[])new String[0]), PlacementConstraints.targetCardinality((String)"rack", (int)2, (int)10, (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"zk"})})});
        Assertions.assertTrue((boolean)(constraintExpr instanceof PlacementConstraint.Or));
        PlacementConstraint constraint = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)constraintExpr);
        PlacementConstraint.Or orExpr = constraintExpr;
        for (PlacementConstraint.AbstractConstraint child : orExpr.getChildren()) {
            Assertions.assertTrue((boolean)(child instanceof PlacementConstraint.SingleConstraint));
        }
        PlacementConstraintTransformations.SpecializedConstraintTransformer specTransformer = new PlacementConstraintTransformations.SpecializedConstraintTransformer(constraint);
        PlacementConstraint specConstraint = specTransformer.transform();
        PlacementConstraint.Or specOrExpr = (PlacementConstraint.Or)specConstraint.getConstraintExpr();
        List specChildren = specOrExpr.getChildren();
        Assertions.assertEquals((int)3, (int)specChildren.size());
        Assertions.assertTrue((boolean)(specChildren.get(0) instanceof PlacementConstraint.TargetConstraint));
        Assertions.assertTrue((boolean)(specChildren.get(1) instanceof PlacementConstraint.SingleConstraint));
        Assertions.assertTrue((boolean)(specChildren.get(2) instanceof PlacementConstraint.SingleConstraint));
        PlacementConstraintTransformations.SingleConstraintTransformer singleTransformer = new PlacementConstraintTransformations.SingleConstraintTransformer(specConstraint);
        PlacementConstraint simConstraint = singleTransformer.transform();
        Assertions.assertTrue((boolean)(simConstraint.getConstraintExpr() instanceof PlacementConstraint.Or));
        PlacementConstraint.Or simOrExpr = (PlacementConstraint.Or)specConstraint.getConstraintExpr();
        for (PlacementConstraint.AbstractConstraint child : simOrExpr.getChildren()) {
            Assertions.assertTrue((boolean)(child instanceof PlacementConstraint.SingleConstraint));
        }
    }
}

