/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.ipc;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.thirdparty.protobuf.ServiceException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRPCUtil {
    @Test
    void testUnknownExceptionUnwrapping() {
        Class<YarnException> exception = YarnException.class;
        String className = "UnknownException.class";
        this.verifyRemoteExceptionUnwrapping(exception, className);
    }

    @Test
    void testRemoteIOExceptionUnwrapping() {
        Class<IOException> exception = IOException.class;
        this.verifyRemoteExceptionUnwrapping(exception, exception.getName());
    }

    @Test
    void testRemoteIOExceptionDerivativeUnwrapping() {
        Class<FileNotFoundException> exception = FileNotFoundException.class;
        this.verifyRemoteExceptionUnwrapping(exception, exception.getName());
    }

    @Test
    void testRemoteYarnExceptionUnwrapping() {
        Class<YarnException> exception = YarnException.class;
        this.verifyRemoteExceptionUnwrapping(exception, exception.getName());
    }

    @Test
    void testRemoteYarnExceptionDerivativeUnwrapping() {
        Class<YarnTestException> exception = YarnTestException.class;
        this.verifyRemoteExceptionUnwrapping(exception, exception.getName());
    }

    @Test
    void testRemoteRuntimeExceptionUnwrapping() {
        Class<NullPointerException> exception = NullPointerException.class;
        this.verifyRemoteExceptionUnwrapping(exception, exception.getName());
    }

    @Test
    void testUnexpectedRemoteExceptionUnwrapping() {
        Class<Exception> exception = Exception.class;
        this.verifyRemoteExceptionUnwrapping(RemoteException.class, exception.getName());
    }

    @Test
    void testRemoteYarnExceptionWithoutStringConstructor() {
        Class<YarnTestExceptionNoConstructor> exception = YarnTestExceptionNoConstructor.class;
        this.verifyRemoteExceptionUnwrapping(RemoteException.class, exception.getName());
    }

    @Test
    void testRPCServiceExceptionUnwrapping() {
        String message = "ServiceExceptionMessage";
        ServiceException se = new ServiceException(message);
        Throwable t = null;
        try {
            RPCUtil.unwrapAndThrowException((ServiceException)se);
        }
        catch (Throwable thrown) {
            t = thrown;
        }
        Assertions.assertTrue((boolean)IOException.class.isInstance(t));
        Assertions.assertTrue((boolean)t.getMessage().contains(message));
    }

    @Test
    void testRPCIOExceptionUnwrapping() {
        String message = "DirectIOExceptionMessage";
        FileNotFoundException ioException = new FileNotFoundException(message);
        ServiceException se = new ServiceException((Throwable)ioException);
        Throwable t = null;
        try {
            RPCUtil.unwrapAndThrowException((ServiceException)se);
        }
        catch (Throwable thrown) {
            t = thrown;
        }
        Assertions.assertTrue((boolean)FileNotFoundException.class.isInstance(t));
        Assertions.assertTrue((boolean)t.getMessage().contains(message));
    }

    @Test
    void testRPCRuntimeExceptionUnwrapping() {
        String message = "RPCRuntimeExceptionUnwrapping";
        NullPointerException re = new NullPointerException(message);
        ServiceException se = new ServiceException((Throwable)re);
        Throwable t = null;
        try {
            RPCUtil.unwrapAndThrowException((ServiceException)se);
        }
        catch (Throwable thrown) {
            t = thrown;
        }
        Assertions.assertTrue((boolean)NullPointerException.class.isInstance(t));
        Assertions.assertTrue((boolean)t.getMessage().contains(message));
    }

    private void verifyRemoteExceptionUnwrapping(Class<? extends Throwable> expectedLocalException, String realExceptionClassName) {
        String message = realExceptionClassName + "Message";
        RemoteException re = new RemoteException(realExceptionClassName, message);
        ServiceException se = new ServiceException((Throwable)re);
        Throwable t = null;
        try {
            RPCUtil.unwrapAndThrowException((ServiceException)se);
        }
        catch (Throwable thrown) {
            t = thrown;
        }
        Assertions.assertTrue((boolean)expectedLocalException.isInstance(t), (String)("Expected exception [" + expectedLocalException + "] but found " + t));
        Assertions.assertTrue((boolean)t.getMessage().contains(message), (String)("Expected message [" + message + "] but found " + t.getMessage()));
    }

    private static class YarnTestExceptionNoConstructor
    extends YarnException {
        private static final long serialVersionUID = 1L;

        private YarnTestExceptionNoConstructor() {
        }
    }

    private static class YarnTestException
    extends YarnException {
        private static final long serialVersionUID = 1L;

        public YarnTestException(String message) {
            super(message);
        }
    }
}

