/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation.testutils;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogDeletionService;
import org.apache.hadoop.yarn.logaggregation.testutils.MockRMClientUtils;

public class AggregatedLogDeletionServiceForTest
extends AggregatedLogDeletionService {
    private final List<ApplicationId> finishedApplications;
    private final List<ApplicationId> runningApplications;
    private final Configuration conf;
    private ApplicationClientProtocol mockRMClient;

    public AggregatedLogDeletionServiceForTest(List<ApplicationId> runningApplications, List<ApplicationId> finishedApplications) {
        this(runningApplications, finishedApplications, null);
    }

    public AggregatedLogDeletionServiceForTest(List<ApplicationId> runningApplications, List<ApplicationId> finishedApplications, Configuration conf) {
        this.runningApplications = runningApplications;
        this.finishedApplications = finishedApplications;
        this.conf = conf;
    }

    protected ApplicationClientProtocol createRMClient() throws IOException {
        if (this.mockRMClient != null) {
            return this.mockRMClient;
        }
        try {
            this.mockRMClient = MockRMClientUtils.createMockRMClient(this.finishedApplications, this.runningApplications);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return this.mockRMClient;
    }

    protected Configuration createConf() {
        return this.conf;
    }

    public ApplicationClientProtocol getMockRMClient() {
        return this.mockRMClient;
    }
}

