/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.util.Log4jWarningErrorMetricsAppender;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class TestLog4jWarningErrorMetricsAppender {
    Log4jWarningErrorMetricsAppender appender;
    private static final Logger LOG = LoggerFactory.getLogger(TestLog4jWarningErrorMetricsAppender.class);
    private static final Marker FATAL = MarkerFactory.getMarker((String)"FATAL");
    List<Long> cutoff = new ArrayList<Long>();

    void setupAppender(int cleanupIntervalSeconds, long messageAgeLimitSeconds, int maxUniqueMessages) {
        this.removeAppender();
        this.appender = new Log4jWarningErrorMetricsAppender(cleanupIntervalSeconds, messageAgeLimitSeconds, maxUniqueMessages);
        LogManager.getRootLogger().addAppender((Appender)this.appender);
    }

    void removeAppender() {
        LogManager.getRootLogger().removeAppender((Appender)this.appender);
    }

    void logMessages(Level level, String message, int count) {
        block8: for (int i = 0; i < count; ++i) {
            switch (level.toInt()) {
                case 50000: {
                    LOG.error(FATAL, message);
                    continue block8;
                }
                case 40000: {
                    LOG.error(message);
                    continue block8;
                }
                case 30000: {
                    LOG.warn(message);
                    continue block8;
                }
                case 20000: {
                    LOG.info(message);
                    continue block8;
                }
                case 10000: {
                    LOG.debug(message);
                    continue block8;
                }
                case 5000: {
                    LOG.trace(message);
                }
            }
        }
    }

    @Test
    void testPurge() throws Exception {
        this.setupAppender(2, 1L, 1);
        this.logMessages(Level.ERROR, "test message 1", 1);
        this.cutoff.clear();
        this.cutoff.add(0L);
        Assertions.assertEquals((int)1, (int)this.appender.getErrorCounts(this.cutoff).size());
        Assertions.assertEquals((long)1L, (long)((Integer)this.appender.getErrorCounts(this.cutoff).get(0)).longValue());
        Assertions.assertEquals((int)1, (int)((Map)this.appender.getErrorMessagesAndCounts(this.cutoff).get(0)).size());
        Thread.sleep(3000L);
        Assertions.assertEquals((int)1, (int)this.appender.getErrorCounts(this.cutoff).size());
        Assertions.assertEquals((long)0L, (long)((Integer)this.appender.getErrorCounts(this.cutoff).get(0)).longValue());
        Assertions.assertEquals((int)0, (int)((Map)this.appender.getErrorMessagesAndCounts(this.cutoff).get(0)).size());
        this.setupAppender(2, 1000L, 2);
        this.logMessages(Level.ERROR, "test message 1", 3);
        this.logMessages(Level.ERROR, "test message 2", 2);
        Assertions.assertEquals((int)1, (int)this.appender.getErrorCounts(this.cutoff).size());
        Assertions.assertEquals((long)5L, (long)((Integer)this.appender.getErrorCounts(this.cutoff).get(0)).longValue());
        Assertions.assertEquals((int)2, (int)((Map)this.appender.getErrorMessagesAndCounts(this.cutoff).get(0)).size());
        this.logMessages(Level.ERROR, "test message 3", 3);
        Thread.sleep(2000L);
        Assertions.assertEquals((long)8L, (long)((Integer)this.appender.getErrorCounts(this.cutoff).get(0)).longValue());
        Assertions.assertEquals((int)2, (int)((Map)this.appender.getErrorMessagesAndCounts(this.cutoff).get(0)).size());
    }

    @Test
    void testErrorCounts() throws Exception {
        this.cutoff.clear();
        this.setupAppender(100, 100L, 100);
        this.cutoff.add(0L);
        this.logMessages(Level.ERROR, "test message 1", 2);
        this.logMessages(Level.ERROR, "test message 2", 3);
        Assertions.assertEquals((int)1, (int)this.appender.getErrorCounts(this.cutoff).size());
        Assertions.assertEquals((int)1, (int)this.appender.getWarningCounts(this.cutoff).size());
        Assertions.assertEquals((long)5L, (long)((Integer)this.appender.getErrorCounts(this.cutoff).get(0)).longValue());
        Assertions.assertEquals((long)0L, (long)((Integer)this.appender.getWarningCounts(this.cutoff).get(0)).longValue());
        Thread.sleep(1000L);
        this.cutoff.add(Time.now() / 1000L);
        this.logMessages(Level.ERROR, "test message 3", 2);
        Assertions.assertEquals((int)2, (int)this.appender.getErrorCounts(this.cutoff).size());
        Assertions.assertEquals((int)2, (int)this.appender.getWarningCounts(this.cutoff).size());
        Assertions.assertEquals((long)7L, (long)((Integer)this.appender.getErrorCounts(this.cutoff).get(0)).longValue());
        Assertions.assertEquals((long)2L, (long)((Integer)this.appender.getErrorCounts(this.cutoff).get(1)).longValue());
        Assertions.assertEquals((long)0L, (long)((Integer)this.appender.getWarningCounts(this.cutoff).get(0)).longValue());
        Assertions.assertEquals((long)0L, (long)((Integer)this.appender.getWarningCounts(this.cutoff).get(1)).longValue());
    }

    @Test
    void testWarningCounts() throws Exception {
        this.cutoff.clear();
        this.setupAppender(100, 100L, 100);
        this.cutoff.add(0L);
        this.logMessages(Level.WARN, "test message 1", 2);
        this.logMessages(Level.WARN, "test message 2", 3);
        Assertions.assertEquals((int)1, (int)this.appender.getErrorCounts(this.cutoff).size());
        Assertions.assertEquals((int)1, (int)this.appender.getWarningCounts(this.cutoff).size());
        Assertions.assertEquals((long)0L, (long)((Integer)this.appender.getErrorCounts(this.cutoff).get(0)).longValue());
        Assertions.assertEquals((long)5L, (long)((Integer)this.appender.getWarningCounts(this.cutoff).get(0)).longValue());
        Thread.sleep(1000L);
        this.cutoff.add(Time.now() / 1000L);
        this.logMessages(Level.WARN, "test message 3", 2);
        Assertions.assertEquals((int)2, (int)this.appender.getErrorCounts(this.cutoff).size());
        Assertions.assertEquals((int)2, (int)this.appender.getWarningCounts(this.cutoff).size());
        Assertions.assertEquals((long)0L, (long)((Integer)this.appender.getErrorCounts(this.cutoff).get(0)).longValue());
        Assertions.assertEquals((long)0L, (long)((Integer)this.appender.getErrorCounts(this.cutoff).get(1)).longValue());
        Assertions.assertEquals((long)7L, (long)((Integer)this.appender.getWarningCounts(this.cutoff).get(0)).longValue());
        Assertions.assertEquals((long)2L, (long)((Integer)this.appender.getWarningCounts(this.cutoff).get(1)).longValue());
    }

    @Test
    void testWarningMessages() throws Exception {
        this.cutoff.clear();
        this.setupAppender(100, 100L, 100);
        this.cutoff.add(0L);
        this.logMessages(Level.WARN, "test message 1", 2);
        this.logMessages(Level.WARN, "test message 2", 3);
        Assertions.assertEquals((int)1, (int)this.appender.getErrorMessagesAndCounts(this.cutoff).size());
        Assertions.assertEquals((int)1, (int)this.appender.getWarningMessagesAndCounts(this.cutoff).size());
        Map errorsMap = (Map)this.appender.getErrorMessagesAndCounts(this.cutoff).get(0);
        Map warningsMap = (Map)this.appender.getWarningMessagesAndCounts(this.cutoff).get(0);
        Assertions.assertEquals((int)0, (int)errorsMap.size());
        Assertions.assertEquals((int)2, (int)warningsMap.size());
        Assertions.assertTrue((boolean)warningsMap.containsKey("test message 1"));
        Assertions.assertTrue((boolean)warningsMap.containsKey("test message 2"));
        Log4jWarningErrorMetricsAppender.Element msg1Info = (Log4jWarningErrorMetricsAppender.Element)warningsMap.get("test message 1");
        Log4jWarningErrorMetricsAppender.Element msg2Info = (Log4jWarningErrorMetricsAppender.Element)warningsMap.get("test message 2");
        Assertions.assertEquals((int)2, (int)msg1Info.count.intValue());
        Assertions.assertEquals((int)3, (int)msg2Info.count.intValue());
        Thread.sleep(1000L);
        this.cutoff.add(Time.now() / 1000L);
        this.logMessages(Level.WARN, "test message 3", 2);
        Assertions.assertEquals((int)2, (int)this.appender.getErrorMessagesAndCounts(this.cutoff).size());
        Assertions.assertEquals((int)2, (int)this.appender.getWarningMessagesAndCounts(this.cutoff).size());
        errorsMap = (Map)this.appender.getErrorMessagesAndCounts(this.cutoff).get(0);
        warningsMap = (Map)this.appender.getWarningMessagesAndCounts(this.cutoff).get(0);
        Assertions.assertEquals((int)0, (int)errorsMap.size());
        Assertions.assertEquals((int)3, (int)warningsMap.size());
        Assertions.assertTrue((boolean)warningsMap.containsKey("test message 3"));
        errorsMap = (Map)this.appender.getErrorMessagesAndCounts(this.cutoff).get(1);
        warningsMap = (Map)this.appender.getWarningMessagesAndCounts(this.cutoff).get(1);
        Assertions.assertEquals((int)0, (int)errorsMap.size());
        Assertions.assertEquals((int)1, (int)warningsMap.size());
        Assertions.assertTrue((boolean)warningsMap.containsKey("test message 3"));
        Log4jWarningErrorMetricsAppender.Element msg3Info = (Log4jWarningErrorMetricsAppender.Element)warningsMap.get("test message 3");
        Assertions.assertEquals((int)2, (int)msg3Info.count.intValue());
    }

    @Test
    void testErrorMessages() throws Exception {
        this.cutoff.clear();
        this.setupAppender(100, 100L, 100);
        this.cutoff.add(0L);
        this.logMessages(Level.ERROR, "test message 1", 2);
        this.logMessages(Level.ERROR, "test message 2", 3);
        Assertions.assertEquals((int)1, (int)this.appender.getErrorMessagesAndCounts(this.cutoff).size());
        Assertions.assertEquals((int)1, (int)this.appender.getWarningMessagesAndCounts(this.cutoff).size());
        Map errorsMap = (Map)this.appender.getErrorMessagesAndCounts(this.cutoff).get(0);
        Map warningsMap = (Map)this.appender.getWarningMessagesAndCounts(this.cutoff).get(0);
        Assertions.assertEquals((int)2, (int)errorsMap.size());
        Assertions.assertEquals((int)0, (int)warningsMap.size());
        Assertions.assertTrue((boolean)errorsMap.containsKey("test message 1"));
        Assertions.assertTrue((boolean)errorsMap.containsKey("test message 2"));
        Log4jWarningErrorMetricsAppender.Element msg1Info = (Log4jWarningErrorMetricsAppender.Element)errorsMap.get("test message 1");
        Log4jWarningErrorMetricsAppender.Element msg2Info = (Log4jWarningErrorMetricsAppender.Element)errorsMap.get("test message 2");
        Assertions.assertEquals((int)2, (int)msg1Info.count.intValue());
        Assertions.assertEquals((int)3, (int)msg2Info.count.intValue());
        Thread.sleep(1000L);
        this.cutoff.add(Time.now() / 1000L);
        this.logMessages(Level.ERROR, "test message 3", 2);
        Assertions.assertEquals((int)2, (int)this.appender.getErrorMessagesAndCounts(this.cutoff).size());
        Assertions.assertEquals((int)2, (int)this.appender.getWarningMessagesAndCounts(this.cutoff).size());
        errorsMap = (Map)this.appender.getErrorMessagesAndCounts(this.cutoff).get(0);
        warningsMap = (Map)this.appender.getWarningMessagesAndCounts(this.cutoff).get(0);
        Assertions.assertEquals((int)3, (int)errorsMap.size());
        Assertions.assertEquals((int)0, (int)warningsMap.size());
        Assertions.assertTrue((boolean)errorsMap.containsKey("test message 3"));
        errorsMap = (Map)this.appender.getErrorMessagesAndCounts(this.cutoff).get(1);
        warningsMap = (Map)this.appender.getWarningMessagesAndCounts(this.cutoff).get(1);
        Assertions.assertEquals((int)1, (int)errorsMap.size());
        Assertions.assertEquals((int)0, (int)warningsMap.size());
        Assertions.assertTrue((boolean)errorsMap.containsKey("test message 3"));
        Log4jWarningErrorMetricsAppender.Element msg3Info = (Log4jWarningErrorMetricsAppender.Element)errorsMap.get("test message 3");
        Assertions.assertEquals((int)2, (int)msg3Info.count.intValue());
    }

    @Test
    void testInfoDebugTrace() {
        this.cutoff.clear();
        this.setupAppender(100, 100L, 100);
        this.cutoff.add(0L);
        this.logMessages(Level.INFO, "test message 1", 2);
        this.logMessages(Level.DEBUG, "test message 2", 2);
        this.logMessages(Level.TRACE, "test message 3", 2);
        Assertions.assertEquals((int)1, (int)this.appender.getErrorMessagesAndCounts(this.cutoff).size());
        Assertions.assertEquals((int)1, (int)this.appender.getWarningMessagesAndCounts(this.cutoff).size());
        Assertions.assertEquals((int)1, (int)this.appender.getErrorCounts(this.cutoff).size());
        Assertions.assertEquals((int)1, (int)this.appender.getWarningCounts(this.cutoff).size());
        Assertions.assertEquals((long)0L, (long)((Integer)this.appender.getErrorCounts(this.cutoff).get(0)).longValue());
        Assertions.assertEquals((long)0L, (long)((Integer)this.appender.getWarningCounts(this.cutoff).get(0)).longValue());
        Assertions.assertEquals((int)0, (int)((Map)this.appender.getErrorMessagesAndCounts(this.cutoff).get(0)).size());
        Assertions.assertEquals((int)0, (int)((Map)this.appender.getWarningMessagesAndCounts(this.cutoff).get(0)).size());
    }
}

