/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.hadoop.yarn.util.Times;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTimes {
    @Test
    void testNegativeStartTimes() {
        long elapsed = Times.elapsed((long)-5L, (long)10L, (boolean)true);
        Assertions.assertEquals((long)0L, (long)elapsed, (String)"Elapsed time is not 0");
        elapsed = Times.elapsed((long)-5L, (long)10L, (boolean)false);
        Assertions.assertEquals((long)-1L, (long)elapsed, (String)"Elapsed time is not -1");
    }

    @Test
    void testNegativeFinishTimes() {
        long elapsed = Times.elapsed((long)5L, (long)-10L, (boolean)false);
        Assertions.assertEquals((long)-1L, (long)elapsed, (String)"Elapsed time is not -1");
    }

    @Test
    void testNegativeStartandFinishTimes() {
        long elapsed = Times.elapsed((long)-5L, (long)-10L, (boolean)false);
        Assertions.assertEquals((long)-1L, (long)elapsed, (String)"Elapsed time is not -1");
    }

    @Test
    void testPositiveStartandFinishTimes() {
        long elapsed = Times.elapsed((long)5L, (long)10L, (boolean)true);
        Assertions.assertEquals((long)5L, (long)elapsed, (String)"Elapsed time is not 5");
        elapsed = Times.elapsed((long)5L, (long)10L, (boolean)false);
        Assertions.assertEquals((long)5L, (long)elapsed, (String)"Elapsed time is not 5");
    }

    @Test
    void testFinishTimesAheadOfStartTimes() {
        long elapsed = Times.elapsed((long)10L, (long)5L, (boolean)true);
        Assertions.assertEquals((long)-1L, (long)elapsed, (String)"Elapsed time is not -1");
        elapsed = Times.elapsed((long)10L, (long)5L, (boolean)false);
        Assertions.assertEquals((long)-1L, (long)elapsed, (String)"Elapsed time is not -1");
        elapsed = Times.elapsed((long)Long.MAX_VALUE, (long)0L, (boolean)true);
        Assertions.assertEquals((long)-1L, (long)elapsed, (String)"Elapsed time is not -1");
    }

    @Test
    void validateISO() throws IOException {
        SimpleDateFormat isoFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        for (int i = 0; i < 1000; ++i) {
            long now = System.currentTimeMillis();
            String instant = Times.formatISO8601((long)now);
            String date = isoFormat.format(new Date(now));
            Assertions.assertEquals((Object)date, (Object)instant);
        }
    }
}

