/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.view;

import com.google.inject.Injector;
import java.io.PrintWriter;
import org.apache.hadoop.yarn.webapp.WebAppException;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.test.WebAppTests;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestHtmlBlock {
    @Test
    void testUsual() {
        Injector injector = WebAppTests.testBlock(TestBlock.class);
        PrintWriter out = (PrintWriter)injector.getInstance(PrintWriter.class);
        ((PrintWriter)Mockito.verify((Object)out)).print(" id=\"testid\"");
        ((PrintWriter)Mockito.verify((Object)out)).print("test note");
    }

    @Test
    void testShortBlock() {
        Assertions.assertThrows(WebAppException.class, () -> WebAppTests.testBlock(ShortBlock.class));
    }

    @Test
    void testShortPage() {
        Assertions.assertThrows(WebAppException.class, () -> WebAppTests.testPage(ShortPage.class));
    }

    public static class ShortPage
    extends HtmlPage {
        public void render(Hamlet.HTML<HtmlPage.__> html) {
            html.title("short test").__(ShortBlock.class);
        }
    }

    public static class ShortBlock
    extends HtmlBlock {
        public void render(HtmlBlock.Block html) {
            html.p().__(new Object[]{"should throw"});
        }
    }

    public static class TestBlock
    extends HtmlBlock {
        public void render(HtmlBlock.Block html) {
            html.p("#testid").__(new Object[]{"test note"}).__();
        }
    }
}

