/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice;

import java.io.IOException;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationAttemptFinishData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationAttemptStartData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationFinishData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationStartData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ContainerFinishData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ContainerStartData;

public class ApplicationHistoryStoreTestUtils {
    protected ApplicationHistoryStore store;

    protected void writeApplicationStartData(ApplicationId appId) throws IOException {
        this.store.applicationStarted(ApplicationStartData.newInstance((ApplicationId)appId, (String)appId.toString(), (String)"test type", (String)"test queue", (String)"test user", (long)0L, (long)0L));
    }

    protected void writeApplicationFinishData(ApplicationId appId) throws IOException {
        this.store.applicationFinished(ApplicationFinishData.newInstance((ApplicationId)appId, (long)0L, (String)appId.toString(), (FinalApplicationStatus)FinalApplicationStatus.UNDEFINED, (YarnApplicationState)YarnApplicationState.FINISHED));
    }

    protected void writeApplicationAttemptStartData(ApplicationAttemptId appAttemptId) throws IOException {
        this.store.applicationAttemptStarted(ApplicationAttemptStartData.newInstance((ApplicationAttemptId)appAttemptId, (String)appAttemptId.toString(), (int)0, (ContainerId)ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)1)));
    }

    protected void writeApplicationAttemptFinishData(ApplicationAttemptId appAttemptId) throws IOException {
        this.store.applicationAttemptFinished(ApplicationAttemptFinishData.newInstance((ApplicationAttemptId)appAttemptId, (String)appAttemptId.toString(), (String)"test tracking url", (FinalApplicationStatus)FinalApplicationStatus.UNDEFINED, (YarnApplicationAttemptState)YarnApplicationAttemptState.FINISHED));
    }

    protected void writeContainerStartData(ContainerId containerId) throws IOException {
        this.store.containerStarted(ContainerStartData.newInstance((ContainerId)containerId, (Resource)Resource.newInstance((int)0, (int)0), (NodeId)NodeId.newInstance((String)"localhost", (int)0), (Priority)Priority.newInstance((int)containerId.getId()), (long)0L));
    }

    protected void writeContainerFinishData(ContainerId containerId) throws IOException {
        this.store.containerFinished(ContainerFinishData.newInstance((ContainerId)containerId, (long)0L, (String)containerId.toString(), (int)0, (ContainerState)ContainerState.COMPLETE));
    }
}

