/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManagerImpl;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryStoreTestUtils;
import org.apache.hadoop.yarn.server.applicationhistoryservice.MemoryApplicationHistoryStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestApplicationHistoryManagerImpl
extends ApplicationHistoryStoreTestUtils {
    ApplicationHistoryManagerImpl applicationHistoryManagerImpl = null;

    @Before
    public void setup() throws Exception {
        Configuration config = new Configuration();
        config.setClass("yarn.timeline-service.generic-application-history.store-class", MemoryApplicationHistoryStore.class, ApplicationHistoryStore.class);
        this.applicationHistoryManagerImpl = new ApplicationHistoryManagerImpl();
        this.applicationHistoryManagerImpl.init(config);
        this.applicationHistoryManagerImpl.start();
        this.store = this.applicationHistoryManagerImpl.getHistoryStore();
    }

    @After
    public void tearDown() throws Exception {
        this.applicationHistoryManagerImpl.stop();
    }

    @Test
    public void testApplicationReport() throws IOException, YarnException {
        ApplicationId appId = null;
        appId = ApplicationId.newInstance((long)0L, (int)1);
        this.writeApplicationStartData(appId);
        this.writeApplicationFinishData(appId);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        this.writeApplicationAttemptStartData(appAttemptId);
        this.writeApplicationAttemptFinishData(appAttemptId);
        ApplicationReport appReport = this.applicationHistoryManagerImpl.getApplication(appId);
        Assert.assertNotNull((Object)appReport);
        Assert.assertEquals((Object)appId, (Object)appReport.getApplicationId());
        Assert.assertEquals((Object)appAttemptId, (Object)appReport.getCurrentApplicationAttemptId());
        Assert.assertEquals((Object)appAttemptId.toString(), (Object)appReport.getHost());
        Assert.assertEquals((Object)"test type", (Object)appReport.getApplicationType().toString());
        Assert.assertEquals((Object)"test queue", (Object)appReport.getQueue().toString());
    }
}

