/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.timeline.GenericObjectMapper;
import org.apache.hadoop.yarn.server.timeline.LeveldbTimelineStore;
import org.apache.hadoop.yarn.server.timeline.NameValuePair;
import org.apache.hadoop.yarn.server.timeline.TimelineStoreTestUtils;
import org.iq80.leveldb.DBIterator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TestLeveldbTimelineStore
extends TimelineStoreTestUtils {
    private FileContext fsContext;
    private File fsPath;

    @Before
    public void setup() throws Exception {
        this.fsContext = FileContext.getLocalFSFileContext();
        YarnConfiguration conf = new YarnConfiguration();
        this.fsPath = new File("target", this.getClass().getSimpleName() + "-tmpDir").getAbsoluteFile();
        this.fsContext.delete(new Path(this.fsPath.getAbsolutePath()), true);
        conf.set("yarn.timeline-service.leveldb-timeline-store.path", this.fsPath.getAbsolutePath());
        conf.setBoolean("yarn.timeline-service.ttl-enable", false);
        this.store = new LeveldbTimelineStore();
        this.store.init((Configuration)conf);
        this.store.start();
        this.loadTestData();
        this.loadVerificationData();
    }

    @After
    public void tearDown() throws Exception {
        this.store.stop();
        this.fsContext.delete(new Path(this.fsPath.getAbsolutePath()), true);
    }

    @Test
    public void testRootDirPermission() throws IOException {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)new YarnConfiguration());
        FileStatus file = fs.getFileStatus(new Path(this.fsPath.getAbsolutePath(), "leveldb-timeline-store.ldb"));
        Assert.assertNotNull((Object)file);
        Assert.assertEquals((Object)LeveldbTimelineStore.LEVELDB_DIR_UMASK, (Object)file.getPermission());
    }

    @Test
    public void testGetSingleEntity() throws IOException {
        super.testGetSingleEntity();
        ((LeveldbTimelineStore)this.store).clearStartTimeCache();
        super.testGetSingleEntity();
        this.loadTestData();
    }

    @Test
    public void testGetEntities() throws IOException {
        super.testGetEntities();
    }

    @Test
    public void testGetEntitiesWithFromId() throws IOException {
        super.testGetEntitiesWithFromId();
    }

    @Test
    public void testGetEntitiesWithFromTs() throws IOException {
        super.testGetEntitiesWithFromTs();
    }

    @Test
    public void testGetEntitiesWithPrimaryFilters() throws IOException {
        super.testGetEntitiesWithPrimaryFilters();
    }

    @Test
    public void testGetEntitiesWithSecondaryFilters() throws IOException {
        super.testGetEntitiesWithSecondaryFilters();
    }

    @Test
    public void testGetEvents() throws IOException {
        super.testGetEvents();
    }

    @Test
    public void testCacheSizes() {
        Configuration conf = new Configuration();
        Assert.assertEquals((long)10000L, (long)LeveldbTimelineStore.getStartTimeReadCacheSize((Configuration)conf));
        Assert.assertEquals((long)10000L, (long)LeveldbTimelineStore.getStartTimeWriteCacheSize((Configuration)conf));
        conf.setInt("yarn.timeline-service.leveldb-timeline-store.start-time-read-cache-size", 10001);
        Assert.assertEquals((long)10001L, (long)LeveldbTimelineStore.getStartTimeReadCacheSize((Configuration)conf));
        conf = new Configuration();
        conf.setInt("yarn.timeline-service.leveldb-timeline-store.start-time-write-cache-size", 10002);
        Assert.assertEquals((long)10002L, (long)LeveldbTimelineStore.getStartTimeWriteCacheSize((Configuration)conf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteNextEntity(String entityType, byte[] ts) throws IOException, InterruptedException {
        boolean bl;
        DBIterator iterator = null;
        DBIterator pfIterator = null;
        try {
            iterator = ((LeveldbTimelineStore)this.store).getDbIterator(false);
            pfIterator = ((LeveldbTimelineStore)this.store).getDbIterator(false);
            bl = ((LeveldbTimelineStore)this.store).deleteNextEntity(entityType, ts, iterator, pfIterator, false);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{iterator, pfIterator});
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{iterator, pfIterator});
        return bl;
    }

    @Test
    public void testGetEntityTypes() throws IOException {
        List entityTypes = ((LeveldbTimelineStore)this.store).getEntityTypes();
        Assert.assertEquals((long)4L, (long)entityTypes.size());
        Assert.assertEquals((Object)this.entityType1, entityTypes.get(0));
        Assert.assertEquals((Object)this.entityType2, entityTypes.get(1));
        Assert.assertEquals((Object)this.entityType4, entityTypes.get(2));
        Assert.assertEquals((Object)this.entityType5, entityTypes.get(3));
    }

    @Test
    public void testDeleteEntities() throws IOException, InterruptedException {
        Assert.assertEquals((long)2L, (long)this.getEntities("type_1").size());
        Assert.assertEquals((long)1L, (long)this.getEntities("type_2").size());
        Assert.assertEquals((Object)false, (Object)this.deleteNextEntity(this.entityType1, GenericObjectMapper.writeReverseOrderedLong((long)122L)));
        Assert.assertEquals((long)2L, (long)this.getEntities("type_1").size());
        Assert.assertEquals((long)1L, (long)this.getEntities("type_2").size());
        Assert.assertEquals((Object)true, (Object)this.deleteNextEntity(this.entityType1, GenericObjectMapper.writeReverseOrderedLong((long)123L)));
        List entities = this.getEntities("type_2");
        Assert.assertEquals((long)1L, (long)entities.size());
        TestLeveldbTimelineStore.verifyEntityInfo((String)this.entityId2, (String)this.entityType2, (List)this.events2, Collections.singletonMap(this.entityType1, Collections.singleton(this.entityId1b)), (Map)EMPTY_PRIMARY_FILTERS, (Map)EMPTY_MAP, (TimelineEntity)((TimelineEntity)entities.get(0)));
        entities = this.getEntitiesWithPrimaryFilter("type_1", this.userFilter);
        Assert.assertEquals((long)1L, (long)entities.size());
        TestLeveldbTimelineStore.verifyEntityInfo((String)this.entityId1b, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(0)));
        ((LeveldbTimelineStore)this.store).discardOldEntities(-123L);
        Assert.assertEquals((long)1L, (long)this.getEntities("type_1").size());
        Assert.assertEquals((long)0L, (long)this.getEntities("type_2").size());
        Assert.assertEquals((long)3L, (long)((LeveldbTimelineStore)this.store).getEntityTypes().size());
        ((LeveldbTimelineStore)this.store).discardOldEntities(123L);
        Assert.assertEquals((long)0L, (long)this.getEntities("type_1").size());
        Assert.assertEquals((long)0L, (long)this.getEntities("type_2").size());
        Assert.assertEquals((long)0L, (long)((LeveldbTimelineStore)this.store).getEntityTypes().size());
        Assert.assertEquals((long)0L, (long)this.getEntitiesWithPrimaryFilter("type_1", this.userFilter).size());
    }

    @Test
    public void testDeleteEntitiesPrimaryFilters() throws IOException, InterruptedException {
        Map<String, Set<String>> primaryFilter = Collections.singletonMap("user", Collections.singleton("otheruser"));
        TimelineEntities atsEntities = new TimelineEntities();
        atsEntities.setEntities(Collections.singletonList(TestLeveldbTimelineStore.createEntity((String)this.entityId1b, (String)this.entityType1, (Long)789L, Collections.singletonList(this.ev2), null, primaryFilter, null)));
        TimelinePutResponse response = this.store.put(atsEntities);
        Assert.assertEquals((long)0L, (long)response.getErrors().size());
        NameValuePair pfPair = new NameValuePair("user", (Object)"otheruser");
        List entities = this.getEntitiesWithPrimaryFilter("type_1", pfPair);
        Assert.assertEquals((long)1L, (long)entities.size());
        TestLeveldbTimelineStore.verifyEntityInfo((String)this.entityId1b, (String)this.entityType1, Collections.singletonList(this.ev2), (Map)EMPTY_REL_ENTITIES, primaryFilter, (Map)EMPTY_MAP, (TimelineEntity)((TimelineEntity)entities.get(0)));
        entities = this.getEntitiesWithPrimaryFilter("type_1", this.userFilter);
        Assert.assertEquals((long)2L, (long)entities.size());
        TestLeveldbTimelineStore.verifyEntityInfo((String)this.entityId1, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(0)));
        TestLeveldbTimelineStore.verifyEntityInfo((String)this.entityId1b, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(1)));
        ((LeveldbTimelineStore)this.store).discardOldEntities(-123L);
        Assert.assertEquals((long)1L, (long)this.getEntitiesWithPrimaryFilter("type_1", pfPair).size());
        Assert.assertEquals((long)2L, (long)this.getEntitiesWithPrimaryFilter("type_1", this.userFilter).size());
        ((LeveldbTimelineStore)this.store).discardOldEntities(123L);
        Assert.assertEquals((long)0L, (long)this.getEntities("type_1").size());
        Assert.assertEquals((long)0L, (long)this.getEntities("type_2").size());
        Assert.assertEquals((long)0L, (long)((LeveldbTimelineStore)this.store).getEntityTypes().size());
        Assert.assertEquals((long)0L, (long)this.getEntitiesWithPrimaryFilter("type_1", pfPair).size());
        Assert.assertEquals((long)0L, (long)this.getEntitiesWithPrimaryFilter("type_1", this.userFilter).size());
    }

    @Test
    public void testFromTsWithDeletion() throws IOException, InterruptedException {
        long l = System.currentTimeMillis();
        Assert.assertEquals((long)2L, (long)this.getEntitiesFromTs("type_1", l).size());
        Assert.assertEquals((long)1L, (long)this.getEntitiesFromTs("type_2", l).size());
        Assert.assertEquals((long)2L, (long)this.getEntitiesFromTsWithPrimaryFilter("type_1", this.userFilter, l).size());
        ((LeveldbTimelineStore)this.store).discardOldEntities(123L);
        Assert.assertEquals((long)0L, (long)this.getEntitiesFromTs("type_1", l).size());
        Assert.assertEquals((long)0L, (long)this.getEntitiesFromTs("type_2", l).size());
        Assert.assertEquals((long)0L, (long)this.getEntitiesFromTsWithPrimaryFilter("type_1", this.userFilter, l).size());
        Assert.assertEquals((long)0L, (long)this.getEntities("type_1").size());
        Assert.assertEquals((long)0L, (long)this.getEntities("type_2").size());
        Assert.assertEquals((long)0L, (long)this.getEntitiesFromTsWithPrimaryFilter("type_1", this.userFilter, l).size());
        this.loadTestData();
        Assert.assertEquals((long)0L, (long)this.getEntitiesFromTs("type_1", l).size());
        Assert.assertEquals((long)0L, (long)this.getEntitiesFromTs("type_2", l).size());
        Assert.assertEquals((long)0L, (long)this.getEntitiesFromTsWithPrimaryFilter("type_1", this.userFilter, l).size());
        Assert.assertEquals((long)2L, (long)this.getEntities("type_1").size());
        Assert.assertEquals((long)1L, (long)this.getEntities("type_2").size());
        Assert.assertEquals((long)2L, (long)this.getEntitiesWithPrimaryFilter("type_1", this.userFilter).size());
    }
}

