/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvents;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.server.timeline.NameValuePair;
import org.apache.hadoop.yarn.server.timeline.TimelineReader;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.junit.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
public class TimelineStoreTestUtils {
    protected static final List<TimelineEvent> EMPTY_EVENTS = Collections.emptyList();
    protected static final Map<String, Object> EMPTY_MAP = Collections.emptyMap();
    protected static final Map<String, Set<Object>> EMPTY_PRIMARY_FILTERS = Collections.emptyMap();
    protected static final Map<String, Set<String>> EMPTY_REL_ENTITIES = Collections.emptyMap();
    protected TimelineStore store;
    protected String entityId1;
    protected String entityType1;
    protected String entityId1b;
    protected String entityId2;
    protected String entityType2;
    protected String entityId4;
    protected String entityType4;
    protected String entityId5;
    protected String entityType5;
    protected Map<String, Set<Object>> primaryFilters;
    protected Map<String, Object> secondaryFilters;
    protected Map<String, Object> allFilters;
    protected Map<String, Object> otherInfo;
    protected Map<String, Set<String>> relEntityMap;
    protected Map<String, Set<String>> relEntityMap2;
    protected NameValuePair userFilter;
    protected NameValuePair numericFilter1;
    protected NameValuePair numericFilter2;
    protected NameValuePair numericFilter3;
    protected Collection<NameValuePair> goodTestingFilters;
    protected Collection<NameValuePair> badTestingFilters;
    protected TimelineEvent ev1;
    protected TimelineEvent ev2;
    protected TimelineEvent ev3;
    protected TimelineEvent ev4;
    protected Map<String, Object> eventInfo;
    protected List<TimelineEvent> events1;
    protected List<TimelineEvent> events2;
    protected long beforeTs;

    protected void loadTestData() throws IOException {
        this.beforeTs = System.currentTimeMillis() - 1L;
        TimelineEntities entities = new TimelineEntities();
        HashMap primaryFilters = new HashMap();
        HashSet<String> l1 = new HashSet<String>();
        l1.add("username");
        HashSet<Long> l2 = new HashSet<Long>();
        l2.add((Long)Integer.MAX_VALUE);
        HashSet<String> l3 = new HashSet<String>();
        l3.add("123abc");
        HashSet<Long> l4 = new HashSet<Long>();
        l4.add(0x80000000L);
        primaryFilters.put("user", l1);
        primaryFilters.put("appname", l2);
        primaryFilters.put("other", l3);
        primaryFilters.put("long", l4);
        HashMap<String, Object> secondaryFilters = new HashMap<String, Object>();
        secondaryFilters.put("startTime", 123456L);
        secondaryFilters.put("status", "RUNNING");
        HashMap<String, Object> otherInfo1 = new HashMap<String, Object>();
        otherInfo1.put("info1", "val1");
        otherInfo1.putAll(secondaryFilters);
        String entityId1 = "id_1";
        String entityType1 = "type_1";
        String entityId1b = "id_2";
        String entityId2 = "id_2";
        String entityType2 = "type_2";
        String entityId4 = "id_4";
        String entityType4 = "type_4";
        String entityId5 = "id_5";
        String entityType5 = "type_5";
        HashMap<String, Set<String>> relatedEntities = new HashMap<String, Set<String>>();
        relatedEntities.put(entityType2, Collections.singleton(entityId2));
        TimelineEvent ev3 = TimelineStoreTestUtils.createEvent((long)789L, (String)"launch_event", null);
        TimelineEvent ev4 = TimelineStoreTestUtils.createEvent((long)-123L, (String)"init_event", null);
        ArrayList<TimelineEvent> events = new ArrayList<TimelineEvent>();
        events.add(ev3);
        events.add(ev4);
        entities.setEntities(Collections.singletonList(TimelineStoreTestUtils.createEntity((String)entityId2, (String)entityType2, null, events, null, null, null)));
        TimelinePutResponse response = this.store.put(entities);
        Assert.assertEquals((long)0L, (long)response.getErrors().size());
        TimelineEvent ev1 = TimelineStoreTestUtils.createEvent((long)123L, (String)"start_event", null);
        entities.setEntities(Collections.singletonList(TimelineStoreTestUtils.createEntity((String)entityId1, (String)entityType1, (Long)123L, Collections.singletonList(ev1), relatedEntities, primaryFilters, otherInfo1)));
        response = this.store.put(entities);
        Assert.assertEquals((long)0L, (long)response.getErrors().size());
        entities.setEntities(Collections.singletonList(TimelineStoreTestUtils.createEntity((String)entityId1b, (String)entityType1, null, Collections.singletonList(ev1), relatedEntities, primaryFilters, otherInfo1)));
        response = this.store.put(entities);
        Assert.assertEquals((long)0L, (long)response.getErrors().size());
        HashMap<String, String> eventInfo = new HashMap<String, String>();
        eventInfo.put("event info 1", "val1");
        TimelineEvent ev2 = TimelineStoreTestUtils.createEvent((long)456L, (String)"end_event", eventInfo);
        HashMap<String, String> otherInfo2 = new HashMap<String, String>();
        otherInfo2.put("info2", "val2");
        entities.setEntities(Collections.singletonList(TimelineStoreTestUtils.createEntity((String)entityId1, (String)entityType1, null, Collections.singletonList(ev2), null, primaryFilters, otherInfo2)));
        response = this.store.put(entities);
        Assert.assertEquals((long)0L, (long)response.getErrors().size());
        entities.setEntities(Collections.singletonList(TimelineStoreTestUtils.createEntity((String)entityId1b, (String)entityType1, (Long)789L, Collections.singletonList(ev2), null, primaryFilters, otherInfo2)));
        response = this.store.put(entities);
        Assert.assertEquals((long)0L, (long)response.getErrors().size());
        entities.setEntities(Collections.singletonList(TimelineStoreTestUtils.createEntity((String)"badentityid", (String)"badentity", null, null, null, null, otherInfo1)));
        response = this.store.put(entities);
        Assert.assertEquals((long)1L, (long)response.getErrors().size());
        TimelinePutResponse.TimelinePutError error = (TimelinePutResponse.TimelinePutError)response.getErrors().get(0);
        Assert.assertEquals((Object)"badentityid", (Object)error.getEntityId());
        Assert.assertEquals((Object)"badentity", (Object)error.getEntityType());
        Assert.assertEquals((long)1L, (long)error.getErrorCode());
        relatedEntities.clear();
        relatedEntities.put(entityType5, Collections.singleton(entityId5));
        entities.setEntities(Collections.singletonList(TimelineStoreTestUtils.createEntity((String)entityId4, (String)entityType4, (Long)42L, null, relatedEntities, null, null)));
        response = this.store.put(entities);
        Assert.assertEquals((long)0L, (long)response.getErrors().size());
    }

    protected void loadVerificationData() throws Exception {
        this.userFilter = new NameValuePair("user", (Object)"username");
        this.numericFilter1 = new NameValuePair("appname", (Object)Integer.MAX_VALUE);
        this.numericFilter2 = new NameValuePair("long", (Object)0x80000000L);
        this.numericFilter3 = new NameValuePair("other", (Object)"123abc");
        this.goodTestingFilters = new ArrayList();
        this.goodTestingFilters.add(new NameValuePair("appname", (Object)Integer.MAX_VALUE));
        this.goodTestingFilters.add(new NameValuePair("status", (Object)"RUNNING"));
        this.badTestingFilters = new ArrayList();
        this.badTestingFilters.add(new NameValuePair("appname", (Object)Integer.MAX_VALUE));
        this.badTestingFilters.add(new NameValuePair("status", (Object)"FINISHED"));
        this.primaryFilters = new HashMap();
        HashSet<String> l1 = new HashSet<String>();
        l1.add("username");
        HashSet<Integer> l2 = new HashSet<Integer>();
        l2.add(Integer.MAX_VALUE);
        HashSet<String> l3 = new HashSet<String>();
        l3.add("123abc");
        HashSet<Long> l4 = new HashSet<Long>();
        l4.add(0x80000000L);
        this.primaryFilters.put("user", l1);
        this.primaryFilters.put("appname", l2);
        this.primaryFilters.put("other", l3);
        this.primaryFilters.put("long", l4);
        this.secondaryFilters = new HashMap();
        this.secondaryFilters.put("startTime", 123456);
        this.secondaryFilters.put("status", "RUNNING");
        this.allFilters = new HashMap();
        this.allFilters.putAll(this.secondaryFilters);
        for (Map.Entry pf : this.primaryFilters.entrySet()) {
            for (Object o : (Set)pf.getValue()) {
                this.allFilters.put(pf.getKey(), o);
            }
        }
        this.otherInfo = new HashMap();
        this.otherInfo.put("info1", "val1");
        this.otherInfo.put("info2", "val2");
        this.otherInfo.putAll(this.secondaryFilters);
        this.entityId1 = "id_1";
        this.entityType1 = "type_1";
        this.entityId1b = "id_2";
        this.entityId2 = "id_2";
        this.entityType2 = "type_2";
        this.entityId4 = "id_4";
        this.entityType4 = "type_4";
        this.entityId5 = "id_5";
        this.entityType5 = "type_5";
        this.ev1 = TimelineStoreTestUtils.createEvent((long)123L, (String)"start_event", null);
        this.eventInfo = new HashMap();
        this.eventInfo.put("event info 1", "val1");
        this.ev2 = TimelineStoreTestUtils.createEvent((long)456L, (String)"end_event", (Map)this.eventInfo);
        this.events1 = new ArrayList();
        this.events1.add(this.ev2);
        this.events1.add(this.ev1);
        this.relEntityMap = new HashMap();
        HashSet<String> ids = new HashSet<String>();
        ids.add(this.entityId1);
        ids.add(this.entityId1b);
        this.relEntityMap.put(this.entityType1, ids);
        this.relEntityMap2 = new HashMap();
        this.relEntityMap2.put(this.entityType4, Collections.singleton(this.entityId4));
        this.ev3 = TimelineStoreTestUtils.createEvent((long)789L, (String)"launch_event", null);
        this.ev4 = TimelineStoreTestUtils.createEvent((long)-123L, (String)"init_event", null);
        this.events2 = new ArrayList();
        this.events2.add(this.ev3);
        this.events2.add(this.ev4);
    }

    public void testGetSingleEntity() throws IOException {
        TimelineStoreTestUtils.verifyEntityInfo(null, null, null, null, null, null, (TimelineEntity)this.store.getEntity("id_1", "type_2", EnumSet.allOf(TimelineReader.Field.class)));
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (Long)123L, (TimelineEntity)this.store.getEntity(this.entityId1, this.entityType1, EnumSet.allOf(TimelineReader.Field.class)));
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1b, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (Long)123L, (TimelineEntity)this.store.getEntity(this.entityId1b, this.entityType1, EnumSet.allOf(TimelineReader.Field.class)));
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId2, (String)this.entityType2, (List)this.events2, (Map)this.relEntityMap, (Map)EMPTY_PRIMARY_FILTERS, (Map)EMPTY_MAP, (Long)-123L, (TimelineEntity)this.store.getEntity(this.entityId2, this.entityType2, EnumSet.allOf(TimelineReader.Field.class)));
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId4, (String)this.entityType4, (List)EMPTY_EVENTS, (Map)EMPTY_REL_ENTITIES, (Map)EMPTY_PRIMARY_FILTERS, (Map)EMPTY_MAP, (Long)42L, (TimelineEntity)this.store.getEntity(this.entityId4, this.entityType4, EnumSet.allOf(TimelineReader.Field.class)));
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId5, (String)this.entityType5, (List)EMPTY_EVENTS, (Map)this.relEntityMap2, (Map)EMPTY_PRIMARY_FILTERS, (Map)EMPTY_MAP, (Long)42L, (TimelineEntity)this.store.getEntity(this.entityId5, this.entityType5, EnumSet.allOf(TimelineReader.Field.class)));
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1, (String)this.entityType1, (List)this.events1, null, null, null, (TimelineEntity)this.store.getEntity(this.entityId1, this.entityType1, EnumSet.of(TimelineReader.Field.EVENTS)));
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1, (String)this.entityType1, Collections.singletonList(this.ev2), null, null, null, (TimelineEntity)this.store.getEntity(this.entityId1, this.entityType1, EnumSet.of(TimelineReader.Field.LAST_EVENT_ONLY)));
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1b, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)this.store.getEntity(this.entityId1b, this.entityType1, null));
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1, (String)this.entityType1, null, null, (Map)this.primaryFilters, null, (TimelineEntity)this.store.getEntity(this.entityId1, this.entityType1, EnumSet.of(TimelineReader.Field.PRIMARY_FILTERS)));
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1, (String)this.entityType1, null, null, null, (Map)this.otherInfo, (TimelineEntity)this.store.getEntity(this.entityId1, this.entityType1, EnumSet.of(TimelineReader.Field.OTHER_INFO)));
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId2, (String)this.entityType2, null, (Map)this.relEntityMap, null, null, (TimelineEntity)this.store.getEntity(this.entityId2, this.entityType2, EnumSet.of(TimelineReader.Field.RELATED_ENTITIES)));
    }

    protected List<TimelineEntity> getEntities(String entityType) throws IOException {
        return this.store.getEntities(entityType, null, null, null, null, null, null, null, null).getEntities();
    }

    protected List<TimelineEntity> getEntitiesWithPrimaryFilter(String entityType, NameValuePair primaryFilter) throws IOException {
        return this.store.getEntities(entityType, null, null, null, null, null, primaryFilter, null, null).getEntities();
    }

    protected List<TimelineEntity> getEntitiesFromId(String entityType, String fromId) throws IOException {
        return this.store.getEntities(entityType, null, null, null, fromId, null, null, null, null).getEntities();
    }

    protected List<TimelineEntity> getEntitiesFromTs(String entityType, long fromTs) throws IOException {
        return this.store.getEntities(entityType, null, null, null, null, Long.valueOf(fromTs), null, null, null).getEntities();
    }

    protected List<TimelineEntity> getEntitiesFromIdWithPrimaryFilter(String entityType, NameValuePair primaryFilter, String fromId) throws IOException {
        return this.store.getEntities(entityType, null, null, null, fromId, null, primaryFilter, null, null).getEntities();
    }

    protected List<TimelineEntity> getEntitiesFromTsWithPrimaryFilter(String entityType, NameValuePair primaryFilter, long fromTs) throws IOException {
        return this.store.getEntities(entityType, null, null, null, null, Long.valueOf(fromTs), primaryFilter, null, null).getEntities();
    }

    protected List<TimelineEntity> getEntitiesFromIdWithWindow(String entityType, Long windowEnd, String fromId) throws IOException {
        return this.store.getEntities(entityType, null, null, windowEnd, fromId, null, null, null, null).getEntities();
    }

    protected List<TimelineEntity> getEntitiesFromIdWithPrimaryFilterAndWindow(String entityType, Long windowEnd, String fromId, NameValuePair primaryFilter) throws IOException {
        return this.store.getEntities(entityType, null, null, windowEnd, fromId, null, primaryFilter, null, null).getEntities();
    }

    protected List<TimelineEntity> getEntitiesWithFilters(String entityType, NameValuePair primaryFilter, Collection<NameValuePair> secondaryFilters) throws IOException {
        return this.store.getEntities(entityType, null, null, null, null, null, primaryFilter, secondaryFilters, null).getEntities();
    }

    protected List<TimelineEntity> getEntities(String entityType, Long limit, Long windowStart, Long windowEnd, NameValuePair primaryFilter, EnumSet<TimelineReader.Field> fields) throws IOException {
        return this.store.getEntities(entityType, limit, windowStart, windowEnd, null, null, primaryFilter, null, fields).getEntities();
    }

    public void testGetEntities() throws IOException {
        Assert.assertEquals((String)"nonzero entities size for nonexistent type", (long)0L, (long)this.getEntities("type_0").size());
        Assert.assertEquals((String)"nonzero entities size for nonexistent type", (long)0L, (long)this.getEntities("type_3").size());
        Assert.assertEquals((String)"nonzero entities size for nonexistent type", (long)0L, (long)this.getEntities("type_6").size());
        Assert.assertEquals((String)"nonzero entities size for nonexistent type", (long)0L, (long)this.getEntitiesWithPrimaryFilter("type_0", this.userFilter).size());
        Assert.assertEquals((String)"nonzero entities size for nonexistent type", (long)0L, (long)this.getEntitiesWithPrimaryFilter("type_3", this.userFilter).size());
        Assert.assertEquals((String)"nonzero entities size for nonexistent type", (long)0L, (long)this.getEntitiesWithPrimaryFilter("type_6", this.userFilter).size());
        List entities = this.getEntities("type_1");
        Assert.assertEquals((long)2L, (long)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(0)));
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1b, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(1)));
        entities = this.getEntities("type_2");
        Assert.assertEquals((long)1L, (long)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId2, (String)this.entityType2, (List)this.events2, (Map)this.relEntityMap, (Map)EMPTY_PRIMARY_FILTERS, (Map)EMPTY_MAP, (TimelineEntity)((TimelineEntity)entities.get(0)));
        entities = this.getEntities("type_1", Long.valueOf(1L), null, null, null, EnumSet.allOf(TimelineReader.Field.class));
        Assert.assertEquals((long)1L, (long)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(0)));
        entities = this.getEntities("type_1", Long.valueOf(1L), Long.valueOf(0L), null, null, EnumSet.allOf(TimelineReader.Field.class));
        Assert.assertEquals((long)1L, (long)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(0)));
        entities = this.getEntities("type_1", null, Long.valueOf(234L), null, null, EnumSet.allOf(TimelineReader.Field.class));
        Assert.assertEquals((long)0L, (long)entities.size());
        entities = this.getEntities("type_1", null, Long.valueOf(123L), null, null, EnumSet.allOf(TimelineReader.Field.class));
        Assert.assertEquals((long)0L, (long)entities.size());
        entities = this.getEntities("type_1", null, Long.valueOf(234L), Long.valueOf(345L), null, EnumSet.allOf(TimelineReader.Field.class));
        Assert.assertEquals((long)0L, (long)entities.size());
        entities = this.getEntities("type_1", null, null, Long.valueOf(345L), null, EnumSet.allOf(TimelineReader.Field.class));
        Assert.assertEquals((long)2L, (long)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(0)));
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1b, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(1)));
        entities = this.getEntities("type_1", null, null, Long.valueOf(123L), null, EnumSet.allOf(TimelineReader.Field.class));
        Assert.assertEquals((long)2L, (long)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(0)));
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1b, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(1)));
    }

    public void testGetEntitiesWithFromId() throws IOException {
        List entities = this.getEntitiesFromId("type_1", this.entityId1);
        Assert.assertEquals((long)2L, (long)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(0)));
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1b, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(1)));
        entities = this.getEntitiesFromId("type_1", this.entityId1b);
        Assert.assertEquals((long)1L, (long)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1b, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(0)));
        entities = this.getEntitiesFromIdWithWindow("type_1", Long.valueOf(0L), this.entityId1);
        Assert.assertEquals((long)0L, (long)entities.size());
        entities = this.getEntitiesFromId("type_2", "a");
        Assert.assertEquals((long)0L, (long)entities.size());
        entities = this.getEntitiesFromId("type_2", this.entityId2);
        Assert.assertEquals((long)1L, (long)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId2, (String)this.entityType2, (List)this.events2, (Map)this.relEntityMap, (Map)EMPTY_PRIMARY_FILTERS, (Map)EMPTY_MAP, (TimelineEntity)((TimelineEntity)entities.get(0)));
        entities = this.getEntitiesFromIdWithWindow("type_2", Long.valueOf(-456L), null);
        Assert.assertEquals((long)0L, (long)entities.size());
        entities = this.getEntitiesFromIdWithWindow("type_2", Long.valueOf(-456L), "a");
        Assert.assertEquals((long)0L, (long)entities.size());
        entities = this.getEntitiesFromIdWithWindow("type_2", Long.valueOf(0L), null);
        Assert.assertEquals((long)1L, (long)entities.size());
        entities = this.getEntitiesFromIdWithWindow("type_2", Long.valueOf(0L), this.entityId2);
        Assert.assertEquals((long)1L, (long)entities.size());
        entities = this.getEntitiesFromIdWithPrimaryFilter("type_1", this.userFilter, this.entityId1);
        Assert.assertEquals((long)2L, (long)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(0)));
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1b, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(1)));
        entities = this.getEntitiesFromIdWithPrimaryFilter("type_1", this.userFilter, this.entityId1b);
        Assert.assertEquals((long)1L, (long)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1b, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(0)));
        entities = this.getEntitiesFromIdWithPrimaryFilterAndWindow("type_1", Long.valueOf(0L), this.entityId1, this.userFilter);
        Assert.assertEquals((long)0L, (long)entities.size());
        entities = this.getEntitiesFromIdWithPrimaryFilter("type_2", this.userFilter, "a");
        Assert.assertEquals((long)0L, (long)entities.size());
    }

    public void testGetEntitiesWithFromTs() throws IOException {
        Assert.assertEquals((long)0L, (long)this.getEntitiesFromTs("type_1", this.beforeTs).size());
        Assert.assertEquals((long)0L, (long)this.getEntitiesFromTs("type_2", this.beforeTs).size());
        Assert.assertEquals((long)0L, (long)this.getEntitiesFromTsWithPrimaryFilter("type_1", this.userFilter, this.beforeTs).size());
        long afterTs = System.currentTimeMillis();
        Assert.assertEquals((long)2L, (long)this.getEntitiesFromTs("type_1", afterTs).size());
        Assert.assertEquals((long)1L, (long)this.getEntitiesFromTs("type_2", afterTs).size());
        Assert.assertEquals((long)2L, (long)this.getEntitiesFromTsWithPrimaryFilter("type_1", this.userFilter, afterTs).size());
        Assert.assertEquals((long)2L, (long)this.getEntities("type_1").size());
        Assert.assertEquals((long)1L, (long)this.getEntities("type_2").size());
        Assert.assertEquals((long)2L, (long)this.getEntitiesWithPrimaryFilter("type_1", this.userFilter).size());
        long beforeTs = this.beforeTs;
        this.loadTestData();
        Assert.assertEquals((long)0L, (long)this.getEntitiesFromTs("type_1", beforeTs).size());
        Assert.assertEquals((long)0L, (long)this.getEntitiesFromTs("type_2", beforeTs).size());
        Assert.assertEquals((long)0L, (long)this.getEntitiesFromTsWithPrimaryFilter("type_1", this.userFilter, beforeTs).size());
        Assert.assertEquals((long)2L, (long)this.getEntitiesFromTs("type_1", afterTs).size());
        Assert.assertEquals((long)1L, (long)this.getEntitiesFromTs("type_2", afterTs).size());
        Assert.assertEquals((long)2L, (long)this.getEntitiesFromTsWithPrimaryFilter("type_1", this.userFilter, afterTs).size());
    }

    public void testGetEntitiesWithPrimaryFilters() throws IOException {
        Assert.assertEquals((String)"nonzero entities size for primary filter", (long)0L, (long)this.getEntitiesWithPrimaryFilter("type_1", new NameValuePair("none", (Object)"none")).size());
        Assert.assertEquals((String)"nonzero entities size for primary filter", (long)0L, (long)this.getEntitiesWithPrimaryFilter("type_2", new NameValuePair("none", (Object)"none")).size());
        Assert.assertEquals((String)"nonzero entities size for primary filter", (long)0L, (long)this.getEntitiesWithPrimaryFilter("type_3", new NameValuePair("none", (Object)"none")).size());
        List entities = this.getEntitiesWithPrimaryFilter("type_1", this.userFilter);
        Assert.assertEquals((long)2L, (long)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(0)));
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1b, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(1)));
        entities = this.getEntitiesWithPrimaryFilter("type_1", this.numericFilter1);
        Assert.assertEquals((long)2L, (long)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(0)));
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1b, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(1)));
        entities = this.getEntitiesWithPrimaryFilter("type_1", this.numericFilter2);
        Assert.assertEquals((long)2L, (long)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(0)));
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1b, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(1)));
        entities = this.getEntitiesWithPrimaryFilter("type_1", this.numericFilter3);
        Assert.assertEquals((long)2L, (long)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(0)));
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1b, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(1)));
        entities = this.getEntitiesWithPrimaryFilter("type_2", this.userFilter);
        Assert.assertEquals((long)0L, (long)entities.size());
        entities = this.getEntities("type_1", Long.valueOf(1L), null, null, this.userFilter, null);
        Assert.assertEquals((long)1L, (long)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(0)));
        entities = this.getEntities("type_1", Long.valueOf(1L), Long.valueOf(0L), null, this.userFilter, null);
        Assert.assertEquals((long)1L, (long)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(0)));
        entities = this.getEntities("type_1", null, Long.valueOf(234L), null, this.userFilter, null);
        Assert.assertEquals((long)0L, (long)entities.size());
        entities = this.getEntities("type_1", null, Long.valueOf(234L), Long.valueOf(345L), this.userFilter, null);
        Assert.assertEquals((long)0L, (long)entities.size());
        entities = this.getEntities("type_1", null, null, Long.valueOf(345L), this.userFilter, null);
        Assert.assertEquals((long)2L, (long)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(0)));
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1b, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(1)));
    }

    public void testGetEntitiesWithSecondaryFilters() throws IOException {
        List entities = this.getEntitiesWithFilters("type_1", null, this.goodTestingFilters);
        Assert.assertEquals((long)2L, (long)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(0)));
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1b, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(1)));
        entities = this.getEntitiesWithFilters("type_1", this.userFilter, this.goodTestingFilters);
        Assert.assertEquals((long)2L, (long)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(0)));
        TimelineStoreTestUtils.verifyEntityInfo((String)this.entityId1b, (String)this.entityType1, (List)this.events1, (Map)EMPTY_REL_ENTITIES, (Map)this.primaryFilters, (Map)this.otherInfo, (TimelineEntity)((TimelineEntity)entities.get(1)));
        entities = this.getEntitiesWithFilters("type_1", null, Collections.singleton(new NameValuePair("user", (Object)"none")));
        Assert.assertEquals((long)0L, (long)entities.size());
        entities = this.getEntitiesWithFilters("type_1", null, this.badTestingFilters);
        Assert.assertEquals((long)0L, (long)entities.size());
        entities = this.getEntitiesWithFilters("type_1", this.userFilter, this.badTestingFilters);
        Assert.assertEquals((long)0L, (long)entities.size());
    }

    public void testGetEvents() throws IOException {
        TreeSet<String> sortedSet = new TreeSet<String>();
        sortedSet.add(this.entityId1);
        List timelines = this.store.getEntityTimelines(this.entityType1, sortedSet, null, null, null, null).getAllEvents();
        Assert.assertEquals((long)1L, (long)timelines.size());
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)((TimelineEvents.EventsOfOneEntity)timelines.get(0)), (String)this.entityId1, (String)this.entityType1, (TimelineEvent[])new TimelineEvent[]{this.ev2, this.ev1});
        sortedSet.add(this.entityId1b);
        timelines = this.store.getEntityTimelines(this.entityType1, sortedSet, null, null, null, null).getAllEvents();
        Assert.assertEquals((long)2L, (long)timelines.size());
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)((TimelineEvents.EventsOfOneEntity)timelines.get(0)), (String)this.entityId1, (String)this.entityType1, (TimelineEvent[])new TimelineEvent[]{this.ev2, this.ev1});
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)((TimelineEvents.EventsOfOneEntity)timelines.get(1)), (String)this.entityId1b, (String)this.entityType1, (TimelineEvent[])new TimelineEvent[]{this.ev2, this.ev1});
        timelines = this.store.getEntityTimelines(this.entityType1, sortedSet, Long.valueOf(1L), null, null, null).getAllEvents();
        Assert.assertEquals((long)2L, (long)timelines.size());
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)((TimelineEvents.EventsOfOneEntity)timelines.get(0)), (String)this.entityId1, (String)this.entityType1, (TimelineEvent[])new TimelineEvent[]{this.ev2});
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)((TimelineEvents.EventsOfOneEntity)timelines.get(1)), (String)this.entityId1b, (String)this.entityType1, (TimelineEvent[])new TimelineEvent[]{this.ev2});
        timelines = this.store.getEntityTimelines(this.entityType1, sortedSet, null, Long.valueOf(345L), null, null).getAllEvents();
        Assert.assertEquals((long)2L, (long)timelines.size());
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)((TimelineEvents.EventsOfOneEntity)timelines.get(0)), (String)this.entityId1, (String)this.entityType1, (TimelineEvent[])new TimelineEvent[]{this.ev2});
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)((TimelineEvents.EventsOfOneEntity)timelines.get(1)), (String)this.entityId1b, (String)this.entityType1, (TimelineEvent[])new TimelineEvent[]{this.ev2});
        timelines = this.store.getEntityTimelines(this.entityType1, sortedSet, null, Long.valueOf(123L), null, null).getAllEvents();
        Assert.assertEquals((long)2L, (long)timelines.size());
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)((TimelineEvents.EventsOfOneEntity)timelines.get(0)), (String)this.entityId1, (String)this.entityType1, (TimelineEvent[])new TimelineEvent[]{this.ev2});
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)((TimelineEvents.EventsOfOneEntity)timelines.get(1)), (String)this.entityId1b, (String)this.entityType1, (TimelineEvent[])new TimelineEvent[]{this.ev2});
        timelines = this.store.getEntityTimelines(this.entityType1, sortedSet, null, null, Long.valueOf(345L), null).getAllEvents();
        Assert.assertEquals((long)2L, (long)timelines.size());
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)((TimelineEvents.EventsOfOneEntity)timelines.get(0)), (String)this.entityId1, (String)this.entityType1, (TimelineEvent[])new TimelineEvent[]{this.ev1});
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)((TimelineEvents.EventsOfOneEntity)timelines.get(1)), (String)this.entityId1b, (String)this.entityType1, (TimelineEvent[])new TimelineEvent[]{this.ev1});
        timelines = this.store.getEntityTimelines(this.entityType1, sortedSet, null, null, Long.valueOf(123L), null).getAllEvents();
        Assert.assertEquals((long)2L, (long)timelines.size());
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)((TimelineEvents.EventsOfOneEntity)timelines.get(0)), (String)this.entityId1, (String)this.entityType1, (TimelineEvent[])new TimelineEvent[]{this.ev1});
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)((TimelineEvents.EventsOfOneEntity)timelines.get(1)), (String)this.entityId1b, (String)this.entityType1, (TimelineEvent[])new TimelineEvent[]{this.ev1});
        timelines = this.store.getEntityTimelines(this.entityType1, sortedSet, null, null, null, Collections.singleton("end_event")).getAllEvents();
        Assert.assertEquals((long)2L, (long)timelines.size());
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)((TimelineEvents.EventsOfOneEntity)timelines.get(0)), (String)this.entityId1, (String)this.entityType1, (TimelineEvent[])new TimelineEvent[]{this.ev2});
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)((TimelineEvents.EventsOfOneEntity)timelines.get(1)), (String)this.entityId1b, (String)this.entityType1, (TimelineEvent[])new TimelineEvent[]{this.ev2});
        sortedSet.add(this.entityId2);
        timelines = this.store.getEntityTimelines(this.entityType2, sortedSet, null, null, null, null).getAllEvents();
        Assert.assertEquals((long)1L, (long)timelines.size());
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)((TimelineEvents.EventsOfOneEntity)timelines.get(0)), (String)this.entityId2, (String)this.entityType2, (TimelineEvent[])new TimelineEvent[]{this.ev3, this.ev4});
    }

    protected static void verifyEntityInfo(String entityId, String entityType, List<TimelineEvent> events, Map<String, Set<String>> relatedEntities, Map<String, Set<Object>> primaryFilters, Map<String, Object> otherInfo, Long startTime, TimelineEntity retrievedEntityInfo) {
        TimelineStoreTestUtils.verifyEntityInfo((String)entityId, (String)entityType, events, relatedEntities, primaryFilters, otherInfo, (TimelineEntity)retrievedEntityInfo);
        Assert.assertEquals((Object)startTime, (Object)retrievedEntityInfo.getStartTime());
    }

    protected static void verifyEntityInfo(String entityId, String entityType, List<TimelineEvent> events, Map<String, Set<String>> relatedEntities, Map<String, Set<Object>> primaryFilters, Map<String, Object> otherInfo, TimelineEntity retrievedEntityInfo) {
        if (entityId == null) {
            Assert.assertNull((Object)retrievedEntityInfo);
            return;
        }
        Assert.assertEquals((Object)entityId, (Object)retrievedEntityInfo.getEntityId());
        Assert.assertEquals((Object)entityType, (Object)retrievedEntityInfo.getEntityType());
        if (events == null) {
            Assert.assertNull((Object)retrievedEntityInfo.getEvents());
        } else {
            Assert.assertEquals(events, (Object)retrievedEntityInfo.getEvents());
        }
        if (relatedEntities == null) {
            Assert.assertNull((Object)retrievedEntityInfo.getRelatedEntities());
        } else {
            Assert.assertEquals(relatedEntities, (Object)retrievedEntityInfo.getRelatedEntities());
        }
        if (primaryFilters == null) {
            Assert.assertNull((Object)retrievedEntityInfo.getPrimaryFilters());
        } else {
            Assert.assertTrue((boolean)primaryFilters.equals(retrievedEntityInfo.getPrimaryFilters()));
        }
        if (otherInfo == null) {
            Assert.assertNull((Object)retrievedEntityInfo.getOtherInfo());
        } else {
            Assert.assertTrue((boolean)otherInfo.equals(retrievedEntityInfo.getOtherInfo()));
        }
    }

    private static void verifyEntityTimeline(TimelineEvents.EventsOfOneEntity retrievedEvents, String entityId, String entityType, TimelineEvent ... actualEvents) {
        Assert.assertEquals((Object)entityId, (Object)retrievedEvents.getEntityId());
        Assert.assertEquals((Object)entityType, (Object)retrievedEvents.getEntityType());
        Assert.assertEquals((long)actualEvents.length, (long)retrievedEvents.getEvents().size());
        for (int i = 0; i < actualEvents.length; ++i) {
            Assert.assertEquals((Object)actualEvents[i], retrievedEvents.getEvents().get(i));
        }
    }

    protected static TimelineEntity createEntity(String entityId, String entityType, Long startTime, List<TimelineEvent> events, Map<String, Set<String>> relatedEntities, Map<String, Set<Object>> primaryFilters, Map<String, Object> otherInfo) {
        TimelineEntity entity = new TimelineEntity();
        entity.setEntityId(entityId);
        entity.setEntityType(entityType);
        entity.setStartTime(startTime);
        entity.setEvents(events);
        if (relatedEntities != null) {
            for (Map.Entry<String, Set<String>> e : relatedEntities.entrySet()) {
                for (String v : e.getValue()) {
                    entity.addRelatedEntity(e.getKey(), v);
                }
            }
        } else {
            entity.setRelatedEntities(null);
        }
        entity.setPrimaryFilters(primaryFilters);
        entity.setOtherInfo(otherInfo);
        return entity;
    }

    private static TimelineEvent createEvent(long timestamp, String type, Map<String, Object> info) {
        TimelineEvent event = new TimelineEvent();
        event.setTimestamp(timestamp);
        event.setEventType(type);
        event.setEventInfo(info);
        return event;
    }
}

