/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.security;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.AdminACLsManager;
import org.apache.hadoop.yarn.server.timeline.EntityIdentifier;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;

@InterfaceAudience.Private
public class TimelineACLsManager {
    private static final Log LOG = LogFactory.getLog(TimelineACLsManager.class);
    private AdminACLsManager adminAclsManager;

    public TimelineACLsManager(Configuration conf) {
        this.adminAclsManager = new AdminACLsManager(conf);
    }

    public boolean checkAccess(UserGroupInformation callerUGI, TimelineEntity entity) throws YarnException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Verifying the access of " + callerUGI.getShortUserName() + " on the timeline entity " + new EntityIdentifier(entity.getEntityId(), entity.getEntityType())));
        }
        if (!this.adminAclsManager.areACLsEnabled()) {
            return true;
        }
        Set values = (Set)entity.getPrimaryFilters().get(TimelineStore.SystemFilter.ENTITY_OWNER.toString());
        if (values == null || values.size() != 1) {
            throw new YarnException("Owner information of the timeline entity " + new EntityIdentifier(entity.getEntityId(), entity.getEntityType()) + " is corrupted.");
        }
        String owner = values.iterator().next().toString();
        return callerUGI != null && (this.adminAclsManager.isAdmin(callerUGI) || callerUGI.getShortUserName().equals(owner));
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public AdminACLsManager setAdminACLsManager(AdminACLsManager adminAclsManager) {
        AdminACLsManager oldAdminACLsManager = this.adminAclsManager;
        this.adminAclsManager = adminAclsManager;
        return oldAdminACLsManager;
    }
}

