/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.JerseyTest;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvents;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.security.AdminACLsManager;
import org.apache.hadoop.yarn.server.timeline.TestMemoryTimelineStore;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.security.TimelineACLsManager;
import org.apache.hadoop.yarn.server.timeline.webapp.TestTimelineWebServices;
import org.apache.hadoop.yarn.server.timeline.webapp.TimelineWebServices;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestTimelineWebServices
extends JerseyTest {
    private static TimelineStore store;
    private static TimelineACLsManager timelineACLsManager;
    private static AdminACLsManager adminACLsManager;
    private static String remoteUser;
    private long beforeTime;
    private Injector injector = Guice.createInjector((Module[])new Module[]{new /* Unavailable Anonymous Inner Class!! */});

    private TimelineStore mockTimelineStore() throws Exception {
        this.beforeTime = System.currentTimeMillis() - 1L;
        TestMemoryTimelineStore store = new TestMemoryTimelineStore();
        store.setup();
        return store.getTimelineStore();
    }

    public TestTimelineWebServices() {
        super((AppDescriptor)((WebAppDescriptor.Builder)new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.yarn.server.applicationhistoryservice.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").clientConfig((ClientConfig)new DefaultClientConfig(new Class[]{YarnJacksonJaxbJsonProvider.class}))).build());
    }

    @Test
    public void testAbout() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TimelineWebServices.AboutInfo about = (TimelineWebServices.AboutInfo)response.getEntity(TimelineWebServices.AboutInfo.class);
        Assert.assertNotNull((Object)about);
        Assert.assertEquals((Object)"Timeline API", (Object)about.getAbout());
    }

    private static void verifyEntities(TimelineEntities entities) {
        Assert.assertNotNull((Object)entities);
        Assert.assertEquals((long)2L, (long)entities.getEntities().size());
        TimelineEntity entity1 = (TimelineEntity)entities.getEntities().get(0);
        Assert.assertNotNull((Object)entity1);
        Assert.assertEquals((Object)"id_1", (Object)entity1.getEntityId());
        Assert.assertEquals((Object)"type_1", (Object)entity1.getEntityType());
        Assert.assertEquals((long)123L, (long)entity1.getStartTime());
        Assert.assertEquals((long)2L, (long)entity1.getEvents().size());
        Assert.assertEquals((long)4L, (long)entity1.getPrimaryFilters().size());
        Assert.assertEquals((long)4L, (long)entity1.getOtherInfo().size());
        TimelineEntity entity2 = (TimelineEntity)entities.getEntities().get(1);
        Assert.assertNotNull((Object)entity2);
        Assert.assertEquals((Object)"id_2", (Object)entity2.getEntityId());
        Assert.assertEquals((Object)"type_1", (Object)entity2.getEntityType());
        Assert.assertEquals((long)123L, (long)entity2.getStartTime());
        Assert.assertEquals((long)2L, (long)entity2.getEvents().size());
        Assert.assertEquals((long)4L, (long)entity2.getPrimaryFilters().size());
        Assert.assertEquals((long)4L, (long)entity2.getOtherInfo().size());
    }

    @Test
    public void testGetEntities() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TestTimelineWebServices.verifyEntities((TimelineEntities)((TimelineEntities)response.getEntity(TimelineEntities.class)));
    }

    @Test
    public void testFromId() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("fromId", "id_2").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        Assert.assertEquals((long)1L, (long)((TimelineEntities)response.getEntity(TimelineEntities.class)).getEntities().size());
        response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("fromId", "id_1").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        Assert.assertEquals((long)2L, (long)((TimelineEntities)response.getEntity(TimelineEntities.class)).getEntities().size());
    }

    @Test
    public void testFromTs() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("fromTs", Long.toString(this.beforeTime)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        Assert.assertEquals((long)0L, (long)((TimelineEntities)response.getEntity(TimelineEntities.class)).getEntities().size());
        response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("fromTs", Long.toString(System.currentTimeMillis())).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        Assert.assertEquals((long)2L, (long)((TimelineEntities)response.getEntity(TimelineEntities.class)).getEntities().size());
    }

    @Test
    public void testPrimaryFilterString() {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("primaryFilter", "user:username").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TestTimelineWebServices.verifyEntities((TimelineEntities)((TimelineEntities)response.getEntity(TimelineEntities.class)));
    }

    @Test
    public void testPrimaryFilterInteger() {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("primaryFilter", "appname:" + Integer.toString(Integer.MAX_VALUE)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TestTimelineWebServices.verifyEntities((TimelineEntities)((TimelineEntities)response.getEntity(TimelineEntities.class)));
    }

    @Test
    public void testPrimaryFilterLong() {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("primaryFilter", "long:" + Long.toString(0x80000000L)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TestTimelineWebServices.verifyEntities((TimelineEntities)((TimelineEntities)response.getEntity(TimelineEntities.class)));
    }

    @Test
    public void testPrimaryFilterNumericString() {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("primaryFilter", "other:123abc").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        Assert.assertEquals((long)0L, (long)((TimelineEntities)response.getEntity(TimelineEntities.class)).getEntities().size());
    }

    @Test
    public void testPrimaryFilterNumericStringWithQuotes() {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("primaryFilter", "other:\"123abc\"").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TestTimelineWebServices.verifyEntities((TimelineEntities)((TimelineEntities)response.getEntity(TimelineEntities.class)));
    }

    @Test
    public void testSecondaryFilters() {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("secondaryFilter", "user:username,appname:" + Integer.toString(Integer.MAX_VALUE)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TestTimelineWebServices.verifyEntities((TimelineEntities)((TimelineEntities)response.getEntity(TimelineEntities.class)));
    }

    @Test
    public void testGetEntity() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").path("id_1").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TimelineEntity entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((Object)"id_1", (Object)entity.getEntityId());
        Assert.assertEquals((Object)"type_1", (Object)entity.getEntityType());
        Assert.assertEquals((long)123L, (long)entity.getStartTime());
        Assert.assertEquals((long)2L, (long)entity.getEvents().size());
        Assert.assertEquals((long)4L, (long)entity.getPrimaryFilters().size());
        Assert.assertEquals((long)4L, (long)entity.getOtherInfo().size());
    }

    @Test
    public void testGetEntityFields1() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").path("id_1").queryParam("fields", "events,otherinfo").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TimelineEntity entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((Object)"id_1", (Object)entity.getEntityId());
        Assert.assertEquals((Object)"type_1", (Object)entity.getEntityType());
        Assert.assertEquals((long)123L, (long)entity.getStartTime());
        Assert.assertEquals((long)2L, (long)entity.getEvents().size());
        Assert.assertEquals((long)0L, (long)entity.getPrimaryFilters().size());
        Assert.assertEquals((long)4L, (long)entity.getOtherInfo().size());
    }

    @Test
    public void testGetEntityFields2() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").path("id_1").queryParam("fields", "lasteventonly,primaryfilters,relatedentities").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TimelineEntity entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((Object)"id_1", (Object)entity.getEntityId());
        Assert.assertEquals((Object)"type_1", (Object)entity.getEntityType());
        Assert.assertEquals((long)123L, (long)entity.getStartTime());
        Assert.assertEquals((long)1L, (long)entity.getEvents().size());
        Assert.assertEquals((long)4L, (long)entity.getPrimaryFilters().size());
        Assert.assertEquals((long)0L, (long)entity.getOtherInfo().size());
    }

    @Test
    public void testGetEvents() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").path("events").queryParam("entityId", "id_1").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TimelineEvents events = (TimelineEvents)response.getEntity(TimelineEvents.class);
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)1L, (long)events.getAllEvents().size());
        TimelineEvents.EventsOfOneEntity partEvents = (TimelineEvents.EventsOfOneEntity)events.getAllEvents().get(0);
        Assert.assertEquals((long)2L, (long)partEvents.getEvents().size());
        TimelineEvent event1 = (TimelineEvent)partEvents.getEvents().get(0);
        Assert.assertEquals((long)456L, (long)event1.getTimestamp());
        Assert.assertEquals((Object)"end_event", (Object)event1.getEventType());
        Assert.assertEquals((long)1L, (long)event1.getEventInfo().size());
        TimelineEvent event2 = (TimelineEvent)partEvents.getEvents().get(1);
        Assert.assertEquals((long)123L, (long)event2.getTimestamp());
        Assert.assertEquals((Object)"start_event", (Object)event2.getEventType());
        Assert.assertEquals((long)0L, (long)event2.getEventInfo().size());
    }

    @Test
    public void testPostEntitiesWithPrimaryFilter() throws Exception {
        TimelineEntities entities = new TimelineEntities();
        TimelineEntity entity = new TimelineEntity();
        HashMap filters = new HashMap();
        filters.put(TimelineStore.SystemFilter.ENTITY_OWNER.toString(), new HashSet());
        entity.setPrimaryFilters(filters);
        entity.setEntityId("test id 6");
        entity.setEntityType("test type 6");
        entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
        entities.addEntity(entity);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
        TimelinePutResponse putResposne = (TimelinePutResponse)response.getEntity(TimelinePutResponse.class);
        Assert.assertEquals((long)1L, (long)putResposne.getErrors().size());
        List errors = putResposne.getErrors();
        Assert.assertEquals((long)3L, (long)((TimelinePutResponse.TimelinePutError)errors.get(0)).getErrorCode());
    }

    @Test
    public void testPostEntities() throws Exception {
        TimelineEntities entities = new TimelineEntities();
        TimelineEntity entity = new TimelineEntity();
        entity.setEntityId("test id 1");
        entity.setEntityType("test type 1");
        entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
        entities.addEntity(entity);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TimelinePutResponse putResposne = (TimelinePutResponse)response.getEntity(TimelinePutResponse.class);
        Assert.assertNotNull((Object)putResposne);
        Assert.assertEquals((long)0L, (long)putResposne.getErrors().size());
        response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("test type 1").path("test id 1").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((Object)"test id 1", (Object)entity.getEntityId());
        Assert.assertEquals((Object)"test type 1", (Object)entity.getEntityType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostEntitiesWithYarnACLsEnabled() throws Exception {
        AdminACLsManager oldAdminACLsManager = timelineACLsManager.setAdminACLsManager(adminACLsManager);
        remoteUser = "tester";
        try {
            TimelineEntities entities = new TimelineEntities();
            TimelineEntity entity = new TimelineEntity();
            entity.setEntityId("test id 2");
            entity.setEntityType("test type 2");
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            entities.addEntity(entity);
            WebResource r = this.resource();
            ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            TimelinePutResponse putResponse = (TimelinePutResponse)response.getEntity(TimelinePutResponse.class);
            Assert.assertNotNull((Object)putResponse);
            Assert.assertEquals((long)0L, (long)putResponse.getErrors().size());
            remoteUser = "other";
            response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            putResponse = (TimelinePutResponse)response.getEntity(TimelinePutResponse.class);
            Assert.assertNotNull((Object)putResponse);
            Assert.assertEquals((long)1L, (long)putResponse.getErrors().size());
            Assert.assertEquals((long)4L, (long)((TimelinePutResponse.TimelinePutError)putResponse.getErrors().get(0)).getErrorCode());
        }
        finally {
            timelineACLsManager.setAdminACLsManager(oldAdminACLsManager);
            remoteUser = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntityWithYarnACLsEnabled() throws Exception {
        AdminACLsManager oldAdminACLsManager = timelineACLsManager.setAdminACLsManager(adminACLsManager);
        remoteUser = "tester";
        try {
            TimelineEntities entities = new TimelineEntities();
            TimelineEntity entity = new TimelineEntity();
            entity.setEntityId("test id 3");
            entity.setEntityType("test type 3");
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            entities.addEntity(entity);
            WebResource r = this.resource();
            ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
            response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("test type 3").path("test id 3").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
            Assert.assertNull(entity.getPrimaryFilters().get(TimelineStore.SystemFilter.ENTITY_OWNER.toString()));
            response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("test type 3").path("test id 3").queryParam("fields", "relatedentities").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
            Assert.assertNull(entity.getPrimaryFilters().get(TimelineStore.SystemFilter.ENTITY_OWNER.toString()));
            response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("test type 3").path("test id 3").queryParam("fields", "primaryfilters").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
            Assert.assertNull(entity.getPrimaryFilters().get(TimelineStore.SystemFilter.ENTITY_OWNER.toString()));
            remoteUser = "other";
            response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("test type 3").path("test id 3").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            Assert.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
        }
        finally {
            timelineACLsManager.setAdminACLsManager(oldAdminACLsManager);
            remoteUser = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntitiesWithYarnACLsEnabled() {
        AdminACLsManager oldAdminACLsManager = timelineACLsManager.setAdminACLsManager(adminACLsManager);
        remoteUser = "tester";
        try {
            TimelineEntities entities = new TimelineEntities();
            TimelineEntity entity = new TimelineEntity();
            entity.setEntityId("test id 4");
            entity.setEntityType("test type 4");
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            entities.addEntity(entity);
            WebResource r = this.resource();
            ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
            remoteUser = "other";
            entities = new TimelineEntities();
            entity = new TimelineEntity();
            entity.setEntityId("test id 5");
            entity.setEntityType("test type 4");
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            entities.addEntity(entity);
            r = this.resource();
            response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
            response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("test type 4").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            entities = (TimelineEntities)response.getEntity(TimelineEntities.class);
            Assert.assertEquals((long)1L, (long)entities.getEntities().size());
            Assert.assertEquals((Object)"test type 4", (Object)((TimelineEntity)entities.getEntities().get(0)).getEntityType());
            Assert.assertEquals((Object)"test id 5", (Object)((TimelineEntity)entities.getEntities().get(0)).getEntityId());
        }
        finally {
            timelineACLsManager.setAdminACLsManager(oldAdminACLsManager);
            remoteUser = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEventsWithYarnACLsEnabled() {
        AdminACLsManager oldAdminACLsManager = timelineACLsManager.setAdminACLsManager(adminACLsManager);
        remoteUser = "tester";
        try {
            TimelineEntities entities = new TimelineEntities();
            TimelineEntity entity = new TimelineEntity();
            entity.setEntityId("test id 5");
            entity.setEntityType("test type 5");
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            TimelineEvent event = new TimelineEvent();
            event.setEventType("event type 1");
            event.setTimestamp(System.currentTimeMillis());
            entity.addEvent(event);
            entities.addEntity(entity);
            WebResource r = this.resource();
            ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
            remoteUser = "other";
            entities = new TimelineEntities();
            entity = new TimelineEntity();
            entity.setEntityId("test id 6");
            entity.setEntityType("test type 5");
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            event = new TimelineEvent();
            event.setEventType("event type 2");
            event.setTimestamp(System.currentTimeMillis());
            entity.addEvent(event);
            entities.addEntity(entity);
            r = this.resource();
            response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
            response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("test type 5").path("events").queryParam("entityId", "test id 5,test id 6").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            TimelineEvents events = (TimelineEvents)response.getEntity(TimelineEvents.class);
            Assert.assertEquals((long)1L, (long)events.getAllEvents().size());
            Assert.assertEquals((Object)"test id 6", (Object)((TimelineEvents.EventsOfOneEntity)events.getAllEvents().get(0)).getEntityId());
        }
        finally {
            timelineACLsManager.setAdminACLsManager(oldAdminACLsManager);
            remoteUser = null;
        }
    }

    static /* synthetic */ TimelineStore access$002(TimelineStore x0) {
        store = x0;
        return store;
    }

    static /* synthetic */ TimelineStore access$100(TestTimelineWebServices x0) throws Exception {
        return x0.mockTimelineStore();
    }

    static /* synthetic */ TimelineStore access$000() {
        return store;
    }

    static /* synthetic */ TimelineACLsManager access$202(TimelineACLsManager x0) {
        timelineACLsManager = x0;
        return timelineACLsManager;
    }

    static /* synthetic */ AdminACLsManager access$302(AdminACLsManager x0) {
        adminACLsManager = x0;
        return adminACLsManager;
    }

    static /* synthetic */ TimelineACLsManager access$200() {
        return timelineACLsManager;
    }

    static /* synthetic */ Injector access$400(TestTimelineWebServices x0) {
        return x0.injector;
    }

    static /* synthetic */ String access$500() {
        return remoteUser;
    }
}

