/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice.webapp;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.server.api.ApplicationContext;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManager;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.AHSController;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.AHSWebServices;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.security.TimelineACLsManager;
import org.apache.hadoop.yarn.server.timeline.security.TimelineDelegationTokenSecretManagerService;
import org.apache.hadoop.yarn.server.timeline.webapp.TimelineWebServices;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;
import org.apache.hadoop.yarn.webapp.YarnWebParams;

public class AHSWebApp
extends WebApp
implements YarnWebParams {
    private ApplicationHistoryManager applicationHistoryManager;
    private TimelineStore timelineStore;
    private TimelineDelegationTokenSecretManagerService secretManagerService;
    private TimelineACLsManager timelineACLsManager;
    private static AHSWebApp instance = null;

    public static AHSWebApp getInstance() {
        if (instance == null) {
            instance = new AHSWebApp();
        }
        return instance;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static void resetInstance() {
        instance = null;
    }

    private AHSWebApp() {
    }

    public ApplicationHistoryManager getApplicationHistoryManager() {
        return this.applicationHistoryManager;
    }

    public void setApplicationHistoryManager(ApplicationHistoryManager applicationHistoryManager) {
        this.applicationHistoryManager = applicationHistoryManager;
    }

    public TimelineStore getTimelineStore() {
        return this.timelineStore;
    }

    public void setTimelineStore(TimelineStore timelineStore) {
        this.timelineStore = timelineStore;
    }

    public TimelineDelegationTokenSecretManagerService getTimelineDelegationTokenSecretManagerService() {
        return this.secretManagerService;
    }

    public void setTimelineDelegationTokenSecretManagerService(TimelineDelegationTokenSecretManagerService secretManagerService) {
        this.secretManagerService = secretManagerService;
    }

    public TimelineACLsManager getTimelineACLsManager() {
        return this.timelineACLsManager;
    }

    public void setTimelineACLsManager(TimelineACLsManager timelineACLsManager) {
        this.timelineACLsManager = timelineACLsManager;
    }

    public void setup() {
        this.bind(YarnJacksonJaxbJsonProvider.class);
        this.bind(AHSWebServices.class);
        this.bind(TimelineWebServices.class);
        this.bind(GenericExceptionHandler.class);
        this.bind(ApplicationContext.class).toInstance((Object)this.applicationHistoryManager);
        this.bind(TimelineStore.class).toInstance((Object)this.timelineStore);
        this.bind(TimelineDelegationTokenSecretManagerService.class).toInstance((Object)this.secretManagerService);
        this.bind(TimelineACLsManager.class).toInstance((Object)this.timelineACLsManager);
        this.route("/", AHSController.class);
        this.route(StringHelper.pajoin((Object[])new Object[]{"/apps", "app.state"}), AHSController.class);
        this.route(StringHelper.pajoin((Object[])new Object[]{"/app", "app.id"}), AHSController.class, "app");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/appattempt", "appattempt.id"}), AHSController.class, "appattempt");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/container", "container.id"}), AHSController.class, "container");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/logs", "nm.id", "container.id", "entity.string", "app.owner", "log.type"}), AHSController.class, "logs");
    }
}

