/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.file.tfile.TFile;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.proto.ApplicationHistoryServerProtos;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationAttemptFinishData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationAttemptHistoryData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationAttemptStartData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationFinishData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationHistoryData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationStartData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ContainerFinishData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ContainerHistoryData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ContainerStartData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.impl.pb.ApplicationAttemptFinishDataPBImpl;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.impl.pb.ApplicationAttemptStartDataPBImpl;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.impl.pb.ApplicationFinishDataPBImpl;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.impl.pb.ApplicationStartDataPBImpl;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.impl.pb.ContainerFinishDataPBImpl;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.impl.pb.ContainerStartDataPBImpl;
import org.apache.hadoop.yarn.util.ConverterUtils;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class FileSystemApplicationHistoryStore
extends AbstractService
implements ApplicationHistoryStore {
    private static final Log LOG = LogFactory.getLog(FileSystemApplicationHistoryStore.class);
    private static final String ROOT_DIR_NAME = "ApplicationHistoryDataRoot";
    private static final int MIN_BLOCK_SIZE = 262144;
    private static final String START_DATA_SUFFIX = "_start";
    private static final String FINISH_DATA_SUFFIX = "_finish";
    private static final FsPermission ROOT_DIR_UMASK = FsPermission.createImmutable((short)480);
    private static final FsPermission HISTORY_FILE_UMASK = FsPermission.createImmutable((short)416);
    private FileSystem fs;
    private Path rootDirPath;
    private ConcurrentMap<ApplicationId, HistoryFileWriter> outstandingWriters = new ConcurrentHashMap<ApplicationId, HistoryFileWriter>();

    public FileSystemApplicationHistoryStore() {
        super(FileSystemApplicationHistoryStore.class.getName());
    }

    protected FileSystem getFileSystem(Path path, Configuration conf) throws Exception {
        return path.getFileSystem(conf);
    }

    public void serviceStart() throws Exception {
        Configuration conf = this.getConfig();
        Path fsWorkingPath = new Path(conf.get("yarn.timeline-service.generic-application-history.fs-history-store.uri", conf.get("hadoop.tmp.dir") + "/yarn/timeline/generic-history"));
        this.rootDirPath = new Path(fsWorkingPath, ROOT_DIR_NAME);
        try {
            this.fs = this.getFileSystem(fsWorkingPath, conf);
            if (!this.fs.isDirectory(this.rootDirPath)) {
                this.fs.mkdirs(this.rootDirPath);
                this.fs.setPermission(this.rootDirPath, ROOT_DIR_UMASK);
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Error when initializing FileSystemHistoryStorage", (Throwable)e);
            throw e;
        }
        super.serviceStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceStop() throws Exception {
        try {
            for (Map.Entry entry : this.outstandingWriters.entrySet()) {
                ((HistoryFileWriter)entry.getValue()).close();
            }
            this.outstandingWriters.clear();
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.fs});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.fs});
        super.serviceStop();
    }

    @Override
    public ApplicationHistoryData getApplication(ApplicationId appId) throws IOException {
        HistoryFileReader hfReader = this.getHistoryFileReader(appId);
        try {
            ApplicationHistoryData applicationHistoryData;
            boolean readStartData = false;
            boolean readFinishData = false;
            ApplicationHistoryData historyData = ApplicationHistoryData.newInstance(appId, null, null, null, null, Long.MIN_VALUE, Long.MIN_VALUE, Long.MAX_VALUE, null, FinalApplicationStatus.UNDEFINED, null);
            while (!(readStartData && readFinishData || !hfReader.hasNext())) {
                HistoryFileReader.Entry entry = hfReader.next();
                if (!entry.key.id.equals(appId.toString())) continue;
                if (entry.key.suffix.equals(START_DATA_SUFFIX)) {
                    ApplicationStartData startData = FileSystemApplicationHistoryStore.parseApplicationStartData(entry.value);
                    FileSystemApplicationHistoryStore.mergeApplicationHistoryData(historyData, startData);
                    readStartData = true;
                    continue;
                }
                if (!entry.key.suffix.equals(FINISH_DATA_SUFFIX)) continue;
                ApplicationFinishData finishData = FileSystemApplicationHistoryStore.parseApplicationFinishData(entry.value);
                FileSystemApplicationHistoryStore.mergeApplicationHistoryData(historyData, finishData);
                readFinishData = true;
            }
            if (!readStartData && !readFinishData) {
                applicationHistoryData = null;
                return applicationHistoryData;
            }
            if (!readStartData) {
                LOG.warn((Object)("Start information is missing for application " + appId));
            }
            if (!readFinishData) {
                LOG.warn((Object)("Finish information is missing for application " + appId));
            }
            LOG.info((Object)("Completed reading history information of application " + appId));
            applicationHistoryData = historyData;
            return applicationHistoryData;
        }
        catch (IOException e) {
            LOG.error((Object)("Error when reading history file of application " + appId), (Throwable)e);
            throw e;
        }
        finally {
            hfReader.close();
        }
    }

    @Override
    public Map<ApplicationId, ApplicationHistoryData> getAllApplications() throws IOException {
        FileStatus[] files;
        HashMap<ApplicationId, ApplicationHistoryData> historyDataMap = new HashMap<ApplicationId, ApplicationHistoryData>();
        for (FileStatus file : files = this.fs.listStatus(this.rootDirPath)) {
            ApplicationId appId = ConverterUtils.toApplicationId((String)file.getPath().getName());
            try {
                ApplicationHistoryData historyData = this.getApplication(appId);
                if (historyData == null) continue;
                historyDataMap.put(appId, historyData);
            }
            catch (IOException e) {
                LOG.error((Object)("History information of application " + appId + " is not included into the result due to the exception"), (Throwable)e);
            }
        }
        return historyDataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<ApplicationAttemptId, ApplicationAttemptHistoryData> getApplicationAttempts(ApplicationId appId) throws IOException {
        HashMap<ApplicationAttemptId, ApplicationAttemptHistoryData> historyDataMap = new HashMap<ApplicationAttemptId, ApplicationAttemptHistoryData>();
        HistoryFileReader hfReader = this.getHistoryFileReader(appId);
        try {
            while (hfReader.hasNext()) {
                ApplicationAttemptId appAttemptId;
                HistoryFileReader.Entry entry = hfReader.next();
                if (!entry.key.id.startsWith("appattempt") || !(appAttemptId = ConverterUtils.toApplicationAttemptId((String)entry.key.id)).getApplicationId().equals((Object)appId)) continue;
                ApplicationAttemptHistoryData historyData = (ApplicationAttemptHistoryData)historyDataMap.get(appAttemptId);
                if (historyData == null) {
                    historyData = ApplicationAttemptHistoryData.newInstance(appAttemptId, null, -1, null, null, null, FinalApplicationStatus.UNDEFINED, null);
                    historyDataMap.put(appAttemptId, historyData);
                }
                if (entry.key.suffix.equals(START_DATA_SUFFIX)) {
                    FileSystemApplicationHistoryStore.mergeApplicationAttemptHistoryData(historyData, FileSystemApplicationHistoryStore.parseApplicationAttemptStartData(entry.value));
                    continue;
                }
                if (!entry.key.suffix.equals(FINISH_DATA_SUFFIX)) continue;
                FileSystemApplicationHistoryStore.mergeApplicationAttemptHistoryData(historyData, FileSystemApplicationHistoryStore.parseApplicationAttemptFinishData(entry.value));
            }
            LOG.info((Object)("Completed reading history information of all application attempts of application " + appId));
        }
        catch (IOException e) {
            LOG.info((Object)("Error when reading history information of some application attempts of application " + appId));
        }
        finally {
            hfReader.close();
        }
        return historyDataMap;
    }

    @Override
    public ApplicationAttemptHistoryData getApplicationAttempt(ApplicationAttemptId appAttemptId) throws IOException {
        HistoryFileReader hfReader = this.getHistoryFileReader(appAttemptId.getApplicationId());
        try {
            ApplicationAttemptHistoryData applicationAttemptHistoryData;
            boolean readStartData = false;
            boolean readFinishData = false;
            ApplicationAttemptHistoryData historyData = ApplicationAttemptHistoryData.newInstance(appAttemptId, null, -1, null, null, null, FinalApplicationStatus.UNDEFINED, null);
            while (!(readStartData && readFinishData || !hfReader.hasNext())) {
                HistoryFileReader.Entry entry = hfReader.next();
                if (!entry.key.id.equals(appAttemptId.toString())) continue;
                if (entry.key.suffix.equals(START_DATA_SUFFIX)) {
                    ApplicationAttemptStartData startData = FileSystemApplicationHistoryStore.parseApplicationAttemptStartData(entry.value);
                    FileSystemApplicationHistoryStore.mergeApplicationAttemptHistoryData(historyData, startData);
                    readStartData = true;
                    continue;
                }
                if (!entry.key.suffix.equals(FINISH_DATA_SUFFIX)) continue;
                ApplicationAttemptFinishData finishData = FileSystemApplicationHistoryStore.parseApplicationAttemptFinishData(entry.value);
                FileSystemApplicationHistoryStore.mergeApplicationAttemptHistoryData(historyData, finishData);
                readFinishData = true;
            }
            if (!readStartData && !readFinishData) {
                applicationAttemptHistoryData = null;
                return applicationAttemptHistoryData;
            }
            if (!readStartData) {
                LOG.warn((Object)("Start information is missing for application attempt " + appAttemptId));
            }
            if (!readFinishData) {
                LOG.warn((Object)("Finish information is missing for application attempt " + appAttemptId));
            }
            LOG.info((Object)("Completed reading history information of application attempt " + appAttemptId));
            applicationAttemptHistoryData = historyData;
            return applicationAttemptHistoryData;
        }
        catch (IOException e) {
            LOG.error((Object)("Error when reading history file of application attempt" + appAttemptId), (Throwable)e);
            throw e;
        }
        finally {
            hfReader.close();
        }
    }

    @Override
    public ContainerHistoryData getContainer(ContainerId containerId) throws IOException {
        HistoryFileReader hfReader = this.getHistoryFileReader(containerId.getApplicationAttemptId().getApplicationId());
        try {
            ContainerHistoryData containerHistoryData;
            boolean readStartData = false;
            boolean readFinishData = false;
            ContainerHistoryData historyData = ContainerHistoryData.newInstance(containerId, null, null, null, Long.MIN_VALUE, Long.MAX_VALUE, null, Integer.MAX_VALUE, null);
            while (!(readStartData && readFinishData || !hfReader.hasNext())) {
                HistoryFileReader.Entry entry = hfReader.next();
                if (!entry.key.id.equals(containerId.toString())) continue;
                if (entry.key.suffix.equals(START_DATA_SUFFIX)) {
                    ContainerStartData startData = FileSystemApplicationHistoryStore.parseContainerStartData(entry.value);
                    FileSystemApplicationHistoryStore.mergeContainerHistoryData(historyData, startData);
                    readStartData = true;
                    continue;
                }
                if (!entry.key.suffix.equals(FINISH_DATA_SUFFIX)) continue;
                ContainerFinishData finishData = FileSystemApplicationHistoryStore.parseContainerFinishData(entry.value);
                FileSystemApplicationHistoryStore.mergeContainerHistoryData(historyData, finishData);
                readFinishData = true;
            }
            if (!readStartData && !readFinishData) {
                containerHistoryData = null;
                return containerHistoryData;
            }
            if (!readStartData) {
                LOG.warn((Object)("Start information is missing for container " + containerId));
            }
            if (!readFinishData) {
                LOG.warn((Object)("Finish information is missing for container " + containerId));
            }
            LOG.info((Object)("Completed reading history information of container " + containerId));
            containerHistoryData = historyData;
            return containerHistoryData;
        }
        catch (IOException e) {
            LOG.error((Object)("Error when reading history file of container " + containerId), (Throwable)e);
            throw e;
        }
        finally {
            hfReader.close();
        }
    }

    @Override
    public ContainerHistoryData getAMContainer(ApplicationAttemptId appAttemptId) throws IOException {
        ApplicationAttemptHistoryData attemptHistoryData = this.getApplicationAttempt(appAttemptId);
        if (attemptHistoryData == null || attemptHistoryData.getMasterContainerId() == null) {
            return null;
        }
        return this.getContainer(attemptHistoryData.getMasterContainerId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<ContainerId, ContainerHistoryData> getContainers(ApplicationAttemptId appAttemptId) throws IOException {
        HashMap<ContainerId, ContainerHistoryData> historyDataMap = new HashMap<ContainerId, ContainerHistoryData>();
        HistoryFileReader hfReader = this.getHistoryFileReader(appAttemptId.getApplicationId());
        try {
            while (hfReader.hasNext()) {
                ContainerId containerId;
                HistoryFileReader.Entry entry = hfReader.next();
                if (!entry.key.id.startsWith("container") || !(containerId = ConverterUtils.toContainerId((String)entry.key.id)).getApplicationAttemptId().equals((Object)appAttemptId)) continue;
                ContainerHistoryData historyData = (ContainerHistoryData)historyDataMap.get(containerId);
                if (historyData == null) {
                    historyData = ContainerHistoryData.newInstance(containerId, null, null, null, Long.MIN_VALUE, Long.MAX_VALUE, null, Integer.MAX_VALUE, null);
                    historyDataMap.put(containerId, historyData);
                }
                if (entry.key.suffix.equals(START_DATA_SUFFIX)) {
                    FileSystemApplicationHistoryStore.mergeContainerHistoryData(historyData, FileSystemApplicationHistoryStore.parseContainerStartData(entry.value));
                    continue;
                }
                if (!entry.key.suffix.equals(FINISH_DATA_SUFFIX)) continue;
                FileSystemApplicationHistoryStore.mergeContainerHistoryData(historyData, FileSystemApplicationHistoryStore.parseContainerFinishData(entry.value));
            }
            LOG.info((Object)("Completed reading history information of all conatiners of application attempt " + appAttemptId));
        }
        catch (IOException e) {
            LOG.info((Object)("Error when reading history information of some containers of application attempt " + appAttemptId));
        }
        finally {
            hfReader.close();
        }
        return historyDataMap;
    }

    @Override
    public void applicationStarted(ApplicationStartData appStart) throws IOException {
        HistoryFileWriter hfWriter = (HistoryFileWriter)this.outstandingWriters.get(appStart.getApplicationId());
        if (hfWriter == null) {
            Path applicationHistoryFile = new Path(this.rootDirPath, appStart.getApplicationId().toString());
            try {
                hfWriter = new HistoryFileWriter(applicationHistoryFile);
                LOG.info((Object)("Opened history file of application " + appStart.getApplicationId()));
            }
            catch (IOException e) {
                LOG.error((Object)("Error when openning history file of application " + appStart.getApplicationId()), (Throwable)e);
                throw e;
            }
        } else {
            throw new IOException("History file of application " + appStart.getApplicationId() + " is already opened");
        }
        this.outstandingWriters.put(appStart.getApplicationId(), hfWriter);
        assert (appStart instanceof ApplicationStartDataPBImpl);
        try {
            hfWriter.writeHistoryData(new HistoryDataKey(appStart.getApplicationId().toString(), START_DATA_SUFFIX), ((ApplicationStartDataPBImpl)appStart).getProto().toByteArray());
            LOG.info((Object)("Start information of application " + appStart.getApplicationId() + " is written"));
        }
        catch (IOException e) {
            LOG.error((Object)("Error when writing start information of application " + appStart.getApplicationId()), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void applicationFinished(ApplicationFinishData appFinish) throws IOException {
        HistoryFileWriter hfWriter = this.getHistoryFileWriter(appFinish.getApplicationId());
        assert (appFinish instanceof ApplicationFinishDataPBImpl);
        try {
            hfWriter.writeHistoryData(new HistoryDataKey(appFinish.getApplicationId().toString(), FINISH_DATA_SUFFIX), ((ApplicationFinishDataPBImpl)appFinish).getProto().toByteArray());
            LOG.info((Object)("Finish information of application " + appFinish.getApplicationId() + " is written"));
        }
        catch (IOException e) {
            LOG.error((Object)("Error when writing finish information of application " + appFinish.getApplicationId()), (Throwable)e);
            throw e;
        }
        finally {
            hfWriter.close();
            this.outstandingWriters.remove(appFinish.getApplicationId());
        }
    }

    @Override
    public void applicationAttemptStarted(ApplicationAttemptStartData appAttemptStart) throws IOException {
        HistoryFileWriter hfWriter = this.getHistoryFileWriter(appAttemptStart.getApplicationAttemptId().getApplicationId());
        assert (appAttemptStart instanceof ApplicationAttemptStartDataPBImpl);
        try {
            hfWriter.writeHistoryData(new HistoryDataKey(appAttemptStart.getApplicationAttemptId().toString(), START_DATA_SUFFIX), ((ApplicationAttemptStartDataPBImpl)appAttemptStart).getProto().toByteArray());
            LOG.info((Object)("Start information of application attempt " + appAttemptStart.getApplicationAttemptId() + " is written"));
        }
        catch (IOException e) {
            LOG.error((Object)("Error when writing start information of application attempt " + appAttemptStart.getApplicationAttemptId()), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void applicationAttemptFinished(ApplicationAttemptFinishData appAttemptFinish) throws IOException {
        HistoryFileWriter hfWriter = this.getHistoryFileWriter(appAttemptFinish.getApplicationAttemptId().getApplicationId());
        assert (appAttemptFinish instanceof ApplicationAttemptFinishDataPBImpl);
        try {
            hfWriter.writeHistoryData(new HistoryDataKey(appAttemptFinish.getApplicationAttemptId().toString(), FINISH_DATA_SUFFIX), ((ApplicationAttemptFinishDataPBImpl)appAttemptFinish).getProto().toByteArray());
            LOG.info((Object)("Finish information of application attempt " + appAttemptFinish.getApplicationAttemptId() + " is written"));
        }
        catch (IOException e) {
            LOG.error((Object)("Error when writing finish information of application attempt " + appAttemptFinish.getApplicationAttemptId()), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void containerStarted(ContainerStartData containerStart) throws IOException {
        HistoryFileWriter hfWriter = this.getHistoryFileWriter(containerStart.getContainerId().getApplicationAttemptId().getApplicationId());
        assert (containerStart instanceof ContainerStartDataPBImpl);
        try {
            hfWriter.writeHistoryData(new HistoryDataKey(containerStart.getContainerId().toString(), START_DATA_SUFFIX), ((ContainerStartDataPBImpl)containerStart).getProto().toByteArray());
            LOG.info((Object)("Start information of container " + containerStart.getContainerId() + " is written"));
        }
        catch (IOException e) {
            LOG.error((Object)("Error when writing start information of container " + containerStart.getContainerId()), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void containerFinished(ContainerFinishData containerFinish) throws IOException {
        HistoryFileWriter hfWriter = this.getHistoryFileWriter(containerFinish.getContainerId().getApplicationAttemptId().getApplicationId());
        assert (containerFinish instanceof ContainerFinishDataPBImpl);
        try {
            hfWriter.writeHistoryData(new HistoryDataKey(containerFinish.getContainerId().toString(), FINISH_DATA_SUFFIX), ((ContainerFinishDataPBImpl)containerFinish).getProto().toByteArray());
            LOG.info((Object)("Finish information of container " + containerFinish.getContainerId() + " is written"));
        }
        catch (IOException e) {
            LOG.error((Object)("Error when writing finish information of container " + containerFinish.getContainerId()), (Throwable)e);
        }
    }

    private static ApplicationStartData parseApplicationStartData(byte[] value) throws InvalidProtocolBufferException {
        return new ApplicationStartDataPBImpl(ApplicationHistoryServerProtos.ApplicationStartDataProto.parseFrom((byte[])value));
    }

    private static ApplicationFinishData parseApplicationFinishData(byte[] value) throws InvalidProtocolBufferException {
        return new ApplicationFinishDataPBImpl(ApplicationHistoryServerProtos.ApplicationFinishDataProto.parseFrom((byte[])value));
    }

    private static ApplicationAttemptStartData parseApplicationAttemptStartData(byte[] value) throws InvalidProtocolBufferException {
        return new ApplicationAttemptStartDataPBImpl(ApplicationHistoryServerProtos.ApplicationAttemptStartDataProto.parseFrom((byte[])value));
    }

    private static ApplicationAttemptFinishData parseApplicationAttemptFinishData(byte[] value) throws InvalidProtocolBufferException {
        return new ApplicationAttemptFinishDataPBImpl(ApplicationHistoryServerProtos.ApplicationAttemptFinishDataProto.parseFrom((byte[])value));
    }

    private static ContainerStartData parseContainerStartData(byte[] value) throws InvalidProtocolBufferException {
        return new ContainerStartDataPBImpl(ApplicationHistoryServerProtos.ContainerStartDataProto.parseFrom((byte[])value));
    }

    private static ContainerFinishData parseContainerFinishData(byte[] value) throws InvalidProtocolBufferException {
        return new ContainerFinishDataPBImpl(ApplicationHistoryServerProtos.ContainerFinishDataProto.parseFrom((byte[])value));
    }

    private static void mergeApplicationHistoryData(ApplicationHistoryData historyData, ApplicationStartData startData) {
        historyData.setApplicationName(startData.getApplicationName());
        historyData.setApplicationType(startData.getApplicationType());
        historyData.setQueue(startData.getQueue());
        historyData.setUser(startData.getUser());
        historyData.setSubmitTime(startData.getSubmitTime());
        historyData.setStartTime(startData.getStartTime());
    }

    private static void mergeApplicationHistoryData(ApplicationHistoryData historyData, ApplicationFinishData finishData) {
        historyData.setFinishTime(finishData.getFinishTime());
        historyData.setDiagnosticsInfo(finishData.getDiagnosticsInfo());
        historyData.setFinalApplicationStatus(finishData.getFinalApplicationStatus());
        historyData.setYarnApplicationState(finishData.getYarnApplicationState());
    }

    private static void mergeApplicationAttemptHistoryData(ApplicationAttemptHistoryData historyData, ApplicationAttemptStartData startData) {
        historyData.setHost(startData.getHost());
        historyData.setRPCPort(startData.getRPCPort());
        historyData.setMasterContainerId(startData.getMasterContainerId());
    }

    private static void mergeApplicationAttemptHistoryData(ApplicationAttemptHistoryData historyData, ApplicationAttemptFinishData finishData) {
        historyData.setDiagnosticsInfo(finishData.getDiagnosticsInfo());
        historyData.setTrackingURL(finishData.getTrackingURL());
        historyData.setFinalApplicationStatus(finishData.getFinalApplicationStatus());
        historyData.setYarnApplicationAttemptState(finishData.getYarnApplicationAttemptState());
    }

    private static void mergeContainerHistoryData(ContainerHistoryData historyData, ContainerStartData startData) {
        historyData.setAllocatedResource(startData.getAllocatedResource());
        historyData.setAssignedNode(startData.getAssignedNode());
        historyData.setPriority(startData.getPriority());
        historyData.setStartTime(startData.getStartTime());
    }

    private static void mergeContainerHistoryData(ContainerHistoryData historyData, ContainerFinishData finishData) {
        historyData.setFinishTime(finishData.getFinishTime());
        historyData.setDiagnosticsInfo(finishData.getDiagnosticsInfo());
        historyData.setContainerExitStatus(finishData.getContainerExitStatus());
        historyData.setContainerState(finishData.getContainerState());
    }

    private HistoryFileWriter getHistoryFileWriter(ApplicationId appId) throws IOException {
        HistoryFileWriter hfWriter = (HistoryFileWriter)this.outstandingWriters.get(appId);
        if (hfWriter == null) {
            throw new IOException("History file of application " + appId + " is not opened");
        }
        return hfWriter;
    }

    private HistoryFileReader getHistoryFileReader(ApplicationId appId) throws IOException {
        Path applicationHistoryFile = new Path(this.rootDirPath, appId.toString());
        if (!this.fs.exists(applicationHistoryFile)) {
            throw new IOException("History file for application " + appId + " is not found");
        }
        if (this.outstandingWriters.containsKey(appId)) {
            throw new IOException("History file for application " + appId + " is under writing");
        }
        return new HistoryFileReader(applicationHistoryFile);
    }

    private static class HistoryDataKey
    implements Writable {
        private String id;
        private String suffix;

        public HistoryDataKey() {
            this(null, null);
        }

        public HistoryDataKey(String id, String suffix) {
            this.id = id;
            this.suffix = suffix;
        }

        public void write(DataOutput out) throws IOException {
            out.writeUTF(this.id);
            out.writeUTF(this.suffix);
        }

        public void readFields(DataInput in) throws IOException {
            this.id = in.readUTF();
            this.suffix = in.readUTF();
        }
    }

    private class HistoryFileWriter {
        private FSDataOutputStream fsdos;
        private TFile.Writer writer;

        public HistoryFileWriter(Path historyFile) throws IOException {
            this.fsdos = FileSystemApplicationHistoryStore.this.fs.exists(historyFile) ? FileSystemApplicationHistoryStore.this.fs.append(historyFile) : FileSystemApplicationHistoryStore.this.fs.create(historyFile);
            try {
                FileSystemApplicationHistoryStore.this.fs.setPermission(historyFile, HISTORY_FILE_UMASK);
                this.writer = new TFile.Writer(this.fsdos, 262144, FileSystemApplicationHistoryStore.this.getConfig().get("yarn.timeline-service.generic-application-history.fs-history-store.compression-type", "none"), null, FileSystemApplicationHistoryStore.this.getConfig());
            }
            catch (IOException e) {
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.fsdos});
                throw e;
            }
        }

        public synchronized void close() {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.writer, this.fsdos});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void writeHistoryData(HistoryDataKey key, byte[] value) throws IOException {
            DataOutputStream dos = null;
            try {
                dos = this.writer.prepareAppendKey(-1);
                key.write(dos);
            }
            catch (Throwable throwable) {
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{dos});
                throw throwable;
            }
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{dos});
            try {
                dos = this.writer.prepareAppendValue(value.length);
                dos.write(value);
            }
            catch (Throwable throwable) {
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{dos});
                throw throwable;
            }
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{dos});
        }
    }

    private class HistoryFileReader {
        private TFile.Reader reader;
        private TFile.Reader.Scanner scanner;
        FSDataInputStream fsdis;

        public HistoryFileReader(Path historyFile) throws IOException {
            this.fsdis = FileSystemApplicationHistoryStore.this.fs.open(historyFile);
            this.reader = new TFile.Reader(this.fsdis, FileSystemApplicationHistoryStore.this.fs.getFileStatus(historyFile).getLen(), FileSystemApplicationHistoryStore.this.getConfig());
            this.reset();
        }

        public boolean hasNext() {
            return !this.scanner.atEnd();
        }

        public Entry next() throws IOException {
            TFile.Reader.Scanner.Entry entry = this.scanner.entry();
            DataInputStream dis = entry.getKeyStream();
            HistoryDataKey key = new HistoryDataKey();
            key.readFields(dis);
            dis = entry.getValueStream();
            byte[] value = new byte[entry.getValueLength()];
            dis.read(value);
            this.scanner.advance();
            return new Entry(key, value);
        }

        public void reset() throws IOException {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.scanner});
            this.scanner = this.reader.createScanner();
        }

        public void close() {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.scanner, this.reader, this.fsdis});
        }

        private class Entry {
            private HistoryDataKey key;
            private byte[] value;

            public Entry(HistoryDataKey key, byte[] value) {
                this.key = key;
                this.value = value;
            }
        }
    }
}

