/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.security.HttpCrossOriginFilterInitializer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.JvmPauseMonitor;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryClientService;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManager;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManagerImpl;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManagerOnTimelineStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.NullApplicationHistoryStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.AHSWebApp;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.timeline.LeveldbTimelineStore;
import org.apache.hadoop.yarn.server.timeline.TimelineDataManager;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.security.TimelineACLsManager;
import org.apache.hadoop.yarn.server.timeline.security.TimelineAuthenticationFilter;
import org.apache.hadoop.yarn.server.timeline.security.TimelineAuthenticationFilterInitializer;
import org.apache.hadoop.yarn.server.timeline.security.TimelineDelegationTokenSecretManagerService;
import org.apache.hadoop.yarn.server.timeline.webapp.CrossOriginFilterInitializer;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.webapp.WebAppContext;

public class ApplicationHistoryServer
extends CompositeService {
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private static final Log LOG = LogFactory.getLog(ApplicationHistoryServer.class);
    private ApplicationHistoryClientService ahsClientService;
    private ApplicationACLsManager aclsManager;
    private ApplicationHistoryManager historyManager;
    private TimelineStore timelineStore;
    private TimelineDelegationTokenSecretManagerService secretManagerService;
    private TimelineDataManager timelineDataManager;
    private WebApp webApp;
    private JvmPauseMonitor pauseMonitor;

    public ApplicationHistoryServer() {
        super(ApplicationHistoryServer.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        try {
            this.doSecureLogin(conf);
        }
        catch (IOException ie) {
            throw new YarnRuntimeException("Failed to login", (Throwable)ie);
        }
        this.timelineStore = this.createTimelineStore(conf);
        this.addIfService(this.timelineStore);
        this.secretManagerService = this.createTimelineDelegationTokenSecretManagerService(conf);
        this.addService((Service)this.secretManagerService);
        this.timelineDataManager = this.createTimelineDataManager(conf);
        this.addService((Service)this.timelineDataManager);
        this.aclsManager = this.createApplicationACLsManager(conf);
        this.historyManager = this.createApplicationHistoryManager(conf);
        this.ahsClientService = this.createApplicationHistoryClientService(this.historyManager);
        this.addService((Service)this.ahsClientService);
        this.addService((Service)this.historyManager);
        DefaultMetricsSystem.initialize((String)"ApplicationHistoryServer");
        JvmMetrics jm = JvmMetrics.initSingleton((String)"ApplicationHistoryServer", null);
        this.pauseMonitor = new JvmPauseMonitor();
        this.addService((Service)this.pauseMonitor);
        jm.setPauseMonitor(this.pauseMonitor);
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        this.startWebApp();
    }

    protected void serviceStop() throws Exception {
        if (this.webApp != null) {
            this.webApp.stop();
        }
        DefaultMetricsSystem.shutdown();
        super.serviceStop();
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    ApplicationHistoryClientService getClientService() {
        return this.ahsClientService;
    }

    private InetSocketAddress getListenerAddress() {
        return this.webApp.httpServer().getConnectorAddress(0);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public int getPort() {
        return this.getListenerAddress().getPort();
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public TimelineStore getTimelineStore() {
        return this.timelineStore;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    ApplicationHistoryManager getApplicationHistoryManager() {
        return this.historyManager;
    }

    static ApplicationHistoryServer launchAppHistoryServer(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
        org.apache.hadoop.util.StringUtils.startupShutdownMessage(ApplicationHistoryServer.class, (String[])args, (Log)LOG);
        ApplicationHistoryServer appHistoryServer = null;
        try {
            appHistoryServer = new ApplicationHistoryServer();
            ShutdownHookManager.get().addShutdownHook((Runnable)new CompositeService.CompositeServiceShutdownHook((CompositeService)appHistoryServer), 30);
            YarnConfiguration conf = new YarnConfiguration();
            new GenericOptionsParser((Configuration)conf, args);
            appHistoryServer.init((Configuration)conf);
            appHistoryServer.start();
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error starting ApplicationHistoryServer", t);
            ExitUtil.terminate((int)-1, (String)"Error starting ApplicationHistoryServer");
        }
        return appHistoryServer;
    }

    public static void main(String[] args) {
        ApplicationHistoryServer.launchAppHistoryServer(args);
    }

    private ApplicationHistoryClientService createApplicationHistoryClientService(ApplicationHistoryManager historyManager) {
        return new ApplicationHistoryClientService(historyManager);
    }

    private ApplicationACLsManager createApplicationACLsManager(Configuration conf) {
        return new ApplicationACLsManager(conf);
    }

    private ApplicationHistoryManager createApplicationHistoryManager(Configuration conf) {
        if (conf.get("yarn.timeline-service.generic-application-history.store-class") == null || conf.get("yarn.timeline-service.generic-application-history.store-class").length() == 0 || conf.get("yarn.timeline-service.generic-application-history.store-class").equals(NullApplicationHistoryStore.class.getName())) {
            return new ApplicationHistoryManagerOnTimelineStore(this.timelineDataManager, this.aclsManager);
        }
        LOG.warn((Object)"The filesystem based application history store is deprecated.");
        return new ApplicationHistoryManagerImpl();
    }

    private TimelineStore createTimelineStore(Configuration conf) {
        return (TimelineStore)ReflectionUtils.newInstance((Class)conf.getClass("yarn.timeline-service.store-class", LeveldbTimelineStore.class, TimelineStore.class), (Configuration)conf);
    }

    private TimelineDelegationTokenSecretManagerService createTimelineDelegationTokenSecretManagerService(Configuration conf) {
        return new TimelineDelegationTokenSecretManagerService();
    }

    private TimelineDataManager createTimelineDataManager(Configuration conf) {
        TimelineACLsManager aclsMgr = new TimelineACLsManager(conf);
        aclsMgr.setTimelineStore(this.timelineStore);
        return new TimelineDataManager(this.timelineStore, aclsMgr);
    }

    private void startWebApp() {
        Configuration conf = this.getConfig();
        TimelineAuthenticationFilter.setTimelineDelegationTokenSecretManager(this.secretManagerService.getTimelineDelegationTokenSecretManager());
        String initializers = conf.get("hadoop.http.filter.initializers");
        boolean modifiedInitializers = false;
        String string = initializers = initializers == null || initializers.length() == 0 ? "" : initializers;
        if (!initializers.contains(CrossOriginFilterInitializer.class.getName()) && conf.getBoolean("yarn.timeline-service.http-cross-origin.enabled", false)) {
            if (initializers.contains(HttpCrossOriginFilterInitializer.class.getName())) {
                initializers = initializers.replaceAll(HttpCrossOriginFilterInitializer.class.getName(), CrossOriginFilterInitializer.class.getName());
            } else {
                if (initializers.length() != 0) {
                    initializers = initializers + ",";
                }
                initializers = initializers + CrossOriginFilterInitializer.class.getName();
            }
            modifiedInitializers = true;
        }
        if (!initializers.contains(TimelineAuthenticationFilterInitializer.class.getName())) {
            if (initializers.length() != 0) {
                initializers = initializers + ",";
            }
            initializers = initializers + TimelineAuthenticationFilterInitializer.class.getName();
            modifiedInitializers = true;
        }
        String[] parts = initializers.split(",");
        ArrayList<String> target = new ArrayList<String>();
        for (String filterInitializer : parts) {
            if ((filterInitializer = filterInitializer.trim()).equals(AuthenticationFilterInitializer.class.getName())) {
                modifiedInitializers = true;
                continue;
            }
            target.add(filterInitializer);
        }
        String actualInitializers = StringUtils.join(target, (String)",");
        if (modifiedInitializers) {
            conf.set("hadoop.http.filter.initializers", actualInitializers);
        }
        String bindAddress = WebAppUtils.getWebAppBindURL((Configuration)conf, (String)"yarn.timeline-service.bind-host", (String)WebAppUtils.getAHSWebAppURLWithoutScheme((Configuration)conf));
        try {
            AHSWebApp ahsWebApp = new AHSWebApp(this.timelineDataManager, this.ahsClientService);
            this.webApp = WebApps.$for((String)"applicationhistory", ApplicationHistoryClientService.class, (Object)((Object)this.ahsClientService), (String)"ws").with(conf).withAttribute("yarn.timeline-service.webapp.address", (Object)conf.get("yarn.timeline-service.webapp.address")).withCSRFProtection("yarn.timeline-service.webapp.rest-csrf.").withXFSProtection("yarn.timeline-service.webapp.xfs-filter.").at(bindAddress).build((WebApp)ahsWebApp);
            HttpServer2 httpServer = this.webApp.httpServer();
            String[] names = conf.getTrimmedStrings("yarn.timeline-service.ui-names");
            WebAppContext webAppContext = httpServer.getWebAppContext();
            for (String name : names) {
                FilterHolder[] filterHolders;
                String webPath = conf.get("yarn.timeline-service.ui-web-path." + name);
                String onDiskPath = conf.get("yarn.timeline-service.ui-on-disk-path." + name);
                WebAppContext uiWebAppContext = new WebAppContext();
                uiWebAppContext.setContextPath(webPath);
                uiWebAppContext.setWar(onDiskPath);
                String[] ALL_URLS = new String[]{"/*"};
                for (FilterHolder filterHolder : filterHolders = webAppContext.getServletHandler().getFilters()) {
                    if ("guice".equals(filterHolder.getName())) continue;
                    HttpServer2.defineFilter((Context)uiWebAppContext, (String)filterHolder.getName(), (String)filterHolder.getClassName(), (Map)filterHolder.getInitParameters(), (String[])ALL_URLS);
                }
                LOG.info((Object)("Hosting " + name + " from " + onDiskPath + " at " + webPath));
                httpServer.addContext((Context)uiWebAppContext, true);
            }
            httpServer.start();
            conf.updateConnectAddr("yarn.timeline-service.bind-host", "yarn.timeline-service.webapp.address", "0.0.0.0:8188", this.getListenerAddress());
            LOG.info((Object)("Instantiating AHSWebApp at " + this.getPort()));
        }
        catch (Exception e) {
            String msg = "AHSWebApp failed to start.";
            LOG.error((Object)msg, (Throwable)e);
            throw new YarnRuntimeException(msg, (Throwable)e);
        }
    }

    private void doSecureLogin(Configuration conf) throws IOException {
        InetSocketAddress socAddr = ApplicationHistoryServer.getBindAddress(conf);
        SecurityUtil.login((Configuration)conf, (String)"yarn.timeline-service.keytab", (String)"yarn.timeline-service.principal", (String)socAddr.getHostName());
    }

    private static InetSocketAddress getBindAddress(Configuration conf) {
        return conf.getSocketAddr("yarn.timeline-service.address", "0.0.0.0:10200", 10200);
    }
}

