/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice.webapp;

import com.google.common.base.Joiner;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.math3.util.Pair;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationBaseProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.timeline.TimelineAbout;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;
import org.apache.hadoop.yarn.server.webapp.WebServices;
import org.apache.hadoop.yarn.server.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.server.webapp.dao.AppAttemptsInfo;
import org.apache.hadoop.yarn.server.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.webapp.dao.AppsInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerLogsInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainersInfo;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;
import org.apache.hadoop.yarn.webapp.BadRequestException;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

@Singleton
@Path(value="/ws/v1/applicationhistory")
public class AHSWebServices
extends WebServices {
    private static final String NM_DOWNLOAD_URI_STR = "/ws/v1/node/containers";
    private static final Joiner JOINER = Joiner.on((String)"");
    private static final Joiner DOT_JOINER = Joiner.on((String)". ");
    private final Configuration conf;

    @Inject
    public AHSWebServices(ApplicationBaseProtocol appBaseProt, Configuration conf) {
        super(appBaseProt);
        this.conf = conf;
    }

    @GET
    @Path(value="/about")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public TimelineAbout about(@Context HttpServletRequest req, @Context HttpServletResponse res) {
        this.init(res);
        return TimelineUtils.createTimelineAbout((String)"Generic History Service API");
    }

    @GET
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppsInfo get(@Context HttpServletRequest req, @Context HttpServletResponse res) {
        return this.getApps(req, res, null, Collections.emptySet(), null, null, null, null, null, null, null, null, Collections.emptySet());
    }

    @GET
    @Path(value="/apps")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppsInfo getApps(@Context HttpServletRequest req, @Context HttpServletResponse res, @QueryParam(value="state") String stateQuery, @QueryParam(value="states") Set<String> statesQuery, @QueryParam(value="finalStatus") String finalStatusQuery, @QueryParam(value="user") String userQuery, @QueryParam(value="queue") String queueQuery, @QueryParam(value="limit") String count, @QueryParam(value="startedTimeBegin") String startedBegin, @QueryParam(value="startedTimeEnd") String startedEnd, @QueryParam(value="finishedTimeBegin") String finishBegin, @QueryParam(value="finishedTimeEnd") String finishEnd, @QueryParam(value="applicationTypes") Set<String> applicationTypes) {
        this.init(res);
        AHSWebServices.validateStates(stateQuery, statesQuery);
        return super.getApps(req, res, stateQuery, statesQuery, finalStatusQuery, userQuery, queueQuery, count, startedBegin, startedEnd, finishBegin, finishEnd, applicationTypes);
    }

    @GET
    @Path(value="/apps/{appid}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppInfo getApp(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId) {
        this.init(res);
        return super.getApp(req, res, appId);
    }

    @GET
    @Path(value="/apps/{appid}/appattempts")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppAttemptsInfo getAppAttempts(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId) {
        this.init(res);
        return super.getAppAttempts(req, res, appId);
    }

    @GET
    @Path(value="/apps/{appid}/appattempts/{appattemptid}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppAttemptInfo getAppAttempt(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId, @PathParam(value="appattemptid") String appAttemptId) {
        this.init(res);
        return super.getAppAttempt(req, res, appId, appAttemptId);
    }

    @GET
    @Path(value="/apps/{appid}/appattempts/{appattemptid}/containers")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public ContainersInfo getContainers(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId, @PathParam(value="appattemptid") String appAttemptId) {
        this.init(res);
        return super.getContainers(req, res, appId, appAttemptId);
    }

    @GET
    @Path(value="/apps/{appid}/appattempts/{appattemptid}/containers/{containerid}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public ContainerInfo getContainer(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId, @PathParam(value="appattemptid") String appAttemptId, @PathParam(value="containerid") String containerId) {
        this.init(res);
        return super.getContainer(req, res, appId, appAttemptId, containerId);
    }

    private static void validateStates(String stateQuery, Set<String> statesQuery) {
        if (stateQuery != null && !stateQuery.isEmpty()) {
            statesQuery.add(stateQuery);
        }
        Set appStates = AHSWebServices.parseQueries(statesQuery, (boolean)true);
        block3: for (String appState : appStates) {
            switch (YarnApplicationState.valueOf((String)StringUtils.toUpperCase((String)appState))) {
                case FINISHED: 
                case FAILED: 
                case KILLED: {
                    continue block3;
                }
            }
            throw new BadRequestException("Invalid application-state " + appState + " specified. It should be a final state");
        }
    }

    @GET
    @Path(value="/containers/{containerid}/logs")
    @Produces(value={"application/json", "application/xml"})
    public Response getContainerLogsInfo(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="containerid") String containerIdStr) {
        ContainerInfo containerInfo;
        AppInfo appInfo;
        ContainerId containerId = null;
        this.init(res);
        try {
            containerId = ContainerId.fromString((String)containerIdStr);
        }
        catch (Exception e) {
            throw new BadRequestException("invalid container id, " + containerIdStr);
        }
        ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
        try {
            appInfo = super.getApp(req, res, appId.toString());
        }
        catch (Exception ex) {
            return this.getContainerLogMeta(appId, null, null, containerIdStr);
        }
        String appOwner = appInfo.getUser();
        try {
            containerInfo = super.getContainer(req, res, appId.toString(), containerId.getApplicationAttemptId().toString(), containerId.toString());
        }
        catch (Exception ex) {
            if (this.isFinishedState(appInfo.getAppState())) {
                return this.getContainerLogMeta(appId, appOwner, null, containerIdStr);
            }
            return this.createBadResponse(Response.Status.INTERNAL_SERVER_ERROR, "Can not get ContainerInfo for the container: " + containerId);
        }
        String nodeId = containerInfo.getNodeId();
        if (this.isRunningState(appInfo.getAppState())) {
            String nodeHttpAddress = containerInfo.getNodeHttpAddress();
            String uri = "/" + containerId.toString() + "/logs";
            String resURI = JOINER.join((Object)nodeHttpAddress, (Object)NM_DOWNLOAD_URI_STR, new Object[]{uri});
            String query = req.getQueryString();
            if (query != null && !query.isEmpty()) {
                resURI = resURI + "?" + query;
            }
            Response.ResponseBuilder response = Response.status((int)307);
            response.header("Location", (Object)resURI);
            return response.build();
        }
        if (this.isFinishedState(appInfo.getAppState())) {
            return this.getContainerLogMeta(appId, appOwner, nodeId, containerIdStr);
        }
        return this.createBadResponse(Response.Status.NOT_FOUND, "The application is not at Running or Finished State.");
    }

    @GET
    @Path(value="/containers/{containerid}/logs/{filename}")
    @Produces(value={"text/plain"})
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public Response getContainerLogFile(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="containerid") String containerIdStr, @PathParam(value="filename") String filename, @QueryParam(value="format") String format, @QueryParam(value="size") String size) {
        return this.getLogs(req, res, containerIdStr, filename, format, size);
    }

    @GET
    @Path(value="/containerlogs/{containerid}/{filename}")
    @Produces(value={"text/plain; charset=utf-8"})
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public Response getLogs(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="containerid") String containerIdStr, @PathParam(value="filename") String filename, @QueryParam(value="format") String format, @QueryParam(value="size") String size) {
        ContainerInfo containerInfo;
        AppInfo appInfo;
        ContainerId containerId;
        this.init(res);
        try {
            containerId = ContainerId.fromString((String)containerIdStr);
        }
        catch (IllegalArgumentException ex) {
            return this.createBadResponse(Response.Status.NOT_FOUND, "Invalid ContainerId: " + containerIdStr);
        }
        long length = this.parseLongParam(size);
        ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
        try {
            appInfo = super.getApp(req, res, appId.toString());
        }
        catch (Exception ex) {
            return this.sendStreamOutputResponse(appId, null, null, containerIdStr, filename, format, length);
        }
        String appOwner = appInfo.getUser();
        try {
            containerInfo = super.getContainer(req, res, appId.toString(), containerId.getApplicationAttemptId().toString(), containerId.toString());
        }
        catch (Exception ex) {
            if (this.isFinishedState(appInfo.getAppState())) {
                return this.sendStreamOutputResponse(appId, appOwner, null, containerIdStr, filename, format, length);
            }
            return this.createBadResponse(Response.Status.INTERNAL_SERVER_ERROR, "Can not get ContainerInfo for the container: " + containerId);
        }
        String nodeId = containerInfo.getNodeId();
        if (this.isRunningState(appInfo.getAppState())) {
            String nodeHttpAddress = containerInfo.getNodeHttpAddress();
            String uri = "/" + containerId.toString() + "/logs/" + filename;
            String resURI = JOINER.join((Object)nodeHttpAddress, (Object)NM_DOWNLOAD_URI_STR, new Object[]{uri});
            String query = req.getQueryString();
            if (query != null && !query.isEmpty()) {
                resURI = resURI + "?" + query;
            }
            Response.ResponseBuilder response = Response.status((int)307);
            response.header("Location", (Object)resURI);
            return response.build();
        }
        if (this.isFinishedState(appInfo.getAppState())) {
            return this.sendStreamOutputResponse(appId, appOwner, nodeId, containerIdStr, filename, format, length);
        }
        return this.createBadResponse(Response.Status.NOT_FOUND, "The application is not at Running or Finished State.");
    }

    private boolean isRunningState(YarnApplicationState appState) {
        return appState == YarnApplicationState.RUNNING;
    }

    private boolean isFinishedState(YarnApplicationState appState) {
        return appState == YarnApplicationState.FINISHED || appState == YarnApplicationState.FAILED || appState == YarnApplicationState.KILLED;
    }

    private Response createBadResponse(Response.Status status, String errMessage) {
        Response response = Response.status((Response.Status)status).entity((Object)DOT_JOINER.join((Object)status.toString(), (Object)errMessage, new Object[0])).build();
        return response;
    }

    private Response sendStreamOutputResponse(ApplicationId appId, String appOwner, String nodeId, String containerIdStr, String fileName, String format, long bytes) {
        String contentType = WebAppUtils.getDefaultLogContentType();
        if (format != null && !format.isEmpty() && (contentType = WebAppUtils.getSupportedLogContentType((String)format)) == null) {
            String errorMessage = "The valid values for the parameter : format are " + WebAppUtils.listSupportedLogContentType();
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).build();
        }
        StreamingOutput stream = null;
        try {
            stream = this.getStreamingOutput(appId, appOwner, nodeId, containerIdStr, fileName, bytes);
        }
        catch (Exception ex) {
            return this.createBadResponse(Response.Status.INTERNAL_SERVER_ERROR, ex.getMessage());
        }
        if (stream == null) {
            return this.createBadResponse(Response.Status.INTERNAL_SERVER_ERROR, "Can not get log for container: " + containerIdStr);
        }
        Response.ResponseBuilder response = Response.ok((Object)stream);
        response.header("Content-Type", (Object)contentType);
        response.header("X-Content-Type-Options", (Object)"nosniff");
        return response.build();
    }

    private StreamingOutput getStreamingOutput(ApplicationId appId, String appOwner, final String nodeId, final String containerIdStr, final String logFile, final long bytes) throws IOException {
        String suffix = LogAggregationUtils.getRemoteNodeLogDirSuffix((Configuration)this.conf);
        org.apache.hadoop.fs.Path remoteRootLogDir = new org.apache.hadoop.fs.Path(this.conf.get("yarn.nodemanager.remote-app-log-dir", "/tmp/logs"));
        org.apache.hadoop.fs.Path qualifiedRemoteRootLogDir = FileContext.getFileContext((Configuration)this.conf).makeQualified(remoteRootLogDir);
        FileContext fc = FileContext.getFileContext((URI)qualifiedRemoteRootLogDir.toUri(), (Configuration)this.conf);
        org.apache.hadoop.fs.Path remoteAppDir = null;
        if (appOwner == null) {
            org.apache.hadoop.fs.Path toMatch = LogAggregationUtils.getRemoteAppLogDir((org.apache.hadoop.fs.Path)remoteRootLogDir, (ApplicationId)appId, (String)"*", (String)suffix);
            FileStatus[] matching = fc.util().globStatus(toMatch);
            if (matching == null || matching.length != 1) {
                return null;
            }
            remoteAppDir = matching[0].getPath();
        } else {
            remoteAppDir = LogAggregationUtils.getRemoteAppLogDir((org.apache.hadoop.fs.Path)remoteRootLogDir, (ApplicationId)appId, (String)appOwner, (String)suffix);
        }
        final RemoteIterator nodeFiles = fc.listStatus(remoteAppDir);
        if (!nodeFiles.hasNext()) {
            return null;
        }
        StreamingOutput stream = new StreamingOutput(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void write(OutputStream os) throws IOException, WebApplicationException {
                DataInputStream valueStream;
                boolean findLogs;
                byte[] buf;
                block19: {
                    buf = new byte[65535];
                    findLogs = false;
                    while (nodeFiles.hasNext()) {
                        AggregatedLogFormat.LogReader reader;
                        block18: {
                            FileStatus thisNodeFile = (FileStatus)nodeFiles.next();
                            String nodeName = thisNodeFile.getPath().getName();
                            if (nodeId != null && !nodeName.contains(LogAggregationUtils.getNodeString((String)nodeId)) || nodeName.endsWith(".tmp")) continue;
                            reader = null;
                            try {
                                reader = new AggregatedLogFormat.LogReader(AHSWebServices.this.conf, thisNodeFile.getPath());
                                AggregatedLogFormat.LogKey key = new AggregatedLogFormat.LogKey();
                                valueStream = reader.next(key);
                                while (valueStream != null && !key.toString().equals(containerIdStr)) {
                                    key = new AggregatedLogFormat.LogKey();
                                    valueStream = reader.next(key);
                                }
                                if (valueStream != null) break block18;
                                if (reader == null) continue;
                            }
                            catch (Throwable throwable) {
                                if (reader != null) {
                                    reader.close();
                                }
                                throw throwable;
                            }
                            reader.close();
                            continue;
                        }
                        try {}
                        catch (EOFException eof) {
                            if (reader == null) continue;
                            reader.close();
                            continue;
                        }
                        break block19;
                    }
                    os.flush();
                    if (!findLogs) {
                        throw new IOException("Can not find logs for container:" + containerIdStr);
                    }
                    return;
                }
                block7: while (true) {
                    int len;
                    int toRead;
                    long pendingRead;
                    long curRead;
                    long skipAfterRead;
                    long totalBytesToRead;
                    byte[] b;
                    StringBuilder sb;
                    String fileType = valueStream.readUTF();
                    String fileLengthStr = valueStream.readUTF();
                    long fileLength = Long.parseLong(fileLengthStr);
                    if (fileType.equalsIgnoreCase(logFile)) {
                        sb = new StringBuilder();
                        sb.append("LogType:");
                        sb.append(fileType + "\n");
                        sb.append("Log Upload Time:");
                        sb.append(Times.format((long)System.currentTimeMillis()) + "\n");
                        sb.append("LogLength:");
                        sb.append(fileLengthStr + "\n");
                        sb.append("Log Contents:\n");
                        b = sb.toString().getBytes(Charset.forName("UTF-8"));
                        os.write(b, 0, b.length);
                        long toSkip = 0L;
                        totalBytesToRead = fileLength;
                        skipAfterRead = 0L;
                        if (bytes < 0L) {
                            long absBytes = Math.abs(bytes);
                            if (absBytes < fileLength) {
                                toSkip = fileLength - absBytes;
                                totalBytesToRead = absBytes;
                            }
                            IOUtils.skipFully((InputStream)valueStream, (long)toSkip);
                        } else if (bytes < fileLength) {
                            totalBytesToRead = bytes;
                            skipAfterRead = fileLength - bytes;
                        }
                        curRead = 0L;
                        pendingRead = totalBytesToRead - curRead;
                        toRead = pendingRead > (long)buf.length ? buf.length : (int)pendingRead;
                        len = valueStream.read(buf, 0, toRead);
                    } else {
                        long totalSkipped = 0L;
                        long currSkipped = 0L;
                        while (true) {
                            if (currSkipped == -1L || totalSkipped >= fileLength) continue block7;
                            currSkipped = valueStream.skip(fileLength - totalSkipped);
                            totalSkipped += currSkipped;
                        }
                    }
                    while (len != -1 && curRead < totalBytesToRead) {
                        os.write(buf, 0, len);
                        pendingRead = totalBytesToRead - (curRead += (long)len);
                        toRead = pendingRead > (long)buf.length ? buf.length : (int)pendingRead;
                        len = valueStream.read(buf, 0, toRead);
                    }
                    IOUtils.skipFully((InputStream)valueStream, (long)skipAfterRead);
                    sb = new StringBuilder();
                    sb.append("\nEnd of LogType:" + fileType + "\n");
                    b = sb.toString().getBytes(Charset.forName("UTF-8"));
                    os.write(b, 0, b.length);
                    findLogs = true;
                }
            }
        };
        return stream;
    }

    private long parseLongParam(String bytes) {
        if (bytes == null || bytes.isEmpty()) {
            return Long.MAX_VALUE;
        }
        return Long.parseLong(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response getContainerLogMeta(ApplicationId appId, String appOwner, String nodeId, String containerIdStr) {
        HashMap<Object, Object> containerLogMeta = new HashMap<Object, Object>();
        try {
            String nodeIdStr;
            String suffix = LogAggregationUtils.getRemoteNodeLogDirSuffix((Configuration)this.conf);
            org.apache.hadoop.fs.Path remoteRootLogDir = new org.apache.hadoop.fs.Path(this.conf.get("yarn.nodemanager.remote-app-log-dir", "/tmp/logs"));
            org.apache.hadoop.fs.Path qualifiedRemoteRootLogDir = FileContext.getFileContext((Configuration)this.conf).makeQualified(remoteRootLogDir);
            FileContext fc = FileContext.getFileContext((URI)qualifiedRemoteRootLogDir.toUri(), (Configuration)this.conf);
            org.apache.hadoop.fs.Path remoteAppDir = null;
            if (appOwner == null) {
                org.apache.hadoop.fs.Path toMatch = LogAggregationUtils.getRemoteAppLogDir((org.apache.hadoop.fs.Path)remoteRootLogDir, (ApplicationId)appId, (String)"*", (String)suffix);
                FileStatus[] matching = fc.util().globStatus(toMatch);
                if (matching == null || matching.length != 1) {
                    return this.createBadResponse(Response.Status.INTERNAL_SERVER_ERROR, "Can not get log meta for container: " + containerIdStr);
                }
                remoteAppDir = matching[0].getPath();
            } else {
                remoteAppDir = LogAggregationUtils.getRemoteAppLogDir((org.apache.hadoop.fs.Path)remoteRootLogDir, (ApplicationId)appId, (String)appOwner, (String)suffix);
            }
            RemoteIterator nodeFiles = fc.listStatus(remoteAppDir);
            if (!nodeFiles.hasNext()) {
                return this.createBadResponse(Response.Status.INTERNAL_SERVER_ERROR, "Can not get log meta for container: " + containerIdStr);
            }
            String string = nodeIdStr = nodeId == null ? null : LogAggregationUtils.getNodeString((String)nodeId);
            block7: while (nodeFiles.hasNext()) {
                FileStatus thisNodeFile = (FileStatus)nodeFiles.next();
                if (nodeIdStr != null && !thisNodeFile.getPath().getName().contains(nodeIdStr) || thisNodeFile.getPath().getName().endsWith(".tmp")) continue;
                try (AggregatedLogFormat.LogReader reader = new AggregatedLogFormat.LogReader(this.conf, thisNodeFile.getPath());){
                    AggregatedLogFormat.LogKey key = new AggregatedLogFormat.LogKey();
                    DataInputStream valueStream = reader.next(key);
                    while (valueStream != null) {
                        if (key.toString().equals(containerIdStr)) {
                            try {
                                while (true) {
                                    Pair logMeta = AggregatedLogFormat.LogReader.readContainerMetaDataAndSkipData((DataInputStream)valueStream, null);
                                    containerLogMeta.put(logMeta.getFirst(), logMeta.getSecond());
                                }
                            }
                            catch (EOFException eof) {
                                continue block7;
                            }
                        }
                        key = new AggregatedLogFormat.LogKey();
                        valueStream = reader.next(key);
                    }
                }
            }
            Response.ResponseBuilder response = Response.ok((Object)new ContainerLogsInfo(containerLogMeta));
            response.header("X-Content-Type-Options", (Object)"nosniff");
            return response.build();
        }
        catch (Exception ex) {
            return this.createBadResponse(Response.Status.INTERNAL_SERVER_ERROR, ex.getMessage());
        }
    }
}

