/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryStoreTestUtils;
import org.apache.hadoop.yarn.server.applicationhistoryservice.FileSystemApplicationHistoryStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationAttemptHistoryData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationHistoryData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ContainerHistoryData;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFileSystemApplicationHistoryStore
extends ApplicationHistoryStoreTestUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)TestFileSystemApplicationHistoryStore.class.getName());
    private FileSystem fs;
    private Path fsWorkingPath;

    @Before
    public void setup() throws Exception {
        this.fs = new RawLocalFileSystem();
        this.initAndStartStore(this.fs);
    }

    private void initAndStartStore(final FileSystem fs) throws IOException, URISyntaxException {
        Configuration conf = new Configuration();
        fs.initialize(new URI("/"), conf);
        this.fsWorkingPath = new Path("target", TestFileSystemApplicationHistoryStore.class.getSimpleName());
        fs.delete(this.fsWorkingPath, true);
        conf.set("yarn.timeline-service.generic-application-history.fs-history-store.uri", this.fsWorkingPath.toString());
        this.store = new FileSystemApplicationHistoryStore(){

            protected FileSystem getFileSystem(Path path, Configuration conf) {
                return fs;
            }
        };
        this.store.init(conf);
        this.store.start();
    }

    @After
    public void tearDown() throws Exception {
        this.store.stop();
        this.fs.delete(this.fsWorkingPath, true);
        this.fs.close();
    }

    @Test
    public void testReadWriteHistoryData() throws IOException {
        LOG.info("Starting testReadWriteHistoryData");
        this.testWriteHistoryData(5);
        this.testReadHistoryData(5);
    }

    private void testWriteHistoryData(int num) throws IOException {
        this.testWriteHistoryData(num, false, false);
    }

    private void testWriteHistoryData(int num, boolean missingContainer, boolean missingApplicationAttempt) throws IOException {
        for (int i = 1; i <= num; ++i) {
            ApplicationId appId = ApplicationId.newInstance((long)0L, (int)i);
            this.writeApplicationStartData(appId);
            for (int j = 1; j <= num; ++j) {
                ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)j);
                this.writeApplicationAttemptStartData(appAttemptId);
                if (missingApplicationAttempt && j == num) continue;
                for (int k = 1; k <= num; ++k) {
                    ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)k);
                    this.writeContainerStartData(containerId);
                    if (missingContainer && k == num) continue;
                    this.writeContainerFinishData(containerId);
                }
                this.writeApplicationAttemptFinishData(appAttemptId);
            }
            this.writeApplicationFinishData(appId);
        }
    }

    private void testReadHistoryData(int num) throws IOException {
        this.testReadHistoryData(num, false, false);
    }

    private void testReadHistoryData(int num, boolean missingContainer, boolean missingApplicationAttempt) throws IOException {
        Assert.assertEquals((long)num, (long)this.store.getAllApplications().size());
        for (int i = 1; i <= num; ++i) {
            ApplicationId appId = ApplicationId.newInstance((long)0L, (int)i);
            ApplicationHistoryData appData = this.store.getApplication(appId);
            Assert.assertNotNull((Object)appData);
            Assert.assertEquals((Object)appId.toString(), (Object)appData.getApplicationName());
            Assert.assertEquals((Object)appId.toString(), (Object)appData.getDiagnosticsInfo());
            Assert.assertEquals((long)num, (long)this.store.getApplicationAttempts(appId).size());
            for (int j = 1; j <= num; ++j) {
                ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)j);
                ApplicationAttemptHistoryData attemptData = this.store.getApplicationAttempt(appAttemptId);
                Assert.assertNotNull((Object)attemptData);
                Assert.assertEquals((Object)appAttemptId.toString(), (Object)attemptData.getHost());
                if (missingApplicationAttempt && j == num) {
                    Assert.assertNull((Object)attemptData.getDiagnosticsInfo());
                    continue;
                }
                Assert.assertEquals((Object)appAttemptId.toString(), (Object)attemptData.getDiagnosticsInfo());
                Assert.assertEquals((long)num, (long)this.store.getContainers(appAttemptId).size());
                for (int k = 1; k <= num; ++k) {
                    ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)k);
                    ContainerHistoryData containerData = this.store.getContainer(containerId);
                    Assert.assertNotNull((Object)containerData);
                    Assert.assertEquals((Object)Priority.newInstance((int)containerId.getId()), (Object)containerData.getPriority());
                    if (missingContainer && k == num) {
                        Assert.assertNull((Object)containerData.getDiagnosticsInfo());
                        continue;
                    }
                    Assert.assertEquals((Object)containerId.toString(), (Object)containerData.getDiagnosticsInfo());
                }
                ContainerHistoryData masterContainer = this.store.getAMContainer(appAttemptId);
                Assert.assertNotNull((Object)masterContainer);
                Assert.assertEquals((Object)ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L), (Object)masterContainer.getContainerId());
            }
        }
    }

    @Test
    public void testWriteAfterApplicationFinish() throws IOException {
        LOG.info("Starting testWriteAfterApplicationFinish");
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        this.writeApplicationStartData(appId);
        this.writeApplicationFinishData(appId);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        try {
            this.writeApplicationAttemptStartData(appAttemptId);
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("is not opened"));
        }
        try {
            this.writeApplicationAttemptFinishData(appAttemptId);
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("is not opened"));
        }
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        try {
            this.writeContainerStartData(containerId);
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("is not opened"));
        }
        try {
            this.writeContainerFinishData(containerId);
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("is not opened"));
        }
    }

    @Test
    public void testMassiveWriteContainerHistoryData() throws IOException {
        LOG.info("Starting testMassiveWriteContainerHistoryData");
        long mb = 0x100000L;
        long usedDiskBefore = this.fs.getContentSummary(this.fsWorkingPath).getLength() / mb;
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        this.writeApplicationStartData(appId);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        for (int i = 1; i <= 100000; ++i) {
            ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)i);
            this.writeContainerStartData(containerId);
            this.writeContainerFinishData(containerId);
        }
        this.writeApplicationFinishData(appId);
        long usedDiskAfter = this.fs.getContentSummary(this.fsWorkingPath).getLength() / mb;
        Assert.assertTrue((usedDiskAfter - usedDiskBefore < 20L ? 1 : 0) != 0);
    }

    @Test
    public void testMissingContainerHistoryData() throws IOException {
        LOG.info("Starting testMissingContainerHistoryData");
        this.testWriteHistoryData(3, true, false);
        this.testReadHistoryData(3, true, false);
    }

    @Test
    public void testMissingApplicationAttemptHistoryData() throws IOException {
        LOG.info("Starting testMissingApplicationAttemptHistoryData");
        this.testWriteHistoryData(3, false, true);
        this.testReadHistoryData(3, false, true);
    }

    @Test
    public void testInitExistingWorkingDirectoryInSafeMode() throws Exception {
        LOG.info("Starting testInitExistingWorkingDirectoryInSafeMode");
        this.tearDown();
        FileSystem fileSystem = (FileSystem)Mockito.spy((Object)new RawLocalFileSystem());
        FileStatus fileStatus = (FileStatus)Mockito.mock(FileStatus.class);
        ((FileStatus)Mockito.doReturn((Object)true).when((Object)fileStatus)).isDirectory();
        ((FileSystem)Mockito.doReturn((Object)fileStatus).when((Object)fileSystem)).getFileStatus((Path)Mockito.any(Path.class));
        try {
            this.initAndStartStore(fileSystem);
        }
        catch (Exception e) {
            Assert.fail((String)("Exception should not be thrown: " + e));
        }
        ((FileStatus)Mockito.verify((Object)fileStatus, (VerificationMode)Mockito.never())).isDirectory();
        ((FileSystem)Mockito.verify((Object)fileSystem, (VerificationMode)Mockito.times((int)1))).mkdirs((Path)Mockito.any(Path.class));
    }

    @Test
    public void testInitNonExistingWorkingDirectoryInSafeMode() throws Exception {
        LOG.info("Starting testInitNonExistingWorkingDirectoryInSafeMode");
        this.tearDown();
        FileSystem fileSystem = (FileSystem)Mockito.spy((Object)new RawLocalFileSystem());
        FileStatus fileStatus = (FileStatus)Mockito.mock(FileStatus.class);
        ((FileStatus)Mockito.doReturn((Object)false).when((Object)fileStatus)).isDirectory();
        ((FileSystem)Mockito.doReturn((Object)fileStatus).when((Object)fileSystem)).getFileStatus((Path)Mockito.any(Path.class));
        ((FileSystem)Mockito.doThrow((Throwable)new IOException()).when((Object)fileSystem)).mkdirs((Path)Mockito.any(Path.class));
        try {
            this.initAndStartStore(fileSystem);
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((FileStatus)Mockito.verify((Object)fileStatus, (VerificationMode)Mockito.never())).isDirectory();
        ((FileSystem)Mockito.verify((Object)fileSystem, (VerificationMode)Mockito.times((int)1))).mkdirs((Path)Mockito.any(Path.class));
    }
}

