/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.yarn.api.ApplicationBaseProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.timeline.TimelineAbout;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.logaggregation.ContainerLogAggregationType;
import org.apache.hadoop.yarn.logaggregation.ContainerLogFileInfo;
import org.apache.hadoop.yarn.logaggregation.TestContainerLogsUtils;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryClientService;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManager;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManagerOnTimelineStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.TestApplicationHistoryManagerOnTimelineStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.AHSWebServices;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.timeline.TimelineDataManager;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.security.TimelineACLsManager;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerLogsInfo;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.GuiceServletConfig;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestAHSWebServices
extends JerseyTestBase {
    private static ApplicationHistoryClientService historyClientService;
    private static AHSWebServices ahsWebservice;
    private static final String[] USERS;
    private static final int MAX_APPS = 6;
    private static Configuration conf;
    private static FileSystem fs;
    private static final String remoteLogRootDir = "target/logs/";
    private static final String rootLogDir = "target/LocalLogs";
    private static final String NM_WEBADDRESS = "test-nm-web-address:9999";
    private static final String NM_ID = "test:1234";
    private int round;

    @BeforeClass
    public static void setupClass() throws Exception {
        conf = new YarnConfiguration();
        TimelineStore store = TestApplicationHistoryManagerOnTimelineStore.createStore(6);
        TimelineACLsManager aclsManager = new TimelineACLsManager(conf);
        aclsManager.setTimelineStore(store);
        TimelineDataManager dataManager = new TimelineDataManager(store, aclsManager);
        conf.setBoolean("yarn.acl.enable", true);
        conf.set("yarn.admin.acl", "foo");
        conf.setBoolean("yarn.log-aggregation-enable", true);
        conf.set("yarn.nodemanager.remote-app-log-dir", remoteLogRootDir);
        dataManager.init(conf);
        ApplicationACLsManager appAclsManager = new ApplicationACLsManager(conf);
        ApplicationHistoryManagerOnTimelineStore historyManager = new ApplicationHistoryManagerOnTimelineStore(dataManager, appAclsManager);
        historyManager.init(conf);
        historyClientService = new ApplicationHistoryClientService((ApplicationHistoryManager)historyManager){

            protected void serviceStart() throws Exception {
            }
        };
        historyClientService.init(conf);
        historyClientService.start();
        ahsWebservice = new AHSWebServices((ApplicationBaseProtocol)historyClientService, conf){

            public String getNMWebAddressFromRM(Configuration configuration, String nodeId) throws ClientHandlerException, UniformInterfaceException, JSONException {
                if (nodeId.equals(TestAHSWebServices.NM_ID)) {
                    return TestAHSWebServices.NM_WEBADDRESS;
                }
                return null;
            }
        };
        fs = FileSystem.get((Configuration)conf);
        GuiceServletConfig.setInjector((Injector)Guice.createInjector((Module[])new Module[]{new WebServletModule()}));
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (historyClientService != null) {
            historyClientService.stop();
        }
        fs.delete(new Path(remoteLogRootDir), true);
        fs.delete(new Path(rootLogDir), true);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> rounds() {
        return Arrays.asList({0}, {1});
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        GuiceServletConfig.setInjector((Injector)Guice.createInjector((Module[])new Module[]{new WebServletModule()}));
    }

    public TestAHSWebServices(int round) {
        super(new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.yarn.server.applicationhistoryservice.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
        this.round = round;
    }

    @Test
    public void testInvalidApp() {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)7);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("apps").path(appId.toString()).queryParam("user.name", USERS[this.round]).accept(new String[]{"application/json"}).get(ClientResponse.class);
        WebServicesTestUtils.assertResponseStatusCode((String)"404 not found expected", (Response.StatusType)ClientResponse.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
    }

    @Test
    public void testInvalidAttempt() {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)7);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("apps").path(appId.toString()).path("appattempts").path(appAttemptId.toString()).queryParam("user.name", USERS[this.round]).accept(new String[]{"application/json"}).get(ClientResponse.class);
        if (this.round == 1) {
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.FORBIDDEN, (Response.StatusType)response.getStatusInfo());
            return;
        }
        WebServicesTestUtils.assertResponseStatusCode((String)"404 not found expected", (Response.StatusType)ClientResponse.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
    }

    @Test
    public void testInvalidContainer() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)7L);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("apps").path(appId.toString()).path("appattempts").path(appAttemptId.toString()).path("containers").path(containerId.toString()).queryParam("user.name", USERS[this.round]).accept(new String[]{"application/json"}).get(ClientResponse.class);
        if (this.round == 1) {
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.FORBIDDEN, (Response.StatusType)response.getStatusInfo());
            return;
        }
        WebServicesTestUtils.assertResponseStatusCode((String)"404 not found expected", (Response.StatusType)ClientResponse.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
    }

    @Test
    public void testInvalidUri() throws JSONException, Exception {
        WebResource r = this.resource();
        String responseStr = "";
        try {
            responseStr = (String)r.path("ws").path("v1").path("applicationhistory").path("bogus").queryParam("user.name", USERS[this.round]).accept(new String[]{"application/json"}).get(String.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
            WebServicesTestUtils.checkStringMatch((String)"error string exists and shouldn't", (String)"", (String)responseStr);
        }
    }

    @Test
    public void testInvalidUri2() throws JSONException, Exception {
        WebResource r = this.resource();
        String responseStr = "";
        try {
            responseStr = (String)r.queryParam("user.name", USERS[this.round]).accept(new String[]{"application/json"}).get(String.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
            WebServicesTestUtils.checkStringMatch((String)"error string exists and shouldn't", (String)"", (String)responseStr);
        }
    }

    @Test
    public void testInvalidAccept() throws JSONException, Exception {
        WebResource r = this.resource();
        String responseStr = "";
        try {
            responseStr = (String)r.path("ws").path("v1").path("applicationhistory").queryParam("user.name", USERS[this.round]).accept(new String[]{"text/plain"}).get(String.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.INTERNAL_SERVER_ERROR, (Response.StatusType)response.getStatusInfo());
            WebServicesTestUtils.checkStringMatch((String)"error string exists and shouldn't", (String)"", (String)responseStr);
        }
    }

    @Test
    public void testAbout() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("about").queryParam("user.name", USERS[this.round]).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        TimelineAbout actualAbout = (TimelineAbout)response.getEntity(TimelineAbout.class);
        TimelineAbout expectedAbout = TimelineUtils.createTimelineAbout((String)"Generic History Service API");
        Assert.assertNotNull((String)"Timeline service about response is null", (Object)actualAbout);
        Assert.assertEquals((Object)expectedAbout.getAbout(), (Object)actualAbout.getAbout());
        Assert.assertEquals((Object)expectedAbout.getTimelineServiceVersion(), (Object)actualAbout.getTimelineServiceVersion());
        Assert.assertEquals((Object)expectedAbout.getTimelineServiceBuildVersion(), (Object)actualAbout.getTimelineServiceBuildVersion());
        Assert.assertEquals((Object)expectedAbout.getTimelineServiceVersionBuiltOn(), (Object)actualAbout.getTimelineServiceVersionBuiltOn());
        Assert.assertEquals((Object)expectedAbout.getHadoopVersion(), (Object)actualAbout.getHadoopVersion());
        Assert.assertEquals((Object)expectedAbout.getHadoopBuildVersion(), (Object)actualAbout.getHadoopBuildVersion());
        Assert.assertEquals((Object)expectedAbout.getHadoopVersionBuiltOn(), (Object)actualAbout.getHadoopVersionBuiltOn());
    }

    @Test
    public void testAppsQuery() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("apps").queryParam("state", YarnApplicationState.FINISHED.toString()).queryParam("user.name", USERS[this.round]).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        JSONArray array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)6L, (long)array.length());
    }

    @Test
    public void testQueueQuery() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("apps").queryParam("queue", "test queue").queryParam("user.name", USERS[this.round]).accept(new String[]{"application/json"}).get(ClientResponse.class);
        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.OK, (Response.StatusType)response.getStatusInfo());
        Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        JSONArray array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)5L, (long)array.length());
    }

    @Test
    public void testSingleApp() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("apps").path(appId.toString()).queryParam("user.name", USERS[this.round]).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject app = json.getJSONObject("app");
        Assert.assertEquals((Object)appId.toString(), (Object)app.getString("appId"));
        Assert.assertEquals((Object)"test app", (Object)app.get("name"));
        Assert.assertEquals((Object)(this.round == 0 ? "test diagnostics info" : ""), (Object)app.get("diagnosticsInfo"));
        Assert.assertEquals((Object)"test queue", (Object)app.get("queue"));
        Assert.assertEquals((Object)"user1", (Object)app.get("user"));
        Assert.assertEquals((Object)"test app type", (Object)app.get("type"));
        Assert.assertEquals((Object)FinalApplicationStatus.UNDEFINED.toString(), (Object)app.get("finalAppStatus"));
        Assert.assertEquals((Object)YarnApplicationState.FINISHED.toString(), (Object)app.get("appState"));
    }

    @Test
    public void testMultipleAttempts() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("apps").path(appId.toString()).path("appattempts").queryParam("user.name", USERS[this.round]).accept(new String[]{"application/json"}).get(ClientResponse.class);
        if (this.round == 1) {
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.FORBIDDEN, (Response.StatusType)response.getStatusInfo());
            return;
        }
        Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject appAttempts = json.getJSONObject("appAttempts");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)appAttempts.length());
        JSONArray array = appAttempts.getJSONArray("appAttempt");
        Assert.assertEquals((String)"incorrect number of elements", (long)6L, (long)array.length());
    }

    @Test
    public void testSingleAttempt() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("apps").path(appId.toString()).path("appattempts").path(appAttemptId.toString()).queryParam("user.name", USERS[this.round]).accept(new String[]{"application/json"}).get(ClientResponse.class);
        if (this.round == 1) {
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.FORBIDDEN, (Response.StatusType)response.getStatusInfo());
            return;
        }
        Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject appAttempt = json.getJSONObject("appAttempt");
        Assert.assertEquals((Object)appAttemptId.toString(), (Object)appAttempt.getString("appAttemptId"));
        Assert.assertEquals((Object)"test host", (Object)appAttempt.getString("host"));
        Assert.assertEquals((Object)"test diagnostics info", (Object)appAttempt.getString("diagnosticsInfo"));
        Assert.assertEquals((Object)"test tracking url", (Object)appAttempt.getString("trackingUrl"));
        Assert.assertEquals((Object)YarnApplicationAttemptState.FINISHED.toString(), (Object)appAttempt.get("appAttemptState"));
    }

    @Test
    public void testMultipleContainers() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("apps").path(appId.toString()).path("appattempts").path(appAttemptId.toString()).path("containers").queryParam("user.name", USERS[this.round]).accept(new String[]{"application/json"}).get(ClientResponse.class);
        if (this.round == 1) {
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.FORBIDDEN, (Response.StatusType)response.getStatusInfo());
            return;
        }
        Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject containers = json.getJSONObject("containers");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)containers.length());
        JSONArray array = containers.getJSONArray("container");
        Assert.assertEquals((String)"incorrect number of elements", (long)6L, (long)array.length());
    }

    @Test
    public void testSingleContainer() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("apps").path(appId.toString()).path("appattempts").path(appAttemptId.toString()).path("containers").path(containerId.toString()).queryParam("user.name", USERS[this.round]).accept(new String[]{"application/json"}).get(ClientResponse.class);
        if (this.round == 1) {
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.FORBIDDEN, (Response.StatusType)response.getStatusInfo());
            return;
        }
        Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject container = json.getJSONObject("container");
        Assert.assertEquals((Object)containerId.toString(), (Object)container.getString("containerId"));
        Assert.assertEquals((Object)"test diagnostics info", (Object)container.getString("diagnosticsInfo"));
        Assert.assertEquals((Object)"-1", (Object)container.getString("allocatedMB"));
        Assert.assertEquals((Object)"-1", (Object)container.getString("allocatedVCores"));
        Assert.assertEquals((Object)NodeId.newInstance((String)"test host", (int)100).toString(), (Object)container.getString("assignedNodeId"));
        Assert.assertEquals((Object)"-1", (Object)container.getString("priority"));
        YarnConfiguration conf = new YarnConfiguration();
        Assert.assertEquals((Object)(WebAppUtils.getHttpSchemePrefix((Configuration)conf) + WebAppUtils.getAHSWebAppURLWithoutScheme((Configuration)conf) + "/applicationhistory/logs/test host:100/container_0_0001_01_000001/container_0_0001_01_000001/user1"), (Object)container.getString("logUrl"));
        Assert.assertEquals((Object)ContainerState.COMPLETE.toString(), (Object)container.getString("containerState"));
    }

    @Test(timeout=10000L)
    public void testContainerLogsForFinishedApps() throws Exception {
        String fileName = "syslog";
        String user = "user1";
        NodeId nodeId = NodeId.newInstance((String)"test host", (int)100);
        NodeId nodeId2 = NodeId.newInstance((String)"host2", (int)1234);
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId1 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        ContainerId containerId100 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)100L);
        TestContainerLogsUtils.createContainerLogFileInRemoteFS((Configuration)conf, (FileSystem)fs, (String)rootLogDir, (ContainerId)containerId1, (NodeId)nodeId, (String)fileName, (String)user, (String)("Hello." + containerId1), (boolean)true);
        TestContainerLogsUtils.createContainerLogFileInRemoteFS((Configuration)conf, (FileSystem)fs, (String)rootLogDir, (ContainerId)containerId100, (NodeId)nodeId2, (String)fileName, (String)user, (String)("Hello." + containerId100), (boolean)false);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("containerlogs").path(containerId1.toString()).path(fileName).queryParam("user.name", user).accept(new String[]{"text/plain"}).get(ClientResponse.class);
        String responseText = (String)response.getEntity(String.class);
        Assert.assertTrue((boolean)responseText.contains("Hello." + containerId1));
        r = this.resource();
        response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("containers").path(containerId1.toString()).path("logs").path(fileName).queryParam("user.name", user).accept(new String[]{"text/plain"}).get(ClientResponse.class);
        responseText = (String)response.getEntity(String.class);
        Assert.assertTrue((boolean)responseText.contains("Hello." + containerId1));
        r = this.resource();
        response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("containerlogs").path(containerId100.toString()).path(fileName).queryParam("user.name", user).accept(new String[]{"text/plain"}).get(ClientResponse.class);
        responseText = (String)response.getEntity(String.class);
        Assert.assertTrue((boolean)responseText.contains("Hello." + containerId100));
        r = this.resource();
        response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("containers").path(containerId100.toString()).path("logs").path(fileName).queryParam("user.name", user).accept(new String[]{"text/plain"}).get(ClientResponse.class);
        responseText = (String)response.getEntity(String.class);
        Assert.assertTrue((boolean)responseText.contains("Hello." + containerId100));
        ApplicationId appId100 = ApplicationId.newInstance((long)0L, (int)100);
        ApplicationAttemptId appAttemptId100 = ApplicationAttemptId.newInstance((ApplicationId)appId100, (int)1);
        ContainerId containerId1ForApp100 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId100, (long)1L);
        TestContainerLogsUtils.createContainerLogFileInRemoteFS((Configuration)conf, (FileSystem)fs, (String)rootLogDir, (ContainerId)containerId1ForApp100, (NodeId)nodeId, (String)fileName, (String)user, (String)("Hello." + containerId1ForApp100), (boolean)true);
        r = this.resource();
        response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("containerlogs").path(containerId1ForApp100.toString()).path(fileName).queryParam("user.name", user).accept(new String[]{"text/plain"}).get(ClientResponse.class);
        responseText = (String)response.getEntity(String.class);
        Assert.assertTrue((boolean)responseText.contains("Hello." + containerId1ForApp100));
        int fullTextSize = responseText.getBytes().length;
        String tailEndSeparator = StringUtils.repeat((String)"*", (int)("End of LogType:syslog".length() + 50)) + "\n\n";
        int tailTextSize = "\nEnd of LogType:syslog\n".getBytes().length + tailEndSeparator.getBytes().length;
        String logMessage = "Hello." + containerId1ForApp100;
        int fileContentSize = logMessage.getBytes().length;
        r = this.resource();
        response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("containerlogs").path(containerId1ForApp100.toString()).path(fileName).queryParam("user.name", user).queryParam("size", "5").accept(new String[]{"text/plain"}).get(ClientResponse.class);
        responseText = (String)response.getEntity(String.class);
        Assert.assertEquals((long)responseText.getBytes().length, (long)(fullTextSize - fileContentSize + 5));
        Assert.assertTrue((fullTextSize >= responseText.getBytes().length ? 1 : 0) != 0);
        Assert.assertEquals((Object)new String(responseText.getBytes(), fullTextSize - fileContentSize - tailTextSize, 5), (Object)new String(logMessage.getBytes(), 0, 5));
        r = this.resource();
        response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("containerlogs").path(containerId1ForApp100.toString()).path(fileName).queryParam("user.name", user).queryParam("size", "-5").accept(new String[]{"text/plain"}).get(ClientResponse.class);
        responseText = (String)response.getEntity(String.class);
        Assert.assertEquals((long)responseText.getBytes().length, (long)(fullTextSize - fileContentSize + 5));
        Assert.assertTrue((fullTextSize >= responseText.getBytes().length ? 1 : 0) != 0);
        Assert.assertEquals((Object)new String(responseText.getBytes(), fullTextSize - fileContentSize - tailTextSize, 5), (Object)new String(logMessage.getBytes(), fileContentSize - 5, 5));
        r = this.resource();
        response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("containerlogs").path(containerId1ForApp100.toString()).path(fileName).queryParam("user.name", user).queryParam("size", "10000").accept(new String[]{"text/plain"}).get(ClientResponse.class);
        responseText = (String)response.getEntity(String.class);
        Assert.assertEquals((long)responseText.getBytes().length, (long)fullTextSize);
        r = this.resource();
        response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("containerlogs").path(containerId1ForApp100.toString()).path(fileName).queryParam("user.name", user).queryParam("size", "-10000").accept(new String[]{"text/plain"}).get(ClientResponse.class);
        responseText = (String)response.getEntity(String.class);
        Assert.assertEquals((long)responseText.getBytes().length, (long)fullTextSize);
    }

    @Test(timeout=10000L)
    public void testContainerLogsForRunningApps() throws Exception {
        String fileName = "syslog";
        String user = "user1";
        ApplicationId appId = ApplicationId.newInstance((long)1234L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId1 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        WebResource r = this.resource();
        URI requestURI = r.path("ws").path("v1").path("applicationhistory").path("containerlogs").path(containerId1.toString()).path(fileName).queryParam("user.name", user).getURI();
        String redirectURL = TestAHSWebServices.getRedirectURL(requestURI.toString());
        Assert.assertTrue((redirectURL != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)redirectURL.contains(NM_ID));
        Assert.assertTrue((boolean)redirectURL.contains("ws/v1/node/containers"));
        Assert.assertTrue((boolean)redirectURL.contains(containerId1.toString()));
        Assert.assertTrue((boolean)redirectURL.contains("/logs/" + fileName));
        Assert.assertTrue((boolean)redirectURL.contains("user.name=" + user));
        requestURI = r.path("ws").path("v1").path("applicationhistory").path("containerlogs").path(containerId1.toString()).path(fileName).queryParam("user.name", user).queryParam("nm.id", NM_ID).getURI();
        redirectURL = TestAHSWebServices.getRedirectURL(requestURI.toString());
        Assert.assertTrue((redirectURL != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)redirectURL.contains(NM_WEBADDRESS));
        Assert.assertTrue((boolean)redirectURL.contains("ws/v1/node/containers"));
        Assert.assertTrue((boolean)redirectURL.contains(containerId1.toString()));
        Assert.assertTrue((boolean)redirectURL.contains("/logs/" + fileName));
        Assert.assertTrue((boolean)redirectURL.contains("user.name=" + user));
        requestURI = r.path("ws").path("v1").path("applicationhistory").path("containers").path(containerId1.toString()).path("logs").path(fileName).queryParam("user.name", user).getURI();
        redirectURL = TestAHSWebServices.getRedirectURL(requestURI.toString());
        Assert.assertTrue((redirectURL != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)redirectURL.contains(NM_ID));
        Assert.assertTrue((boolean)redirectURL.contains("ws/v1/node/containers"));
        Assert.assertTrue((boolean)redirectURL.contains(containerId1.toString()));
        Assert.assertTrue((boolean)redirectURL.contains("/logs/" + fileName));
        Assert.assertTrue((boolean)redirectURL.contains("user.name=" + user));
        requestURI = r.path("ws").path("v1").path("applicationhistory").path("containers").path(containerId1.toString()).path("logs").path(fileName).queryParam("user.name", user).queryParam("nm.id", NM_ID).getURI();
        redirectURL = TestAHSWebServices.getRedirectURL(requestURI.toString());
        Assert.assertTrue((redirectURL != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)redirectURL.contains(NM_WEBADDRESS));
        Assert.assertTrue((boolean)redirectURL.contains("ws/v1/node/containers"));
        Assert.assertTrue((boolean)redirectURL.contains(containerId1.toString()));
        Assert.assertTrue((boolean)redirectURL.contains("/logs/" + fileName));
        Assert.assertTrue((boolean)redirectURL.contains("user.name=" + user));
        ContainerId containerId1000 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1000L);
        String content = "Hello." + containerId1000;
        NodeId nodeId = NodeId.newInstance((String)"test host", (int)100);
        TestContainerLogsUtils.createContainerLogFileInRemoteFS((Configuration)conf, (FileSystem)fs, (String)rootLogDir, (ContainerId)containerId1000, (NodeId)nodeId, (String)fileName, (String)user, (String)content, (boolean)true);
        r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("containerlogs").path(containerId1000.toString()).path(fileName).queryParam("user.name", user).accept(new String[]{"text/plain"}).get(ClientResponse.class);
        String responseText = (String)response.getEntity(String.class);
        Assert.assertTrue((boolean)responseText.contains(content));
        Assert.assertTrue((boolean)responseText.contains("LogAggregationType: " + ContainerLogAggregationType.LOCAL));
        Assert.assertTrue((boolean)responseText.contains(AHSWebServices.getNoRedirectWarning()));
        response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("containerlogs").path(containerId1000.toString()).path(fileName).queryParam("nm.id", "invalid-nm:1234").queryParam("user.name", user).accept(new String[]{"text/plain"}).get(ClientResponse.class);
        responseText = (String)response.getEntity(String.class);
        Assert.assertTrue((boolean)responseText.contains(content));
        Assert.assertTrue((boolean)responseText.contains("LogAggregationType: " + ContainerLogAggregationType.LOCAL));
        Assert.assertTrue((boolean)responseText.contains(AHSWebServices.getNoRedirectWarning()));
        String content1 = "Hello." + containerId1;
        NodeId nodeId1 = NodeId.fromString((String)NM_ID);
        TestContainerLogsUtils.createContainerLogFileInRemoteFS((Configuration)conf, (FileSystem)fs, (String)rootLogDir, (ContainerId)containerId1, (NodeId)nodeId1, (String)fileName, (String)user, (String)content1, (boolean)true);
        response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("containers").path(containerId1.toString()).path("logs").path(fileName).queryParam("user.name", user).queryParam("redirected_from_node", "true").accept(new String[]{"text/plain"}).get(ClientResponse.class);
        responseText = (String)response.getEntity(String.class);
        Assert.assertTrue((boolean)responseText.contains(content1));
        Assert.assertTrue((boolean)responseText.contains("LogAggregationType: " + ContainerLogAggregationType.AGGREGATED));
    }

    @Test(timeout=10000L)
    public void testContainerLogsMetaForRunningApps() throws Exception {
        List logMeta;
        String user = "user1";
        ApplicationId appId = ApplicationId.newInstance((long)1234L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId1 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        WebResource r = this.resource();
        URI requestURI = r.path("ws").path("v1").path("applicationhistory").path("containers").path(containerId1.toString()).path("logs").queryParam("user.name", user).queryParam("nm.id", NM_ID).getURI();
        String redirectURL = TestAHSWebServices.getRedirectURL(requestURI.toString());
        Assert.assertTrue((redirectURL != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)redirectURL.contains(NM_WEBADDRESS));
        Assert.assertTrue((boolean)redirectURL.contains("ws/v1/node/containers"));
        Assert.assertTrue((boolean)redirectURL.contains(containerId1.toString()));
        Assert.assertTrue((boolean)redirectURL.contains("/logs"));
        requestURI = r.path("ws").path("v1").path("applicationhistory").path("containers").path(containerId1.toString()).path("logs").queryParam("user.name", user).getURI();
        redirectURL = TestAHSWebServices.getRedirectURL(requestURI.toString());
        Assert.assertTrue((redirectURL != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)redirectURL.contains(NM_ID));
        Assert.assertTrue((boolean)redirectURL.contains("ws/v1/node/containers"));
        Assert.assertTrue((boolean)redirectURL.contains(containerId1.toString()));
        Assert.assertTrue((boolean)redirectURL.contains("/logs"));
        ContainerId containerId1000 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1000L);
        String fileName = "syslog";
        String content = "Hello." + containerId1000;
        NodeId nodeId = NodeId.newInstance((String)"test host", (int)100);
        TestContainerLogsUtils.createContainerLogFileInRemoteFS((Configuration)conf, (FileSystem)fs, (String)rootLogDir, (ContainerId)containerId1000, (NodeId)nodeId, (String)fileName, (String)user, (String)content, (boolean)true);
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("containers").path(containerId1000.toString()).path("logs").queryParam("user.name", user).accept(new String[]{"application/json"}).get(ClientResponse.class);
        List responseText = (List)response.getEntity((GenericType)new GenericType<List<ContainerLogsInfo>>(){});
        Assert.assertTrue((responseText.size() == 2 ? 1 : 0) != 0);
        for (ContainerLogsInfo logInfo : responseText) {
            if (logInfo.getLogType().equals(ContainerLogAggregationType.AGGREGATED.toString())) {
                logMeta = logInfo.getContainerLogsInfo();
                Assert.assertTrue((logMeta.size() == 1 ? 1 : 0) != 0);
                Assert.assertEquals((Object)((ContainerLogFileInfo)logMeta.get(0)).getFileName(), (Object)fileName);
                Assert.assertEquals((Object)((ContainerLogFileInfo)logMeta.get(0)).getFileSize(), (Object)String.valueOf(content.length()));
                continue;
            }
            Assert.assertEquals((Object)logInfo.getLogType(), (Object)ContainerLogAggregationType.LOCAL.toString());
        }
        response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("containers").path(containerId1000.toString()).path("logs").queryParam("nm.id", "invalid-nm:1234").queryParam("user.name", user).accept(new String[]{"application/json"}).get(ClientResponse.class);
        responseText = (List)response.getEntity((GenericType)new GenericType<List<ContainerLogsInfo>>(){});
        Assert.assertTrue((responseText.size() == 2 ? 1 : 0) != 0);
        for (ContainerLogsInfo logInfo : responseText) {
            if (logInfo.getLogType().equals(ContainerLogAggregationType.AGGREGATED.toString())) {
                logMeta = logInfo.getContainerLogsInfo();
                Assert.assertTrue((logMeta.size() == 1 ? 1 : 0) != 0);
                Assert.assertEquals((Object)((ContainerLogFileInfo)logMeta.get(0)).getFileName(), (Object)fileName);
                Assert.assertEquals((Object)((ContainerLogFileInfo)logMeta.get(0)).getFileSize(), (Object)String.valueOf(content.length()));
                continue;
            }
            Assert.assertEquals((Object)logInfo.getLogType(), (Object)ContainerLogAggregationType.LOCAL.toString());
        }
    }

    @Test(timeout=10000L)
    public void testContainerLogsMetaForFinishedApps() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId1 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        String fileName = "syslog";
        String user = "user1";
        String content = "Hello." + containerId1;
        NodeId nodeId = NodeId.newInstance((String)"test host", (int)100);
        TestContainerLogsUtils.createContainerLogFileInRemoteFS((Configuration)conf, (FileSystem)fs, (String)rootLogDir, (ContainerId)containerId1, (NodeId)nodeId, (String)fileName, (String)user, (String)content, (boolean)true);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("containers").path(containerId1.toString()).path("logs").queryParam("user.name", user).accept(new String[]{"application/json"}).get(ClientResponse.class);
        List responseText = (List)response.getEntity((GenericType)new GenericType<List<ContainerLogsInfo>>(){});
        Assert.assertTrue((responseText.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)((ContainerLogsInfo)responseText.get(0)).getLogType(), (Object)ContainerLogAggregationType.AGGREGATED.toString());
        List logMeta = ((ContainerLogsInfo)responseText.get(0)).getContainerLogsInfo();
        Assert.assertTrue((logMeta.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)((ContainerLogFileInfo)logMeta.get(0)).getFileName(), (Object)fileName);
        Assert.assertEquals((Object)((ContainerLogFileInfo)logMeta.get(0)).getFileSize(), (Object)String.valueOf(content.length()));
    }

    private static String getRedirectURL(String url) {
        String redirectUrl = null;
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setInstanceFollowRedirects(false);
            if (conn.getResponseCode() == 307) {
                redirectUrl = conn.getHeaderField("Location");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return redirectUrl;
    }

    static {
        USERS = new String[]{"foo", "bar"};
    }

    @Singleton
    public static class TestSimpleAuthFilter
    extends AuthenticationFilter {
        protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
            Properties properties = super.getConfiguration(configPrefix, filterConfig);
            properties.put("type", "simple");
            properties.put("simple.anonymous.allowed", "false");
            return properties;
        }
    }

    private static class WebServletModule
    extends ServletModule {
        private WebServletModule() {
        }

        protected void configureServlets() {
            this.bind(JAXBContextResolver.class);
            this.bind(AHSWebServices.class).toInstance((Object)ahsWebservice);
            this.bind(GenericExceptionHandler.class);
            this.bind(ApplicationBaseProtocol.class).toInstance((Object)historyClientService);
            this.serve("/*", new String[0]).with(GuiceContainer.class);
            this.filter("/*", new String[0]).through(TestSimpleAuthFilter.class);
        }
    }
}

