/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.client.RMProxy;
import org.apache.hadoop.yarn.server.api.ResourceTracker;

public class ServerRMProxy<T>
extends RMProxy<T> {
    private static final Log LOG = LogFactory.getLog(ServerRMProxy.class);

    public static <T> T createRMProxy(Configuration conf, Class<T> protocol) throws IOException {
        InetSocketAddress rmAddress = ServerRMProxy.getRMAddress(conf, protocol);
        return (T)ServerRMProxy.createRMProxy((Configuration)conf, protocol, (InetSocketAddress)rmAddress);
    }

    private static InetSocketAddress getRMAddress(Configuration conf, Class<?> protocol) {
        if (protocol == ResourceTracker.class) {
            return conf.getSocketAddr("yarn.resourcemanager.resource-tracker.address", "0.0.0.0:8031", 8031);
        }
        String message = "Unsupported protocol found when creating the proxy connection to ResourceManager: " + (protocol != null ? protocol.getClass().getName() : "null");
        LOG.error((Object)message);
        throw new IllegalStateException(message);
    }
}

