/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server;

import com.google.common.base.Strings;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FailApplicationAttemptRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FailApplicationAttemptResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceTypeInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceTypeInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetLabelsToNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetLabelsToNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewReservationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewReservationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationPriorityRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationPriorityResponse;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationTimeoutsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationTimeoutsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.SignalContainerResponsePBImpl;
import org.apache.hadoop.yarn.api.records.AMCommand;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.exceptions.ApplicationMasterNotRegisteredException;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.InvalidApplicationMasterRequestException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.server.api.ResourceManagerAdministrationProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.AddToClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.AddToClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.CheckForDecommissioningNodesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.CheckForDecommissioningNodesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshAdminAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshAdminAclsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshClusterMaxPriorityRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshClusterMaxPriorityResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesResourcesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesResourcesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshQueuesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshQueuesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshServiceAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshServiceAclsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshSuperUserGroupsConfigurationRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshSuperUserGroupsConfigurationResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshUserToGroupsMappingsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshUserToGroupsMappingsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoveFromClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoveFromClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReplaceLabelsOnNodeRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReplaceLabelsOnNodeResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdateNodeResourceRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdateNodeResourceResponse;
import org.apache.hadoop.yarn.util.Records;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockResourceManagerFacade
implements ApplicationClientProtocol,
ApplicationMasterProtocol,
ResourceManagerAdministrationProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(MockResourceManagerFacade.class);
    private HashSet<ApplicationId> applicationMap = new HashSet();
    private HashMap<String, List<ContainerId>> applicationContainerIdMap = new HashMap();
    private HashMap<ContainerId, Container> allocatedContainerMap = new HashMap();
    private AtomicInteger containerIndex = new AtomicInteger(0);
    private Configuration conf;
    private int subClusterId;
    private final AtomicInteger applicationCounter = new AtomicInteger(0);
    private boolean isRunning;
    private boolean shouldReRegisterNext = false;
    private static Object syncObj = new Object();

    public static Object getSyncObj() {
        return syncObj;
    }

    public MockResourceManagerFacade(Configuration conf, int startContainerIndex) {
        this(conf, startContainerIndex, 0, true);
    }

    public MockResourceManagerFacade(Configuration conf, int startContainerIndex, int subClusterId, boolean isRunning) {
        this.conf = conf;
        this.containerIndex.set(startContainerIndex);
        this.subClusterId = subClusterId;
        this.isRunning = isRunning;
    }

    public void setShouldReRegisterNext() {
        this.shouldReRegisterNext = true;
    }

    public void setRunningMode(boolean mode) {
        this.isRunning = mode;
    }

    private static String getAppIdentifier() throws IOException {
        AMRMTokenIdentifier result = null;
        UserGroupInformation remoteUgi = UserGroupInformation.getCurrentUser();
        Set tokenIds = remoteUgi.getTokenIdentifiers();
        for (TokenIdentifier tokenId : tokenIds) {
            if (!(tokenId instanceof AMRMTokenIdentifier)) continue;
            result = (AMRMTokenIdentifier)tokenId;
            break;
        }
        return result != null ? result.getApplicationAttemptId().toString() : "";
    }

    private void validateRunning() throws ConnectException {
        if (!this.isRunning) {
            throw new ConnectException("RM is stopped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisterApplicationMasterResponse registerApplicationMaster(RegisterApplicationMasterRequest request) throws YarnException, IOException {
        this.validateRunning();
        String amrmToken = MockResourceManagerFacade.getAppIdentifier();
        LOG.info("Registering application attempt: " + amrmToken);
        this.shouldReRegisterNext = false;
        Object object = this.applicationContainerIdMap;
        synchronized (object) {
            if (this.applicationContainerIdMap.containsKey(amrmToken)) {
                throw new InvalidApplicationMasterRequestException("Application Master is already registered : ");
            }
            this.applicationContainerIdMap.put(amrmToken, new ArrayList());
        }
        object = syncObj;
        synchronized (object) {
            syncObj.notifyAll();
            if (request.getRpcPort() > 1000) {
                LOG.info("Register call in RM start waiting");
                try {
                    syncObj.wait();
                    LOG.info("Register call in RM wait finished");
                }
                catch (InterruptedException e) {
                    LOG.info("Register call in RM wait interrupted", (Throwable)e);
                }
            }
        }
        return RegisterApplicationMasterResponse.newInstance(null, null, null, null, null, (String)request.getHost(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FinishApplicationMasterResponse finishApplicationMaster(FinishApplicationMasterRequest request) throws YarnException, IOException {
        this.validateRunning();
        String amrmToken = MockResourceManagerFacade.getAppIdentifier();
        LOG.info("Finishing application attempt: " + amrmToken);
        if (this.shouldReRegisterNext) {
            String message = "AM is not registered, should re-register.";
            LOG.warn(message);
            throw new ApplicationMasterNotRegisteredException(message);
        }
        HashMap<String, List<ContainerId>> hashMap = this.applicationContainerIdMap;
        synchronized (hashMap) {
            Assert.assertTrue((String)("The application id is NOT registered: " + amrmToken), (boolean)this.applicationContainerIdMap.containsKey(amrmToken));
            List<ContainerId> ids = this.applicationContainerIdMap.remove(amrmToken);
            for (ContainerId c : ids) {
                this.allocatedContainerMap.remove(c);
            }
        }
        return FinishApplicationMasterResponse.newInstance((request.getFinalApplicationStatus() == FinalApplicationStatus.SUCCEEDED ? 1 : 0) != 0);
    }

    protected ApplicationId getApplicationId(int id) {
        return ApplicationId.newInstance((long)12345L, (int)id);
    }

    protected ApplicationAttemptId getApplicationAttemptId(int id) {
        return ApplicationAttemptId.newInstance((ApplicationId)this.getApplicationId(id), (int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AllocateResponse allocate(AllocateRequest request) throws YarnException, IOException {
        this.validateRunning();
        if (request.getAskList() != null && request.getAskList().size() > 0 && request.getReleaseList() != null && request.getReleaseList().size() > 0) {
            Assert.fail((String)"The mock RM implementation does not support receiving askList and releaseList in the same heartbeat");
        }
        String amrmToken = MockResourceManagerFacade.getAppIdentifier();
        LOG.info("Allocate from application attempt: " + amrmToken);
        if (this.shouldReRegisterNext) {
            String message = "AM is not registered, should re-register.";
            LOG.warn(message);
            throw new ApplicationMasterNotRegisteredException(message);
        }
        ArrayList<Container> containerList = new ArrayList<Container>();
        if (request.getAskList() != null) {
            for (ResourceRequest rr : request.getAskList()) {
                for (int i = 0; i < rr.getNumContainers(); ++i) {
                    ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)this.getApplicationAttemptId(1), (int)this.containerIndex.incrementAndGet());
                    Container container = (Container)Records.newRecord(Container.class);
                    container.setId(containerId);
                    container.setPriority(rr.getPriority());
                    NodeId nodeId = NodeId.newInstance((String)(!Strings.isNullOrEmpty((String)rr.getResourceName()) ? rr.getResourceName() : "dummy"), (int)1000);
                    container.setNodeId(nodeId);
                    container.setResource(rr.getCapability());
                    containerList.add(container);
                    HashMap<String, List<ContainerId>> hashMap = this.applicationContainerIdMap;
                    synchronized (hashMap) {
                        Assert.assertTrue((String)("The application id is Not registered before allocate(): " + amrmToken), (boolean)this.applicationContainerIdMap.containsKey(amrmToken));
                        List<ContainerId> ids = this.applicationContainerIdMap.get(amrmToken);
                        ids.add(containerId);
                        this.allocatedContainerMap.put(containerId, container);
                        continue;
                    }
                }
            }
        }
        if (request.getReleaseList() != null && request.getReleaseList().size() > 0) {
            LOG.info("Releasing containers: " + request.getReleaseList().size());
            HashMap<String, List<ContainerId>> hashMap = this.applicationContainerIdMap;
            synchronized (hashMap) {
                Assert.assertTrue((String)("The application id is not registered before allocate(): " + amrmToken), (boolean)this.applicationContainerIdMap.containsKey(amrmToken));
                List<ContainerId> ids = this.applicationContainerIdMap.get(amrmToken);
                for (ContainerId id : request.getReleaseList()) {
                    boolean found = false;
                    for (ContainerId c : ids) {
                        if (!c.equals((Object)id)) continue;
                        found = true;
                        break;
                    }
                    Assert.assertTrue((String)("ContainerId " + id + " being released is not valid for application: " + this.conf.get("AMRMTOKEN")), (boolean)found);
                    ids.remove(id);
                    ContainerId fakeContainerId = ContainerId.newInstance((ApplicationAttemptId)this.getApplicationAttemptId(1), (int)this.containerIndex.incrementAndGet());
                    Container fakeContainer = this.allocatedContainerMap.get(id);
                    fakeContainer.setId(fakeContainerId);
                    containerList.add(fakeContainer);
                }
            }
        }
        LOG.info("Allocating containers: " + containerList.size() + " for application attempt: " + this.conf.get("AMRMTOKEN"));
        Token newAMRMToken = Token.newInstance((byte[])new byte[0], (String)"", (byte[])new byte[0], (String)"");
        return AllocateResponse.newInstance((int)0, new ArrayList(), containerList, new ArrayList(), null, (AMCommand)AMCommand.AM_RESYNC, (int)1, null, new ArrayList(), (Token)newAMRMToken, new ArrayList());
    }

    public GetApplicationReportResponse getApplicationReport(GetApplicationReportRequest request) throws YarnException, IOException {
        this.validateRunning();
        GetApplicationReportResponse response = (GetApplicationReportResponse)Records.newRecord(GetApplicationReportResponse.class);
        ApplicationReport report = (ApplicationReport)Records.newRecord(ApplicationReport.class);
        report.setYarnApplicationState(YarnApplicationState.ACCEPTED);
        report.setApplicationId(request.getApplicationId());
        report.setCurrentApplicationAttemptId(ApplicationAttemptId.newInstance((ApplicationId)request.getApplicationId(), (int)1));
        response.setApplicationReport(report);
        return response;
    }

    public GetApplicationAttemptReportResponse getApplicationAttemptReport(GetApplicationAttemptReportRequest request) throws YarnException, IOException {
        this.validateRunning();
        GetApplicationAttemptReportResponse response = (GetApplicationAttemptReportResponse)Records.newRecord(GetApplicationAttemptReportResponse.class);
        ApplicationAttemptReport report = (ApplicationAttemptReport)Records.newRecord(ApplicationAttemptReport.class);
        report.setApplicationAttemptId(request.getApplicationAttemptId());
        report.setYarnApplicationAttemptState(YarnApplicationAttemptState.LAUNCHED);
        response.setApplicationAttemptReport(report);
        return response;
    }

    public GetNewApplicationResponse getNewApplication(GetNewApplicationRequest request) throws YarnException, IOException {
        this.validateRunning();
        return GetNewApplicationResponse.newInstance((ApplicationId)ApplicationId.newInstance((long)this.subClusterId, (int)this.applicationCounter.incrementAndGet()), null, null);
    }

    public SubmitApplicationResponse submitApplication(SubmitApplicationRequest request) throws YarnException, IOException {
        this.validateRunning();
        ApplicationId appId = null;
        if (request.getApplicationSubmissionContext() != null) {
            appId = request.getApplicationSubmissionContext().getApplicationId();
        }
        LOG.info("Application submitted: " + appId);
        this.applicationMap.add(appId);
        return SubmitApplicationResponse.newInstance();
    }

    public KillApplicationResponse forceKillApplication(KillApplicationRequest request) throws YarnException, IOException {
        this.validateRunning();
        ApplicationId appId = null;
        if (request.getApplicationId() != null && !this.applicationMap.remove(appId = request.getApplicationId())) {
            throw new ApplicationNotFoundException("Trying to kill an absent application: " + appId);
        }
        LOG.info("Force killing application: " + appId);
        return KillApplicationResponse.newInstance((boolean)true);
    }

    public GetClusterMetricsResponse getClusterMetrics(GetClusterMetricsRequest request) throws YarnException, IOException {
        this.validateRunning();
        return GetClusterMetricsResponse.newInstance(null);
    }

    public GetApplicationsResponse getApplications(GetApplicationsRequest request) throws YarnException, IOException {
        this.validateRunning();
        return GetApplicationsResponse.newInstance(null);
    }

    public GetClusterNodesResponse getClusterNodes(GetClusterNodesRequest request) throws YarnException, IOException {
        this.validateRunning();
        return GetClusterNodesResponse.newInstance(null);
    }

    public GetQueueInfoResponse getQueueInfo(GetQueueInfoRequest request) throws YarnException, IOException {
        this.validateRunning();
        return GetQueueInfoResponse.newInstance(null);
    }

    public GetQueueUserAclsInfoResponse getQueueUserAcls(GetQueueUserAclsInfoRequest request) throws YarnException, IOException {
        this.validateRunning();
        return GetQueueUserAclsInfoResponse.newInstance(null);
    }

    public GetDelegationTokenResponse getDelegationToken(GetDelegationTokenRequest request) throws YarnException, IOException {
        this.validateRunning();
        return GetDelegationTokenResponse.newInstance(null);
    }

    public RenewDelegationTokenResponse renewDelegationToken(RenewDelegationTokenRequest request) throws YarnException, IOException {
        this.validateRunning();
        return RenewDelegationTokenResponse.newInstance((long)0L);
    }

    public CancelDelegationTokenResponse cancelDelegationToken(CancelDelegationTokenRequest request) throws YarnException, IOException {
        this.validateRunning();
        return CancelDelegationTokenResponse.newInstance();
    }

    public MoveApplicationAcrossQueuesResponse moveApplicationAcrossQueues(MoveApplicationAcrossQueuesRequest request) throws YarnException, IOException {
        this.validateRunning();
        return MoveApplicationAcrossQueuesResponse.newInstance();
    }

    public GetApplicationAttemptsResponse getApplicationAttempts(GetApplicationAttemptsRequest request) throws YarnException, IOException {
        this.validateRunning();
        return GetApplicationAttemptsResponse.newInstance(null);
    }

    public GetContainerReportResponse getContainerReport(GetContainerReportRequest request) throws YarnException, IOException {
        this.validateRunning();
        return GetContainerReportResponse.newInstance(null);
    }

    public GetContainersResponse getContainers(GetContainersRequest request) throws YarnException, IOException {
        this.validateRunning();
        return GetContainersResponse.newInstance(null);
    }

    public ReservationSubmissionResponse submitReservation(ReservationSubmissionRequest request) throws YarnException, IOException {
        this.validateRunning();
        return ReservationSubmissionResponse.newInstance();
    }

    public ReservationListResponse listReservations(ReservationListRequest request) throws YarnException, IOException {
        this.validateRunning();
        return ReservationListResponse.newInstance(new ArrayList());
    }

    public ReservationUpdateResponse updateReservation(ReservationUpdateRequest request) throws YarnException, IOException {
        this.validateRunning();
        return ReservationUpdateResponse.newInstance();
    }

    public ReservationDeleteResponse deleteReservation(ReservationDeleteRequest request) throws YarnException, IOException {
        this.validateRunning();
        return ReservationDeleteResponse.newInstance();
    }

    public GetNodesToLabelsResponse getNodeToLabels(GetNodesToLabelsRequest request) throws YarnException, IOException {
        this.validateRunning();
        return GetNodesToLabelsResponse.newInstance(new HashMap());
    }

    public GetClusterNodeLabelsResponse getClusterNodeLabels(GetClusterNodeLabelsRequest request) throws YarnException, IOException {
        this.validateRunning();
        return GetClusterNodeLabelsResponse.newInstance(new ArrayList());
    }

    public GetLabelsToNodesResponse getLabelsToNodes(GetLabelsToNodesRequest request) throws YarnException, IOException {
        this.validateRunning();
        return GetLabelsToNodesResponse.newInstance(null);
    }

    public GetNewReservationResponse getNewReservation(GetNewReservationRequest request) throws YarnException, IOException {
        this.validateRunning();
        return GetNewReservationResponse.newInstance((ReservationId)ReservationId.newInstance((long)0L, (long)0L));
    }

    public FailApplicationAttemptResponse failApplicationAttempt(FailApplicationAttemptRequest request) throws YarnException, IOException {
        this.validateRunning();
        return FailApplicationAttemptResponse.newInstance();
    }

    public UpdateApplicationPriorityResponse updateApplicationPriority(UpdateApplicationPriorityRequest request) throws YarnException, IOException {
        this.validateRunning();
        return UpdateApplicationPriorityResponse.newInstance(null);
    }

    public SignalContainerResponse signalToContainer(SignalContainerRequest request) throws YarnException, IOException {
        this.validateRunning();
        return new SignalContainerResponsePBImpl();
    }

    public UpdateApplicationTimeoutsResponse updateApplicationTimeouts(UpdateApplicationTimeoutsRequest request) throws YarnException, IOException {
        this.validateRunning();
        return UpdateApplicationTimeoutsResponse.newInstance();
    }

    public RefreshQueuesResponse refreshQueues(RefreshQueuesRequest request) throws StandbyException, YarnException, IOException {
        this.validateRunning();
        return RefreshQueuesResponse.newInstance();
    }

    public RefreshNodesResponse refreshNodes(RefreshNodesRequest request) throws StandbyException, YarnException, IOException {
        this.validateRunning();
        return RefreshNodesResponse.newInstance();
    }

    public RefreshSuperUserGroupsConfigurationResponse refreshSuperUserGroupsConfiguration(RefreshSuperUserGroupsConfigurationRequest request) throws StandbyException, YarnException, IOException {
        this.validateRunning();
        return RefreshSuperUserGroupsConfigurationResponse.newInstance();
    }

    public RefreshUserToGroupsMappingsResponse refreshUserToGroupsMappings(RefreshUserToGroupsMappingsRequest request) throws StandbyException, YarnException, IOException {
        this.validateRunning();
        return RefreshUserToGroupsMappingsResponse.newInstance();
    }

    public RefreshAdminAclsResponse refreshAdminAcls(RefreshAdminAclsRequest request) throws YarnException, IOException {
        this.validateRunning();
        return RefreshAdminAclsResponse.newInstance();
    }

    public RefreshServiceAclsResponse refreshServiceAcls(RefreshServiceAclsRequest request) throws YarnException, IOException {
        this.validateRunning();
        return RefreshServiceAclsResponse.newInstance();
    }

    public UpdateNodeResourceResponse updateNodeResource(UpdateNodeResourceRequest request) throws YarnException, IOException {
        this.validateRunning();
        return UpdateNodeResourceResponse.newInstance();
    }

    public RefreshNodesResourcesResponse refreshNodesResources(RefreshNodesResourcesRequest request) throws YarnException, IOException {
        this.validateRunning();
        return RefreshNodesResourcesResponse.newInstance();
    }

    public AddToClusterNodeLabelsResponse addToClusterNodeLabels(AddToClusterNodeLabelsRequest request) throws YarnException, IOException {
        this.validateRunning();
        return AddToClusterNodeLabelsResponse.newInstance();
    }

    public RemoveFromClusterNodeLabelsResponse removeFromClusterNodeLabels(RemoveFromClusterNodeLabelsRequest request) throws YarnException, IOException {
        this.validateRunning();
        return RemoveFromClusterNodeLabelsResponse.newInstance();
    }

    public ReplaceLabelsOnNodeResponse replaceLabelsOnNode(ReplaceLabelsOnNodeRequest request) throws YarnException, IOException {
        this.validateRunning();
        return ReplaceLabelsOnNodeResponse.newInstance();
    }

    public CheckForDecommissioningNodesResponse checkForDecommissioningNodes(CheckForDecommissioningNodesRequest checkForDecommissioningNodesRequest) throws YarnException, IOException {
        this.validateRunning();
        return CheckForDecommissioningNodesResponse.newInstance(null);
    }

    public RefreshClusterMaxPriorityResponse refreshClusterMaxPriority(RefreshClusterMaxPriorityRequest request) throws YarnException, IOException {
        this.validateRunning();
        return RefreshClusterMaxPriorityResponse.newInstance();
    }

    public String[] getGroupsForUser(String user) throws IOException {
        this.validateRunning();
        return new String[0];
    }

    public GetAllResourceTypeInfoResponse getResourceTypeInfo(GetAllResourceTypeInfoRequest request) throws YarnException, IOException {
        return null;
    }
}

