/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.router;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.ConfigurableFederationPolicy;
import org.apache.hadoop.yarn.server.federation.policies.router.BaseRouterPoliciesTest;
import org.apache.hadoop.yarn.server.federation.policies.router.FederationRouterPolicy;
import org.apache.hadoop.yarn.server.federation.policies.router.HashBasedRouterPolicy;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.utils.FederationPoliciesTestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestHashBasedRouterPolicy
extends BaseRouterPoliciesTest {
    private int numSubclusters = 10;

    @Before
    public void setUp() throws Exception {
        this.setPolicy((ConfigurableFederationPolicy)new HashBasedRouterPolicy());
        this.setMockActiveSubclusters(this.numSubclusters);
        FederationPoliciesTestUtil.initializePolicyContext(this.getPolicy(), this.getPolicyInfo(), this.getActiveSubclusters());
    }

    @Test
    public void testHashSpreadUniformlyAmongSubclusters() throws YarnException {
        HashMap<SubClusterId, AtomicLong> counter = new HashMap<SubClusterId, AtomicLong>();
        for (SubClusterId id : this.getActiveSubclusters().keySet()) {
            counter.put(id, new AtomicLong(0L));
        }
        long jobPerSub = 100L;
        ApplicationSubmissionContext applicationSubmissionContext = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        int i = 0;
        while ((long)i < jobPerSub * (long)this.numSubclusters) {
            Mockito.when((Object)applicationSubmissionContext.getQueue()).thenReturn((Object)("queue" + i));
            SubClusterId chosen = ((FederationRouterPolicy)this.getPolicy()).getHomeSubcluster(applicationSubmissionContext, null);
            ((AtomicLong)counter.get(chosen)).addAndGet(1L);
            ++i;
        }
        for (AtomicLong a : counter.values()) {
            Assert.assertEquals((long)a.get(), (long)jobPerSub);
        }
    }
}

