/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.utils;

import com.zaxxer.hikari.pool.HikariPool;
import javax.cache.integration.CacheLoaderException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.store.exception.FederationStateStoreException;
import org.apache.hadoop.yarn.server.federation.store.exception.FederationStateStoreInvalidInputException;
import org.apache.hadoop.yarn.server.federation.store.exception.FederationStateStoreRetriableException;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFederationStateStoreFacadeRetry {
    private int maxRetries = 4;
    private Configuration conf;

    @Before
    public void setup() {
        this.conf = new Configuration();
        this.conf.setInt("yarn.client.failover-retries", this.maxRetries);
    }

    @Test
    public void testFacadeRetriableException() throws Exception {
        RetryPolicy policy = FederationStateStoreFacade.createRetryPolicy((Configuration)this.conf);
        RetryPolicy.RetryAction action = policy.shouldRetry((Exception)new FederationStateStoreRetriableException(""), 0, 0, false);
        Assert.assertEquals((Object)RetryPolicy.RetryAction.RETRY.action, (Object)action.action);
        action = policy.shouldRetry((Exception)new FederationStateStoreRetriableException(""), this.maxRetries, 0, false);
        Assert.assertEquals((Object)RetryPolicy.RetryAction.FAIL.action, (Object)action.action);
    }

    @Test
    public void testFacadeYarnException() throws Exception {
        RetryPolicy policy = FederationStateStoreFacade.createRetryPolicy((Configuration)this.conf);
        RetryPolicy.RetryAction action = policy.shouldRetry((Exception)((Object)new YarnException()), 0, 0, false);
        Assert.assertEquals((Object)RetryPolicy.RetryAction.FAIL.action, (Object)action.action);
    }

    @Test
    public void testFacadeStateStoreException() throws Exception {
        RetryPolicy policy = FederationStateStoreFacade.createRetryPolicy((Configuration)this.conf);
        RetryPolicy.RetryAction action = policy.shouldRetry((Exception)((Object)new FederationStateStoreException("Error")), 0, 0, false);
        Assert.assertEquals((Object)RetryPolicy.RetryAction.FAIL.action, (Object)action.action);
    }

    @Test
    public void testFacadeInvalidInputException() throws Exception {
        RetryPolicy policy = FederationStateStoreFacade.createRetryPolicy((Configuration)this.conf);
        RetryPolicy.RetryAction action = policy.shouldRetry((Exception)((Object)new FederationStateStoreInvalidInputException("")), 0, 0, false);
        Assert.assertEquals((Object)RetryPolicy.RetryAction.FAIL.action, (Object)action.action);
    }

    @Test
    public void testFacadeCacheRetriableException() throws Exception {
        RetryPolicy policy = FederationStateStoreFacade.createRetryPolicy((Configuration)this.conf);
        RetryPolicy.RetryAction action = policy.shouldRetry((Exception)new CacheLoaderException(""), 0, 0, false);
        Assert.assertEquals((Object)RetryPolicy.RetryAction.RETRY.action, (Object)action.action);
        action = policy.shouldRetry((Exception)new CacheLoaderException(""), this.maxRetries, 0, false);
        Assert.assertEquals((Object)RetryPolicy.RetryAction.FAIL.action, (Object)action.action);
    }

    @Test
    public void testFacadePoolInitRetriableException() throws Exception {
        RetryPolicy policy = FederationStateStoreFacade.createRetryPolicy((Configuration)this.conf);
        RetryPolicy.RetryAction action = policy.shouldRetry((Exception)new HikariPool.PoolInitializationException((Throwable)new YarnException()), 0, 0, false);
        Assert.assertEquals((Object)RetryPolicy.RetryAction.RETRY.action, (Object)action.action);
        action = policy.shouldRetry((Exception)new HikariPool.PoolInitializationException((Throwable)new YarnException()), this.maxRetries, 0, false);
        Assert.assertEquals((Object)RetryPolicy.RetryAction.FAIL.action, (Object)action.action);
    }
}

