/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies;

import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyInitializationContext;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;

public final class FederationPolicyInitializationContextValidator {
    private FederationPolicyInitializationContextValidator() {
    }

    public static void validate(FederationPolicyInitializationContext policyContext, String myType) throws FederationPolicyInitializationException {
        if (myType == null) {
            throw new FederationPolicyInitializationException("The myType parameter should not be null.");
        }
        if (policyContext == null) {
            throw new FederationPolicyInitializationException("The FederationPolicyInitializationContext provided is null. Cannot reinitalize successfully.");
        }
        if (policyContext.getFederationStateStoreFacade() == null) {
            throw new FederationPolicyInitializationException("The FederationStateStoreFacade provided is null. Cannot reinitalize successfully.");
        }
        if (policyContext.getFederationSubclusterResolver() == null) {
            throw new FederationPolicyInitializationException("The FederationSubclusterResolver provided is null. Cannot reinitalize successfully.");
        }
        if (policyContext.getSubClusterPolicyConfiguration() == null) {
            throw new FederationPolicyInitializationException("The SubClusterPolicyConfiguration provided is null. Cannot reinitalize successfully.");
        }
        String intendedType = policyContext.getSubClusterPolicyConfiguration().getType();
        if (!myType.equals(intendedType)) {
            throw new FederationPolicyInitializationException("The FederationPolicyConfiguration carries a type (" + intendedType + ") different then mine (" + myType + "). Cannot reinitialize successfully.");
        }
    }
}

