/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainerLaunch;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainersLauncherEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainersLauncherEventType;
import org.apache.hadoop.yarn.service.AbstractService;

public class ContainersLauncher
extends AbstractService
implements EventHandler<ContainersLauncherEvent> {
    private static final Log LOG = LogFactory.getLog(ContainersLauncher.class);
    private final Context context;
    private final ContainerExecutor exec;
    private final Dispatcher dispatcher;
    private LocalDirsHandlerService dirsHandler;
    private final ExecutorService containerLauncher = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("ContainersLauncher #%d").build());
    private final Map<ContainerId, RunningContainer> running = Collections.synchronizedMap(new HashMap());

    public ContainersLauncher(Context context, Dispatcher dispatcher, ContainerExecutor exec, LocalDirsHandlerService dirsHandler) {
        super("containers-launcher");
        this.exec = exec;
        this.context = context;
        this.dispatcher = dispatcher;
        this.dirsHandler = dirsHandler;
    }

    public void init(Configuration conf) {
        try {
            FileContext.getLocalFSFileContext((Configuration)conf);
        }
        catch (UnsupportedFileSystemException e) {
            throw new YarnException("Failed to start ContainersLauncher", (Throwable)e);
        }
        super.init(conf);
    }

    public void stop() {
        this.containerLauncher.shutdownNow();
        super.stop();
    }

    public void handle(ContainersLauncherEvent event) {
        Container container = event.getContainer();
        ContainerId containerId = container.getContainerID();
        switch ((ContainersLauncherEventType)event.getType()) {
            case LAUNCH_CONTAINER: {
                Application app = (Application)this.context.getApplications().get(containerId.getApplicationAttemptId().getApplicationId());
                ContainerLaunch launch = new ContainerLaunch(this.getConfig(), this.dispatcher, this.exec, app, event.getContainer(), this.dirsHandler);
                this.running.put(containerId, new RunningContainer(this.containerLauncher.submit(launch), launch));
                break;
            }
            case CLEANUP_CONTAINER: {
                RunningContainer rContainerDatum = this.running.remove(containerId);
                if (rContainerDatum == null) {
                    return;
                }
                Future<Integer> rContainer = rContainerDatum.runningcontainer;
                if (rContainer != null && !rContainer.isDone()) {
                    rContainer.cancel(false);
                }
                try {
                    rContainerDatum.launcher.cleanupContainer();
                    break;
                }
                catch (IOException e) {
                    LOG.warn((Object)("Got exception while cleaning container " + containerId + ". Ignoring."));
                }
            }
        }
    }

    private static final class RunningContainer {
        Future<Integer> runningcontainer;
        ContainerLaunch launcher;

        public RunningContainer(Future<Integer> submit, ContainerLaunch launcher) {
            this.runningcontainer = submit;
            this.launcher = launcher;
        }
    }
}

