/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer;

import java.io.File;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.server.nodemanager.DeletionService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.LocalResourceRequest;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.LocalResourcesTracker;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.LocalizedResource;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.ResourceState;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ResourceEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ResourceEventType;

class LocalResourcesTrackerImpl
implements LocalResourcesTracker {
    static final Log LOG = LogFactory.getLog(LocalResourcesTrackerImpl.class);
    private static final String RANDOM_DIR_REGEX = "-?\\d+";
    private static final Pattern RANDOM_DIR_PATTERN = Pattern.compile("-?\\d+");
    private final String user;
    private final Dispatcher dispatcher;
    private final ConcurrentMap<LocalResourceRequest, LocalizedResource> localrsrc;

    public LocalResourcesTrackerImpl(String user, Dispatcher dispatcher) {
        this(user, dispatcher, new ConcurrentHashMap<LocalResourceRequest, LocalizedResource>());
    }

    LocalResourcesTrackerImpl(String user, Dispatcher dispatcher, ConcurrentMap<LocalResourceRequest, LocalizedResource> localrsrc) {
        this.user = user;
        this.dispatcher = dispatcher;
        this.localrsrc = localrsrc;
    }

    public void handle(ResourceEvent event) {
        LocalResourceRequest req = event.getLocalResourceRequest();
        LocalizedResource rsrc = (LocalizedResource)this.localrsrc.get(req);
        switch ((ResourceEventType)event.getType()) {
            case LOCALIZED: {
                break;
            }
            case REQUEST: {
                if (rsrc != null && !this.isResourcePresent(rsrc)) {
                    LOG.info((Object)("Resource " + rsrc.getLocalPath() + " is missing, localizing it again"));
                    this.localrsrc.remove(req);
                    rsrc = null;
                }
                if (null != rsrc) break;
                rsrc = new LocalizedResource(req, this.dispatcher);
                this.localrsrc.put(req, rsrc);
                break;
            }
            case RELEASE: {
                if (null != rsrc) break;
                LOG.info((Object)"Release unknown rsrc null (discard)");
                return;
            }
        }
        rsrc.handle(event);
    }

    public boolean isResourcePresent(LocalizedResource rsrc) {
        File file;
        boolean ret = true;
        if (rsrc.getState() == ResourceState.LOCALIZED && !(file = new File(rsrc.getLocalPath().toUri().getRawPath().toString())).exists()) {
            ret = false;
        }
        return ret;
    }

    @Override
    public boolean contains(LocalResourceRequest resource) {
        return this.localrsrc.containsKey(resource);
    }

    @Override
    public boolean remove(LocalizedResource rem, DeletionService delService) {
        LocalizedResource rsrc = (LocalizedResource)this.localrsrc.get(rem.getRequest());
        if (null == rsrc) {
            LOG.error((Object)("Attempt to remove absent resource: " + rem.getRequest() + " from " + this.getUser()));
            return true;
        }
        if (rsrc.getRefCount() > 0 || ResourceState.DOWNLOADING.equals((Object)rsrc.getState()) || rsrc != rem) {
            LOG.error((Object)("Attempt to remove resource: " + rsrc + " with non-zero refcount"));
            return false;
        }
        this.localrsrc.remove(rem.getRequest());
        if (ResourceState.LOCALIZED.equals((Object)rsrc.getState())) {
            delService.delete(this.getUser(), this.getPathToDelete(rsrc.getLocalPath()), new Path[0]);
        }
        LOG.info((Object)("Removed " + rsrc.getLocalPath() + " from localized cache"));
        return true;
    }

    private Path getPathToDelete(Path localPath) {
        Path delPath = localPath.getParent();
        String name = delPath.getName();
        Matcher matcher = RANDOM_DIR_PATTERN.matcher(name);
        if (matcher.matches()) {
            return delPath;
        }
        LOG.warn((Object)"Random directory component did not match. Deleting localized path only");
        return localPath;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public Iterator<LocalizedResource> iterator() {
        return this.localrsrc.values().iterator();
    }
}

