/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.DeletionService;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.api.LocalizationProtocol;
import org.apache.hadoop.yarn.server.nodemanager.api.protocolrecords.LocalResourceStatus;
import org.apache.hadoop.yarn.server.nodemanager.api.protocolrecords.LocalizerAction;
import org.apache.hadoop.yarn.server.nodemanager.api.protocolrecords.LocalizerHeartbeatResponse;
import org.apache.hadoop.yarn.server.nodemanager.api.protocolrecords.LocalizerStatus;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationInitedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerResourceFailedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.ContainerLocalizer;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.LocalResourceRequest;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.LocalResourcesTracker;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.LocalResourcesTrackerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.LocalizedResource;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.LocalizerContext;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.ResourceRetentionSet;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.ResourceState;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ApplicationLocalizationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ContainerLocalizationCleanupEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ContainerLocalizationRequestEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.LocalizationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.LocalizationEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.LocalizerEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.LocalizerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.LocalizerResourceRequestEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ResourceLocalizedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ResourceReleaseEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ResourceRequestEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.security.LocalizerTokenSecretManager;
import org.apache.hadoop.yarn.server.nodemanager.security.authorize.NMPolicyProvider;
import org.apache.hadoop.yarn.service.AbstractService;
import org.apache.hadoop.yarn.service.CompositeService;
import org.apache.hadoop.yarn.service.Service;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.FSDownload;

public class ResourceLocalizationService
extends CompositeService
implements EventHandler<LocalizationEvent>,
LocalizationProtocol {
    private static final Log LOG = LogFactory.getLog(ResourceLocalizationService.class);
    public static final String NM_PRIVATE_DIR = "nmPrivate";
    public static final FsPermission NM_PRIVATE_PERM = new FsPermission(448);
    private Server server;
    private InetSocketAddress localizationServerAddress;
    private long cacheTargetSize;
    private long cacheCleanupPeriod;
    private final ContainerExecutor exec;
    protected final Dispatcher dispatcher;
    private final DeletionService delService;
    private LocalizerTracker localizerTracker;
    private RecordFactory recordFactory;
    private final ScheduledExecutorService cacheCleanup;
    private final LocalResourcesTracker publicRsrc;
    private LocalDirsHandlerService dirsHandler;
    private final ConcurrentMap<String, LocalResourcesTracker> privateRsrc = new ConcurrentHashMap<String, LocalResourcesTracker>();
    private final ConcurrentMap<String, LocalResourcesTracker> appRsrc = new ConcurrentHashMap<String, LocalResourcesTracker>();

    public ResourceLocalizationService(Dispatcher dispatcher, ContainerExecutor exec, DeletionService delService, LocalDirsHandlerService dirsHandler) {
        super(ResourceLocalizationService.class.getName());
        this.exec = exec;
        this.dispatcher = dispatcher;
        this.delService = delService;
        this.dirsHandler = dirsHandler;
        this.publicRsrc = new LocalResourcesTrackerImpl(null, dispatcher);
        this.cacheCleanup = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNameFormat("ResourceLocalizationService Cache Cleanup").build());
    }

    FileContext getLocalFileContext(Configuration conf) {
        try {
            return FileContext.getLocalFSFileContext((Configuration)conf);
        }
        catch (IOException e) {
            throw new YarnException("Failed to access local fs");
        }
    }

    public void init(Configuration conf) {
        this.recordFactory = RecordFactoryProvider.getRecordFactory((Configuration)conf);
        try {
            FileContext lfs = this.getLocalFileContext(conf);
            lfs.setUMask(new FsPermission(18));
            this.cleanUpLocalDir(lfs, this.delService);
            List<String> localDirs = this.dirsHandler.getLocalDirs();
            for (String localDir : localDirs) {
                Path userDir = new Path(localDir, "usercache");
                lfs.mkdir(userDir, null, true);
                Path fileDir = new Path(localDir, "filecache");
                lfs.mkdir(fileDir, null, true);
                Path sysDir = new Path(localDir, NM_PRIVATE_DIR);
                lfs.mkdir(sysDir, NM_PRIVATE_PERM, true);
            }
            List<String> logDirs = this.dirsHandler.getLogDirs();
            for (String logDir : logDirs) {
                lfs.mkdir(new Path(logDir), null, true);
            }
        }
        catch (IOException e) {
            throw new YarnException("Failed to initialize LocalizationService", (Throwable)e);
        }
        this.cacheTargetSize = conf.getLong("yarn.nodemanager.localizer.cache.target-size-mb", 10240L) << 20;
        this.cacheCleanupPeriod = conf.getLong("yarn.nodemanager.localizer.cache.cleanup.interval-ms", 600000L);
        this.localizationServerAddress = conf.getSocketAddr("yarn.nodemanager.localizer.address", "0.0.0.0:8040", 8040);
        this.localizerTracker = this.createLocalizerTracker(conf);
        this.addService((Service)this.localizerTracker);
        this.dispatcher.register(LocalizerEventType.class, (EventHandler)this.localizerTracker);
        super.init(conf);
    }

    @Override
    public LocalizerHeartbeatResponse heartbeat(LocalizerStatus status) {
        return this.localizerTracker.processHeartbeat(status);
    }

    public void start() {
        this.cacheCleanup.scheduleWithFixedDelay(new CacheCleanup(this.dispatcher), this.cacheCleanupPeriod, this.cacheCleanupPeriod, TimeUnit.MILLISECONDS);
        this.server = this.createServer();
        this.server.start();
        this.localizationServerAddress = this.getConfig().updateConnectAddr("yarn.nodemanager.localizer.address", this.server.getListenerAddress());
        LOG.info((Object)("Localizer started on port " + this.server.getPort()));
        super.start();
    }

    LocalizerTracker createLocalizerTracker(Configuration conf) {
        return new LocalizerTracker(conf);
    }

    Server createServer() {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        LocalizerTokenSecretManager secretManager = null;
        if (UserGroupInformation.isSecurityEnabled()) {
            secretManager = new LocalizerTokenSecretManager();
        }
        Server server = rpc.getServer(LocalizationProtocol.class, (Object)this, this.localizationServerAddress, conf, (SecretManager)secretManager, conf.getInt("yarn.nodemanager.localizer.client.thread-count", 5));
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            server.refreshServiceAcl(conf, (PolicyProvider)new NMPolicyProvider());
        }
        return server;
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
        this.cacheCleanup.shutdown();
        super.stop();
    }

    public void handle(LocalizationEvent event) {
        switch ((LocalizationEventType)event.getType()) {
            case INIT_APPLICATION_RESOURCES: {
                this.handleInitApplicationResources(((ApplicationLocalizationEvent)event).getApplication());
                break;
            }
            case INIT_CONTAINER_RESOURCES: {
                this.handleInitContainerResources((ContainerLocalizationRequestEvent)event);
                break;
            }
            case CACHE_CLEANUP: {
                this.handleCacheCleanup(event);
                break;
            }
            case CLEANUP_CONTAINER_RESOURCES: {
                this.handleCleanupContainerResources((ContainerLocalizationCleanupEvent)event);
                break;
            }
            case DESTROY_APPLICATION_RESOURCES: {
                this.handleDestroyApplicationResources(((ApplicationLocalizationEvent)event).getApplication());
                break;
            }
            default: {
                throw new YarnException("Unknown localization event: " + (Object)((Object)event));
            }
        }
    }

    private void handleInitApplicationResources(Application app) {
        String userName = app.getUser();
        this.privateRsrc.putIfAbsent(userName, new LocalResourcesTrackerImpl(userName, this.dispatcher));
        if (null != this.appRsrc.putIfAbsent(ConverterUtils.toString((ApplicationId)app.getAppId()), new LocalResourcesTrackerImpl(app.getUser(), this.dispatcher))) {
            LOG.warn((Object)("Initializing application " + app + " already present"));
            assert (false);
        }
        this.dispatcher.getEventHandler().handle((Event)new ApplicationInitedEvent(app.getAppId()));
    }

    private void handleInitContainerResources(ContainerLocalizationRequestEvent rsrcReqs) {
        Container c = rsrcReqs.getContainer();
        LocalizerContext ctxt = new LocalizerContext(c.getUser(), c.getContainerID(), c.getCredentials());
        Map<LocalResourceVisibility, Collection<LocalResourceRequest>> rsrcs = rsrcReqs.getRequestedResources();
        for (Map.Entry<LocalResourceVisibility, Collection<LocalResourceRequest>> e : rsrcs.entrySet()) {
            LocalResourcesTracker tracker = this.getLocalResourcesTracker(e.getKey(), c.getUser(), c.getContainerID().getApplicationAttemptId().getApplicationId());
            for (LocalResourceRequest req : e.getValue()) {
                tracker.handle((Event)new ResourceRequestEvent(req, e.getKey(), ctxt));
            }
        }
    }

    private void handleCacheCleanup(LocalizationEvent event) {
        ResourceRetentionSet retain = new ResourceRetentionSet(this.delService, this.cacheTargetSize);
        retain.addResources(this.publicRsrc);
        LOG.debug((Object)("Resource cleanup (public) " + retain));
        for (LocalResourcesTracker t : this.privateRsrc.values()) {
            retain.addResources(t);
            LOG.debug((Object)("Resource cleanup " + t.getUser() + ":" + retain));
        }
    }

    private void handleCleanupContainerResources(ContainerLocalizationCleanupEvent rsrcCleanup) {
        Container c = rsrcCleanup.getContainer();
        Map<LocalResourceVisibility, Collection<LocalResourceRequest>> rsrcs = rsrcCleanup.getResources();
        for (Map.Entry<LocalResourceVisibility, Collection<LocalResourceRequest>> e : rsrcs.entrySet()) {
            LocalResourcesTracker tracker = this.getLocalResourcesTracker(e.getKey(), c.getUser(), c.getContainerID().getApplicationAttemptId().getApplicationId());
            for (LocalResourceRequest req : e.getValue()) {
                tracker.handle((Event)new ResourceReleaseEvent(req, c.getContainerID()));
            }
        }
        String locId = ConverterUtils.toString((ContainerId)c.getContainerID());
        this.localizerTracker.cleanupPrivLocalizers(locId);
        String userName = c.getUser();
        String containerIDStr = c.toString();
        String appIDStr = ConverterUtils.toString((ApplicationId)c.getContainerID().getApplicationAttemptId().getApplicationId());
        for (String localDir : this.dirsHandler.getLocalDirs()) {
            Path usersdir = new Path(localDir, "usercache");
            Path userdir = new Path(usersdir, userName);
            Path allAppsdir = new Path(userdir, "appcache");
            Path appDir = new Path(allAppsdir, appIDStr);
            Path containerDir = new Path(appDir, containerIDStr);
            this.delService.delete(userName, containerDir, new Path[0]);
            Path sysDir = new Path(localDir, NM_PRIVATE_DIR);
            Path appSysDir = new Path(sysDir, appIDStr);
            Path containerSysDir = new Path(appSysDir, containerIDStr);
            this.delService.delete(null, containerSysDir, new Path[0]);
        }
        this.dispatcher.getEventHandler().handle((Event)new ContainerEvent(c.getContainerID(), ContainerEventType.CONTAINER_RESOURCES_CLEANEDUP));
    }

    private void handleDestroyApplicationResources(Application application) {
        LocalResourcesTracker appLocalRsrcsTracker = (LocalResourcesTracker)this.appRsrc.remove(ConverterUtils.toString((ApplicationId)application.getAppId()));
        if (null == appLocalRsrcsTracker) {
            LOG.warn((Object)("Removing uninitialized application " + application));
        }
        String userName = application.getUser();
        String appIDStr = application.toString();
        for (String localDir : this.dirsHandler.getLocalDirs()) {
            Path usersdir = new Path(localDir, "usercache");
            Path userdir = new Path(usersdir, userName);
            Path allAppsdir = new Path(userdir, "appcache");
            Path appDir = new Path(allAppsdir, appIDStr);
            this.delService.delete(userName, appDir, new Path[0]);
            Path sysDir = new Path(localDir, NM_PRIVATE_DIR);
            Path appSysDir = new Path(sysDir, appIDStr);
            this.delService.delete(null, appSysDir, new Path[0]);
        }
        this.dispatcher.getEventHandler().handle((Event)new ApplicationEvent(application.getAppId(), ApplicationEventType.APPLICATION_RESOURCES_CLEANEDUP));
    }

    LocalResourcesTracker getLocalResourcesTracker(LocalResourceVisibility visibility, String user, ApplicationId appId) {
        switch (visibility) {
            default: {
                return this.publicRsrc;
            }
            case PRIVATE: {
                return (LocalResourcesTracker)this.privateRsrc.get(user);
            }
            case APPLICATION: 
        }
        return (LocalResourcesTracker)this.appRsrc.get(ConverterUtils.toString((ApplicationId)appId));
    }

    private static ExecutorService createLocalizerExecutor(Configuration conf) {
        int nThreads = conf.getInt("yarn.nodemanager.localizer.fetch.thread-count", 4);
        ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat("PublicLocalizer #%d").build();
        return Executors.newFixedThreadPool(nThreads, tf);
    }

    private void cleanUpLocalDir(FileContext lfs, DeletionService del) {
        long currentTimeStamp = System.currentTimeMillis();
        for (String localDir : this.dirsHandler.getLocalDirs()) {
            this.renameLocalDir(lfs, localDir, "usercache", currentTimeStamp);
            this.renameLocalDir(lfs, localDir, "filecache", currentTimeStamp);
            this.renameLocalDir(lfs, localDir, NM_PRIVATE_DIR, currentTimeStamp);
            try {
                this.deleteLocalDir(lfs, del, localDir);
            }
            catch (IOException e) {
                LOG.warn((Object)("Failed to delete localDir: " + localDir));
            }
        }
    }

    private void renameLocalDir(FileContext lfs, String localDir, String localSubDir, long currentTimeStamp) {
        try {
            lfs.rename(new Path(localDir, localSubDir), new Path(localDir, localSubDir + "_DEL_" + currentTimeStamp), new Options.Rename[0]);
        }
        catch (FileNotFoundException ex) {
        }
        catch (Exception ex) {
            LOG.warn((Object)("Failed to rename the local file under " + localDir + "/" + localSubDir));
        }
    }

    private void deleteLocalDir(FileContext lfs, DeletionService del, String localDir) throws IOException {
        RemoteIterator fileStatus = lfs.listStatus(new Path(localDir));
        if (fileStatus != null) {
            while (fileStatus.hasNext()) {
                FileStatus status = (FileStatus)fileStatus.next();
                try {
                    if (status.getPath().getName().matches(".*usercache_DEL_.*")) {
                        this.cleanUpFilesFromSubDir(lfs, del, status.getPath());
                        continue;
                    }
                    if (!status.getPath().getName().matches(".*nmPrivate_DEL_.*") && !status.getPath().getName().matches(".*filecache_DEL_.*")) continue;
                    del.delete(null, status.getPath(), new Path[0]);
                }
                catch (IOException ex) {
                    LOG.warn((Object)("Failed to delete this local Directory: " + status.getPath().getName()));
                }
            }
        }
    }

    private void cleanUpFilesFromSubDir(FileContext lfs, DeletionService del, Path dirPath) throws IOException {
        RemoteIterator fileStatus = lfs.listStatus(dirPath);
        if (fileStatus != null) {
            while (fileStatus.hasNext()) {
                FileStatus status = (FileStatus)fileStatus.next();
                String owner = status.getOwner();
                del.delete(owner, status.getPath(), new Path[0]);
            }
        }
        del.delete(null, dirPath, new Path[0]);
    }

    static class CacheCleanup
    extends Thread {
        private final Dispatcher dispatcher;

        public CacheCleanup(Dispatcher dispatcher) {
            super("CacheCleanup");
            this.dispatcher = dispatcher;
        }

        @Override
        public void run() {
            this.dispatcher.getEventHandler().handle((Event)new LocalizationEvent(LocalizationEventType.CACHE_CLEANUP));
        }
    }

    class LocalizerRunner
    extends Thread {
        final LocalizerContext context;
        final String localizerId;
        final Map<LocalResourceRequest, LocalizerResourceRequestEvent> scheduled;
        final List<LocalizerResourceRequestEvent> pending;
        private final RecordFactory recordFactory;

        LocalizerRunner(LocalizerContext context, String localizerId) {
            super("LocalizerRunner for " + localizerId);
            this.recordFactory = RecordFactoryProvider.getRecordFactory((Configuration)ResourceLocalizationService.this.getConfig());
            this.context = context;
            this.localizerId = localizerId;
            this.pending = Collections.synchronizedList(new ArrayList());
            this.scheduled = new HashMap<LocalResourceRequest, LocalizerResourceRequestEvent>();
        }

        public void addResource(LocalizerResourceRequestEvent request) {
            this.pending.add(request);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LocalResource findNextResource() {
            List<LocalizerResourceRequestEvent> list = this.pending;
            synchronized (list) {
                Iterator<LocalizerResourceRequestEvent> i = this.pending.iterator();
                while (i.hasNext()) {
                    LocalizerResourceRequestEvent evt = i.next();
                    LocalizedResource nRsrc = evt.getResource();
                    if (ResourceState.LOCALIZED.equals((Object)nRsrc.getState())) {
                        i.remove();
                        continue;
                    }
                    if (!nRsrc.tryAcquire()) continue;
                    LocalResourceRequest nextRsrc = nRsrc.getRequest();
                    LocalResource next = (LocalResource)this.recordFactory.newRecordInstance(LocalResource.class);
                    next.setResource(ConverterUtils.getYarnUrlFromPath((Path)nextRsrc.getPath()));
                    next.setTimestamp(nextRsrc.getTimestamp());
                    next.setType(nextRsrc.getType());
                    next.setVisibility(evt.getVisibility());
                    next.setPattern(evt.getPattern());
                    this.scheduled.put(nextRsrc, evt);
                    return next;
                }
                return null;
            }
        }

        LocalizerHeartbeatResponse update(List<LocalResourceStatus> remoteResourceStatuses) {
            LocalizerHeartbeatResponse response = (LocalizerHeartbeatResponse)this.recordFactory.newRecordInstance(LocalizerHeartbeatResponse.class);
            if (remoteResourceStatuses.isEmpty()) {
                LocalResource next = this.findNextResource();
                if (next != null) {
                    response.setLocalizerAction(LocalizerAction.LIVE);
                    response.addResource(next);
                } else if (this.pending.isEmpty()) {
                    response.setLocalizerAction(LocalizerAction.DIE);
                } else {
                    response.setLocalizerAction(LocalizerAction.LIVE);
                }
                return response;
            }
            block9: for (LocalResourceStatus stat : remoteResourceStatuses) {
                LocalResource rsrc = stat.getResource();
                LocalResourceRequest req = null;
                try {
                    req = new LocalResourceRequest(rsrc);
                }
                catch (URISyntaxException e) {
                    // empty catch block
                }
                LocalizerResourceRequestEvent assoc = this.scheduled.get(req);
                if (assoc == null) {
                    LOG.error((Object)("Unknown resource reported: " + req));
                    continue;
                }
                switch (stat.getStatus()) {
                    case FETCH_SUCCESS: {
                        try {
                            assoc.getResource().handle(new ResourceLocalizedEvent(req, ConverterUtils.getPathFromYarnURL((URL)stat.getLocalPath()), stat.getLocalSize()));
                        }
                        catch (URISyntaxException e) {
                            // empty catch block
                        }
                        if (this.pending.isEmpty()) {
                            response.setLocalizerAction(LocalizerAction.DIE);
                            continue block9;
                        }
                        response.setLocalizerAction(LocalizerAction.LIVE);
                        LocalResource next = this.findNextResource();
                        if (next == null) continue block9;
                        response.addResource(next);
                        continue block9;
                    }
                    case FETCH_PENDING: {
                        response.setLocalizerAction(LocalizerAction.LIVE);
                        continue block9;
                    }
                    case FETCH_FAILURE: {
                        LOG.info((Object)("DEBUG: FAILED " + req), (Throwable)stat.getException());
                        assoc.getResource().unlock();
                        response.setLocalizerAction(LocalizerAction.DIE);
                        ResourceLocalizationService.this.dispatcher.getEventHandler().handle((Event)new ContainerResourceFailedEvent(this.context.getContainerId(), req, (Throwable)stat.getException()));
                        continue block9;
                    }
                }
                LOG.info((Object)("Unknown status: " + (Object)((Object)stat.getStatus())));
                response.setLocalizerAction(LocalizerAction.DIE);
                ResourceLocalizationService.this.dispatcher.getEventHandler().handle((Event)new ContainerResourceFailedEvent(this.context.getContainerId(), req, (Throwable)stat.getException()));
            }
            return response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Path nmPrivateCTokensPath = null;
            try {
                nmPrivateCTokensPath = ResourceLocalizationService.this.dirsHandler.getLocalPathForWrite("nmPrivate/" + String.format("%s.tokens", this.localizerId));
                this.writeCredentials(nmPrivateCTokensPath);
                List<String> localDirs = ResourceLocalizationService.this.dirsHandler.getLocalDirs();
                List<String> logDirs = ResourceLocalizationService.this.dirsHandler.getLogDirs();
                if (!ResourceLocalizationService.this.dirsHandler.areDisksHealthy()) {
                    throw new IOException("All disks failed. " + ResourceLocalizationService.this.dirsHandler.getDisksHealthReport());
                }
                ResourceLocalizationService.this.exec.startLocalizer(nmPrivateCTokensPath, ResourceLocalizationService.this.localizationServerAddress, this.context.getUser(), ConverterUtils.toString((ApplicationId)this.context.getContainerId().getApplicationAttemptId().getApplicationId()), this.localizerId, localDirs, logDirs);
            }
            catch (Exception e) {
                try {
                    LOG.info((Object)"Localizer failed", (Throwable)e);
                    ContainerId cId = this.context.getContainerId();
                    ResourceLocalizationService.this.dispatcher.getEventHandler().handle((Event)new ContainerResourceFailedEvent(cId, null, e));
                }
                catch (Throwable throwable) {
                    for (LocalizerResourceRequestEvent event : this.scheduled.values()) {
                        event.getResource().unlock();
                    }
                    ResourceLocalizationService.this.delService.delete(null, nmPrivateCTokensPath, new Path[0]);
                    throw throwable;
                }
                for (LocalizerResourceRequestEvent event : this.scheduled.values()) {
                    event.getResource().unlock();
                }
                ResourceLocalizationService.this.delService.delete(null, nmPrivateCTokensPath, new Path[0]);
            }
            for (LocalizerResourceRequestEvent event : this.scheduled.values()) {
                event.getResource().unlock();
            }
            ResourceLocalizationService.this.delService.delete(null, nmPrivateCTokensPath, new Path[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeCredentials(Path nmPrivateCTokensPath) throws IOException {
            FilterOutputStream tokenOut = null;
            try {
                Credentials credentials = this.context.getCredentials();
                FileContext lfs = ResourceLocalizationService.this.getLocalFileContext(ResourceLocalizationService.this.getConfig());
                tokenOut = lfs.create(nmPrivateCTokensPath, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
                LOG.info((Object)("Writing credentials to the nmPrivate file " + nmPrivateCTokensPath.toString() + ". Credentials list: "));
                if (LOG.isDebugEnabled()) {
                    for (Token tk : credentials.getAllTokens()) {
                        LOG.debug((Object)(tk.getService() + " : " + tk.encodeToUrlString()));
                    }
                }
                credentials.writeTokenStorageToStream((DataOutputStream)tokenOut);
            }
            finally {
                if (tokenOut != null) {
                    tokenOut.close();
                }
            }
        }
    }

    class PublicLocalizer
    extends Thread {
        final FileContext lfs;
        final Configuration conf;
        final ExecutorService threadPool;
        final CompletionService<Path> queue;
        final Map<Future<Path>, LocalizerResourceRequestEvent> pending;
        final Map<LocalResourceRequest, List<LocalizerResourceRequestEvent>> attempts;

        PublicLocalizer(Configuration conf) {
            this.lfs = ResourceLocalizationService.this.getLocalFileContext(conf);
            this.conf = conf;
            this.pending = new ConcurrentHashMap<Future<Path>, LocalizerResourceRequestEvent>();
            this.attempts = new HashMap<LocalResourceRequest, List<LocalizerResourceRequestEvent>>();
            this.threadPool = ResourceLocalizationService.createLocalizerExecutor(conf);
            this.queue = new ExecutorCompletionService<Path>(this.threadPool);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addResource(LocalizerResourceRequestEvent request) {
            LocalResourceRequest key = request.getResource().getRequest();
            LOG.info((Object)("Downloading public rsrc:" + key));
            Map<LocalResourceRequest, List<LocalizerResourceRequestEvent>> map = this.attempts;
            synchronized (map) {
                List<LocalizerResourceRequestEvent> sigh = this.attempts.get(key);
                if (null == sigh) {
                    LocalResourceRequest resource = request.getResource().getRequest();
                    try {
                        Path publicDirDestPath = ResourceLocalizationService.this.dirsHandler.getLocalPathForWrite("./filecache", ContainerLocalizer.getEstimatedSize(resource), true);
                        this.pending.put(this.queue.submit((Callable<Path>)new FSDownload(this.lfs, null, this.conf, publicDirDestPath, (LocalResource)resource, new Random())), request);
                        this.attempts.put(key, new LinkedList());
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Local path for public localization is not found.  May be disks failed.", (Throwable)e);
                    }
                } else {
                    sigh.add(request);
                }
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[MONITOR], 14[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    class LocalizerTracker
    extends AbstractService
    implements EventHandler<LocalizerEvent> {
        private final PublicLocalizer publicLocalizer;
        private final Map<String, LocalizerRunner> privLocalizers;

        LocalizerTracker(Configuration conf) {
            this(conf, new HashMap<String, LocalizerRunner>());
        }

        LocalizerTracker(Configuration conf, Map<String, LocalizerRunner> privLocalizers) {
            super(LocalizerTracker.class.getName());
            this.publicLocalizer = new PublicLocalizer(conf);
            this.privLocalizers = privLocalizers;
        }

        public synchronized void start() {
            this.publicLocalizer.start();
            super.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LocalizerHeartbeatResponse processHeartbeat(LocalizerStatus status) {
            String locId = status.getLocalizerId();
            Map<String, LocalizerRunner> map = this.privLocalizers;
            synchronized (map) {
                LocalizerRunner localizer = this.privLocalizers.get(locId);
                if (null == localizer) {
                    LOG.info((Object)("Unknown localizer with localizerId " + locId + " is sending heartbeat. Ordering it to DIE"));
                    LocalizerHeartbeatResponse response = (LocalizerHeartbeatResponse)ResourceLocalizationService.this.recordFactory.newRecordInstance(LocalizerHeartbeatResponse.class);
                    response.setLocalizerAction(LocalizerAction.DIE);
                    return response;
                }
                return localizer.update(status.getResources());
            }
        }

        public void stop() {
            for (LocalizerRunner localizer : this.privLocalizers.values()) {
                localizer.interrupt();
            }
            this.publicLocalizer.interrupt();
            super.stop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(LocalizerEvent event) {
            String locId = event.getLocalizerId();
            block2 : switch ((LocalizerEventType)event.getType()) {
                case REQUEST_RESOURCE_LOCALIZATION: {
                    LocalizerResourceRequestEvent req = (LocalizerResourceRequestEvent)event;
                    switch (req.getVisibility()) {
                        case PUBLIC: {
                            this.publicLocalizer.addResource(req);
                            break block2;
                        }
                        case PRIVATE: 
                        case APPLICATION: {
                            Map<String, LocalizerRunner> map = this.privLocalizers;
                            synchronized (map) {
                                LocalizerRunner localizer = this.privLocalizers.get(locId);
                                if (null == localizer) {
                                    LOG.info((Object)("Created localizer for " + locId));
                                    localizer = new LocalizerRunner(req.getContext(), locId);
                                    this.privLocalizers.put(locId, localizer);
                                    localizer.start();
                                }
                                localizer.addResource(req);
                                break block2;
                            }
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanupPrivLocalizers(String locId) {
            Map<String, LocalizerRunner> map = this.privLocalizers;
            synchronized (map) {
                LocalizerRunner localizer = this.privLocalizers.get(locId);
                if (null == localizer) {
                    return;
                }
                this.privLocalizers.remove(locId);
                localizer.interrupt();
            }
        }
    }
}

