/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerExitEvent;
import org.apache.hadoop.yarn.server.nodemanager.util.ProcessIdFileReader;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class ContainerLaunch
implements Callable<Integer> {
    private static final Log LOG = LogFactory.getLog(ContainerLaunch.class);
    public static final String CONTAINER_SCRIPT = "launch_container.sh";
    public static final String FINAL_CONTAINER_TOKENS_FILE = "container_tokens";
    private static final String PID_FILE_NAME_FMT = "%s.pid";
    private final Dispatcher dispatcher;
    private final ContainerExecutor exec;
    private final Application app;
    private final Container container;
    private final Configuration conf;
    private volatile AtomicBoolean shouldLaunchContainer = new AtomicBoolean(false);
    private volatile AtomicBoolean completed = new AtomicBoolean(false);
    private long sleepDelayBeforeSigKill = 250L;
    private long maxKillWaitTime = 2000L;
    private Path pidFilePath = null;
    private final LocalDirsHandlerService dirsHandler;

    public ContainerLaunch(Configuration configuration, Dispatcher dispatcher, ContainerExecutor exec, Application app, Container container, LocalDirsHandlerService dirsHandler) {
        this.conf = configuration;
        this.app = app;
        this.exec = exec;
        this.container = container;
        this.dispatcher = dispatcher;
        this.dirsHandler = dirsHandler;
        this.sleepDelayBeforeSigKill = this.conf.getLong("yarn.nodemanager.sleep-delay-before-sigkill.ms", 250L);
        this.maxKillWaitTime = this.conf.getLong("yarn.nodemanager.process-kill-wait.ms", 2000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() {
        ContainerLaunchContext launchContext = this.container.getLaunchContext();
        Map<Path, List<String>> localResources = this.container.getLocalizedResources();
        ContainerId containerID = this.container.getContainerID();
        String containerIdStr = ConverterUtils.toString((ContainerId)containerID);
        String user = launchContext.getUser();
        List command = launchContext.getCommands();
        int ret = -1;
        try {
            ArrayList<String> newCmds = new ArrayList<String>(command.size());
            String appIdStr = this.app.getAppId().toString();
            Path containerLogDir = this.dirsHandler.getLogPathForWrite(ContainerLaunch.getRelativeContainerLogDir(appIdStr, containerIdStr), false);
            for (String str : command) {
                newCmds.add(str.replace("<LOG_DIR>", containerLogDir.toUri().getPath()));
            }
            launchContext.setCommands(newCmds);
            Map environment = launchContext.getEnvironment();
            for (Map.Entry entry : environment.entrySet()) {
                String value = (String)entry.getValue();
                entry.setValue(value.replace("<LOG_DIR>", containerLogDir.toUri().getPath()));
            }
            FileContext lfs = FileContext.getLocalFSFileContext();
            Path path = this.dirsHandler.getLocalPathForWrite(this.getContainerPrivateDir(appIdStr, containerIdStr) + "/" + CONTAINER_SCRIPT);
            Path nmPrivateTokensPath = this.dirsHandler.getLocalPathForWrite(this.getContainerPrivateDir(appIdStr, containerIdStr) + "/" + String.format("%s.tokens", containerIdStr));
            FSDataOutputStream containerScriptOutStream = null;
            FSDataOutputStream tokensOutStream = null;
            Path containerWorkDir = this.dirsHandler.getLocalPathForWrite("usercache/" + user + "/" + "appcache" + "/" + appIdStr + "/" + containerIdStr, -1L, false);
            String pidFileSuffix = String.format(PID_FILE_NAME_FMT, containerIdStr);
            this.pidFilePath = this.dirsHandler.getLocalPathForWrite("nmPrivate/" + pidFileSuffix);
            List<String> localDirs = this.dirsHandler.getLocalDirs();
            List<String> logDirs = this.dirsHandler.getLogDirs();
            if (!this.dirsHandler.areDisksHealthy()) {
                ret = -101;
                throw new IOException("Most of the disks failed. " + this.dirsHandler.getDisksHealthReport());
            }
            try {
                ArrayList<Path> appDirs = new ArrayList<Path>(localDirs.size());
                for (String localDir : localDirs) {
                    Path usersdir = new Path(localDir, "usercache");
                    Path userdir = new Path(usersdir, user);
                    Path appsdir = new Path(userdir, "appcache");
                    appDirs.add(new Path(appsdir, appIdStr));
                }
                containerScriptOutStream = lfs.create(path, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
                environment.put("HADOOP_TOKEN_FILE_LOCATION", new Path(containerWorkDir, FINAL_CONTAINER_TOKENS_FILE).toUri().getPath());
                this.sanitizeEnv(environment, containerWorkDir, appDirs);
                ContainerLaunch.writeLaunchEnv((OutputStream)containerScriptOutStream, environment, localResources, launchContext.getCommands());
                tokensOutStream = lfs.create(nmPrivateTokensPath, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
                Credentials creds = this.container.getCredentials();
                creds.writeTokenStorageToStream((DataOutputStream)tokensOutStream);
            }
            catch (Throwable throwable) {
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{containerScriptOutStream, tokensOutStream});
                throw throwable;
            }
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{containerScriptOutStream, tokensOutStream});
            this.dispatcher.getEventHandler().handle((Event)new ContainerEvent(containerID, ContainerEventType.CONTAINER_LAUNCHED));
            if (!this.shouldLaunchContainer.compareAndSet(false, true)) {
                LOG.info((Object)("Container " + containerIdStr + " not launched as " + "cleanup already called"));
                ret = ContainerExecutor.ExitCode.TERMINATED.getExitCode();
            } else {
                this.exec.activateContainer(containerID, this.pidFilePath);
                ret = this.exec.launchContainer(this.container, path, nmPrivateTokensPath, user, appIdStr, containerWorkDir, localDirs, logDirs);
            }
        }
        catch (Throwable e) {
            LOG.warn((Object)"Failed to launch container.", e);
            this.dispatcher.getEventHandler().handle((Event)new ContainerExitEvent(launchContext.getContainerId(), ContainerEventType.CONTAINER_EXITED_WITH_FAILURE, ret, e.getMessage()));
            Integer n = ret;
            return n;
        }
        finally {
            this.completed.set(true);
            this.exec.deactivateContainer(containerID);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Container " + containerIdStr + " completed with exit code " + ret));
        }
        if (ret == ContainerExecutor.ExitCode.FORCE_KILLED.getExitCode() || ret == ContainerExecutor.ExitCode.TERMINATED.getExitCode()) {
            this.dispatcher.getEventHandler().handle((Event)new ContainerExitEvent(launchContext.getContainerId(), ContainerEventType.CONTAINER_KILLED_ON_REQUEST, ret, "Container exited with a non-zero exit code " + ret));
            return ret;
        }
        if (ret != 0) {
            LOG.warn((Object)("Container exited with a non-zero exit code " + ret));
            this.dispatcher.getEventHandler().handle((Event)new ContainerExitEvent(launchContext.getContainerId(), ContainerEventType.CONTAINER_EXITED_WITH_FAILURE, ret, "Container exited with a non-zero exit code " + ret));
            return ret;
        }
        LOG.info((Object)("Container " + containerIdStr + " succeeded "));
        this.dispatcher.getEventHandler().handle((Event)new ContainerEvent(launchContext.getContainerId(), ContainerEventType.CONTAINER_EXITED_WITH_SUCCESS));
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupContainer() throws IOException {
        boolean alreadyLaunched;
        ContainerId containerId = this.container.getContainerID();
        String containerIdStr = ConverterUtils.toString((ContainerId)containerId);
        LOG.info((Object)("Cleaning up container " + containerIdStr));
        boolean bl = alreadyLaunched = !this.shouldLaunchContainer.compareAndSet(false, true);
        if (!alreadyLaunched) {
            LOG.info((Object)("Container " + containerIdStr + " not launched." + " No cleanup needed to be done"));
            return;
        }
        LOG.debug((Object)("Marking container " + containerIdStr + " as inactive"));
        this.exec.deactivateContainer(containerId);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting pid for container " + containerIdStr + " to kill" + " from pid file " + (this.pidFilePath != null ? this.pidFilePath.toString() : "null")));
        }
        try {
            String processId = null;
            if (this.pidFilePath != null) {
                processId = this.getContainerPid(this.pidFilePath);
            }
            if (processId != null) {
                String user = this.container.getLaunchContext().getUser();
                LOG.debug((Object)("Sending signal to pid " + processId + " as user " + user + " for container " + containerIdStr));
                if (this.sleepDelayBeforeSigKill > 0L) {
                    boolean result = this.exec.signalContainer(user, processId, ContainerExecutor.Signal.TERM);
                    LOG.debug((Object)("Sent signal to pid " + processId + " as user " + user + " for container " + containerIdStr + ", result=" + (result ? "success" : "failed")));
                    new ContainerExecutor.DelayedProcessKiller(user, processId, this.sleepDelayBeforeSigKill, ContainerExecutor.Signal.KILL, this.exec).start();
                }
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Got error when trying to cleanup container " + containerIdStr + ", error=" + e.getMessage()));
        }
        finally {
            if (this.pidFilePath != null) {
                FileContext lfs = FileContext.getLocalFSFileContext();
                lfs.delete(this.pidFilePath, false);
            }
        }
    }

    private String getContainerPid(Path pidFilePath) throws Exception {
        String containerIdStr = ConverterUtils.toString((ContainerId)this.container.getContainerID());
        String processId = null;
        LOG.debug((Object)("Accessing pid for container " + containerIdStr + " from pid file " + pidFilePath));
        int sleepCounter = 0;
        int sleepInterval = 100;
        while (!this.completed.get()) {
            processId = ProcessIdFileReader.getProcessId(pidFilePath);
            if (processId != null) {
                LOG.debug((Object)("Got pid " + processId + " for container " + containerIdStr));
                break;
            }
            if ((long)(sleepCounter * 100) > this.maxKillWaitTime) {
                LOG.info((Object)("Could not get pid for " + containerIdStr + ". Waited for " + this.maxKillWaitTime + " ms."));
                break;
            }
            ++sleepCounter;
            Thread.sleep(100L);
        }
        return processId;
    }

    public static String getRelativeContainerLogDir(String appIdStr, String containerIdStr) {
        return appIdStr + "/" + containerIdStr;
    }

    private String getContainerPrivateDir(String appIdStr, String containerIdStr) {
        return this.getAppPrivateDir(appIdStr) + "/" + containerIdStr + "/";
    }

    private String getAppPrivateDir(String appIdStr) {
        return "nmPrivate/" + appIdStr;
    }

    private static void putEnvIfNotNull(Map<String, String> environment, String variable, String value) {
        if (value != null) {
            environment.put(variable, value);
        }
    }

    private static void putEnvIfAbsent(Map<String, String> environment, String variable) {
        if (environment.get(variable) == null) {
            ContainerLaunch.putEnvIfNotNull(environment, variable, System.getenv(variable));
        }
    }

    public void sanitizeEnv(Map<String, String> environment, Path pwd, List<Path> appDirs) {
        String[] whitelist;
        ContainerLaunch.putEnvIfNotNull(environment, ApplicationConstants.Environment.USER.name(), this.container.getUser());
        ContainerLaunch.putEnvIfNotNull(environment, ApplicationConstants.Environment.LOGNAME.name(), this.container.getUser());
        ContainerLaunch.putEnvIfNotNull(environment, ApplicationConstants.Environment.HOME.name(), this.conf.get("yarn.nodemanager.user-home-dir", "/home/"));
        ContainerLaunch.putEnvIfNotNull(environment, ApplicationConstants.Environment.PWD.name(), pwd.toString());
        ContainerLaunch.putEnvIfNotNull(environment, ApplicationConstants.Environment.HADOOP_CONF_DIR.name(), System.getenv(ApplicationConstants.Environment.HADOOP_CONF_DIR.name()));
        ContainerLaunch.putEnvIfNotNull(environment, "YARN_LOCAL_DIRS", StringUtils.join((CharSequence)",", appDirs));
        if (!Shell.WINDOWS) {
            environment.put("JVM_PID", "$$");
        }
        for (String whitelistEnvVariable : whitelist = this.conf.get("yarn.nodemanager.env-whitelist", "JAVA_HOME,HADOOP_COMMON_HOME,HADOOP_HDFS_HOME,HADOOP_CONF_DIR,YARN_HOME").split(",")) {
            ContainerLaunch.putEnvIfAbsent(environment, whitelistEnvVariable.trim());
        }
        Apps.setEnvFromInputString(environment, (String)this.conf.get("yarn.nodemanager.admin-env", "MALLOC_ARENA_MAX=$MALLOC_ARENA_MAX"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeLaunchEnv(OutputStream out, Map<String, String> environment, Map<Path, List<String>> resources, List<String> command) throws IOException {
        ShellScriptBuilder sb = new ShellScriptBuilder();
        if (environment != null) {
            for (Map.Entry<String, Object> entry : environment.entrySet()) {
                sb.env(entry.getKey().toString(), ((String)entry.getValue()).toString());
            }
        }
        if (resources != null) {
            for (Map.Entry<String, Object> entry : resources.entrySet()) {
                for (String linkName : (List)entry.getValue()) {
                    sb.symlink((Path)entry.getKey(), linkName);
                }
            }
        }
        ArrayList<String> cmd = new ArrayList<String>(2 * command.size() + 5);
        cmd.add("exec /bin/bash ");
        cmd.add("-c ");
        cmd.add("\"");
        for (String cs : command) {
            cmd.add(cs.toString());
            cmd.add(" ");
        }
        cmd.add("\"");
        sb.line(cmd.toArray(new String[cmd.size()]));
        Object var6_10 = null;
        try {
            PrintStream printStream = new PrintStream(out);
            sb.write(printStream);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private static class ShellScriptBuilder {
        private final StringBuilder sb;

        public ShellScriptBuilder() {
            this(new StringBuilder("#!/bin/bash\n\n"));
        }

        protected ShellScriptBuilder(StringBuilder sb) {
            this.sb = sb;
        }

        public ShellScriptBuilder env(String key, String value) {
            this.line("export ", key, "=\"", value, "\"");
            return this;
        }

        public ShellScriptBuilder symlink(Path src, String dst) throws IOException {
            return this.symlink(src, new Path(dst));
        }

        public ShellScriptBuilder symlink(Path src, Path dst) throws IOException {
            if (!src.isAbsolute()) {
                throw new IOException("Source must be absolute");
            }
            if (dst.isAbsolute()) {
                throw new IOException("Destination must be relative");
            }
            if (dst.toUri().getPath().indexOf(47) != -1) {
                this.line("mkdir -p ", dst.getParent().toString());
            }
            this.line("ln -sf \"", src.toUri().getPath(), "\" \"", dst.toString(), "\"");
            return this;
        }

        public void write(PrintStream out) throws IOException {
            out.append(this.sb);
        }

        public void line(String ... command) {
            for (String s : command) {
                this.sb.append(s);
            }
            this.sb.append("\n");
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

