/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.DiskChecker;

class DirectoryCollection {
    private static final Log LOG = LogFactory.getLog(DirectoryCollection.class);
    private List<String> localDirs;
    private List<String> failedDirs;
    private int numFailures;

    public DirectoryCollection(String[] dirs) {
        this.localDirs = new CopyOnWriteArrayList<String>(dirs);
        this.failedDirs = new CopyOnWriteArrayList<String>();
    }

    synchronized List<String> getGoodDirs() {
        return Collections.unmodifiableList(this.localDirs);
    }

    synchronized List<String> getFailedDirs() {
        return Collections.unmodifiableList(this.failedDirs);
    }

    synchronized int getNumFailures() {
        return this.numFailures;
    }

    synchronized boolean checkDirs() {
        int oldNumFailures = this.numFailures;
        for (String dir : this.localDirs) {
            try {
                DiskChecker.checkDir((File)new File(dir));
            }
            catch (DiskChecker.DiskErrorException de) {
                LOG.warn((Object)("Directory " + dir + " error " + de.getMessage() + ", removing from the list of valid directories."));
                this.localDirs.remove(dir);
                this.failedDirs.add(dir);
                ++this.numFailures;
            }
        }
        return this.numFailures > oldNumFailures;
    }
}

