/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import java.io.IOException;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.server.nodemanager.DirectoryCollection;
import org.apache.hadoop.yarn.service.AbstractService;

public class LocalDirsHandlerService
extends AbstractService {
    private static Log LOG = LogFactory.getLog(LocalDirsHandlerService.class);
    private Timer dirsHandlerScheduler;
    private long diskHealthCheckInterval;
    private boolean isDiskHealthCheckerEnabled;
    private float minNeededHealthyDisksFactor;
    private MonitoringTimerTask monitoringTimerTask;
    private DirectoryCollection localDirs = null;
    private DirectoryCollection logDirs = null;
    private LocalDirAllocator localDirsAllocator;
    private LocalDirAllocator logDirsAllocator;
    private long lastDisksCheckTime;

    public LocalDirsHandlerService() {
        super(LocalDirsHandlerService.class.getName());
    }

    public void init(Configuration config) {
        Configuration conf = new Configuration(config);
        this.diskHealthCheckInterval = conf.getLong("yarn.nodemanager.disk-health-checker.interval-ms", 120000L);
        this.monitoringTimerTask = new MonitoringTimerTask(conf);
        this.isDiskHealthCheckerEnabled = conf.getBoolean("yarn.nodemanager.disk-health-checker.enable", true);
        this.minNeededHealthyDisksFactor = conf.getFloat("yarn.nodemanager.disk-health-checker.min-healthy-disks", 0.25f);
        this.lastDisksCheckTime = System.currentTimeMillis();
        super.init(conf);
    }

    public void start() {
        if (this.isDiskHealthCheckerEnabled) {
            this.dirsHandlerScheduler = new Timer("DiskHealthMonitor-Timer", true);
            this.dirsHandlerScheduler.scheduleAtFixedRate((TimerTask)this.monitoringTimerTask, 0L, this.diskHealthCheckInterval);
        }
        super.start();
    }

    public void stop() {
        if (this.dirsHandlerScheduler != null) {
            this.dirsHandlerScheduler.cancel();
        }
        super.stop();
    }

    public List<String> getLocalDirs() {
        return this.localDirs.getGoodDirs();
    }

    public List<String> getLogDirs() {
        return this.logDirs.getGoodDirs();
    }

    public String getDisksHealthReport() {
        if (!this.isDiskHealthCheckerEnabled) {
            return "";
        }
        StringBuilder report = new StringBuilder();
        List<String> failedLocalDirsList = this.localDirs.getFailedDirs();
        List<String> failedLogDirsList = this.logDirs.getFailedDirs();
        int numLocalDirs = this.localDirs.getGoodDirs().size() + failedLocalDirsList.size();
        int numLogDirs = this.logDirs.getGoodDirs().size() + failedLogDirsList.size();
        if (!failedLocalDirsList.isEmpty()) {
            report.append(failedLocalDirsList.size() + "/" + numLocalDirs + " local-dirs turned bad: " + StringUtils.join((CharSequence)",", failedLocalDirsList) + ";");
        }
        if (!failedLogDirsList.isEmpty()) {
            report.append(failedLogDirsList.size() + "/" + numLogDirs + " log-dirs turned bad: " + StringUtils.join((CharSequence)",", failedLogDirsList));
        }
        return report.toString();
    }

    public boolean areDisksHealthy() {
        int failedDirs;
        int totalConfiguredDirs;
        if (!this.isDiskHealthCheckerEnabled) {
            return true;
        }
        int goodDirs = this.getLocalDirs().size();
        if ((float)goodDirs / (float)(totalConfiguredDirs = goodDirs + (failedDirs = this.localDirs.getFailedDirs().size())) < this.minNeededHealthyDisksFactor) {
            return false;
        }
        goodDirs = this.getLogDirs().size();
        return !((float)goodDirs / (float)(totalConfiguredDirs = goodDirs + (failedDirs = this.logDirs.getFailedDirs().size())) < this.minNeededHealthyDisksFactor);
    }

    public long getLastDisksCheckTime() {
        return this.lastDisksCheckTime;
    }

    private void updateDirsInConfiguration() {
        Configuration conf = this.getConfig();
        List<String> localDirs = this.getLocalDirs();
        conf.setStrings("yarn.nodemanager.local-dirs", localDirs.toArray(new String[localDirs.size()]));
        List<String> logDirs = this.getLogDirs();
        conf.setStrings("yarn.nodemanager.log-dirs", logDirs.toArray(new String[logDirs.size()]));
    }

    public Path getLocalPathForWrite(String pathStr) throws IOException {
        return this.localDirsAllocator.getLocalPathForWrite(pathStr, this.getConfig());
    }

    public Path getLocalPathForWrite(String pathStr, long size, boolean checkWrite) throws IOException {
        return this.localDirsAllocator.getLocalPathForWrite(pathStr, size, this.getConfig(), checkWrite);
    }

    public Path getLogPathForWrite(String pathStr, boolean checkWrite) throws IOException {
        return this.logDirsAllocator.getLocalPathForWrite(pathStr, -1L, this.getConfig(), checkWrite);
    }

    public Path getLogPathToRead(String pathStr) throws IOException {
        return this.logDirsAllocator.getLocalPathToRead(pathStr, this.getConfig());
    }

    private final class MonitoringTimerTask
    extends TimerTask {
        public MonitoringTimerTask(Configuration conf) {
            LocalDirsHandlerService.this.localDirs = new DirectoryCollection(conf.getTrimmedStrings("yarn.nodemanager.local-dirs"));
            LocalDirsHandlerService.this.logDirs = new DirectoryCollection(conf.getTrimmedStrings("yarn.nodemanager.log-dirs"));
            LocalDirsHandlerService.this.localDirsAllocator = new LocalDirAllocator("yarn.nodemanager.local-dirs");
            LocalDirsHandlerService.this.logDirsAllocator = new LocalDirAllocator("yarn.nodemanager.log-dirs");
        }

        @Override
        public void run() {
            boolean newFailure = false;
            if (LocalDirsHandlerService.this.localDirs.checkDirs()) {
                newFailure = true;
            }
            if (LocalDirsHandlerService.this.logDirs.checkDirs()) {
                newFailure = true;
            }
            if (newFailure) {
                LOG.info((Object)("Disk(s) failed. " + LocalDirsHandlerService.this.getDisksHealthReport()));
                LocalDirsHandlerService.this.updateDirsInConfiguration();
                if (!LocalDirsHandlerService.this.areDisksHealthy()) {
                    LOG.error((Object)("Most of the disks failed. " + LocalDirsHandlerService.this.getDisksHealthReport()));
                }
            }
            LocalDirsHandlerService.this.lastDisksCheckTime = System.currentTimeMillis();
        }
    }
}

