/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServicesEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServicesEventType;
import org.apache.hadoop.yarn.service.AbstractService;
import org.apache.hadoop.yarn.service.Service;
import org.apache.hadoop.yarn.service.ServiceStateChangeListener;

public class AuxServices
extends AbstractService
implements ServiceStateChangeListener,
EventHandler<AuxServicesEvent> {
    private static final Log LOG = LogFactory.getLog(AuxServices.class);
    protected final Map<String, AuxiliaryService> serviceMap = Collections.synchronizedMap(new HashMap());
    protected final Map<String, ByteBuffer> serviceMeta = Collections.synchronizedMap(new HashMap());

    public AuxServices() {
        super(AuxServices.class.getName());
    }

    protected final synchronized void addService(String name, AuxiliaryService service) {
        LOG.info((Object)("Adding auxiliary service " + service.getName() + ", \"" + name + "\""));
        this.serviceMap.put(name, service);
    }

    Collection<AuxiliaryService> getServices() {
        return Collections.unmodifiableCollection(this.serviceMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ByteBuffer> getMeta() {
        HashMap<String, ByteBuffer> metaClone = new HashMap<String, ByteBuffer>(this.serviceMeta.size());
        Map<String, ByteBuffer> map = this.serviceMeta;
        synchronized (map) {
            for (Map.Entry<String, ByteBuffer> entry : this.serviceMeta.entrySet()) {
                metaClone.put(entry.getKey(), entry.getValue().duplicate());
            }
        }
        return metaClone;
    }

    public void init(Configuration conf) {
        Collection auxNames = conf.getStringCollection("yarn.nodemanager.aux-services");
        for (String sName : auxNames) {
            try {
                Class sClass = conf.getClass(String.format("yarn.nodemanager.aux-services.%s.class", sName), null, AuxiliaryService.class);
                if (null == sClass) {
                    throw new RuntimeException("No class defiend for " + sName);
                }
                AuxiliaryService s = (AuxiliaryService)ReflectionUtils.newInstance((Class)sClass, (Configuration)conf);
                if (!sName.equals(s.getName())) {
                    LOG.warn((Object)("The Auxilurary Service named '" + sName + "' in the " + "configuration is for class " + sClass + " which has " + "a name of '" + s.getName() + "'. Because these are " + "not the same tools trying to send ServiceData and read " + "Service Meta Data may have issues unless the refer to " + "the name in the config."));
                }
                this.addService(sName, s);
                s.init(conf);
            }
            catch (RuntimeException e) {
                LOG.fatal((Object)("Failed to initialize " + sName), (Throwable)e);
                throw e;
            }
        }
        super.init(conf);
    }

    public void start() {
        for (Map.Entry<String, AuxiliaryService> entry : this.serviceMap.entrySet()) {
            AuxiliaryService service = entry.getValue();
            String name = entry.getKey();
            service.start();
            service.register(this);
            ByteBuffer meta = service.getMeta();
            if (meta == null) continue;
            this.serviceMeta.put(name, meta);
        }
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            Map<String, AuxiliaryService> map = this.serviceMap;
            synchronized (map) {
                for (Service service : this.serviceMap.values()) {
                    if (service.getServiceState() != Service.STATE.STARTED) continue;
                    service.unregister((ServiceStateChangeListener)this);
                    service.stop();
                }
                this.serviceMap.clear();
                this.serviceMeta.clear();
            }
        }
        finally {
            super.stop();
        }
    }

    public void stateChanged(Service service) {
        LOG.fatal((Object)("Service " + service.getName() + " changed state: " + service.getServiceState()));
        this.stop();
    }

    public void handle(AuxServicesEvent event) {
        LOG.info((Object)("Got event " + event.getType() + " for appId " + event.getApplicationID()));
        switch ((AuxServicesEventType)event.getType()) {
            case APPLICATION_INIT: {
                LOG.info((Object)("Got APPLICATION_INIT for service " + event.getServiceID()));
                AuxiliaryService service = this.serviceMap.get(event.getServiceID());
                if (null == service) {
                    LOG.info((Object)"service is null");
                    return;
                }
                service.initApp(event.getUser(), event.getApplicationID(), event.getServiceData());
                break;
            }
            case APPLICATION_STOP: {
                for (AuxiliaryService serv : this.serviceMap.values()) {
                    serv.stopApp(event.getApplicationID());
                }
                break;
            }
            default: {
                throw new RuntimeException("Unknown type: " + event.getType());
            }
        }
    }

    public static interface AuxiliaryService
    extends Service {
        public void initApp(String var1, ApplicationId var2, ByteBuffer var3);

        public void stopApp(ApplicationId var1);

        public ByteBuffer getMeta();
    }
}

