/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceStateChangeListener;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.api.ApplicationInitializationContext;
import org.apache.hadoop.yarn.server.api.ApplicationTerminationContext;
import org.apache.hadoop.yarn.server.api.AuxiliaryService;
import org.apache.hadoop.yarn.server.api.ContainerInitializationContext;
import org.apache.hadoop.yarn.server.api.ContainerTerminationContext;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServicesEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServicesEventType;

public class AuxServices
extends AbstractService
implements ServiceStateChangeListener,
EventHandler<AuxServicesEvent> {
    private static final Log LOG = LogFactory.getLog(AuxServices.class);
    protected final Map<String, AuxiliaryService> serviceMap = Collections.synchronizedMap(new HashMap());
    protected final Map<String, ByteBuffer> serviceMetaData = Collections.synchronizedMap(new HashMap());

    public AuxServices() {
        super(AuxServices.class.getName());
    }

    protected final synchronized void addService(String name, AuxiliaryService service) {
        LOG.info((Object)("Adding auxiliary service " + service.getName() + ", \"" + name + "\""));
        this.serviceMap.put(name, service);
    }

    Collection<AuxiliaryService> getServices() {
        return Collections.unmodifiableCollection(this.serviceMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ByteBuffer> getMetaData() {
        HashMap<String, ByteBuffer> metaClone = new HashMap<String, ByteBuffer>(this.serviceMetaData.size());
        Map<String, ByteBuffer> map = this.serviceMetaData;
        synchronized (map) {
            for (Map.Entry<String, ByteBuffer> entry : this.serviceMetaData.entrySet()) {
                metaClone.put(entry.getKey(), entry.getValue().duplicate());
            }
        }
        return metaClone;
    }

    public void serviceInit(Configuration conf) throws Exception {
        Collection auxNames = conf.getStringCollection("yarn.nodemanager.aux-services");
        for (String sName : auxNames) {
            try {
                Class sClass = conf.getClass(String.format("yarn.nodemanager.aux-services.%s.class", sName), null, AuxiliaryService.class);
                if (null == sClass) {
                    throw new RuntimeException("No class defined for " + sName);
                }
                AuxiliaryService s = (AuxiliaryService)ReflectionUtils.newInstance((Class)sClass, (Configuration)conf);
                if (!sName.equals(s.getName())) {
                    LOG.warn((Object)("The Auxilurary Service named '" + sName + "' in the " + "configuration is for class " + sClass + " which has " + "a name of '" + s.getName() + "'. Because these are " + "not the same tools trying to send ServiceData and read " + "Service Meta Data may have issues unless the refer to " + "the name in the config."));
                }
                this.addService(sName, s);
                s.init(conf);
            }
            catch (RuntimeException e) {
                LOG.fatal((Object)("Failed to initialize " + sName), (Throwable)e);
                throw e;
            }
        }
        super.serviceInit(conf);
    }

    public void serviceStart() throws Exception {
        for (Map.Entry<String, AuxiliaryService> entry : this.serviceMap.entrySet()) {
            AuxiliaryService service = entry.getValue();
            String name = entry.getKey();
            service.start();
            service.registerServiceListener((ServiceStateChangeListener)this);
            ByteBuffer meta = service.getMetaData();
            if (meta == null) continue;
            this.serviceMetaData.put(name, meta);
        }
        super.serviceStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceStop() throws Exception {
        try {
            Map<String, AuxiliaryService> map = this.serviceMap;
            synchronized (map) {
                for (AuxiliaryService service : this.serviceMap.values()) {
                    if (service.getServiceState() != Service.STATE.STARTED) continue;
                    service.unregisterServiceListener((ServiceStateChangeListener)this);
                    service.stop();
                }
                this.serviceMap.clear();
                this.serviceMetaData.clear();
            }
        }
        finally {
            super.serviceStop();
        }
    }

    public void stateChanged(Service service) {
        LOG.fatal((Object)("Service " + service.getName() + " changed state: " + service.getServiceState()));
        this.stop();
    }

    public void handle(AuxServicesEvent event) {
        LOG.info((Object)("Got event " + event.getType() + " for appId " + event.getApplicationID()));
        switch ((AuxServicesEventType)event.getType()) {
            case APPLICATION_INIT: {
                LOG.info((Object)("Got APPLICATION_INIT for service " + event.getServiceID()));
                AuxiliaryService service = this.serviceMap.get(event.getServiceID());
                if (null == service) {
                    LOG.info((Object)"service is null");
                    return;
                }
                service.initializeApplication(new ApplicationInitializationContext(event.getUser(), event.getApplicationID(), event.getServiceData()));
                break;
            }
            case APPLICATION_STOP: {
                for (AuxiliaryService serv : this.serviceMap.values()) {
                    serv.stopApplication(new ApplicationTerminationContext(event.getApplicationID()));
                }
                break;
            }
            case CONTAINER_INIT: {
                for (AuxiliaryService serv : this.serviceMap.values()) {
                    serv.initializeContainer(new ContainerInitializationContext(event.getUser(), event.getContainer().getContainerId(), event.getContainer().getResource()));
                }
                break;
            }
            case CONTAINER_STOP: {
                for (AuxiliaryService serv : this.serviceMap.values()) {
                    serv.stopContainer(new ContainerTerminationContext(event.getUser(), event.getContainer().getContainerId(), event.getContainer().getResource()));
                }
                break;
            }
            default: {
                throw new RuntimeException("Unknown type: " + event.getType());
            }
        }
    }
}

