/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.ContainerManagerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerExitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerState;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainerLaunch;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainersLauncherEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainersLauncherEventType;

public class ContainersLauncher
extends AbstractService
implements EventHandler<ContainersLauncherEvent> {
    private static final Log LOG = LogFactory.getLog(ContainersLauncher.class);
    private final Context context;
    private final ContainerExecutor exec;
    private final Dispatcher dispatcher;
    private final ContainerManagerImpl containerManager;
    private LocalDirsHandlerService dirsHandler;
    @VisibleForTesting
    public ExecutorService containerLauncher = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("ContainersLauncher #%d").build());
    private final Map<ContainerId, RunningContainer> running = Collections.synchronizedMap(new HashMap());

    public ContainersLauncher(Context context, Dispatcher dispatcher, ContainerExecutor exec, LocalDirsHandlerService dirsHandler, ContainerManagerImpl containerManager) {
        super("containers-launcher");
        this.exec = exec;
        this.context = context;
        this.dispatcher = dispatcher;
        this.dirsHandler = dirsHandler;
        this.containerManager = containerManager;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        try {
            FileContext.getLocalFSFileContext((Configuration)conf);
        }
        catch (UnsupportedFileSystemException e) {
            throw new YarnRuntimeException("Failed to start ContainersLauncher", (Throwable)e);
        }
        super.serviceInit(conf);
    }

    protected void serviceStop() throws Exception {
        this.containerLauncher.shutdownNow();
        super.serviceStop();
    }

    public void handle(ContainersLauncherEvent event) {
        Container container = event.getContainer();
        ContainerId containerId = container.getContainerId();
        switch ((ContainersLauncherEventType)event.getType()) {
            case LAUNCH_CONTAINER: {
                Application app = (Application)this.context.getApplications().get(containerId.getApplicationAttemptId().getApplicationId());
                ContainerLaunch launch = new ContainerLaunch(this.context, this.getConfig(), this.dispatcher, this.exec, app, event.getContainer(), this.dirsHandler, this.containerManager);
                this.running.put(containerId, new RunningContainer(this.containerLauncher.submit(launch), launch));
                break;
            }
            case CLEANUP_CONTAINER: {
                RunningContainer rContainerDatum = this.running.remove(containerId);
                if (rContainerDatum == null) {
                    return;
                }
                Future<Integer> rContainer = rContainerDatum.runningcontainer;
                if (rContainer != null && !rContainer.isDone() && rContainer.cancel(false) && container.getContainerState() == ContainerState.KILLING) {
                    this.dispatcher.getEventHandler().handle((Event)new ContainerExitEvent(containerId, ContainerEventType.CONTAINER_KILLED_ON_REQUEST, Shell.WINDOWS ? ContainerExecutor.ExitCode.FORCE_KILLED.getExitCode() : ContainerExecutor.ExitCode.TERMINATED.getExitCode(), "Container terminated before launch."));
                }
                try {
                    rContainerDatum.launcher.cleanupContainer();
                    break;
                }
                catch (IOException e) {
                    LOG.warn((Object)("Got exception while cleaning container " + containerId + ". Ignoring."));
                }
            }
        }
    }

    private static final class RunningContainer {
        Future<Integer> runningcontainer;
        ContainerLaunch launcher;

        public RunningContainer(Future<Integer> submit, ContainerLaunch launcher) {
            this.runningcontainer = submit;
            this.launcher = launcher;
        }
    }
}

