/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.scheduler;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.ResourceUtilization;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.api.records.ContainerQueuingLimit;
import org.apache.hadoop.yarn.server.api.records.OpportunisticContainersStatus;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerState;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ChangeMonitoringContainerResourceEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainersMonitor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.scheduler.AllocationBasedResourceUtilizationTracker;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.scheduler.ContainerSchedulerEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.scheduler.ContainerSchedulerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.scheduler.ResourceUtilizationTracker;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.scheduler.UpdateContainerSchedulerEvent;
import org.apache.hadoop.yarn.server.nodemanager.metrics.NodeManagerMetrics;
import org.apache.hadoop.yarn.server.nodemanager.recovery.NMStateStoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerScheduler
extends AbstractService
implements EventHandler<ContainerSchedulerEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerScheduler.class);
    private final Context context;
    private final int maxOppQueueLength;
    private final LinkedHashMap<ContainerId, Container> queuedGuaranteedContainers = new LinkedHashMap();
    private final LinkedHashMap<ContainerId, Container> queuedOpportunisticContainers = new LinkedHashMap();
    private final Map<ContainerId, Container> oppContainersToKill = new HashMap<ContainerId, Container>();
    private final LinkedHashMap<ContainerId, Container> runningContainers = new LinkedHashMap();
    private final ContainerQueuingLimit queuingLimit = ContainerQueuingLimit.newInstance();
    private final OpportunisticContainersStatus opportunisticContainersStatus;
    private ResourceUtilizationTracker utilizationTracker;
    private final AsyncDispatcher dispatcher;
    private final NodeManagerMetrics metrics;
    private Boolean usePauseEventForPreemption = false;

    public ContainerScheduler(Context context, AsyncDispatcher dispatcher, NodeManagerMetrics metrics) {
        this(context, dispatcher, metrics, context.getConf().getInt("yarn.nodemanager.opportunistic-containers-max-queue-length", 0));
    }

    public void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        this.usePauseEventForPreemption = conf.getBoolean("yarn.nodemanager.opportunistic-containers-use-pause-for-preemption", false);
    }

    @VisibleForTesting
    public ContainerScheduler(Context context, AsyncDispatcher dispatcher, NodeManagerMetrics metrics, int qLength) {
        super(ContainerScheduler.class.getName());
        this.context = context;
        this.dispatcher = dispatcher;
        this.metrics = metrics;
        this.maxOppQueueLength = qLength <= 0 ? 0 : qLength;
        this.utilizationTracker = new AllocationBasedResourceUtilizationTracker(this);
        this.opportunisticContainersStatus = OpportunisticContainersStatus.newInstance();
    }

    public void handle(ContainerSchedulerEvent event) {
        switch ((ContainerSchedulerEventType)event.getType()) {
            case SCHEDULE_CONTAINER: {
                this.scheduleContainer(event.getContainer());
                break;
            }
            case CONTAINER_PAUSED: 
            case CONTAINER_COMPLETED: {
                this.onResourcesReclaimed(event.getContainer());
                break;
            }
            case UPDATE_CONTAINER: {
                if (event instanceof UpdateContainerSchedulerEvent) {
                    this.onUpdateContainer((UpdateContainerSchedulerEvent)event);
                    break;
                }
                LOG.error("Unknown event type on UpdateCOntainer: " + event.getType());
                break;
            }
            case SHED_QUEUED_CONTAINERS: {
                this.shedQueuedOpportunisticContainers();
                break;
            }
            case RECOVERY_COMPLETED: {
                this.startPendingContainers(this.maxOppQueueLength <= 0);
            }
            default: {
                LOG.error("Unknown event arrived at ContainerScheduler: " + event.toString());
            }
        }
    }

    private void onUpdateContainer(UpdateContainerSchedulerEvent updateEvent) {
        ContainerId containerId = updateEvent.getContainer().getContainerId();
        if (updateEvent.isResourceChange() && this.runningContainers.containsKey(containerId)) {
            this.utilizationTracker.subtractContainerResource(new ContainerImpl(this.getConfig(), null, null, null, null, updateEvent.getOriginalToken(), this.context));
            this.utilizationTracker.addContainerResources(updateEvent.getContainer());
            this.getContainersMonitor().handle((Event)new ChangeMonitoringContainerResourceEvent(containerId, updateEvent.getUpdatedToken().getResource()));
        }
        if (updateEvent.isExecTypeUpdate()) {
            if (updateEvent.isIncrease()) {
                if (this.queuedOpportunisticContainers.remove(containerId) != null) {
                    this.queuedGuaranteedContainers.put(containerId, updateEvent.getContainer());
                    this.reclaimOpportunisticContainerResources(updateEvent.getContainer());
                }
            } else if (this.queuedGuaranteedContainers.remove(containerId) != null) {
                this.queuedOpportunisticContainers.put(containerId, updateEvent.getContainer());
            }
            this.startPendingContainers(this.maxOppQueueLength <= 0);
        }
    }

    public void recoverActiveContainer(Container container, NMStateStoreService.RecoveredContainerState rcs) {
        ExecutionType execType = container.getContainerTokenIdentifier().getExecutionType();
        if (rcs.getStatus() == NMStateStoreService.RecoveredContainerStatus.QUEUED || rcs.getStatus() == NMStateStoreService.RecoveredContainerStatus.PAUSED) {
            if (execType == ExecutionType.GUARANTEED) {
                this.queuedGuaranteedContainers.put(container.getContainerId(), container);
            } else if (execType == ExecutionType.OPPORTUNISTIC) {
                this.queuedOpportunisticContainers.put(container.getContainerId(), container);
            } else {
                LOG.error("UnKnown execution type received " + container.getContainerId() + ", execType " + execType);
            }
        } else if (rcs.getStatus() == NMStateStoreService.RecoveredContainerStatus.LAUNCHED) {
            this.runningContainers.put(container.getContainerId(), container);
            this.utilizationTracker.addContainerResources(container);
        }
        if (rcs.getStatus() != NMStateStoreService.RecoveredContainerStatus.COMPLETED && rcs.getCapability() != null) {
            this.metrics.launchedContainer();
            this.metrics.allocateContainer(rcs.getCapability());
        }
    }

    public int getNumQueuedContainers() {
        return this.queuedGuaranteedContainers.size() + this.queuedOpportunisticContainers.size();
    }

    @VisibleForTesting
    public int getNumQueuedGuaranteedContainers() {
        return this.queuedGuaranteedContainers.size();
    }

    @VisibleForTesting
    public int getNumQueuedOpportunisticContainers() {
        return this.queuedOpportunisticContainers.size();
    }

    @VisibleForTesting
    public int getNumRunningContainers() {
        return this.runningContainers.size();
    }

    @VisibleForTesting
    public void setUsePauseEventForPreemption(boolean usePauseEventForPreemption) {
        this.usePauseEventForPreemption = usePauseEventForPreemption;
    }

    public OpportunisticContainersStatus getOpportunisticContainersStatus() {
        this.opportunisticContainersStatus.setQueuedOpportContainers(this.getNumQueuedOpportunisticContainers());
        this.opportunisticContainersStatus.setWaitQueueLength(this.getNumQueuedContainers());
        this.opportunisticContainersStatus.setOpportMemoryUsed(this.metrics.getAllocatedOpportunisticGB());
        this.opportunisticContainersStatus.setOpportCoresUsed(this.metrics.getAllocatedOpportunisticVCores());
        this.opportunisticContainersStatus.setRunningOpportContainers(this.metrics.getRunningOpportunisticContainers());
        return this.opportunisticContainersStatus;
    }

    private void onResourcesReclaimed(Container container) {
        Container completedContainer;
        boolean resourceReleased;
        this.oppContainersToKill.remove(container.getContainerId());
        Container queued = (Container)this.queuedOpportunisticContainers.remove(container.getContainerId());
        if (queued == null) {
            this.queuedGuaranteedContainers.remove(container.getContainerId());
        }
        if (container.getContainerState() == ContainerState.PAUSED) {
            if (container.getContainerTokenIdentifier().getExecutionType() == ExecutionType.GUARANTEED) {
                this.queuedGuaranteedContainers.put(container.getContainerId(), container);
            } else {
                this.queuedOpportunisticContainers.put(container.getContainerId(), container);
            }
        }
        boolean bl = resourceReleased = (completedContainer = (Container)this.runningContainers.remove(container.getContainerId())) != null;
        if (resourceReleased) {
            this.utilizationTracker.subtractContainerResource(container);
            if (container.getContainerTokenIdentifier().getExecutionType() == ExecutionType.OPPORTUNISTIC) {
                this.metrics.completeOpportunisticContainer(container.getResource());
            }
            boolean forceStartGuaranteedContainers = this.maxOppQueueLength <= 0;
            this.startPendingContainers(forceStartGuaranteedContainers);
        }
    }

    private void startPendingContainers(boolean forceStartGuaranteedContaieners) {
        boolean resourcesAvailable = this.startContainers(this.queuedGuaranteedContainers.values(), forceStartGuaranteedContaieners);
        if (resourcesAvailable) {
            this.startContainers(this.queuedOpportunisticContainers.values(), false);
        }
    }

    private boolean startContainers(Collection<Container> containersToBeStarted, boolean force) {
        Iterator<Container> cIter = containersToBeStarted.iterator();
        boolean resourcesAvailable = true;
        while (cIter.hasNext() && resourcesAvailable) {
            Container container = cIter.next();
            if (this.tryStartContainer(container, force)) {
                cIter.remove();
                continue;
            }
            resourcesAvailable = false;
        }
        return resourcesAvailable;
    }

    private boolean tryStartContainer(Container container, boolean force) {
        boolean containerStarted = false;
        if (force || this.resourceAvailableToStartContainer(container)) {
            this.startContainer(container);
            containerStarted = true;
        }
        return containerStarted;
    }

    private boolean resourceAvailableToStartContainer(Container container) {
        return this.utilizationTracker.hasResourcesAvailable(container);
    }

    private boolean enqueueContainer(Container container) {
        boolean isQueued;
        boolean isGuaranteedContainer;
        boolean bl = isGuaranteedContainer = container.getContainerTokenIdentifier().getExecutionType() == ExecutionType.GUARANTEED;
        if (isGuaranteedContainer) {
            this.queuedGuaranteedContainers.put(container.getContainerId(), container);
            isQueued = true;
        } else if (this.queuedOpportunisticContainers.size() < this.maxOppQueueLength) {
            LOG.info("Opportunistic container {} will be queued at the NM.", (Object)container.getContainerId());
            this.queuedOpportunisticContainers.put(container.getContainerId(), container);
            isQueued = true;
        } else {
            LOG.info("Opportunistic container [{}] will not be queued at the NMsince max queue length [{}] has been reached", (Object)container.getContainerId(), (Object)this.maxOppQueueLength);
            container.sendKillEvent(-108, "Opportunistic container queue is full.");
            isQueued = false;
        }
        if (isQueued) {
            try {
                this.context.getNMStateStore().storeContainerQueued(container.getContainerId());
            }
            catch (IOException e) {
                LOG.warn("Could not store container [" + container.getContainerId() + "] state. The Container has been queued.", (Throwable)e);
            }
        }
        return isQueued;
    }

    @VisibleForTesting
    protected void scheduleContainer(Container container) {
        boolean isGuaranteedContainer;
        boolean bl = isGuaranteedContainer = container.getContainerTokenIdentifier().getExecutionType() == ExecutionType.GUARANTEED;
        if (isGuaranteedContainer) {
            this.enqueueContainer(container);
            boolean forceStartGuaranteedContainers = this.maxOppQueueLength <= 0;
            this.startPendingContainers(forceStartGuaranteedContainers);
            if (this.queuedGuaranteedContainers.containsKey(container.getContainerId())) {
                this.reclaimOpportunisticContainerResources(container);
            }
        } else {
            this.startPendingContainers(false);
            boolean containerQueued = this.enqueueContainer(container);
            if (containerQueued) {
                this.startPendingContainers(false);
            }
        }
    }

    private void reclaimOpportunisticContainerResources(Container container) {
        List<Container> extraOppContainersToReclaim = this.pickOpportunisticContainersToReclaimResources(container.getContainerId());
        for (Container contToReclaim : extraOppContainersToReclaim) {
            String preemptionAction = this.usePauseEventForPreemption == true ? "paused" : "resumed";
            LOG.info("Container {} will be {} to start the execution of guaranteed container {}.", new Object[]{contToReclaim.getContainerId(), preemptionAction, container.getContainerId()});
            if (this.usePauseEventForPreemption.booleanValue()) {
                contToReclaim.sendPauseEvent("Container Paused to make room for Guaranteed Container");
            } else {
                contToReclaim.sendKillEvent(-108, "Container Killed to make room for Guaranteed Container.");
            }
            this.oppContainersToKill.put(contToReclaim.getContainerId(), contToReclaim);
        }
    }

    private void startContainer(Container container) {
        LOG.info("Starting container [" + container.getContainerId() + "]");
        this.runningContainers.put(container.getContainerId(), container);
        this.utilizationTracker.addContainerResources(container);
        if (container.getContainerTokenIdentifier().getExecutionType() == ExecutionType.OPPORTUNISTIC) {
            this.metrics.startOpportunisticContainer(container.getResource());
        }
        container.sendLaunchEvent();
    }

    private List<Container> pickOpportunisticContainersToReclaimResources(ContainerId containerToStartId) {
        ArrayList<Container> extraOpportContainersToKill = new ArrayList<Container>();
        ResourceUtilization resourcesToFreeUp = this.resourcesToFreeUp(containerToStartId);
        Iterator<Container> lifoIterator = new LinkedList<Container>(this.runningContainers.values()).descendingIterator();
        while (lifoIterator.hasNext() && !this.hasSufficientResources(resourcesToFreeUp)) {
            Container runningCont = lifoIterator.next();
            if (runningCont.getContainerTokenIdentifier().getExecutionType() != ExecutionType.OPPORTUNISTIC || this.oppContainersToKill.containsKey(runningCont.getContainerId())) continue;
            extraOpportContainersToKill.add(runningCont);
            ContainersMonitor.ContainerManagerUtils.decreaseResourceUtilization(this.getContainersMonitor(), resourcesToFreeUp, runningCont.getResource());
        }
        if (!this.hasSufficientResources(resourcesToFreeUp)) {
            LOG.warn("There are no sufficient resources to start guaranteed [{}]at the moment. Opportunistic containers are in the process ofbeing killed to make room.", (Object)containerToStartId);
        }
        return extraOpportContainersToKill;
    }

    private boolean hasSufficientResources(ResourceUtilization resourcesToFreeUp) {
        return resourcesToFreeUp.getPhysicalMemory() <= 0 && resourcesToFreeUp.getVirtualMemory() <= 0 && Math.round(resourcesToFreeUp.getCPU() * (float)this.getContainersMonitor().getVCoresAllocatedForContainers()) <= 0;
    }

    private ResourceUtilization resourcesToFreeUp(ContainerId containerToStartId) {
        ResourceUtilization resourceAllocationToFreeUp = ResourceUtilization.newInstance((ResourceUtilization)this.utilizationTracker.getCurrentUtilization());
        for (Container container : this.queuedGuaranteedContainers.values()) {
            ContainersMonitor.ContainerManagerUtils.increaseResourceUtilization(this.getContainersMonitor(), resourceAllocationToFreeUp, container.getResource());
            if (!container.getContainerId().equals((Object)containerToStartId)) continue;
            break;
        }
        for (Container container : this.oppContainersToKill.values()) {
            ContainersMonitor.ContainerManagerUtils.decreaseResourceUtilization(this.getContainersMonitor(), resourceAllocationToFreeUp, container.getResource());
        }
        this.getContainersMonitor().subtractNodeResourcesFromResourceUtilization(resourceAllocationToFreeUp);
        return resourceAllocationToFreeUp;
    }

    public void updateQueuingLimit(ContainerQueuingLimit limit) {
        this.queuingLimit.setMaxQueueLength(limit.getMaxQueueLength());
        if (this.queuingLimit.getMaxQueueLength() > -1 && this.queuingLimit.getMaxQueueLength() < this.queuedOpportunisticContainers.size()) {
            this.dispatcher.getEventHandler().handle((Event)new ContainerSchedulerEvent(null, ContainerSchedulerEventType.SHED_QUEUED_CONTAINERS));
        }
    }

    private void shedQueuedOpportunisticContainers() {
        int numAllowed = this.queuingLimit.getMaxQueueLength();
        Iterator<Container> containerIter = this.queuedOpportunisticContainers.values().iterator();
        while (containerIter.hasNext()) {
            Container container = containerIter.next();
            if (container.getContainerState() == ContainerState.PAUSED) continue;
            if (numAllowed <= 0) {
                container.sendKillEvent(-108, "Container De-queued to meet NM queuing limits.");
                containerIter.remove();
                LOG.info("Opportunistic container {} will be killed to meet NM queuing limits.", (Object)container.getContainerId());
            }
            --numAllowed;
        }
    }

    public ContainersMonitor getContainersMonitor() {
        return this.context.getContainerManager().getContainersMonitor();
    }

    @VisibleForTesting
    public ResourceUtilization getCurrentUtilization() {
        return this.utilizationTracker.getCurrentUtilization();
    }
}

