/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.VersionUtil;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceUtilization;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factories.impl.pb.RecordFactoryPBImpl;
import org.apache.hadoop.yarn.nodelabels.CommonNodeLabelsManager;
import org.apache.hadoop.yarn.server.api.ResourceTracker;
import org.apache.hadoop.yarn.server.api.ServerRMProxy;
import org.apache.hadoop.yarn.server.api.protocolrecords.LogAggregationReport;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.UnRegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.api.records.NodeAction;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.NodeHealthCheckerService;
import org.apache.hadoop.yarn.server.nodemanager.NodeResourceMonitorImpl;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdater;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.ContainerManagerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationState;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerState;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainersMonitor;
import org.apache.hadoop.yarn.server.nodemanager.metrics.NodeManagerMetrics;
import org.apache.hadoop.yarn.server.nodemanager.nodelabels.NodeLabelsProvider;
import org.apache.hadoop.yarn.server.nodemanager.util.NodeManagerHardwareUtils;
import org.apache.hadoop.yarn.util.YarnVersionInfo;
import org.apache.hadoop.yarn.util.resource.Resources;

public class NodeStatusUpdaterImpl
extends AbstractService
implements NodeStatusUpdater {
    public static final String YARN_NODEMANAGER_DURATION_TO_TRACK_STOPPED_CONTAINERS = "yarn.nodemanager.duration-to-track-stopped-containers";
    private static final Log LOG = LogFactory.getLog(NodeStatusUpdaterImpl.class);
    private final Object heartbeatMonitor = new Object();
    private final Object shutdownMonitor = new Object();
    private final Context context;
    private final Dispatcher dispatcher;
    private NodeId nodeId;
    private long nextHeartBeatInterval;
    private ResourceTracker resourceTracker;
    private Resource totalResource;
    private int httpPort;
    private String nodeManagerVersionId;
    private String minimumResourceManagerVersion;
    private volatile boolean isStopped;
    private boolean tokenKeepAliveEnabled;
    private long tokenRemovalDelayMs;
    private Map<ApplicationId, Long> appTokenKeepAliveMap = new HashMap<ApplicationId, Long>();
    private Random keepAliveDelayRandom = new Random();
    private final Map<ContainerId, Long> recentlyStoppedContainers;
    private final Map<ContainerId, ContainerStatus> pendingCompletedContainers;
    private long durationToTrackStoppedContainers;
    private boolean logAggregationEnabled;
    private final List<LogAggregationReport> logAggregationReportForAppsTempList;
    private final NodeHealthCheckerService healthChecker;
    private final NodeManagerMetrics metrics;
    private Runnable statusUpdaterRunnable;
    private Thread statusUpdater;
    private boolean failedToConnect = false;
    private long rmIdentifier = -1L;
    private boolean registeredWithRM = false;
    Set<ContainerId> pendingContainersToRemove = new HashSet<ContainerId>();
    private NMNodeLabelsHandler nodeLabelsHandler;
    private final NodeLabelsProvider nodeLabelsProvider;

    public NodeStatusUpdaterImpl(Context context, Dispatcher dispatcher, NodeHealthCheckerService healthChecker, NodeManagerMetrics metrics) {
        this(context, dispatcher, healthChecker, metrics, null);
    }

    public NodeStatusUpdaterImpl(Context context, Dispatcher dispatcher, NodeHealthCheckerService healthChecker, NodeManagerMetrics metrics, NodeLabelsProvider nodeLabelsProvider) {
        super(NodeStatusUpdaterImpl.class.getName());
        this.healthChecker = healthChecker;
        this.context = context;
        this.dispatcher = dispatcher;
        this.nodeLabelsProvider = nodeLabelsProvider;
        this.metrics = metrics;
        this.recentlyStoppedContainers = new LinkedHashMap<ContainerId, Long>();
        this.pendingCompletedContainers = new HashMap<ContainerId, ContainerStatus>();
        this.logAggregationReportForAppsTempList = new ArrayList<LogAggregationReport>();
    }

    protected void serviceInit(Configuration conf) throws Exception {
        int memoryMb = NodeManagerHardwareUtils.getContainerMemoryMB(conf);
        float vMemToPMem = conf.getFloat("yarn.nodemanager.vmem-pmem-ratio", 2.1f);
        int virtualMemoryMb = (int)Math.ceil((float)memoryMb * vMemToPMem);
        int virtualCores = NodeManagerHardwareUtils.getVCores(conf);
        LOG.info((Object)("Nodemanager resources: memory set to " + memoryMb + "MB."));
        LOG.info((Object)("Nodemanager resources: vcores set to " + virtualCores + "."));
        this.totalResource = Resource.newInstance((int)memoryMb, (int)virtualCores);
        this.metrics.addResource(this.totalResource);
        this.tokenKeepAliveEnabled = this.isTokenKeepAliveEnabled(conf);
        this.tokenRemovalDelayMs = conf.getInt("yarn.nm.liveness-monitor.expiry-interval-ms", 600000);
        this.minimumResourceManagerVersion = conf.get("yarn.nodemanager.resourcemanager.minimum.version", "NONE");
        this.nodeLabelsHandler = this.createNMNodeLabelsHandler(this.nodeLabelsProvider);
        this.durationToTrackStoppedContainers = conf.getLong(YARN_NODEMANAGER_DURATION_TO_TRACK_STOPPED_CONTAINERS, 600000L);
        if (this.durationToTrackStoppedContainers < 0L) {
            String message = "Invalid configuration for yarn.nodemanager.duration-to-track-stopped-containers default value is 10Min(600000).";
            LOG.error((Object)message);
            throw new YarnException(message);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("yarn.nodemanager.duration-to-track-stopped-containers :" + this.durationToTrackStoppedContainers));
        }
        super.serviceInit(conf);
        LOG.info((Object)("Initialized nodemanager with : physical-memory=" + memoryMb + " virtual-memory=" + virtualMemoryMb + " virtual-cores=" + virtualCores));
        this.logAggregationEnabled = conf.getBoolean("yarn.log-aggregation-enable", false);
    }

    protected void serviceStart() throws Exception {
        this.nodeId = this.context.getNodeId();
        LOG.info((Object)("Node ID assigned is : " + this.nodeId));
        this.httpPort = this.context.getHttpPort();
        this.nodeManagerVersionId = YarnVersionInfo.getVersion();
        try {
            this.resourceTracker = this.getRMClient();
            this.registerWithRM();
            super.serviceStart();
            this.startStatusUpdater();
        }
        catch (Exception e) {
            String errorMessage = "Unexpected error starting NodeStatusUpdater";
            LOG.error((Object)errorMessage, (Throwable)e);
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceStop() throws Exception {
        Object object = this.shutdownMonitor;
        synchronized (object) {
            if (!(!this.registeredWithRM || this.isStopped || this.isNMUnderSupervisionWithRecoveryEnabled() || this.context.getDecommissioned() || this.failedToConnect)) {
                this.unRegisterNM();
            }
            this.isStopped = true;
            this.stopRMProxy();
            super.serviceStop();
        }
    }

    private boolean isNMUnderSupervisionWithRecoveryEnabled() {
        Configuration config = this.getConfig();
        return config.getBoolean("yarn.nodemanager.recovery.enabled", false) && config.getBoolean("yarn.nodemanager.recovery.supervised", false);
    }

    private void unRegisterNM() {
        RecordFactory recordFactory = RecordFactoryPBImpl.get();
        UnRegisterNodeManagerRequest request = (UnRegisterNodeManagerRequest)recordFactory.newRecordInstance(UnRegisterNodeManagerRequest.class);
        request.setNodeId(this.nodeId);
        try {
            this.resourceTracker.unRegisterNodeManager(request);
            LOG.info((Object)("Successfully Unregistered the Node " + this.nodeId + " with ResourceManager."));
        }
        catch (Exception e) {
            LOG.warn((Object)("Unregistration of the Node " + this.nodeId + " failed."), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebootNodeStatusUpdaterAndRegisterWithRM() {
        Object object = this.shutdownMonitor;
        synchronized (object) {
            if (this.isStopped) {
                LOG.info((Object)"Currently being shutdown. Aborting reboot");
                return;
            }
            this.isStopped = true;
            this.sendOutofBandHeartBeat();
            try {
                this.statusUpdater.join();
                this.registerWithRM();
                this.statusUpdater = new Thread(this.statusUpdaterRunnable, "Node Status Updater");
                this.statusUpdater.start();
                this.isStopped = false;
                LOG.info((Object)"NodeStatusUpdater thread is reRegistered and restarted");
            }
            catch (Exception e) {
                String errorMessage = "Unexpected error rebooting NodeStatusUpdater";
                LOG.error((Object)errorMessage, (Throwable)e);
                throw new YarnRuntimeException((Throwable)e);
            }
        }
    }

    @VisibleForTesting
    protected void stopRMProxy() {
        if (this.resourceTracker != null) {
            RPC.stopProxy((Object)this.resourceTracker);
        }
    }

    @InterfaceAudience.Private
    protected boolean isTokenKeepAliveEnabled(Configuration conf) {
        return conf.getBoolean("yarn.log-aggregation-enable", false) && UserGroupInformation.isSecurityEnabled();
    }

    @VisibleForTesting
    protected ResourceTracker getRMClient() throws IOException {
        Configuration conf = this.getConfig();
        return (ResourceTracker)ServerRMProxy.createRMProxy((Configuration)conf, ResourceTracker.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void registerWithRM() throws YarnException, IOException {
        RegisterNodeManagerResponse regNMResponse;
        Set<NodeLabel> nodeLabels = this.nodeLabelsHandler.getNodeLabelsForRegistration();
        Context context = this.context;
        synchronized (context) {
            List<NMContainerStatus> containerReports = this.getNMContainerStatuses();
            RegisterNodeManagerRequest request = RegisterNodeManagerRequest.newInstance((NodeId)this.nodeId, (int)this.httpPort, (Resource)this.totalResource, (String)this.nodeManagerVersionId, containerReports, this.getRunningApplications(), nodeLabels);
            if (containerReports != null) {
                LOG.info((Object)("Registering with RM using containers :" + containerReports));
            }
            regNMResponse = this.resourceTracker.registerNodeManager(request);
            this.rmIdentifier = regNMResponse.getRMIdentifier();
        }
        if (NodeAction.SHUTDOWN.equals((Object)regNMResponse.getNodeAction())) {
            String message = "Message from ResourceManager: " + regNMResponse.getDiagnosticsMessage();
            throw new YarnRuntimeException("Recieved SHUTDOWN signal from Resourcemanager, Registration of NodeManager failed, " + message);
        }
        if (!this.minimumResourceManagerVersion.equals("NONE")) {
            String message;
            String rmVersion;
            if (this.minimumResourceManagerVersion.equals("EqualToNM")) {
                this.minimumResourceManagerVersion = this.nodeManagerVersionId;
            }
            if ((rmVersion = regNMResponse.getRMVersion()) == null) {
                message = "The Resource Manager's did not return a version. Valid version cannot be checked.";
                throw new YarnRuntimeException("Shutting down the Node Manager. " + message);
            }
            if (VersionUtil.compareVersions((String)rmVersion, (String)this.minimumResourceManagerVersion) < 0) {
                message = "The Resource Manager's version (" + rmVersion + ") is less than the minimum " + "allowed version " + this.minimumResourceManagerVersion;
                throw new YarnRuntimeException("Shutting down the Node Manager on RM version error, " + message);
            }
        }
        this.registeredWithRM = true;
        MasterKey masterKey = regNMResponse.getContainerTokenMasterKey();
        if (masterKey != null) {
            this.context.getContainerTokenSecretManager().setMasterKey(masterKey);
        }
        if ((masterKey = regNMResponse.getNMTokenMasterKey()) != null) {
            this.context.getNMTokenSecretManager().setMasterKey(masterKey);
        }
        StringBuilder successfullRegistrationMsg = new StringBuilder();
        successfullRegistrationMsg.append("Registered with ResourceManager as ").append(this.nodeId);
        Resource newResource = regNMResponse.getResource();
        if (newResource != null) {
            this.updateNMResource(newResource);
            successfullRegistrationMsg.append(" with updated total resource of ").append(this.totalResource);
        } else {
            successfullRegistrationMsg.append(" with total resource of ").append(this.totalResource);
        }
        successfullRegistrationMsg.append(this.nodeLabelsHandler.verifyRMRegistrationResponseForNodeLabels(regNMResponse));
        LOG.info((Object)successfullRegistrationMsg);
        LOG.info((Object)"Notifying ContainerManager to unblock new container-requests");
        ((ContainerManagerImpl)this.context.getContainerManager()).setBlockNewContainerRequests(false);
    }

    private List<ApplicationId> createKeepAliveApplicationList() {
        if (!this.tokenKeepAliveEnabled) {
            return Collections.emptyList();
        }
        ArrayList<ApplicationId> appList = new ArrayList<ApplicationId>();
        Iterator<Map.Entry<ApplicationId, Long>> i = this.appTokenKeepAliveMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<ApplicationId, Long> e = i.next();
            ApplicationId appId = e.getKey();
            Long nextKeepAlive = e.getValue();
            if (!this.context.getApplications().containsKey(appId)) {
                i.remove();
                continue;
            }
            if (System.currentTimeMillis() <= nextKeepAlive) continue;
            appList.add(appId);
            this.trackAppForKeepAlive(appId);
        }
        return appList;
    }

    @VisibleForTesting
    protected NodeStatus getNodeStatus(int responseId) throws IOException {
        NodeHealthStatus nodeHealthStatus = this.context.getNodeHealthStatus();
        nodeHealthStatus.setHealthReport(this.healthChecker.getHealthReport());
        nodeHealthStatus.setIsNodeHealthy(this.healthChecker.isHealthy());
        nodeHealthStatus.setLastHealthReportTime(this.healthChecker.getLastHealthReportTime());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Node's health-status : " + nodeHealthStatus.getIsNodeHealthy() + ", " + nodeHealthStatus.getHealthReport()));
        }
        List<ContainerStatus> containersStatuses = this.getContainerStatuses();
        ResourceUtilization containersUtilization = this.getContainersUtilization();
        ResourceUtilization nodeUtilization = this.getNodeUtilization();
        List<org.apache.hadoop.yarn.api.records.Container> increasedContainers = this.getIncreasedContainers();
        NodeStatus nodeStatus = NodeStatus.newInstance((NodeId)this.nodeId, (int)responseId, containersStatuses, this.createKeepAliveApplicationList(), (NodeHealthStatus)nodeHealthStatus, (ResourceUtilization)containersUtilization, (ResourceUtilization)nodeUtilization, increasedContainers);
        return nodeStatus;
    }

    private ResourceUtilization getContainersUtilization() {
        ContainerManagerImpl containerManager = (ContainerManagerImpl)this.context.getContainerManager();
        ContainersMonitor containersMonitor = containerManager.getContainersMonitor();
        return containersMonitor.getContainersUtilization();
    }

    private ResourceUtilization getNodeUtilization() {
        NodeResourceMonitorImpl nodeResourceMonitor = (NodeResourceMonitorImpl)this.context.getNodeResourceMonitor();
        return nodeResourceMonitor.getUtilization();
    }

    private List<org.apache.hadoop.yarn.api.records.Container> getIncreasedContainers() {
        ArrayList<org.apache.hadoop.yarn.api.records.Container> increasedContainers = new ArrayList<org.apache.hadoop.yarn.api.records.Container>(this.context.getIncreasedContainers().values());
        for (org.apache.hadoop.yarn.api.records.Container container : increasedContainers) {
            this.context.getIncreasedContainers().remove(container.getId());
        }
        return increasedContainers;
    }

    private void updateNMResource(Resource resource) {
        this.metrics.addResource(Resources.subtract((Resource)resource, (Resource)this.totalResource));
        this.totalResource = resource;
    }

    @VisibleForTesting
    protected List<ContainerStatus> getContainerStatuses() throws IOException {
        ArrayList<ContainerStatus> containerStatuses = new ArrayList<ContainerStatus>();
        for (Container container : this.context.getContainers().values()) {
            ContainerId containerId = container.getContainerId();
            ApplicationId applicationId = containerId.getApplicationAttemptId().getApplicationId();
            ContainerStatus containerStatus = container.cloneAndGetContainerStatus();
            if (containerStatus.getState() == org.apache.hadoop.yarn.api.records.ContainerState.COMPLETE) {
                if (this.isApplicationStopped(applicationId)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(applicationId + " is completing, " + " remove " + containerId + " from NM context."));
                    }
                    this.context.getContainers().remove(containerId);
                    this.pendingCompletedContainers.put(containerId, containerStatus);
                } else if (!this.isContainerRecentlyStopped(containerId)) {
                    this.pendingCompletedContainers.put(containerId, containerStatus);
                }
                this.addCompletedContainer(containerId);
                continue;
            }
            containerStatuses.add(containerStatus);
        }
        containerStatuses.addAll(this.pendingCompletedContainers.values());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Sending out " + containerStatuses.size() + " container statuses: " + containerStatuses));
        }
        return containerStatuses;
    }

    private List<ApplicationId> getRunningApplications() {
        ArrayList<ApplicationId> runningApplications = new ArrayList<ApplicationId>();
        runningApplications.addAll(this.context.getApplications().keySet());
        return runningApplications;
    }

    private List<NMContainerStatus> getNMContainerStatuses() throws IOException {
        ArrayList<NMContainerStatus> containerStatuses = new ArrayList<NMContainerStatus>();
        for (Container container : this.context.getContainers().values()) {
            ContainerId containerId = container.getContainerId();
            ApplicationId applicationId = containerId.getApplicationAttemptId().getApplicationId();
            if (!this.context.getApplications().containsKey(applicationId)) {
                this.context.getContainers().remove(containerId);
                continue;
            }
            NMContainerStatus status = container.getNMContainerStatus();
            containerStatuses.add(status);
            if (status.getContainerState() != org.apache.hadoop.yarn.api.records.ContainerState.COMPLETE) continue;
            this.addCompletedContainer(containerId);
        }
        LOG.info((Object)("Sending out " + containerStatuses.size() + " NM container statuses: " + containerStatuses));
        return containerStatuses;
    }

    private boolean isApplicationStopped(ApplicationId applicationId) {
        if (!this.context.getApplications().containsKey(applicationId)) {
            return true;
        }
        ApplicationState applicationState = ((Application)this.context.getApplications().get(applicationId)).getApplicationState();
        return applicationState == ApplicationState.FINISHING_CONTAINERS_WAIT || applicationState == ApplicationState.APPLICATION_RESOURCES_CLEANINGUP || applicationState == ApplicationState.FINISHED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCompletedContainer(ContainerId containerId) {
        Map<ContainerId, Long> map = this.recentlyStoppedContainers;
        synchronized (map) {
            this.removeVeryOldStoppedContainersFromCache();
            if (!this.recentlyStoppedContainers.containsKey(containerId)) {
                this.recentlyStoppedContainers.put(containerId, System.currentTimeMillis() + this.durationToTrackStoppedContainers);
            }
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void removeOrTrackCompletedContainersFromContext(List<ContainerId> containerIds) throws IOException {
        HashSet<ContainerId> removedContainers = new HashSet<ContainerId>();
        this.pendingContainersToRemove.addAll(containerIds);
        Iterator<ContainerId> iter = this.pendingContainersToRemove.iterator();
        while (iter.hasNext()) {
            ContainerId containerId = iter.next();
            Container nmContainer = (Container)this.context.getContainers().get(containerId);
            if (nmContainer == null) {
                iter.remove();
                continue;
            }
            if (!nmContainer.getContainerState().equals((Object)ContainerState.DONE)) continue;
            this.context.getContainers().remove(containerId);
            removedContainers.add(containerId);
            iter.remove();
        }
        if (!removedContainers.isEmpty()) {
            LOG.info((Object)("Removed completed containers from NM context: " + removedContainers));
        }
        this.pendingCompletedContainers.clear();
    }

    private void trackAppsForKeepAlive(List<ApplicationId> appIds) {
        if (this.tokenKeepAliveEnabled && appIds != null && appIds.size() > 0) {
            for (ApplicationId appId : appIds) {
                this.trackAppForKeepAlive(appId);
            }
        }
    }

    private void trackAppForKeepAlive(ApplicationId appId) {
        long nextTime = System.currentTimeMillis() + (long)(0.7 * (double)this.tokenRemovalDelayMs + 0.2 * (double)this.tokenRemovalDelayMs * (double)this.keepAliveDelayRandom.nextInt(100) / 100.0);
        this.appTokenKeepAliveMap.put(appId, nextTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendOutofBandHeartBeat() {
        Object object = this.heartbeatMonitor;
        synchronized (object) {
            this.heartbeatMonitor.notify();
        }
    }

    @VisibleForTesting
    Thread.State getStatusUpdaterThreadState() {
        return this.statusUpdater.getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isContainerRecentlyStopped(ContainerId containerId) {
        Map<ContainerId, Long> map = this.recentlyStoppedContainers;
        synchronized (map) {
            return this.recentlyStoppedContainers.containsKey(containerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearFinishedContainersFromCache() {
        Map<ContainerId, Long> map = this.recentlyStoppedContainers;
        synchronized (map) {
            this.recentlyStoppedContainers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    @VisibleForTesting
    public void removeVeryOldStoppedContainersFromCache() {
        Map<ContainerId, Long> map = this.recentlyStoppedContainers;
        synchronized (map) {
            ContainerId cid;
            long currentTime = System.currentTimeMillis();
            Iterator<ContainerId> i = this.recentlyStoppedContainers.keySet().iterator();
            while (i.hasNext() && this.recentlyStoppedContainers.get(cid = i.next()) < currentTime) {
                if (this.context.getContainers().containsKey(cid)) continue;
                i.remove();
                try {
                    this.context.getNMStateStore().removeContainer(cid);
                }
                catch (IOException e) {
                    LOG.error((Object)("Unable to remove container " + cid + " in store"), (Throwable)e);
                }
            }
        }
    }

    @Override
    public long getRMIdentifier() {
        return this.rmIdentifier;
    }

    private static Map<ApplicationId, Credentials> parseCredentials(Map<ApplicationId, ByteBuffer> systemCredentials) throws IOException {
        HashMap<ApplicationId, Credentials> map = new HashMap<ApplicationId, Credentials>();
        for (Map.Entry<ApplicationId, ByteBuffer> entry : systemCredentials.entrySet()) {
            Credentials credentials = new Credentials();
            DataInputByteBuffer buf = new DataInputByteBuffer();
            ByteBuffer buffer = entry.getValue();
            buffer.rewind();
            buf.reset(new ByteBuffer[]{buffer});
            credentials.readTokenStorageStream((DataInputStream)buf);
            map.put(entry.getKey(), credentials);
        }
        if (LOG.isDebugEnabled()) {
            for (Map.Entry<Object, ByteBuffer> entry : map.entrySet()) {
                LOG.debug((Object)("Retrieved credentials form RM for " + entry.getKey() + ": " + ((Credentials)entry.getValue()).getAllTokens()));
            }
        }
        return map;
    }

    protected void startStatusUpdater() {
        this.statusUpdaterRunnable = new Runnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [25[CATCHBLOCK]], but top level block is 9[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            private void updateMasterKeys(NodeHeartbeatResponse response) {
                MasterKey updatedMasterKey = response.getContainerTokenMasterKey();
                if (updatedMasterKey != null) {
                    NodeStatusUpdaterImpl.this.context.getContainerTokenSecretManager().setMasterKey(updatedMasterKey);
                }
                if ((updatedMasterKey = response.getNMTokenMasterKey()) != null) {
                    NodeStatusUpdaterImpl.this.context.getNMTokenSecretManager().setMasterKey(updatedMasterKey);
                }
            }
        };
        this.statusUpdater = new Thread(this.statusUpdaterRunnable, "Node Status Updater");
        this.statusUpdater.start();
    }

    private List<LogAggregationReport> getLogAggregationReportsForApps(ConcurrentLinkedQueue<LogAggregationReport> lastestLogAggregationStatus) {
        LogAggregationReport status;
        while ((status = lastestLogAggregationStatus.poll()) != null) {
            this.logAggregationReportForAppsTempList.add(status);
        }
        ArrayList<LogAggregationReport> reports = new ArrayList<LogAggregationReport>();
        reports.addAll(this.logAggregationReportForAppsTempList);
        return reports;
    }

    private NMNodeLabelsHandler createNMNodeLabelsHandler(NodeLabelsProvider nodeLabelsProvider) {
        if (nodeLabelsProvider == null) {
            return new NMCentralizedNodeLabelsHandler();
        }
        return new NMDistributedNodeLabelsHandler(nodeLabelsProvider, this.getConfig());
    }

    static /* synthetic */ boolean access$000(NodeStatusUpdaterImpl x0) {
        return x0.isStopped;
    }

    static /* synthetic */ NMNodeLabelsHandler access$100(NodeStatusUpdaterImpl x0) {
        return x0.nodeLabelsHandler;
    }

    static /* synthetic */ boolean access$300(NodeStatusUpdaterImpl x0) {
        return x0.logAggregationEnabled;
    }

    static /* synthetic */ List access$400(NodeStatusUpdaterImpl x0, ConcurrentLinkedQueue x1) {
        return x0.getLogAggregationReportsForApps(x1);
    }

    static /* synthetic */ ResourceTracker access$500(NodeStatusUpdaterImpl x0) {
        return x0.resourceTracker;
    }

    static /* synthetic */ long access$602(NodeStatusUpdaterImpl x0, long x1) {
        x0.nextHeartBeatInterval = x1;
        return x0.nextHeartBeatInterval;
    }

    static /* synthetic */ Dispatcher access$800(NodeStatusUpdaterImpl x0) {
        return x0.dispatcher;
    }

    static /* synthetic */ long access$902(NodeStatusUpdaterImpl x0, long x1) {
        x0.rmIdentifier = x1;
        return x0.rmIdentifier;
    }

    static /* synthetic */ Map access$1000(NodeStatusUpdaterImpl x0) {
        return x0.pendingCompletedContainers;
    }

    static /* synthetic */ List access$1100(NodeStatusUpdaterImpl x0) {
        return x0.logAggregationReportForAppsTempList;
    }

    static /* synthetic */ void access$1200(NodeStatusUpdaterImpl x0, List x1) {
        x0.trackAppsForKeepAlive(x1);
    }

    static /* synthetic */ Map access$1300(Map x0) throws IOException {
        return NodeStatusUpdaterImpl.parseCredentials(x0);
    }

    static /* synthetic */ void access$1400(NodeStatusUpdaterImpl x0, Resource x1) {
        x0.updateNMResource(x1);
    }

    static /* synthetic */ boolean access$1502(NodeStatusUpdaterImpl x0, boolean x1) {
        x0.failedToConnect = x1;
        return x0.failedToConnect;
    }

    static /* synthetic */ Object access$1600(NodeStatusUpdaterImpl x0) {
        return x0.heartbeatMonitor;
    }

    static /* synthetic */ long access$600(NodeStatusUpdaterImpl x0) {
        return x0.nextHeartBeatInterval;
    }

    private static class NMDistributedNodeLabelsHandler
    implements NMNodeLabelsHandler {
        private final NodeLabelsProvider nodeLabelsProvider;
        private Set<NodeLabel> previousNodeLabels;
        private boolean areLabelsSentToRM;
        private long lastNodeLabelSendMills = 0L;
        private final long resyncInterval;

        private NMDistributedNodeLabelsHandler(NodeLabelsProvider nodeLabelsProvider, Configuration conf) {
            this.nodeLabelsProvider = nodeLabelsProvider;
            this.resyncInterval = conf.getLong("yarn.nodemanager.node-labels.resync-interval-ms", 120000L);
        }

        @Override
        public Set<NodeLabel> getNodeLabelsForRegistration() {
            Set<NodeLabel> nodeLabels = this.nodeLabelsProvider.getNodeLabels();
            nodeLabels = null == nodeLabels ? CommonNodeLabelsManager.EMPTY_NODELABEL_SET : nodeLabels;
            this.previousNodeLabels = nodeLabels;
            try {
                this.validateNodeLabels(nodeLabels);
            }
            catch (IOException e) {
                nodeLabels = null;
            }
            return nodeLabels;
        }

        @Override
        public String verifyRMRegistrationResponseForNodeLabels(RegisterNodeManagerResponse regNMResponse) {
            StringBuilder successfulNodeLabelsRegistrationMsg = new StringBuilder("");
            if (regNMResponse.getAreNodeLabelsAcceptedByRM()) {
                successfulNodeLabelsRegistrationMsg.append(" and with following Node label(s) : {").append(StringUtils.join((CharSequence)",", this.previousNodeLabels)).append("}");
            } else {
                String errorMsgFromRM = regNMResponse.getDiagnosticsMessage();
                LOG.error((Object)("NodeLabels sent from NM while registration were rejected by RM. " + (errorMsgFromRM == null ? "Seems like RM is configured with Centralized Labels." : "And with message " + regNMResponse.getDiagnosticsMessage())));
            }
            return successfulNodeLabelsRegistrationMsg.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<NodeLabel> getNodeLabelsForHeartbeat() {
            Set<NodeLabel> nodeLabelsForHeartbeat = this.nodeLabelsProvider.getNodeLabels();
            nodeLabelsForHeartbeat = nodeLabelsForHeartbeat == null ? CommonNodeLabelsManager.EMPTY_NODELABEL_SET : nodeLabelsForHeartbeat;
            boolean areNodeLabelsUpdated = nodeLabelsForHeartbeat.size() != this.previousNodeLabels.size() || !this.previousNodeLabels.containsAll(nodeLabelsForHeartbeat);
            this.areLabelsSentToRM = false;
            if (areNodeLabelsUpdated || this.isResyncIntervalElapsed()) {
                this.previousNodeLabels = nodeLabelsForHeartbeat;
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Labels from provider: " + StringUtils.join((CharSequence)",", this.previousNodeLabels)));
                    }
                    this.validateNodeLabels(nodeLabelsForHeartbeat);
                    this.areLabelsSentToRM = true;
                }
                catch (IOException e) {
                    nodeLabelsForHeartbeat = null;
                }
                finally {
                    this.lastNodeLabelSendMills = System.currentTimeMillis();
                }
            } else {
                nodeLabelsForHeartbeat = null;
            }
            return nodeLabelsForHeartbeat;
        }

        private void validateNodeLabels(Set<NodeLabel> nodeLabelsForHeartbeat) throws IOException {
            Iterator<NodeLabel> iterator = nodeLabelsForHeartbeat.iterator();
            boolean hasInvalidLabel = false;
            StringBuilder errorMsg = new StringBuilder("");
            while (iterator.hasNext()) {
                try {
                    CommonNodeLabelsManager.checkAndThrowLabelName((String)iterator.next().getName());
                }
                catch (IOException e) {
                    errorMsg.append(e.getMessage());
                    errorMsg.append(" , ");
                    hasInvalidLabel = true;
                }
            }
            if (hasInvalidLabel) {
                LOG.error((Object)("Invalid Node Label(s) from Provider : " + errorMsg));
                throw new IOException(errorMsg.toString());
            }
        }

        public boolean isResyncIntervalElapsed() {
            long elapsedTimeSinceLastSync = System.currentTimeMillis() - this.lastNodeLabelSendMills;
            return elapsedTimeSinceLastSync > this.resyncInterval;
        }

        @Override
        public void verifyRMHeartbeatResponseForNodeLabels(NodeHeartbeatResponse response) {
            if (this.areLabelsSentToRM) {
                if (response.getAreNodeLabelsAcceptedByRM() && LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Node Labels {" + StringUtils.join((CharSequence)",", this.previousNodeLabels) + "} were Accepted by RM "));
                } else {
                    LOG.error((Object)("NM node labels {" + StringUtils.join((CharSequence)",", this.previousNodeLabels) + "} were not accepted by RM and message from RM : " + response.getDiagnosticsMessage()));
                }
            }
        }
    }

    private static class NMCentralizedNodeLabelsHandler
    implements NMNodeLabelsHandler {
        private NMCentralizedNodeLabelsHandler() {
        }

        @Override
        public Set<NodeLabel> getNodeLabelsForHeartbeat() {
            return null;
        }

        @Override
        public Set<NodeLabel> getNodeLabelsForRegistration() {
            return null;
        }

        @Override
        public void verifyRMHeartbeatResponseForNodeLabels(NodeHeartbeatResponse response) {
        }

        @Override
        public String verifyRMRegistrationResponseForNodeLabels(RegisterNodeManagerResponse regNMResponse) {
            return "";
        }
    }

    private static interface NMNodeLabelsHandler {
        public Set<NodeLabel> getNodeLabelsForRegistration();

        public String verifyRMRegistrationResponseForNodeLabels(RegisterNodeManagerResponse var1);

        public Set<NodeLabel> getNodeLabelsForHeartbeat();

        public void verifyRMHeartbeatResponseForNodeLabels(NodeHeartbeatResponse var1);
    }
}

