/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.executor;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class ContainerStartContext {
    private final Container container;
    private final Map<Path, List<String>> localizedResources;
    private final Path nmPrivateContainerScriptPath;
    private final Path nmPrivateTokensPath;
    private final String user;
    private final String appId;
    private final Path containerWorkDir;
    private final List<String> localDirs;
    private final List<String> logDirs;

    private ContainerStartContext(Builder builder) {
        this.container = builder.container;
        this.localizedResources = builder.localizedResources;
        this.nmPrivateContainerScriptPath = builder.nmPrivateContainerScriptPath;
        this.nmPrivateTokensPath = builder.nmPrivateTokensPath;
        this.user = builder.user;
        this.appId = builder.appId;
        this.containerWorkDir = builder.containerWorkDir;
        this.localDirs = builder.localDirs;
        this.logDirs = builder.logDirs;
    }

    public Container getContainer() {
        return this.container;
    }

    public Map<Path, List<String>> getLocalizedResources() {
        if (this.localizedResources != null) {
            return Collections.unmodifiableMap(this.localizedResources);
        }
        return null;
    }

    public Path getNmPrivateContainerScriptPath() {
        return this.nmPrivateContainerScriptPath;
    }

    public Path getNmPrivateTokensPath() {
        return this.nmPrivateTokensPath;
    }

    public String getUser() {
        return this.user;
    }

    public String getAppId() {
        return this.appId;
    }

    public Path getContainerWorkDir() {
        return this.containerWorkDir;
    }

    public List<String> getLocalDirs() {
        return Collections.unmodifiableList(this.localDirs);
    }

    public List<String> getLogDirs() {
        return Collections.unmodifiableList(this.logDirs);
    }

    public static final class Builder {
        private Container container;
        private Map<Path, List<String>> localizedResources;
        private Path nmPrivateContainerScriptPath;
        private Path nmPrivateTokensPath;
        private String user;
        private String appId;
        private Path containerWorkDir;
        private List<String> localDirs;
        private List<String> logDirs;

        public Builder setContainer(Container container) {
            this.container = container;
            return this;
        }

        public Builder setLocalizedResources(Map<Path, List<String>> localizedResources) {
            this.localizedResources = localizedResources;
            return this;
        }

        public Builder setNmPrivateContainerScriptPath(Path nmPrivateContainerScriptPath) {
            this.nmPrivateContainerScriptPath = nmPrivateContainerScriptPath;
            return this;
        }

        public Builder setNmPrivateTokensPath(Path nmPrivateTokensPath) {
            this.nmPrivateTokensPath = nmPrivateTokensPath;
            return this;
        }

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        public Builder setAppId(String appId) {
            this.appId = appId;
            return this;
        }

        public Builder setContainerWorkDir(Path containerWorkDir) {
            this.containerWorkDir = containerWorkDir;
            return this;
        }

        public Builder setLocalDirs(List<String> localDirs) {
            this.localDirs = localDirs;
            return this;
        }

        public Builder setLogDirs(List<String> logDirs) {
            this.logDirs = logDirs;
            return this;
        }

        public ContainerStartContext build() {
            return new ContainerStartContext(this);
        }
    }
}

