/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.amrmproxy;

import com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.nodemanager.amrmproxy.AMRMProxyApplicationContext;
import org.apache.hadoop.yarn.server.nodemanager.amrmproxy.RequestInterceptor;

public abstract class AbstractRequestInterceptor
implements RequestInterceptor {
    private Configuration conf;
    private AMRMProxyApplicationContext appContext;
    private RequestInterceptor nextInterceptor;

    @Override
    public void setNextInterceptor(RequestInterceptor nextInterceptor) {
        this.nextInterceptor = nextInterceptor;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        if (this.nextInterceptor != null) {
            this.nextInterceptor.setConf(conf);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void init(AMRMProxyApplicationContext appContext) {
        Preconditions.checkState((this.appContext == null ? 1 : 0) != 0, (Object)("init is called multiple times on this interceptor: " + this.getClass().getName()));
        this.appContext = appContext;
        if (this.nextInterceptor != null) {
            this.nextInterceptor.init(appContext);
        }
    }

    @Override
    public void shutdown() {
        if (this.nextInterceptor != null) {
            this.nextInterceptor.shutdown();
        }
    }

    @Override
    public RequestInterceptor getNextInterceptor() {
        return this.nextInterceptor;
    }

    @Override
    public AMRMProxyApplicationContext getApplicationContext() {
        return this.appContext;
    }
}

