/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.recovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerNodemanagerRecoveryProtos;
import org.apache.hadoop.yarn.server.api.records.MasterKey;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class NMStateStoreService
extends AbstractService {
    public NMStateStoreService(String name) {
        super(name);
    }

    public void serviceInit(Configuration conf) throws IOException {
        this.initStorage(conf);
    }

    public void serviceStart() throws IOException {
        this.startStorage();
    }

    public void serviceStop() throws IOException {
        this.closeStorage();
    }

    public boolean canRecover() {
        return true;
    }

    public boolean isNewlyCreated() {
        return false;
    }

    public abstract RecoveredApplicationsState loadApplicationsState() throws IOException;

    public abstract void storeApplication(ApplicationId var1, YarnServerNodemanagerRecoveryProtos.ContainerManagerApplicationProto var2) throws IOException;

    public abstract void removeApplication(ApplicationId var1) throws IOException;

    public abstract List<RecoveredContainerState> loadContainersState() throws IOException;

    public abstract void storeContainer(ContainerId var1, int var2, StartContainerRequest var3) throws IOException;

    public abstract void storeContainerLaunched(ContainerId var1) throws IOException;

    public abstract void storeContainerResourceChanged(ContainerId var1, int var2, Resource var3) throws IOException;

    public abstract void storeContainerCompleted(ContainerId var1, int var2) throws IOException;

    public abstract void storeContainerKilled(ContainerId var1) throws IOException;

    public abstract void storeContainerDiagnostics(ContainerId var1, StringBuilder var2) throws IOException;

    public abstract void removeContainer(ContainerId var1) throws IOException;

    public abstract RecoveredLocalizationState loadLocalizationState() throws IOException;

    public abstract void startResourceLocalization(String var1, ApplicationId var2, YarnProtos.LocalResourceProto var3, Path var4) throws IOException;

    public abstract void finishResourceLocalization(String var1, ApplicationId var2, YarnServerNodemanagerRecoveryProtos.LocalizedResourceProto var3) throws IOException;

    public abstract void removeLocalizedResource(String var1, ApplicationId var2, Path var3) throws IOException;

    public abstract RecoveredDeletionServiceState loadDeletionServiceState() throws IOException;

    public abstract void storeDeletionTask(int var1, YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto var2) throws IOException;

    public abstract void removeDeletionTask(int var1) throws IOException;

    public abstract RecoveredNMTokensState loadNMTokensState() throws IOException;

    public abstract void storeNMTokenCurrentMasterKey(MasterKey var1) throws IOException;

    public abstract void storeNMTokenPreviousMasterKey(MasterKey var1) throws IOException;

    public abstract void storeNMTokenApplicationMasterKey(ApplicationAttemptId var1, MasterKey var2) throws IOException;

    public abstract void removeNMTokenApplicationMasterKey(ApplicationAttemptId var1) throws IOException;

    public abstract RecoveredContainerTokensState loadContainerTokensState() throws IOException;

    public abstract void storeContainerTokenCurrentMasterKey(MasterKey var1) throws IOException;

    public abstract void storeContainerTokenPreviousMasterKey(MasterKey var1) throws IOException;

    public abstract void storeContainerToken(ContainerId var1, Long var2) throws IOException;

    public abstract void removeContainerToken(ContainerId var1) throws IOException;

    public abstract RecoveredLogDeleterState loadLogDeleterState() throws IOException;

    public abstract void storeLogDeleter(ApplicationId var1, YarnServerNodemanagerRecoveryProtos.LogDeleterProto var2) throws IOException;

    public abstract void removeLogDeleter(ApplicationId var1) throws IOException;

    protected abstract void initStorage(Configuration var1) throws IOException;

    protected abstract void startStorage() throws IOException;

    protected abstract void closeStorage() throws IOException;

    public static class RecoveredLogDeleterState {
        Map<ApplicationId, YarnServerNodemanagerRecoveryProtos.LogDeleterProto> logDeleterMap;

        public Map<ApplicationId, YarnServerNodemanagerRecoveryProtos.LogDeleterProto> getLogDeleterMap() {
            return this.logDeleterMap;
        }
    }

    public static class RecoveredContainerTokensState {
        MasterKey currentMasterKey;
        MasterKey previousMasterKey;
        Map<ContainerId, Long> activeTokens;

        public MasterKey getCurrentMasterKey() {
            return this.currentMasterKey;
        }

        public MasterKey getPreviousMasterKey() {
            return this.previousMasterKey;
        }

        public Map<ContainerId, Long> getActiveTokens() {
            return this.activeTokens;
        }
    }

    public static class RecoveredNMTokensState {
        MasterKey currentMasterKey;
        MasterKey previousMasterKey;
        Map<ApplicationAttemptId, MasterKey> applicationMasterKeys;

        public MasterKey getCurrentMasterKey() {
            return this.currentMasterKey;
        }

        public MasterKey getPreviousMasterKey() {
            return this.previousMasterKey;
        }

        public Map<ApplicationAttemptId, MasterKey> getApplicationMasterKeys() {
            return this.applicationMasterKeys;
        }
    }

    public static class RecoveredDeletionServiceState {
        List<YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto> tasks;

        public List<YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto> getTasks() {
            return this.tasks;
        }
    }

    public static class RecoveredLocalizationState {
        LocalResourceTrackerState publicTrackerState = new LocalResourceTrackerState();
        Map<String, RecoveredUserResources> userResources = new HashMap<String, RecoveredUserResources>();

        public LocalResourceTrackerState getPublicTrackerState() {
            return this.publicTrackerState;
        }

        public Map<String, RecoveredUserResources> getUserResources() {
            return this.userResources;
        }
    }

    public static class RecoveredUserResources {
        LocalResourceTrackerState privateTrackerState = new LocalResourceTrackerState();
        Map<ApplicationId, LocalResourceTrackerState> appTrackerStates = new HashMap<ApplicationId, LocalResourceTrackerState>();

        public LocalResourceTrackerState getPrivateTrackerState() {
            return this.privateTrackerState;
        }

        public Map<ApplicationId, LocalResourceTrackerState> getAppTrackerStates() {
            return this.appTrackerStates;
        }
    }

    public static class LocalResourceTrackerState {
        List<YarnServerNodemanagerRecoveryProtos.LocalizedResourceProto> localizedResources = new ArrayList<YarnServerNodemanagerRecoveryProtos.LocalizedResourceProto>();
        Map<YarnProtos.LocalResourceProto, Path> inProgressResources = new HashMap<YarnProtos.LocalResourceProto, Path>();

        public List<YarnServerNodemanagerRecoveryProtos.LocalizedResourceProto> getLocalizedResources() {
            return this.localizedResources;
        }

        public Map<YarnProtos.LocalResourceProto, Path> getInProgressResources() {
            return this.inProgressResources;
        }

        public boolean isEmpty() {
            return this.localizedResources.isEmpty() && this.inProgressResources.isEmpty();
        }
    }

    public static class RecoveredContainerState {
        RecoveredContainerStatus status;
        int exitCode = -1000;
        boolean killed = false;
        String diagnostics = "";
        StartContainerRequest startRequest;
        Resource capability;
        int version;
        private RecoveredContainerType recoveryType = RecoveredContainerType.RECOVER;

        public RecoveredContainerStatus getStatus() {
            return this.status;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public boolean getKilled() {
            return this.killed;
        }

        public String getDiagnostics() {
            return this.diagnostics;
        }

        public int getVersion() {
            return this.version;
        }

        public StartContainerRequest getStartRequest() {
            return this.startRequest;
        }

        public Resource getCapability() {
            return this.capability;
        }

        public String toString() {
            return new StringBuffer("Status: ").append((Object)this.getStatus()).append(", Exit code: ").append(this.exitCode).append(", Version: ").append(this.version).append(", Killed: ").append(this.getKilled()).append(", Diagnostics: ").append(this.getDiagnostics()).append(", Capability: ").append(this.getCapability()).append(", StartRequest: ").append(this.getStartRequest()).toString();
        }

        public RecoveredContainerType getRecoveryType() {
            return this.recoveryType;
        }

        public void setRecoveryType(RecoveredContainerType recoveryType) {
            this.recoveryType = recoveryType;
        }
    }

    public static enum RecoveredContainerStatus {
        REQUESTED,
        LAUNCHED,
        COMPLETED;

    }

    public static enum RecoveredContainerType {
        KILL,
        RECOVER;

    }

    public static class RecoveredApplicationsState {
        List<YarnServerNodemanagerRecoveryProtos.ContainerManagerApplicationProto> applications;

        public List<YarnServerNodemanagerRecoveryProtos.ContainerManagerApplicationProto> getApplications() {
            return this.applications;
        }
    }
}

