/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainerLaunch;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.ContainerLocalizer;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerLivenessContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerSignalContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerStartContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.DeletionAsUserContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.LocalizerStartContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DockerContainerExecutor
extends ContainerExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(DockerContainerExecutor.class);
    public static final String DOCKER_CONTAINER_EXECUTOR_SCRIPT = "docker_container_executor";
    public static final String DOCKER_CONTAINER_EXECUTOR_SESSION_SCRIPT = "docker_container_executor_session";
    public static final String DOCKER_IMAGE_PATTERN = "^(([\\w\\.-]+)(:\\d+)*\\/)?[\\w\\.:-]+$";
    private final FileContext lfs;
    private final Pattern dockerImagePattern;
    static final short USER_PERM = 488;
    static final short APPCACHE_PERM = 456;
    static final short FILECACHE_PERM = 456;
    static final short APPDIR_PERM = 456;
    static final short LOGDIR_PERM = 456;

    public DockerContainerExecutor() {
        try {
            this.lfs = FileContext.getLocalFSFileContext();
            this.dockerImagePattern = Pattern.compile(DOCKER_IMAGE_PATTERN);
        }
        catch (UnsupportedFileSystemException e) {
            throw new RuntimeException(e);
        }
    }

    protected void copyFile(Path src, Path dst, String owner) throws IOException {
        this.lfs.util().copy(src, dst);
    }

    @Override
    public void init() throws IOException {
        String auth = this.getConf().get("hadoop.security.authentication");
        if (auth != null && !auth.equals("simple")) {
            throw new IllegalStateException("DockerContainerExecutor only works with simple authentication mode");
        }
        String dockerExecutor = this.getConf().get("yarn.nodemanager.docker-container-executor.exec-name", "/usr/bin/docker");
        if (!new File(dockerExecutor).exists()) {
            throw new IllegalStateException("Invalid docker exec path: " + dockerExecutor);
        }
    }

    @Override
    public synchronized void startLocalizer(LocalizerStartContext ctx) throws IOException, InterruptedException {
        Path nmPrivateContainerTokensPath = ctx.getNmPrivateContainerTokens();
        InetSocketAddress nmAddr = ctx.getNmAddr();
        String user = ctx.getUser();
        String appId = ctx.getAppId();
        String locId = ctx.getLocId();
        LocalDirsHandlerService dirsHandler = ctx.getDirsHandler();
        List<String> localDirs = dirsHandler.getLocalDirs();
        List<String> logDirs = dirsHandler.getLogDirs();
        ContainerLocalizer localizer = new ContainerLocalizer(this.lfs, user, appId, locId, DockerContainerExecutor.getPaths(localDirs), RecordFactoryProvider.getRecordFactory((Configuration)this.getConf()));
        this.createUserLocalDirs(localDirs, user);
        this.createUserCacheDirs(localDirs, user);
        this.createAppDirs(localDirs, user, appId);
        this.createAppLogDirs(appId, logDirs, user);
        Path appStorageDir = this.getWorkingDir(localDirs, user, appId);
        String tokenFn = String.format("%s.tokens", locId);
        Path tokenDst = new Path(appStorageDir, tokenFn);
        this.copyFile(nmPrivateContainerTokensPath, tokenDst, user);
        LOG.info("Copying from " + nmPrivateContainerTokensPath + " to " + tokenDst);
        this.lfs.setWorkingDirectory(appStorageDir);
        LOG.info("CWD set to " + appStorageDir + " = " + this.lfs.getWorkingDirectory());
        localizer.runLocalization(nmAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int launchContainer(ContainerStartContext ctx) throws IOException {
        block15: {
            Container container = ctx.getContainer();
            Path nmPrivateContainerScriptPath = ctx.getNmPrivateContainerScriptPath();
            Path nmPrivateTokensPath = ctx.getNmPrivateTokensPath();
            String userName = ctx.getUser();
            Path containerWorkDir = ctx.getContainerWorkDir();
            List<String> localDirs = ctx.getLocalDirs();
            List<String> logDirs = ctx.getLogDirs();
            String containerImageName = (String)container.getLaunchContext().getEnvironment().get("yarn.nodemanager.docker-container-executor.image-name");
            if (LOG.isDebugEnabled()) {
                LOG.debug("containerImageName from launchContext: " + containerImageName);
            }
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)containerImageName) ? 1 : 0) != 0, (Object)"Container image must not be null");
            containerImageName = containerImageName.replaceAll("['\"]", "");
            Preconditions.checkArgument((boolean)this.saneDockerImage(containerImageName), (Object)("Image: " + containerImageName + " is not a proper docker image"));
            String dockerExecutor = this.getConf().get("yarn.nodemanager.docker-container-executor.exec-name", "/usr/bin/docker");
            FsPermission dirPerm = new FsPermission(456);
            ContainerId containerId = container.getContainerId();
            String containerIdStr = containerId.toString();
            String appIdStr = containerId.getApplicationAttemptId().getApplicationId().toString();
            for (String sLocalDir : localDirs) {
                Path usersdir = new Path(sLocalDir, "usercache");
                Path userdir = new Path(usersdir, userName);
                Path appCacheDir = new Path(userdir, "appcache");
                Path appDir = new Path(appCacheDir, appIdStr);
                Path containerDir = new Path(appDir, containerIdStr);
                this.createDir(containerDir, dirPerm, true, userName);
            }
            this.createContainerLogDirs(appIdStr, containerIdStr, logDirs, userName);
            Path tmpDir = new Path(containerWorkDir, "./tmp");
            this.createDir(tmpDir, dirPerm, false, userName);
            Path launchDst = new Path(containerWorkDir, ContainerLaunch.CONTAINER_SCRIPT);
            this.lfs.util().copy(nmPrivateContainerScriptPath, launchDst);
            Path tokenDst = new Path(containerWorkDir, "container_tokens");
            this.lfs.util().copy(nmPrivateTokensPath, tokenDst);
            String localDirMount = this.toMount(localDirs);
            String logDirMount = this.toMount(logDirs);
            String containerWorkDirMount = this.toMount(Collections.singletonList(containerWorkDir.toUri().getPath()));
            StringBuilder commands = new StringBuilder();
            String commandStr = commands.append(dockerExecutor).append(" ").append("run").append(" ").append("--rm --net=host").append(" ").append(" --name " + containerIdStr).append(localDirMount).append(logDirMount).append(containerWorkDirMount).append(" ").append(containerImageName).toString();
            String dockerPidScript = "`" + dockerExecutor + " inspect --format {{.State.Pid}} " + containerIdStr + "`";
            UnixLocalWrapperScriptBuilder sb = new UnixLocalWrapperScriptBuilder(containerWorkDir, commandStr, dockerPidScript);
            Path pidFile = this.getPidFilePath(containerId);
            if (pidFile == null) {
                LOG.info("Container " + containerIdStr + " was marked as inactive. Returning terminated error");
                return ContainerExecutor.ExitCode.TERMINATED.getExitCode();
            }
            ((LocalWrapperScriptBuilder)sb).writeLocalWrapperScript(launchDst, pidFile);
            try (Shell.ShellCommandExecutor shExec = null;){
                this.lfs.setPermission(launchDst, ContainerExecutor.TASK_LAUNCH_SCRIPT_PERMISSION);
                this.lfs.setPermission(sb.getWrapperScriptPath(), ContainerExecutor.TASK_LAUNCH_SCRIPT_PERMISSION);
                Object[] command = this.getRunCommand(sb.getWrapperScriptPath().toString(), containerIdStr, userName, pidFile, this.getConf());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("launchContainer: " + commandStr + " " + Joiner.on((String)" ").join(command));
                }
                shExec = new Shell.ShellCommandExecutor((String[])command, new File(containerWorkDir.toUri().getPath()), container.getLaunchContext().getEnvironment(), 0L, false);
                if (this.isContainerActive(containerId)) {
                    shExec.execute();
                    break block15;
                }
                LOG.info("Container " + containerIdStr + " was marked as inactive. Returning terminated error");
                int n = ContainerExecutor.ExitCode.TERMINATED.getExitCode();
                return n;
            }
        }
        return 0;
    }

    @Override
    public void writeLaunchEnv(OutputStream out, Map<String, String> environment, Map<Path, List<String>> resources, List<String> command, Path logDir, String user) throws IOException {
        ContainerLaunch.ShellScriptBuilder sb = ContainerLaunch.ShellScriptBuilder.create();
        HashSet<String> exclusionSet = new HashSet<String>();
        exclusionSet.add("yarn.nodemanager.docker-container-executor.image-name");
        exclusionSet.add(ApplicationConstants.Environment.HADOOP_YARN_HOME.name());
        exclusionSet.add(ApplicationConstants.Environment.HADOOP_COMMON_HOME.name());
        exclusionSet.add(ApplicationConstants.Environment.HADOOP_HDFS_HOME.name());
        exclusionSet.add(ApplicationConstants.Environment.HADOOP_CONF_DIR.name());
        exclusionSet.add(ApplicationConstants.Environment.JAVA_HOME.name());
        if (environment != null) {
            for (Map.Entry<String, Object> entry : environment.entrySet()) {
                if (exclusionSet.contains(entry.getKey())) continue;
                sb.env(entry.getKey(), (String)entry.getValue());
            }
        }
        if (resources != null) {
            for (Map.Entry<String, Object> entry : resources.entrySet()) {
                for (String linkName : (List)entry.getValue()) {
                    if (new Path(linkName).getName().equals("*")) {
                        for (File wildLink : this.readDirAsUser(user, (Path)entry.getKey())) {
                            sb.symlink(new Path(wildLink.toString()), new Path(wildLink.getName()));
                        }
                        continue;
                    }
                    sb.symlink((Path)entry.getKey(), new Path(linkName));
                }
            }
        }
        if (this.getConf() != null && this.getConf().getBoolean("yarn.nodemanager.log-container-debug-info.enabled", false)) {
            sb.copyDebugInformation(new Path(ContainerLaunch.CONTAINER_SCRIPT), new Path(logDir, ContainerLaunch.CONTAINER_SCRIPT));
            sb.listDebugInformation(new Path(logDir, "directory.info"));
        }
        sb.command(command);
        Throwable throwable = null;
        try (PrintStream pout = new PrintStream(out, false, "UTF-8");){
            sb.write(pout);
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        if (LOG.isDebugEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (PrintStream printStream = new PrintStream((OutputStream)baos, false, "UTF-8");){
                sb.write(printStream);
            }
            LOG.debug("Script: " + baos.toString("UTF-8"));
        }
    }

    private boolean saneDockerImage(String containerImageName) {
        return this.dockerImagePattern.matcher(containerImageName).matches();
    }

    @Override
    public boolean signalContainer(ContainerSignalContext ctx) throws IOException {
        String user = ctx.getUser();
        String pid = ctx.getPid();
        ContainerExecutor.Signal signal = ctx.getSignal();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending signal " + signal.getValue() + " to pid " + pid + " as user " + user);
        }
        if (!DockerContainerExecutor.containerIsAlive(pid)) {
            return false;
        }
        try {
            this.killContainer(pid, signal);
        }
        catch (IOException e) {
            if (!DockerContainerExecutor.containerIsAlive(pid)) {
                return false;
            }
            throw e;
        }
        return true;
    }

    @Override
    public boolean isContainerAlive(ContainerLivenessContext ctx) throws IOException {
        String pid = ctx.getPid();
        return DockerContainerExecutor.containerIsAlive(pid);
    }

    @VisibleForTesting
    public static boolean containerIsAlive(String pid) throws IOException {
        try {
            new Shell.ShellCommandExecutor(Shell.getCheckProcessIsAliveCommand((String)pid)).execute();
            return true;
        }
        catch (Shell.ExitCodeException e) {
            return false;
        }
    }

    protected void killContainer(String pid, ContainerExecutor.Signal signal) throws IOException {
        new Shell.ShellCommandExecutor(Shell.getSignalKillCommand((int)signal.getValue(), (String)pid)).execute();
    }

    @Override
    public void deleteAsUser(DeletionAsUserContext ctx) throws IOException, InterruptedException {
        Path subDir = ctx.getSubDir();
        List<Path> baseDirs = ctx.getBasedirs();
        if (baseDirs == null || baseDirs.size() == 0) {
            LOG.info("Deleting absolute path : " + subDir);
            if (!this.lfs.delete(subDir, true)) {
                LOG.warn("delete returned false for path: [" + subDir + "]");
            }
            return;
        }
        for (Path baseDir : baseDirs) {
            Path del = subDir == null ? baseDir : new Path(baseDir, subDir);
            LOG.info("Deleting path : " + del);
            try {
                if (this.lfs.delete(del, true)) continue;
                LOG.warn("delete returned false for path: [" + del + "]");
            }
            catch (FileNotFoundException e) {}
        }
    }

    @Override
    public void symLink(String target, String symlink) throws IOException {
    }

    private String toMount(List<String> dirs) {
        StringBuilder builder = new StringBuilder();
        for (String dir : dirs) {
            builder.append(" -v " + dir + ":" + dir);
        }
        return builder.toString();
    }

    protected void createDir(Path dirPath, FsPermission perms, boolean createParent, String user) throws IOException {
        this.lfs.mkdir(dirPath, perms, createParent);
        if (!perms.equals((Object)perms.applyUMask(this.lfs.getUMask()))) {
            this.lfs.setPermission(dirPath, perms);
        }
    }

    void createUserLocalDirs(List<String> localDirs, String user) throws IOException {
        boolean userDirStatus = false;
        FsPermission userperms = new FsPermission(488);
        for (String localDir : localDirs) {
            try {
                this.createDir(this.getUserCacheDir(new Path(localDir), user), userperms, true, user);
            }
            catch (IOException e) {
                LOG.warn("Unable to create the user directory : " + localDir, (Throwable)e);
                continue;
            }
            userDirStatus = true;
        }
        if (!userDirStatus) {
            throw new IOException("Not able to initialize user directories in any of the configured local directories for user " + user);
        }
    }

    void createUserCacheDirs(List<String> localDirs, String user) throws IOException {
        LOG.info("Initializing user " + user);
        boolean appcacheDirStatus = false;
        boolean distributedCacheDirStatus = false;
        FsPermission appCachePerms = new FsPermission(456);
        FsPermission fileperms = new FsPermission(456);
        for (String localDir : localDirs) {
            Path localDirPath = new Path(localDir);
            Path appDir = this.getAppcacheDir(localDirPath, user);
            try {
                this.createDir(appDir, appCachePerms, true, user);
                appcacheDirStatus = true;
            }
            catch (IOException e) {
                LOG.warn("Unable to create app cache directory : " + appDir, (Throwable)e);
            }
            Path distDir = this.getFileCacheDir(localDirPath, user);
            try {
                this.createDir(distDir, fileperms, true, user);
                distributedCacheDirStatus = true;
            }
            catch (IOException e) {
                LOG.warn("Unable to create file cache directory : " + distDir, (Throwable)e);
            }
        }
        if (!appcacheDirStatus) {
            throw new IOException("Not able to initialize app-cache directories in any of the configured local directories for user " + user);
        }
        if (!distributedCacheDirStatus) {
            throw new IOException("Not able to initialize distributed-cache directories in any of the configured local directories for user " + user);
        }
    }

    void createAppDirs(List<String> localDirs, String user, String appId) throws IOException {
        boolean initAppDirStatus = false;
        FsPermission appperms = new FsPermission(456);
        for (String localDir : localDirs) {
            Path fullAppDir = this.getApplicationDir(new Path(localDir), user, appId);
            try {
                this.createDir(fullAppDir, appperms, true, user);
                initAppDirStatus = true;
            }
            catch (IOException e) {
                LOG.warn("Unable to create app directory " + fullAppDir.toString(), (Throwable)e);
            }
        }
        if (!initAppDirStatus) {
            throw new IOException("Not able to initialize app directories in any of the configured local directories for app " + appId.toString());
        }
    }

    void createContainerLogDirs(String appId, String containerId, List<String> logDirs, String user) throws IOException {
        boolean containerLogDirStatus = false;
        FsPermission containerLogDirPerms = new FsPermission(456);
        for (String rootLogDir : logDirs) {
            Path appLogDir = new Path(rootLogDir, appId);
            Path containerLogDir = new Path(appLogDir, containerId);
            try {
                this.createDir(containerLogDir, containerLogDirPerms, true, user);
            }
            catch (IOException e) {
                LOG.warn("Unable to create the container-log directory : " + appLogDir, (Throwable)e);
                continue;
            }
            containerLogDirStatus = true;
        }
        if (!containerLogDirStatus) {
            throw new IOException("Not able to initialize container-log directories in any of the configured local directories for container " + containerId);
        }
    }

    private long getDiskFreeSpace(Path base) throws IOException {
        return this.lfs.getFsStatus(base).getRemaining();
    }

    private Path getApplicationDir(Path base, String user, String appId) {
        return new Path(this.getAppcacheDir(base, user), appId);
    }

    private Path getUserCacheDir(Path base, String user) {
        return new Path(new Path(base, "usercache"), user);
    }

    private Path getAppcacheDir(Path base, String user) {
        return new Path(this.getUserCacheDir(base, user), "appcache");
    }

    private Path getFileCacheDir(Path base, String user) {
        return new Path(this.getUserCacheDir(base, user), "filecache");
    }

    protected Path getWorkingDir(List<String> localDirs, String user, String appId) throws IOException {
        Path appStorageDir = null;
        long totalAvailable = 0L;
        long[] availableOnDisk = new long[localDirs.size()];
        int i = 0;
        for (String localDir : localDirs) {
            Path curBase = this.getApplicationDir(new Path(localDir), user, appId);
            long space = 0L;
            try {
                space = this.getDiskFreeSpace(curBase);
            }
            catch (IOException e) {
                LOG.warn("Unable to get Free Space for " + curBase.toString(), (Throwable)e);
            }
            availableOnDisk[i++] = space;
            totalAvailable += space;
        }
        if (totalAvailable <= 0L) {
            throw new IOException("Not able to find a working directory for " + user);
        }
        long randomPosition = RandomUtils.nextLong() % totalAvailable;
        int dir = 0;
        while (availableOnDisk[dir] == 0L) {
            ++dir;
        }
        while (randomPosition > availableOnDisk[dir]) {
            randomPosition -= availableOnDisk[dir++];
        }
        appStorageDir = this.getApplicationDir(new Path(localDirs.get(dir)), user, appId);
        return appStorageDir;
    }

    void createAppLogDirs(String appId, List<String> logDirs, String user) throws IOException {
        boolean appLogDirStatus = false;
        FsPermission appLogDirPerms = new FsPermission(456);
        for (String rootLogDir : logDirs) {
            Path appLogDir = new Path(rootLogDir, appId);
            try {
                this.createDir(appLogDir, appLogDirPerms, true, user);
            }
            catch (IOException e) {
                LOG.warn("Unable to create the app-log directory : " + appLogDir, (Throwable)e);
                continue;
            }
            appLogDirStatus = true;
        }
        if (!appLogDirStatus) {
            throw new IOException("Not able to initialize app-log directories in any of the configured local directories for app " + appId);
        }
    }

    private static List<Path> getPaths(List<String> dirs) {
        ArrayList<Path> paths = new ArrayList<Path>(dirs.size());
        for (int i = 0; i < dirs.size(); ++i) {
            paths.add(new Path(dirs.get(i)));
        }
        return paths;
    }

    private final class UnixLocalWrapperScriptBuilder
    extends LocalWrapperScriptBuilder {
        private final Path sessionScriptPath;
        private final String dockerCommand;
        private final String dockerPidScript;

        public UnixLocalWrapperScriptBuilder(Path containerWorkDir, String dockerCommand, String dockerPidScript) {
            super(containerWorkDir);
            this.dockerCommand = dockerCommand;
            this.dockerPidScript = dockerPidScript;
            this.sessionScriptPath = new Path(containerWorkDir, Shell.appendScriptExtension((String)DockerContainerExecutor.DOCKER_CONTAINER_EXECUTOR_SESSION_SCRIPT));
        }

        @Override
        public void writeLocalWrapperScript(Path launchDst, Path pidFile) throws IOException {
            this.writeSessionScript(launchDst, pidFile);
            super.writeLocalWrapperScript(launchDst, pidFile);
        }

        @Override
        public void writeLocalWrapperScript(Path launchDst, Path pidFile, PrintStream pout) {
            String exitCodeFile = ContainerLaunch.getExitCodeFile(pidFile.toString());
            String tmpFile = exitCodeFile + ".tmp";
            pout.println("#!/usr/bin/env bash");
            pout.println("bash \"" + this.sessionScriptPath.toString() + "\"");
            pout.println("rc=$?");
            pout.println("echo $rc > \"" + tmpFile + "\"");
            pout.println("mv -f \"" + tmpFile + "\" \"" + exitCodeFile + "\"");
            pout.println("exit $rc");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeSessionScript(Path launchDst, Path pidFile) throws IOException {
            FSDataOutputStream out = null;
            PrintStream pout = null;
            try {
                out = DockerContainerExecutor.this.lfs.create(this.sessionScriptPath, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
                pout = new PrintStream((OutputStream)out, false, "UTF-8");
                pout.println("#!/usr/bin/env bash");
                pout.println();
                pout.println("echo " + this.dockerPidScript + " > " + pidFile.toString() + ".tmp");
                pout.println("/bin/mv -f " + pidFile.toString() + ".tmp " + pidFile);
                pout.println(this.dockerCommand + " bash \"" + launchDst.toUri().getPath().toString() + "\"");
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{pout, out});
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{pout, out});
            DockerContainerExecutor.this.lfs.setPermission(this.sessionScriptPath, ContainerExecutor.TASK_LAUNCH_SCRIPT_PERMISSION);
        }
    }

    private abstract class LocalWrapperScriptBuilder {
        private final Path wrapperScriptPath;

        public Path getWrapperScriptPath() {
            return this.wrapperScriptPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeLocalWrapperScript(Path launchDst, Path pidFile) throws IOException {
            FSDataOutputStream out = null;
            PrintStream pout = null;
            try {
                out = DockerContainerExecutor.this.lfs.create(this.wrapperScriptPath, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
                pout = new PrintStream((OutputStream)out, false, "UTF-8");
                this.writeLocalWrapperScript(launchDst, pidFile, pout);
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{pout, out});
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{pout, out});
        }

        protected abstract void writeLocalWrapperScript(Path var1, Path var2, PrintStream var3);

        protected LocalWrapperScriptBuilder(Path containerWorkDir) {
            this.wrapperScriptPath = new Path(containerWorkDir, Shell.appendScriptExtension((String)DockerContainerExecutor.DOCKER_CONTAINER_EXECUTOR_SCRIPT));
        }
    }
}

