/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.collectormanager;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.api.CollectorNodemanagerProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.GetTimelineCollectorContextRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.GetTimelineCollectorContextResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReportNewCollectorInfoRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReportNewCollectorInfoResponse;
import org.apache.hadoop.yarn.server.api.records.AppCollectorData;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.security.authorize.NMPolicyProvider;
import org.apache.hadoop.yarn.server.nodemanager.timelineservice.NMTimelinePublisher;

public class NMCollectorService
extends CompositeService
implements CollectorNodemanagerProtocol {
    private static final Log LOG = LogFactory.getLog(NMCollectorService.class);
    private final Context context;
    private Server server;

    public NMCollectorService(Context context) {
        super(NMCollectorService.class.getName());
        this.context = context;
    }

    protected void serviceStart() throws Exception {
        Configuration conf = this.getConfig();
        InetSocketAddress collectorServerAddress = conf.getSocketAddr("yarn.nodemanager.bind-host", "yarn.nodemanager.collector-service.address", "0.0.0.0:8040", 8048);
        Configuration serverConf = new Configuration(conf);
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        this.server = rpc.getServer(CollectorNodemanagerProtocol.class, (Object)this, collectorServerAddress, serverConf, null, conf.getInt("yarn.nodemanager.collector-service.thread-count", 5));
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.server.refreshServiceAcl(conf, (PolicyProvider)new NMPolicyProvider());
        }
        this.server.start();
        collectorServerAddress = conf.updateConnectAddr("yarn.nodemanager.bind-host", "yarn.nodemanager.collector-service.address", "0.0.0.0:8040", this.server.getListenerAddress());
        super.serviceStart();
        LOG.info((Object)("NMCollectorService started at " + collectorServerAddress));
    }

    public void serviceStop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        super.serviceStop();
    }

    public ReportNewCollectorInfoResponse reportNewCollectorInfo(ReportNewCollectorInfoRequest request) throws YarnException, IOException {
        List newCollectorsList = request.getAppCollectorsList();
        if (newCollectorsList != null && !newCollectorsList.isEmpty()) {
            HashMap<ApplicationId, AppCollectorData> newCollectorsMap = new HashMap<ApplicationId, AppCollectorData>();
            for (AppCollectorData collector : newCollectorsList) {
                ApplicationId appId = collector.getApplicationId();
                newCollectorsMap.put(appId, collector);
                NMTimelinePublisher nmTimelinePublisher = this.context.getNMTimelinePublisher();
                if (nmTimelinePublisher == null) continue;
                nmTimelinePublisher.setTimelineServiceAddress(appId, collector.getCollectorAddr());
            }
            ConcurrentMap<ApplicationId, AppCollectorData> registeringCollectors = this.context.getRegisteringCollectors();
            if (registeringCollectors != null) {
                registeringCollectors.putAll(newCollectorsMap);
            } else {
                LOG.warn((Object)"collectors are added when the registered collectors are initialized");
            }
        }
        return ReportNewCollectorInfoResponse.newInstance();
    }

    public GetTimelineCollectorContextResponse getTimelineCollectorContext(GetTimelineCollectorContextRequest request) throws YarnException, IOException {
        Application app = (Application)this.context.getApplications().get(request.getApplicationId());
        if (app == null) {
            throw new YarnException("Application " + request.getApplicationId() + " doesn't exist on NM.");
        }
        return GetTimelineCollectorContextResponse.newInstance((String)app.getUser(), (String)app.getFlowName(), (String)app.getFlowVersion(), (long)app.getFlowRunId());
    }
}

