/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerModule;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class CGroupsHandlerImpl
implements CGroupsHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CGroupsHandlerImpl.class);
    private static final String MTAB_FILE = "/proc/mounts";
    private static final String CGROUPS_FSTYPE = "cgroup";
    private String mtabFile;
    private final String cGroupPrefix;
    private final boolean enableCGroupMount;
    private final String cGroupMountPath;
    private final long deleteCGroupTimeout;
    private final long deleteCGroupDelay;
    private Map<CGroupsHandler.CGroupController, String> controllerPaths;
    private Map<String, Set<String>> parsedMtab;
    private final ReadWriteLock rwLock;
    private final PrivilegedOperationExecutor privilegedOperationExecutor;
    private final Clock clock;
    private static final Pattern MTAB_FILE_FORMAT = Pattern.compile("^[^\\s]+\\s([^\\s]+)\\s([^\\s]+)\\s([^\\s]+)\\s[^\\s]+\\s[^\\s]+$");

    CGroupsHandlerImpl(Configuration conf, PrivilegedOperationExecutor privilegedOperationExecutor, String mtab) throws ResourceHandlerException {
        this.cGroupPrefix = conf.get("yarn.nodemanager.linux-container-executor.cgroups.hierarchy", "/hadoop-yarn").replaceAll("^/", "").replaceAll("$/", "");
        this.enableCGroupMount = conf.getBoolean("yarn.nodemanager.linux-container-executor.cgroups.mount", false);
        this.cGroupMountPath = conf.get("yarn.nodemanager.linux-container-executor.cgroups.mount-path", null);
        this.deleteCGroupTimeout = conf.getLong("yarn.nodemanager.linux-container-executor.cgroups.delete-timeout-ms", 1000L);
        this.deleteCGroupDelay = conf.getLong("yarn.nodemanager.linux-container-executor.cgroups.delete-delay-ms", 20L);
        this.controllerPaths = new HashMap<CGroupsHandler.CGroupController, String>();
        this.parsedMtab = new HashMap<String, Set<String>>();
        this.rwLock = new ReentrantReadWriteLock();
        this.privilegedOperationExecutor = privilegedOperationExecutor;
        this.clock = SystemClock.getInstance();
        this.mtabFile = mtab;
        this.init();
    }

    CGroupsHandlerImpl(Configuration conf, PrivilegedOperationExecutor privilegedOperationExecutor) throws ResourceHandlerException {
        this(conf, privilegedOperationExecutor, MTAB_FILE);
    }

    private void init() throws ResourceHandlerException {
        this.initializeControllerPaths();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getControllerPath(CGroupsHandler.CGroupController controller) {
        try {
            this.rwLock.readLock().lock();
            String string = this.controllerPaths.get((Object)controller);
            return string;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeControllerPaths() throws ResourceHandlerException {
        Map<CGroupsHandler.CGroupController, String> cPaths;
        Map<String, Set<String>> newMtab = null;
        try {
            if (this.cGroupMountPath != null && !this.enableCGroupMount) {
                newMtab = ResourceHandlerModule.parseConfiguredCGroupPath(this.cGroupMountPath);
            }
            if (newMtab == null) {
                newMtab = CGroupsHandlerImpl.parseMtab(this.mtabFile);
            }
            cPaths = CGroupsHandlerImpl.initializeControllerPathsFromMtab(newMtab);
        }
        catch (IOException e) {
            LOG.warn("Failed to initialize controller paths! Exception: " + e);
            throw new ResourceHandlerException("Failed to initialize controller paths!");
        }
        try {
            this.rwLock.writeLock().lock();
            this.controllerPaths = cPaths;
            this.parsedMtab = newMtab;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @VisibleForTesting
    static Map<CGroupsHandler.CGroupController, String> initializeControllerPathsFromMtab(Map<String, Set<String>> parsedMtab) throws ResourceHandlerException {
        HashMap<CGroupsHandler.CGroupController, String> ret = new HashMap<CGroupsHandler.CGroupController, String>();
        for (CGroupsHandler.CGroupController controller : CGroupsHandler.CGroupController.values()) {
            String subsystemName = controller.getName();
            String controllerPath = CGroupsHandlerImpl.findControllerInMtab(subsystemName, parsedMtab);
            if (controllerPath == null) continue;
            ret.put(controller, controllerPath);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static Map<String, Set<String>> parseMtab(String mtab) throws IOException {
        HashMap<String, Set<String>> ret = new HashMap<String, Set<String>>();
        BufferedReader in = null;
        Set<String> validCgroups = CGroupsHandler.CGroupController.getValidCGroups();
        try {
            FileInputStream fis = new FileInputStream(new File(mtab));
            in = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
            String str = in.readLine();
            while (str != null) {
                Matcher m = MTAB_FILE_FORMAT.matcher(str);
                boolean mat = m.find();
                if (mat) {
                    String path = m.group(1);
                    String type = m.group(2);
                    String options = m.group(3);
                    if (type.equals(CGROUPS_FSTYPE)) {
                        HashSet<String> cgroupList = new HashSet<String>(Arrays.asList(options.split(",")));
                        cgroupList.retainAll(validCgroups);
                        ret.put(path, cgroupList);
                    }
                }
                str = in.readLine();
            }
        }
        catch (IOException e) {
            try {
                if (Shell.LINUX) {
                    throw new IOException("Error while reading " + mtab, e);
                }
                LOG.warn("Error while reading " + mtab, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{in});
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{in});
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{in});
        return ret;
    }

    @VisibleForTesting
    static String findControllerInMtab(String controller, Map<String, Set<String>> entries) {
        for (Map.Entry<String, Set<String>> e : entries.entrySet()) {
            if (!e.getValue().contains(controller)) continue;
            if (new File(e.getKey()).canRead()) {
                return e.getKey();
            }
            LOG.warn(String.format("Skipping inaccessible cgroup mount point %s", e.getKey()));
        }
        return null;
    }

    private void mountCGroupController(CGroupsHandler.CGroupController controller) throws ResourceHandlerException {
        if (this.cGroupMountPath == null) {
            throw new ResourceHandlerException(String.format("Cgroups mount path not specified in %s.", "yarn.nodemanager.linux-container-executor.cgroups.mount-path"));
        }
        String existingMountPath = this.getControllerPath(controller);
        String requestedMountPath = new File(this.cGroupMountPath, controller.getName()).getAbsolutePath();
        if (existingMountPath == null || !requestedMountPath.equals(existingMountPath)) {
            try {
                this.rwLock.writeLock().lock();
                String mountOptions = existingMountPath != null ? Joiner.on((char)',').join((Iterable)this.parsedMtab.get(existingMountPath)) : controller.getName();
                String cGroupKV = mountOptions + "=" + requestedMountPath;
                PrivilegedOperation.OperationType opType = PrivilegedOperation.OperationType.MOUNT_CGROUPS;
                PrivilegedOperation op = new PrivilegedOperation(opType);
                op.appendArgs(this.cGroupPrefix, cGroupKV);
                LOG.info("Mounting controller " + controller.getName() + " at " + requestedMountPath);
                this.privilegedOperationExecutor.executePrivilegedOperation(op, false);
                this.controllerPaths.put(controller, requestedMountPath);
            }
            catch (PrivilegedOperationException e) {
                LOG.error("Failed to mount controller: " + controller.getName());
                throw new ResourceHandlerException("Failed to mount controller: " + controller.getName());
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
        } else {
            LOG.info("CGroup controller already mounted at: " + existingMountPath);
        }
    }

    @Override
    public String getRelativePathForCGroup(String cGroupId) {
        return this.cGroupPrefix + "/" + cGroupId;
    }

    @Override
    public String getPathForCGroup(CGroupsHandler.CGroupController controller, String cGroupId) {
        return this.getControllerPath(controller) + "/" + this.cGroupPrefix + "/" + cGroupId;
    }

    @Override
    public String getPathForCGroupTasks(CGroupsHandler.CGroupController controller, String cGroupId) {
        return this.getPathForCGroup(controller, cGroupId) + "/" + "tasks";
    }

    @Override
    public String getPathForCGroupParam(CGroupsHandler.CGroupController controller, String cGroupId, String param) {
        return this.getPathForCGroup(controller, cGroupId) + "/" + controller.getName() + "." + param;
    }

    @Override
    public void initializeCGroupController(CGroupsHandler.CGroupController controller) throws ResourceHandlerException {
        if (this.enableCGroupMount) {
            this.mountCGroupController(controller);
        }
        this.initializePreMountedCGroupController(controller);
    }

    private void initializePreMountedCGroupController(CGroupsHandler.CGroupController controller) throws ResourceHandlerException {
        block7: {
            String controllerPath = this.getControllerPath(controller);
            if (controllerPath == null) {
                throw new ResourceHandlerException(String.format("Controller %s not mounted. You either need to mount it with %s or mount cgroups before launching Yarn", controller.getName(), "yarn.nodemanager.linux-container-executor.cgroups.mount"));
            }
            File rootHierarchy = new File(controllerPath);
            File yarnHierarchy = new File(rootHierarchy, this.cGroupPrefix);
            String subsystemName = controller.getName();
            LOG.info("Initializing mounted controller " + controller.getName() + " " + "at " + yarnHierarchy);
            if (!rootHierarchy.exists()) {
                throw new ResourceHandlerException(this.getErrorWithDetails("Cgroups mount point does not exist or not accessible", subsystemName, rootHierarchy.getAbsolutePath()));
            }
            if (!yarnHierarchy.exists()) {
                LOG.info("Yarn control group does not exist. Creating " + yarnHierarchy.getAbsolutePath());
                try {
                    if (!yarnHierarchy.mkdir()) {
                        throw new ResourceHandlerException(this.getErrorWithDetails("Unexpected: Cannot create yarn cgroup", subsystemName, yarnHierarchy.getAbsolutePath()));
                    }
                    break block7;
                }
                catch (SecurityException e) {
                    throw new ResourceHandlerException(this.getErrorWithDetails("No permissions to create yarn cgroup", subsystemName, yarnHierarchy.getAbsolutePath()), e);
                }
            }
            if (!FileUtil.canWrite((File)yarnHierarchy)) {
                throw new ResourceHandlerException(this.getErrorWithDetails("Yarn control group not writable", subsystemName, yarnHierarchy.getAbsolutePath()));
            }
        }
    }

    private String getErrorWithDetails(String errorMessage, String subsystemName, String yarnCgroupPath) {
        return String.format("%s Subsystem:%s Mount points:%s User:%s Path:%s ", errorMessage, subsystemName, this.mtabFile, System.getProperty("user.name"), yarnCgroupPath);
    }

    @Override
    public String createCGroup(CGroupsHandler.CGroupController controller, String cGroupId) throws ResourceHandlerException {
        String path = this.getPathForCGroup(controller, cGroupId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("createCgroup: " + path);
        }
        if (!new File(path).mkdir()) {
            throw new ResourceHandlerException("Failed to create cgroup at " + path);
        }
        return path;
    }

    private void logLineFromTasksFile(File cgf) {
        if (LOG.isDebugEnabled()) {
            try (BufferedReader inl = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(cgf + "/tasks"), "UTF-8"));){
                String str = inl.readLine();
                if (str != null) {
                    LOG.debug("First line in cgroup tasks file: " + cgf + " " + str);
                }
            }
            catch (IOException e) {
                LOG.warn("Failed to read cgroup tasks file. ", (Throwable)e);
            }
        }
    }

    private boolean checkAndDeleteCgroup(File cgf) throws InterruptedException {
        boolean deleted = false;
        try (FileInputStream in = new FileInputStream(cgf + "/tasks");){
            if (in.read() == -1) {
                Thread.sleep(this.deleteCGroupDelay);
                deleted = cgf.delete();
                if (!deleted) {
                    LOG.warn("Failed attempt to delete cgroup: " + cgf);
                }
            } else {
                this.logLineFromTasksFile(cgf);
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to read cgroup tasks file. ", (Throwable)e);
        }
        return deleted;
    }

    @Override
    public void deleteCGroup(CGroupsHandler.CGroupController controller, String cGroupId) throws ResourceHandlerException {
        boolean deleted = false;
        String cGroupPath = this.getPathForCGroup(controller, cGroupId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("deleteCGroup: " + cGroupPath);
        }
        long start = this.clock.getTime();
        do {
            try {
                deleted = this.checkAndDeleteCgroup(new File(cGroupPath));
                if (deleted) continue;
                Thread.sleep(this.deleteCGroupDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!deleted && this.clock.getTime() - start < this.deleteCGroupTimeout);
        if (!deleted) {
            LOG.warn(String.format("Unable to delete  %s, tried to delete for %d ms", cGroupPath, this.deleteCGroupTimeout));
        }
    }

    @Override
    public void updateCGroupParam(CGroupsHandler.CGroupController controller, String cGroupId, String param, String value) throws ResourceHandlerException {
        block9: {
            PrintWriter pw;
            String cGroupParamPath;
            block10: {
                cGroupParamPath = this.getPathForCGroupParam(controller, cGroupId, param);
                pw = null;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("updateCGroupParam for path: %s with value %s", cGroupParamPath, value));
                }
                try {
                    File file = new File(cGroupParamPath);
                    OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
                    pw = new PrintWriter(w);
                    pw.write(value);
                    if (pw == null) break block9;
                    boolean hasError = pw.checkError();
                    pw.close();
                    if (!hasError) break block10;
                }
                catch (IOException e) {
                    try {
                        throw new ResourceHandlerException(String.format("Unable to write to %s with value: %s", cGroupParamPath, value), e);
                    }
                    catch (Throwable throwable) {
                        if (pw != null) {
                            boolean hasError = pw.checkError();
                            pw.close();
                            if (hasError) {
                                throw new ResourceHandlerException(String.format("PrintWriter unable to write to %s with value: %s", cGroupParamPath, value));
                            }
                            if (pw.checkError()) {
                                throw new ResourceHandlerException(String.format("Error while closing cgroup file %s", cGroupParamPath));
                            }
                        }
                        throw throwable;
                    }
                }
                throw new ResourceHandlerException(String.format("PrintWriter unable to write to %s with value: %s", cGroupParamPath, value));
            }
            if (pw.checkError()) {
                throw new ResourceHandlerException(String.format("Error while closing cgroup file %s", cGroupParamPath));
            }
        }
    }

    @Override
    public String getCGroupParam(CGroupsHandler.CGroupController controller, String cGroupId, String param) throws ResourceHandlerException {
        String cGroupParamPath = this.getPathForCGroupParam(controller, cGroupId, param);
        try {
            byte[] contents = Files.readAllBytes(Paths.get(cGroupParamPath, new String[0]));
            return new String(contents, "UTF-8").trim();
        }
        catch (IOException e) {
            throw new ResourceHandlerException("Unable to read from " + cGroupParamPath);
        }
    }

    @Override
    public String getCGroupMountPath() {
        return this.cGroupMountPath;
    }
}

